#ifndef lint
static char *RCSid = "$Id: unixfuncs.c,v 1.11 1993/05/10 06:08:07 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: unixfuncs.c,v $
 * Revision 1.11  1993/05/10  06:08:07  anders
 * Minor adjustements in order to kill compiler warnings.
 *
 * Revision 1.10  1993/05/07  20:17:32  anders
 * Minor bugfixes.
 *
 * Revision 1.9  1993/02/09  18:25:55  anders
 * Added support for VMS
 * Renamed Str*() to Str_*() to humor case insensitive machines
 * Simplified, and fixed a bug in unx_chdir
 *
 * Revision 1.8  1992/07/24  03:37:34  anders
 * Added GPL. Added unx_getpid(). Some minor changes.
 *
 * Revision 1.7  1992/04/25  13:18:30  anders
 * Converted to REXX strings
 *
 * Revision 1.6  1992/04/05  19:49:47  anders
 * Added copyright notice
 * Made code compatible with ANSI C and POSIX.
 *
 * Revision 1.5  1992/03/22  18:54:56  anders
 * Defined popen() explicitly for CRAY
 *
 * Revision 1.4  1992/03/22  01:40:25  anders
 * Did lots of changes to interface correctly againts the REXX
 *    type of file io.
 *
 * Revision 1.3  1992/03/01  19:11:25  anders
 * Fixed problems with sprintf()
 *
 * Revision 1.2  1990/08/26  01:53:19  anders
 * Added new function, eof()
 *
 * Revision 1.1  90/08/08  02:14:04  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <string.h>
#ifdef VAXC
# include <types.h>
#else
# include <sys/types.h>
# include <unistd.h>
#endif

#if defined(CRAY)
FILE *popen( char *command, char *access ) ;
#endif

streng *unx_getpath( paramboxptr parms )
{
   return nullstringptr() ;
}


streng *unx_popen( paramboxptr parms )
{
   extern proclevel currlevel ;
   streng *string ;
   streng *cptr ;
   int length ;

   checkparam( parms, 1, 1 ) ;
   string = (parms->value) ;

   cptr = Str_make( length=Str_len(string) + 6 ) ;
   cptr = Str_cat( cptr, string ) ;
   cptr = Str_catstr( cptr, ">FIFO" ) ;

   return perform( cptr, currlevel->environment, NULL ) ; 
/*   Free( cptr ) ;
   sprintf( (result=Str_make(SMALLSTR))->value, "%d", rcode ) ;
   result->len = Str_len(result) ;
   return result ; */
}


streng *unx_getpid( paramboxptr parms )
{
   checkparam( parms, 0, 0 ) ;
   return int_to_streng( getpid() ) ;
}


char *unx_eof( paramboxptr parms )
{
   char *ptr=NULL ;
   checkparam( parms, 0, 0 ) ;
/*    sprintf(ptr=Malloc(SMALLSTR),"%d",eof_on_input()) ; */
   return( ptr ) ;
}


char *unx_unixerror( paramboxptr parms )
{
   char *result, *errtxt ;
   extern char *sys_errlist[] ;
   int errno ;
   
   checkparam( parms, 1, 1 ) ;
   errno = atozpos( parms->value ) ;
   errtxt = sys_errlist[ errno ] ;
   strcpy( result=Malloc(strlen(errtxt)+1+STRHEAD), errtxt ) ;
   return result ;
}
   


streng *unx_chdir( paramboxptr parms )
{
   checkparam( parms, 1, 1 ) ;
   return int_to_streng( chdir(Str_ify(parms->value)->value)!=0 ) ;
}


streng *unx_getenv( paramboxptr parms ) 
{
   streng *retval ;
   char *output ;

   checkparam( parms, 1, 1 ) ;
   output = getenv( Str_ify(parms->value)->value ) ;
   if (output) 
      retval = Str_cre(output) ;
   else 
      retval = nullstringptr() ;

   return retval ;
}
   

