/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: types.h,v 1.11 1993/05/10 05:54:59 anders Exp anders $
 *
 * $Log: types.h,v $
 * Revision 1.11  1993/05/10  05:54:59  anders
 * Changed type field in parse tree node, in order to take advantage of
 * special optimaliztion in gcc.
 *
 * Revision 1.10  1993/05/07  16:20:25  anders
 * Move in the definition of the variablebox, since this is not a private
 * datastructure for variable.c anymore. Removed the value field from
 * struct tnode, since it is not in use. Same for mother. Added more
 * fields to the misc union. Added a dealloc field to the parambox type
 * in order to optimize parameter handling. Added numberous fields to
 * sysinfobox, in order to the interpreter reentrant.
 *
 * Revision 1.9  1993/02/09  18:00:49  anders
 * Made numeric form a 'enumerable' instead of a string, saves space.
 * Made misc in nodeptr into a union, to avoid having to cast it
 * to whatever it is needed for in the moment.
 *
 * Revision 1.8  1992/07/24  03:01:42  anders
 * Added GPL. Added next to nodeptr (to thread stats). Added misc to
 * nodeptr (to chache info). Added defs for traps and conditions.
 * Added defs into proclevel to hold trap/cond. info.
 *
 * Revision 1.7  1992/04/25  18:44:45  anders
 * Moved definitions of strings over to strings.h
 *
 * Revision 1.6  1992/04/25  13:16:56  anders
 * Converted to REXX strings
 *
 * Revision 1.5  1992/04/05  19:51:18  anders
 * Added copyright notice, and pointer to revious envionment name
 *
 * Revision 1.4  1992/03/23  05:10:10  anders
 * Added new field numform to currlevel, to contain the type of
 *    numeric form that is set using NUMERIC FORM
 *
 * Revision 1.3  1992/03/22  01:00:01  anders
 * Moved all references to the filetable to files.c
 * Commented out definition of string, as it confused som compilers
 *    when it discovered variables called string.
 *
 * Revision 1.2  1990/08/11  00:40:40  anders
 * Removed definition of stack (to be hidden in stack.c)
 * Removed pointer to stack from sysbox, same reason
 *
 * Revision 1.1  90/08/08  02:05:32  anders
 * Initial revision
 * 
 */


typedef struct varbox *variableptr ;
typedef struct varbox {
   variableptr next, prev, realbox, *index ;   
   struct strengtype *name, *value ;
   int guard ;
   num_descr *num ;
   int flag ;
   short hwired, valid ;
   variableptr stem ;
} variable ;

/* typedef int bool ; */

typedef struct {
   unsigned int lnum:1 ;
   unsigned int rnum:1 ;
   unsigned int lsvar:1 ;
   unsigned int rsvar:1 ;
   unsigned int lcvar:1 ;
   unsigned int rcvar:1 ;
} compflags ;

typedef struct tnode *nodeptr ;
typedef struct tnode {
   unsigned int type ;
   int charnr, lineno ;
/*   char *value ; */
   struct strengtype *name ;
   long now, unow, usec, sec ;
   nodeptr p[5] ;
   union {
      streng *(*func)() ;
      streng *strng ;
      nodeptr node ;
      num_descr *number ;
      compflags flags ;
      variable *varbx ;
   } u ;
   nodeptr next ; 
} treenode ;

typedef struct stackboxtype *stackboxptr ;
typedef struct stackboxtype {
   int whereto, number ;
   void *increment, *tdescr, *stopval ;
   int incrdir ;
   int guard ;
   streng *oldcnt ;
   nodeptr this ;
} stackbox ;

typedef struct pparambox *paramboxptr ;
typedef struct pparambox {
   paramboxptr next ;
   int dealloc ;
   struct strengtype *value ; 
} parambox ;

typedef struct lineboxx *lineboxptr ;
typedef struct lineboxx {
   lineboxptr next, prev ;
   struct strengtype *line ;
   int lineno ;
} linebox ;

typedef variableptr hashtabl[HASHTABLENGTH] ;

typedef struct labelboxx *labelboxptr ;
typedef struct labelboxx {
   labelboxptr next ;
   nodeptr entry ; 
} labelbox ;

typedef struct trap_type  /* index is type of signal */
{
   unsigned on_off:1 ;     /* true if trap is active/on */
/* unsigned trapped:1 ; */ /* true if condition has been raised */ 
   unsigned def_act:1 ;    /* true if default action is to ignore */
   unsigned delayed:1 ;    /* true if trap is in delay mode */
   unsigned ignored:1 ;    /* true if ignored when in delayed mode */
   unsigned invoked:1 ;    /* true if invoked by SIGNAL */
   streng *name ;          /* label to transfer control to */
} trap ;

typedef struct sig_type 
{
   int type ;
   streng *info ;
   streng *descr ;
   int invoke ;     /* is true if invoked with SIGNAL */
   int rc, lineno ;
} sigtype ;

typedef struct proclevelbox *proclevel ;
typedef struct proclevelbox {
   int numfuzz, numsize, currnumsize, numform ;
   int mathtype ;
   long sec, usec ;
   proclevel prev, next ;
   variableptr *vars ;
   paramboxptr args ;
   struct strengtype *environment, *prev_env ;
   char tracestat, varflag ;
   sigtype *sig ; 
   trap *traps ;
   jmp_buf *buf ;  /* for use by longjmp */
} proclevbox ;

typedef struct systeminfobox *sysinfo ;
typedef struct systeminfobox {
   struct strengtype *called_as, *input_file ;
   streng *environment ;
   char tracing ;
   int interactive ;
   lineboxptr firstline, lastline ;
   labelboxptr first, last ;
   jmp_buf *panic ;
   streng *result ;
   proclevbox *currlevel ;
   struct systeminfobox *previous ;
   nodeptr rootnode, *callstack ;
   int cstackcnt, cstackmax ;
   int hooks ;
   int invoked ;
} sysinfobox ;


