#ifndef lint
static char *RCSid = "$Header: /auto/home/flipper/anders/flipper/prosj/rexx/src/RCS/signals.c,v 1.4 1993/05/10 06:04:52 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: signals.c,v $
 * Revision 1.4  1993/05/10  06:04:52  anders
 * Some changes in order to kill compiler warnings, and removed som
 * kludges needed for malfunctioning old systems that have been fixed now.
 *
 * Revision 1.3  1993/05/07  21:28:11  anders
 * Added support for better memory tracing, and support for trapping
 * debugging output from applications. Also fixed some bugs.
 *
 * Revision 1.2  1993/02/09  17:58:29  anders
 * Fixed misc spelling errors and compiler warnings.
 * Added support for VMS, and renamed Str*() to Str_*() to humor
 * case insensitive machines.
 *
 * Revision 1.1  1992/07/24  03:57:51  anders
 * Initial revision
 *
 */




#include "rexx.h"
#include <signal.h>
#include <string.h>
#include <stdio.h>

#ifdef VMS
# ifndef SIG_ERR
#  define SIG_ERR BADSIG
# endif
#endif

/* at least dolphin does not have a properly ANSI C set of include files */
#ifndef SIG_ERR
# define SIG_ERR ((void(*)())(-1))
#endif



extern proclevel currlevel ;

char *signalnames[] = {
   "ERROR",
   "FAILURE",
   "HALT",
   "NOVALUE",
   "NOTREADY",
   "SYNTAX" 
} ;

sigtype *nextsig = NULL ; 


#ifdef TRACEMEM
void mark_signals()
{
    if (nextsig)
    {
       markmemory( nextsig, TRC_MATH ) ;
       if (nextsig->descr)
          markmemory( nextsig->descr, TRC_MATH ) ;
    }
}
#endif


static trap *dupltraps( trap *traps ) 
{
   trap *ptr ;
   int i ;
  
   ptr = Malloc(sizeof(trap) * SIGNALS) ;
   /* Stupid SunOS acc gives incorrect warning for the next line */
   memcpy( ptr, traps, sizeof(trap) * SIGNALS) ;
   for ( i=0; i<SIGNALS; i++ )
      if (traps[i].name)
         ptr[i].name = Str_dup( traps[i].name ) ;
      

   return ptr ;
}


sigtype *getsigs( proclevel level ) 
{
   for (; level && (!level->sig); level=level->prev ) ;
   return ((level) ? (level->sig) : (NULL)) ;
}

jmp_buf *getjmpbuf( proclevel level )
{
   for (; level && level->buf; level=level->prev ) ;
   return ((level) ? (level->buf) : (NULL)) ;
}
   

trap *gettraps( proclevel level ) 
{
   proclevel ptr=level ;

   if (!ptr->traps)
   {
      for (ptr=level; ptr && ptr->traps==NULL; ptr=ptr->prev ) ;
      if (ptr==NULL || ptr->traps==NULL)
         exiterror( ERR_INTERPRETER_FAILURE ) ;

      level->traps = dupltraps( ptr->traps ) ;
      ptr = level ;
   }

   return ptr->traps ;
}


int condition_hook( int type, int errno, int lineno, streng *description ) 
{
   extern proclevel currlevel ;
   trap *traps = gettraps( currlevel ) ;
/*   volatile sigtype **sigptr=((volatile sigtype **)(&nextsig)) ; */
   sigtype *sigptr ;

   /* if we dont know what to do, ... or */
   /* if we don't *really* want to try to recover from these ... */
   if (traps==NULL || type == SIGNAL_FATAL) 
   {
      if (description)
         Free_string( description ) ;       
      return 0 ;
   }

   if ( traps[type].on_off) /* condition is being trapped */
   {
      static streng sigl = { 4, 4, { 'S', 'I', 'G', 'L' }};
      static streng rc = { 4, 2, "RC" } ;
      
      if ((traps[type].delayed) && (traps[type].ignored))
      {
         if (description)
            Free_string( description ) ;
         return 0 ;
      }

      sigptr = Malloc( sizeof( sigtype )) ;

      sigptr->type = type ;
      sigptr->info = NULL ;   /* BUG: I don't really think this is used */
      sigptr->descr = description ;
      sigptr->invoke = traps[type].invoked ;
      sigptr->rc = errno ;
      sigptr->lineno = lineno ; 

      if ( traps[type].invoked )   /* if SIGNAL ON */
      {
      /* traps[type].on_off = 0 ;  */ /* turn trap off */
      /* traps[type].trapped = 0 ; */ /* unecessary, just to be sure */
         traps[type].delayed = 0 ;    /* ... ditto ... */
         setvalue( &sigl, int_to_streng( lineno )) ;
         if (type == SIGNAL_SYNTAX)
            setvalue( &rc, int_to_streng( errno )) ;  /* special condition */

         nextsig = sigptr ;

         longjmp( *(currlevel->buf), 1 ) ;
         abort() ;
      }
      else
      {
        nextsig = sigptr ;
        return 1 ;
      }
   }

   if (description)
      Free_string(description) ;

   /* signal is not to be trapped */
   return (traps[type].def_act) ;
}


int identify_trap( int type ) 
{
   switch (type)
   {
      case X_S_HALT:     return SIGNAL_HALT ;
      case X_S_SYNTAX:   return SIGNAL_SYNTAX ;
      case X_S_NOVALUE:  return SIGNAL_NOVALUE ;
      case X_S_NOTREADY: return SIGNAL_NOTREADY ;
      case X_S_ERROR:    return SIGNAL_ERROR ;
      case X_S_FAILURE:  return SIGNAL_FAILURE ; 
   }
   exiterror( ERR_INTERPRETER_FAILURE ) ;
   return SIGNAL_FATAL ;
}


/* the rest should probably also be defined */
char *signals_names[] = {
     "", "SIGHUP", "SIGINTR", "", "", "", "", "", "", "",
     "", "", "", "", "", "SIGTERM", "", "", "", "", "",
     "", "", "", "", "", "", "", "", "", "",
     "", "" 
} ;


/* Yuk! Some of these should *really* have been volatilized */
static void halt_handler( int num )
{
   extern nodeptr currentnode ;

#ifdef VMS
   vms_killproc() ;
#endif

   if (signal( num, halt_handler ) == SIG_ERR)
      exiterror( ERR_SYSTEM_FAILURE ) ;

   if (!condition_hook(SIGNAL_HALT, ERR_PROG_INTERRUPT, 
               lineno_of(currentnode), Str_cre(signals_names[num])))
      exiterror( ERR_PROG_INTERRUPT ) ;
 
   return ;
}

static void hup_handler( int num ) 
{
   exit( 0 ) ;
}



void signal_setup( void )
{
   extern int isclient ;

   if (signal( SIGTERM, halt_handler ) == SIG_ERR)
      exiterror( ERR_SYSTEM_FAILURE ) ;

   if (signal( SIGINT, halt_handler) == SIG_ERR)
      exiterror( ERR_SYSTEM_FAILURE ) ;

   if (signal( SIGHUP, (isclient)?(hup_handler):(halt_handler)) == SIG_ERR)
      exiterror( ERR_SYSTEM_FAILURE ) ;

}




