#ifndef lint
static char *RCSid = "$Id: rexxext.c,v 1.7 1993/02/09 17:30:13 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: rexxext.c,v $
 * Revision 1.7  1993/02/09  17:30:13  anders
 * Renamed Str*() to Str_*() to humor case insensitive machines
 * Added some support for VAX/VMS
 *
 * Revision 1.6  1992/07/24  03:42:14  anders
 * Added GPL.
 *
 * Revision 1.5  1992/04/25  13:18:30  anders
 * Converted to REXX strings
 *
 * Revision 1.4  1992/04/05  20:08:40  anders
 * Added copyright notice.
 * Removed call to cuserid() to get something POSIX
 *
 * Revision 1.3  1992/03/22  18:56:22  anders
 * Added support for CRAY
 *
 * Revision 1.2  1992/03/22  01:15:38  anders
 * #include'd stdio.h
 * explicitly defined cuserid() since it is not defined in ANSI C
 *    under ultrix
 *
 * Revision 1.1  1990/08/08  02:12:26  anders
 * Initial revision
 *
 */

#include "rexx.h"
#include <stdio.h>
#ifndef VMS
# include <unistd.h>
# include <pwd.h>
#endif

streng *rex_userid( paramboxptr parms ) 
{
   checkparam( parms, 0, 0 ) ;
#ifdef VMS
   return nullstringptr() ;
#else
   return(Str_cre(getpwuid(getuid())->pw_name)) ;
#endif
}
