/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: rexx.h,v 1.17 1993/05/10 05:48:51 anders Exp anders $
 *
 * $Log: rexx.h,v $
 * Revision 1.17  1993/05/10  05:48:51  anders
 * Minor ajustments to kill warnings and to make code more tidy.
 *
 * Revision 1.16  1993/05/07  16:27:35  anders
 * Cleaned up the code a bit, set STACKSIZE to 256 (old 512) in order
 * to save some space. Defined some global variables.
 *
 * Revision 1.15  1993/02/09  16:55:33  anders
 * Cleaned up the code wrt the settings of NUMERIC.
 * Added some code to make it work on VAX/VMS
 * Added another level of indirection to the memoryallocation routines
 *
 * Revision 1.14  1992/07/24  02:53:20  anders
 * Changed copyrightnotice to GPL
 * Made TRACEMEM a subset of NDEBUG, never to be used with optimalization
 * Set the PARSE VERSION info to correct value according to TRL
 * Moved in some macro defs from other places, to avoid mult. defs
 * Added defs needed for setjmp/longjmp
 *
 * Revision 1.13  1992/04/25  18:39:41  anders
 * Moved all definition connected to strings over to strings.h
 * Added an #include for strings.h
 *
 * Revision 1.12  1992/04/25  13:16:56  anders
 * Converted to REXX strings
 *
 * Revision 1.11  1992/04/05  20:09:54  anders
 * Removed most of the unneccesary prototypes used for non-ANSI C
 * compilers, but added #include for time.h, which is needed in
 * extern.h in the getsecs() prototype.
 * Added copyright notice.
 *
 * Revision 1.10  1992/03/23  05:11:14  anders
 * Incremented STRINGSPACE.
 * Added DEFAULT_NUMFORM to have the default NUMERIC FORM
 *
 * Revision 1.9  1992/03/22  01:37:44  anders
 * Removed most of the #include of standard files
 * Removed most of the explicit defining of functions.
 *
 * Revision 1.8  1992/03/01  03:54:57  anders
 * Decreased the size of some of the definitions, to save memory
 * Shuffled around on some of the prototypes to make the compiler happy
 *
 * Revision 1.7  1991/06/03  02:50:23  anders
 * The usleep() call is #ifdef'ed out when HAS_USLEEP is not defined
 *
 * Revision 1.6  91/05/28  23:42:05  anders
 * Added cpp flag PATTERN_MEMORY to decide if newly allocated and
 * deallocated memory is to be overwritten by a certain byte value
 * 
 * Revision 1.5  91/05/25  02:48:06  anders
 * Put #ifdef's around definitions of standard C-routines, to avoid
 *    complains from C-compilers
 * 
 * Revision 1.4  91/04/05  23:42:03  anders
 * Added support for not including system header files, depending
 * on the setting of the cpp macro NO_INCLUDE
 * Changed some of the explicit declarations of routines in the system
 * library, to match the definitions in the latest version of the 
 * system include files.
 * 
 * Revision 1.3  90/12/10  00:28:09  anders
 * Redefined system() to return int, instead of void.
 * Removed some definitions of standard routines, as these now are 
 *     correctly defined in the includefiles for gcc.
 * 
 * Revision 1.2  90/08/09  03:58:16  anders
 * Moved '#include <malloc.h>' to memory.c (only placed used)
 * Created '#define TRACEMEM' for controlling tracing dynamic memory
 * 
 * Revision 1.1  90/08/08  02:05:13  anders
 * Initial revision
 * 
 */

/* Things you might want to change .... (at your own risk!!!) */

/*
 * define TRACEMEM to use tracing of dynamically allocated memory. This
 * is only useful when debugging memory management of the interpreter.
 * Some conditions must be fullfilled when using this (see memory.c).
 */
/* #define TRACEMEM */
#define FLISTS

/* TRACEMEM is s subset of the debugging functionality */
#ifdef NDEBUG
# ifdef TRACEMEM
#  undef TRACEMEM
# endif
#endif



/*
 * define PATTERN_MEMORY to initiate newly allocated dynamic memory to
 * a particular value, and freed memory to be set to another value
 * before it is freed. Useful for debugging only.
 */
#define PATTERN_MEMORY


extern char *numeric_forms[] ;
extern char *invo_strings[] ;


#include "defs.h"

#include "config.h"

#define MAXNUMERIC 64		/* Max setting for NUMERIC DIGITS 	*/
/* #define REXXDEBUG */		/* You probably don't want this ... :-) */

/* #define HAVE_STRMATH */	/* Do we have *real* REXX string math ? */
/* #define HAVE_MPMATH */	/* Do we have C ``mp'' math		*/
#define HAVE_CMATH		/* Do we have std. C math calls ? 	*/
#define MATH_TYPES 1		/* How many different types available	*/

#define LINELENGTH 1024         /* max linelength of source code        */
#define STACKSIZE 256		/* It might have to be increased	*/
#define STRINGSPACE 48000	/* You might to increase this too	*/
#define BUFFERSIZE 512          /* Size of input buffer, longest line   */
#define LOOKAHEAD 256           /* Size of input lookahead              */

#define SMALLSTR 5              /* For holding small integers		*/
#define NULL_STR_LENGTH 1
#define BOOL_STR_LENGTH 2

#define DEFAULT_TRACING		'N'
#define DEFAULT_INT_TRACING	0
#define DEFAULT_NUMFORM         NUM_FORM_SCI
#define DEFAULT_ENVIRONMENT 	ENV_SYSTEM
#define NESTEDCOMMENTS          /* The Standard wants them ....         */

#ifdef SUNOS
#define SUN_STRTOD_BUG
#endif /* SUNOS */


/* The following have been included to support national languages.       */
/*    English has a small set of letters. In the ASCII alphabet the      */
/*    English uppercase letters occupy the range from d2c(65) to d2c(90) */
/*    and the lowercase version of each letter have an offset of +32     */
/*    from the corresponding uppercase letter.                           */
/*                                                                       */
/* You may define FIRST_CHAR and LAST_CHAR to the lowermost and the      */
/*    uppermost letters of the uppercase alphabet. And you may define    */
/*    CHAR_OFFSET as the difference between upper- and lowercase.        */
/*    other Western European languages                                   */

#define FIRST_CHAR 	'A'
#define LAST_CHAR 	'Z'
#define CHAR_OFFSET	32

#define HEXNUM(c) (((c>='0')&&(c<='9'))||((c>='a')&&(c<='f')))
#define HEXVAL(c) (((c)>'9')?(RXTOLOW(c)-'a'+10):((c)-'0'))

#define PARSE_VERSION_STRING	"REXX-Regina_0_05d 4.00 10 May 1993" 

#define TRUE 1
#define FALSE 0

/* Fancy time-optimalizations (non-space optimalizations!) */
#define FANCY

/* Things you probably don't want to change ....			*/

#include <stdlib.h>
#include <stdio.h>
#ifdef VAXC
# include <types.h>
#else
# include <sys/types.h>
#endif
#include <setjmp.h>

#include "strings.h"            /* definitions of REXX strings */
#include "types.h"		/* various types */
#include "extern.h"		/* function prototypes */

#define FREE_IF_DEFINED(a) { if (a) Free(a); a=NULL ; }


#ifdef VMS  /* F*ck DEC */
# ifdef EXIT_SUCCESS
#  undef EXIT_SUCCESS
# endif
# define EXIT_SUCCESS 1
#endif

/* For some mysterious reason, this macro is very difficult for some vendors */
#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif


extern lineboxptr first_source_line, last_source_line ;
extern FILE *stddump ;
extern nodeptr parseroot ;
extern char *signalnames[] ;
extern sigtype signals ;
extern sigtype *nextsig ;
extern streng nofunc ;
     

extern proclevel currlevel, mainlevel ;
extern sysinfo systeminfo ;
