#ifndef lint
static char *RCSid = "$Id: rexx.c,v 1.13 1993/05/10 06:09:38 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: rexx.c,v $
 * Revision 1.13  1993/05/10  06:09:38  anders
 * Minor changes in order to kill compiler warnings
 *
 * Revision 1.12  1993/05/07  16:15:42  anders
 * Cleaned up the code a bit, set STACKSIZE to 256 (old 512) in order
 * to save some space. Defined some global variables.
 *
 * Revision 1.11  1993/02/09  23:22:15  anders
 * Added support for VMS
 *
 * Revision 1.10  1993/02/09  18:10:51  anders
 * Removed old debug co.
 * Added more kludges to try to get EXIT_SUCCESS right (sigh)
 * enamed Str*() to Str_*() to humor case insensitive machines.
 *
 * Revision 1.9  1992/07/24  03:09:06  anders
 * Added GPL. Fixed spelling errors. Added better control over subtrees
 * when interpreting. Added possibility to thread stats, instead of
 * recursive traversing parse tree. Added flag for debug in yaccsrc.y.
 *
 * Revision 1.8  1992/04/25  13:16:56  anders
 * Converted to REXX strings
 *
 * Revision 1.7  1992/04/05  20:11:43  anders
 * Added copyright notice.
 * Added support for more environments
 * Added better processing of command line
 *
 * Revision 1.6  1992/03/23  05:12:08  anders
 * Added strings for the possible NUMERIC FORM's
 *
 * Revision 1.5  1992/03/22  01:01:48  anders
 * #included files which were not included in rexx.h enymore
 * Removed references to the filetable, moved to files.c
 * Added call to initfiletable() to initiate it.
 * Added call to initscanner to set up lex properly
 * removed \b (backspace) from strings, SGI dont like it (yuk!)
 *
 * Revision 1.4  1992/03/01  19:00:25  anders
 * Added new routine mark_systeminfo() to improve on memory management
 *
 * Revision 1.3  1990/08/11  00:38:04  anders
 * Removed call to initstack(), stack is automatically initiated
 *
 * Revision 1.2  90/08/09  04:02:36  anders
 * Changed magic nummer with TRC_* macro
 * 
 * Revision 1.1  90/08/08  02:12:16  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#ifdef VMS
# include <stat.h>
#else
# include <sys/stat.h>
#endif

proclevel currlevel, mainlevel ;
sysinfo systeminfo ;


nodeptr parseroot=NULL ;

int nextstart=1, thischar=0, nextline=1, tstart, tline ;

char *environments[] = { "SH", "CSH", "COMMAND", "PATH", "SYSTEM" } ;

FILE *stddump=NULL ;

/* 
 * Note: must match the settings of NUM_FORM_* in flags.h
 */
char *numeric_forms[] = { "SCIENTIFIC", "ENGINEERING" } ;

char *WeekDays[] = { "Sunday", "Monday", "Tuesday", "Wednesday",
   "Thursday", "Friday", "Saturday" } ;

char *months[] = {
   "January", "February", "March", "April", "May", "June",
   "July", "August", "September", "October", "November", "December" } ;

/*
 * Note: these must match the definitions of INVO_* in defs.h
 */
char *invo_strings[] = {
   "COMMAND", "FUNCTION", "SUBROUTINE" } ;

#ifdef TRACEMEM
void marksubtree( nodeptr ptr )
{
   int i ;
   if ( ptr ) 
   {
      markmemory(ptr,TRC_TREENODE) ;
      if (ptr->name) markmemory(ptr->name, TRC_TREENODE) ;
      for (i=0;i<5;marksubtree(ptr->p[i++])) ; 
      if (ptr->next) marksubtree( ptr->next ) ;

      if (ptr->type == X_STRING || ptr->type == X_CON_SYMBOL)
         if (ptr->u.number)
         {
            markmemory( ptr->u.number, TRC_TREENODE ) ;
            markmemory( ptr->u.number->num, TRC_TREENODE ) ;
         }

      if (ptr->type == X_CEXPRLIST)
         if (ptr->u.strng)
            markmemory( ptr->u.strng, TRC_TREENODE ) ;
   }
}
         

#endif /* TRACEMEM */



nodeptr treadit( nodeptr tree )
{
/* 
   nodeptr left, mid, right ;
 */
   return NULL ;   
/*
   if (!tree)
      return NULL ;

   left = tree->p[0] ;
   mid = tree->p[1] ;
   right = tree->p[2] ;

   switch (tree->type)
   {
      case X_OTHERWISE:
      case X_PROGRAM: 
         treadit( left ) ;
         tree = NULL ;
         break ;

      case X_STATS:
      case X_WHENS:
         left->next = treadit( mid ) ;
         treadit( left ) ;
         tree = left ;
         break ;

      case X_IF:
         treadit( mid ) ;
      case X_DO:
         treadit( right ) ;
         break ;

      case X_SELECT:
         treadit( left ) ;
      case X_WHEN:
         treadit( mid ) ;
         break ;
   }

   return tree ;
 */
}

#ifdef TRACEMEM
   int listleakedmemory=0 ;
#endif


int main(int argc,char **argv)
{
   extern int isclient ;
   extern FILE *yyin ;
   streng *string ;
   int rccode, i, j, stdinput=1, state=0, rcode, oldi ;
#ifndef NDEBUG
   extern int yydebug ; 
#endif
   paramboxptr args ;
   char *arg ;
   int make_perl=0 ;

#ifdef FLISTS
   init_hash_table() ; /* initiate the memory system */
#endif

   stddump = stderr ;

   systeminfo = creat_sysinfo( Str_cre("SYSTEM")) ;
   systeminfo->called_as = Str_cre( argv[0] ) ;

   systeminfo->currlevel = mainlevel = currlevel = newlevel( NULL ) ; 

   initexpr() ;
   initfiletable() ;
   init_envir() ;
   init_spec_vars() ;
   init_vars() ;

   for (i=1; i<argc; i++)
   {
      arg = argv[i] ;
      if (state==0)
      {
         if (*arg=='-') 
         {
            if (*(++arg))
            {
               for (;*arg;arg++)
               {
                  switch (*arg)
                  {
                     case 'i':
                        starttrace() ;
                        set_trace_char('A') ;
                        intertrace() ;
                        intertrace() ;
                        break ;

                     case 'C':
                        if (*(arg+1)=='p')
                           SetupClient( arg+2 ) ;
                        break ;

                     case 'p':
		        make_perl = 1 ;
                        break ;   

                     case 't':
                        set_trace_char(*(arg+1)? *(++arg) : 'A') ;
                        break ;

                     case 'd':
#ifdef TRACEMEM
                        if (*(arg+1)=='m')
                           listleakedmemory = 1 ;
#endif
                        break ;
                  }
               }
            }
            else
            {
               break ;
            }
         }
         else
         {
            stdinput = 0 ;
            systeminfo->input_file = Str_cre(argv[i]) ;
            yyin=fopen(argv[i],"r") ;
            if (!yyin)
               exiterror( ERR_PROG_UNREADABLE ) ;
            break ;
         }
      }
    }

   if (stdinput)
      systeminfo->input_file = Str_cre("<stdin>") ; 

   if (isclient) 
      RunClient() ;

   oldi = ++i ;

   for (j=1;i<argc;i++)
      j += strlen(argv[i]) + 1 ;


   currlevel->args = args = Malloc(sizeof(parambox)) ;
/*   
   args->value = Str_dup(systeminfo->input_file) ;
   args = args->next = Malloc(sizeof(parambox)) ;
 */
   args->next = NULL ;
   if (oldi>=argc)
      args->value = string = NULL ;
   else
   {
      args->value = string = Str_make( j ) ;
      string->len = 0 ;
   }

   for (i=oldi;i<argc;i++) 
   {
      string = Str_catstr(string,argv[i]) ;
      string->value[string->len++] = ' ' ;
   }

   signal_setup() ;

   initscanner() ;
#ifndef NDEBUG
   yydebug = 0 ;   /* 1 == yacc-debugging */
#endif

   parseroot = NULL ;
   if ((rccode=yyparse())) 
      return rccode ;

   systeminfo->firstline = first_source_line ;
   systeminfo->lastline = last_source_line ;
   systeminfo->rootnode = parseroot ;
   parseroot = NULL ;
   tline = 0 ;

#ifndef R2PERL
#ifndef MINIMAL
#ifndef VMS
   if ( stdinput )
   {
      struct stat buffer ;

      rcode = fstat( fileno(stdin), &buffer ) ;
      if (rcode==0 && S_ISCHR(buffer.st_mode))
      { 
         printf("  \b\b") ; 
         fflush(stdout) ;
         rewind(stdin) ; 
      }
   } 
#endif /* !VMS */
#endif /* !MINIMAL */
#endif

   treadit( systeminfo->rootnode ) ;

#ifdef R2PERL
   if (make_perl)
   {
      preamble() ;
      translate( systeminfo->rootnode ) ;
      exit( 0 ) ;
   }
#endif

   string = interpret( systeminfo->rootnode ) ;

   rcode = EXIT_SUCCESS ;
   if (string)
      rcode = myatol( string ) ;

#ifdef TRACEMEM
   if (listleakedmemory)
      listleaked( MEMTRC_LEAKED )  ;
#endif

   return(rcode) ;
   
}

#ifdef TRACEMEM
void mark_systeminfo()
{
   extern sysinfo systeminfo ;
   sysinfo sinfo ;
   labelbox *lptr ;
   lineboxptr llptr ;

   for (sinfo=systeminfo; sinfo; sinfo=sinfo->previous)
   {
      markmemory(sinfo, TRC_SYSINFO) ;
      markmemory(sinfo->called_as, TRC_SYSINFO) ;
      markmemory(sinfo->input_file, TRC_SYSINFO) ;
      markmemory(sinfo->environment, TRC_SYSINFO) ;
      markmemory(sinfo->callstack, TRC_SYSINFO) ;

      markvariables( sinfo->currlevel ) ;
      marksource( sinfo->firstline ) ;
      marksubtree( sinfo->rootnode ) ;

      for (lptr=sinfo->first; lptr; lptr=lptr->next ) 
      {
         markmemory( lptr, TRC_SYSINFO ) ;
      }

      for (llptr=sinfo->firstline; llptr; llptr=llptr->next ) 
      {
         markmemory( llptr, TRC_SYSINFO ) ;
         markmemory( llptr->line, TRC_SYSINFO ) ;
      }
   }

}
#endif


sysinfobox *creat_sysinfo( streng *envir ) 
{
   sysinfobox *sinfo ;

   sinfo = Malloc( sizeof(sysinfobox) ) ;
   sinfo->environment = envir ;
   sinfo->tracing = DEFAULT_TRACING ; 
   sinfo->interactive = DEFAULT_INT_TRACING ;
   sinfo->previous = NULL ;
   sinfo->invoked = INVO_COMMAND ;
   sinfo->called_as = NULL ;
   sinfo->input_file = NULL ;
   sinfo->panic = NULL ;
   sinfo->hooks = 0 ;
   sinfo->firstline = NULL ;
   sinfo->first = NULL ;
   sinfo->last = NULL ;
   sinfo->lastline = NULL ;
   sinfo->callstack = Malloc(sizeof(nodeptr)*10) ;
   sinfo->result = NULL ;
   sinfo->rootnode = NULL ;
   sinfo->cstackcnt = 0 ;
   sinfo->cstackmax = 10 ;

   return sinfo ;
}



