#ifndef lint
static char *RCSid = "$Header: /auto/home/flipper/anders/flipper/prosj/rexx/src/RCS/library.c,v 1.2 1993/02/09 18:15:09 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: library.c,v $
 * Revision 1.2  1993/02/09  18:15:09  anders
 * Renamed Str*() to Str_*() to humor case insensitive machines
 *
 * Revision 1.1  1992/07/24  03:54:54  anders
 * Initial revision
 *
 */


#include "rexx.h"

#ifndef CHEATING

#undef TRUE
#undef FALSE
#include <curses.h>

void *dyn_get_address( char *name ) ;

typedef struct libfunctype 
{
   streng *name ;
   streng *((*addr)()) ;
   struct libfunctype *next ;
} libfunc ;


static libfunc *(libfuncs[1005]) ;

/* 
 * Calulates a hashvalue for 'name', for use as index into the array of
 *    functions that have been loaded from external function packages.
 */
int libfunchashval( streng *name ) 
{
   char *ptr=name->value, *end=Str_end(name) ;
   int result=0 ;

   for ( ; ptr<end; ptr++ )
      result = (result << 3) + *ptr ;

   return (result % 1005) ;
}


/*
 * Adds a function (a part of an external function package) to the 
 *   internal list of loaded functions. The function must have been 
 *   loaded previously
 */
void add_external( streng *((*addr)()), streng *name )
{
   struct libfunctype *tptr ;
   int hashval ;

   tptr = Malloc( sizeof( struct libfunctype ) ) ;
   tptr->next = libfuncs[ hashval=libfunchashval(name) ] ;
   tptr->name = Str_dup( name ) ;
   tptr->addr = addr ;
   libfuncs[ hashval ] = tptr ;
}
#endif


/*
 * parameters:
 *   1) name of object file to link in
 *   2) name of prefix to add to functions (default = "")
 *   3) name of library (default = filename stripped of dir and extentions)
 */
streng
 *rex_loadlib( paramboxptr parms )
{
#ifdef CHEATING
   return nullstringptr() ;
#else
   int result, i ;
   streng *string, *prefix, *pname ;

   checkparam( parms, 1, 3 ) ;
   string = Str_ify( parms->value ) ;
   if (Str_len(string) <= 0)
      exiterror( ERR_INCORRECT_CALL ) ;

   if ((parms=parms->next) && (parms->value))
      prefix = parms->value ;
   else 
      prefix = nullstringptr() ;

   if ((parms=parms->next) && (parms->value))
      pname = parms->value ;
   else
   {
      char *cptr, *ext ;
      ext = cptr = &(string->value[ string->len ]) ;
      for ( cptr--; cptr>string->value; cptr-- )
      {
         if (*cptr == '.')
            ext = cptr ;

         if (*cptr == '/')
            break ;
      }
      pname = Str_make( ext - cptr ) ;
      for ( i=0 ; cptr<ext; i++ )
         pname->value[i] = *cptr++ ;
      pname->len = i ;
   }

   result = load_package( string, pname, prefix ) ;

   return int_to_streng( result ) ;
#endif
}


streng *rex_listlib( paramboxptr parms )
{
#ifdef CHEATING
   return nullstringptr() ;
#else
   streng *result ;
   int i, length=0 ;
   libfunc *ptr ;

   checkparam( parms, 0, 0 ) ;
   for ( i=0; i<1005; i++ ) 
      for ( ptr=libfuncs[i]; ptr; ptr=ptr->next ) 
         length += Str_len( ptr->name ) + 1 ;

   result = Str_make( length ) ;
   for ( i=0; i<1005; i++ )
      for ( ptr=libfuncs[i]; ptr; ptr=ptr->next )
      {
         result = Str_cat( result, ptr->name ) ;
         result->value[ (result->len)++ ] = ' ' ;
      }
   if (result->len)
      result->len-- ;

   return result ;
#endif
}


/* 
 * Loads an external function package into memory. This can be done in 
 *    two way. 1) Dynamically loading the package, or 2) cheating by 
 *    linking the package in at compile time.
 */
int load_package( streng *fname, streng *lname, streng *prefix ) 
{
   int loaded=0 ;

#ifdef CHEATING
#else
   char **funcs, **((*init)()) ;
   streng *name, *cptr ;
   char *nameinit ;
   void *tptr, (*fun)() ;
   int i, j, length ;
   static initialized=0 ;

   if (!initialized)
   {
      initialized = 1 ;
      dyn_init( "rexx" ) ;
      for ( i=0; i<1005; i++ )
         libfuncs[i] = NULL ;
   }

   name = Str_ify( fname ) ;
   dyn_link( name->value ) ;

   name = Str_make( Str_len( lname ) + 5 ) ;
   name = Str_ify( Str_catstr( Str_cat( name, lname ), "_init" )) ;

   init = dyn_get_address( name->value ) ;
   if (!init)
   {
      fprintf(stderr, "No init-function called \"%s\"\n", name->value ) ;
      return -1 ;
   }

   funcs = (*init)() ;
   length = strlen( funcs[0] ) ;
   if (Str_len(prefix) > length)
      length = Str_len(prefix) ;

   for ( i=1; funcs[i]; i++ )
   {
      cptr = Str_make( length + strlen( funcs[i] + 1 ) ) ;
      cptr = Str_catstr( cptr, funcs[0] ) ;
      cptr = Str_catstr( cptr, funcs[i] ) ;
      cptr->value[ cptr->len ] = 0x00 ;
      tptr = dyn_get_address( cptr->value ) ;

      cptr->len = 0 ;
      cptr = Str_cat( cptr, prefix ) ;
      cptr = Str_catstr( cptr, funcs[i] ) ;
      for ( j=0; j<Str_len(cptr); j++ )
         cptr->value[j] = toupper( cptr->value[j] ) ;

      if ( tptr )        
      {
         (void)add_external( tptr, cptr ) ;
         loaded++ ;
      }
   }
#endif

   return loaded ;
 }


#ifndef CHEATING
/*
 * Returns a pointer to the function called 'name', that is assumed to 
 *    previously have been loaded from an external function package
 */

streng *(*(loaded_lib_func( streng *name )))()
{
   struct libfunctype *fptr ;

   fptr = libfuncs[ libfunchashval(name) ] ;
   for ( ; fptr; fptr=fptr->next ) 
      if (!Str_cmp( fptr->name, name ))
         return fptr->addr ;

   return NULL ;
}

extern int endwin(), wmove(), getcury(), getcurx(), waddch(),
   winsch(), winsertln(), box(), wrefresh(), wdelch(), wdeleteln(),
   wclrtoeol(), wclrtobot(), werase(), wclear()
#ifndef echo
   , echo(), noecho(), nl(), nonl() 
#endif
   ;

void *dummy_functions[] = {
   &initscr, &stdscr, &curscr, &endwin, &wmove, &getcury, &getcurx, 
   &winch, &leaveok, &waddch, &winsch, &winsertln, &box, &wrefresh,
   &wstandout, &wstandend, &wgetch, &cbreak, &nocbreak, &raw, &noraw,
   &echo, &noecho, &nl, &nonl, &wdelch, &wdeleteln, &wclrtoeol, 
   &wclrtobot, &werase, &clearok, &wclear
} ;

#endif
