#ifndef lint
static char *RCSid = "$Id: interp.c,v 1.7 1993/05/07 20:23:38 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: interp.c,v $
 * Revision 1.7  1993/05/07  20:23:38  anders
 * Inplemented better support for deallocting memory in case of runtime
 * error during interactive trace.
 *
 * Revision 1.6  1992/07/24  03:46:28  anders
 * Added GPL. Added support for better control over line numbers.
 *
 * Revision 1.5  1992/04/25  13:16:56  anders
 * Converted to REXX strings
 *
 * Revision 1.4  1992/04/05  20:18:41  anders
 * Added copyright notice
 *
 * Revision 1.3  1992/03/22  01:12:09  anders
 * #include'd stdio.h and ctype.h, which is not included in
 *    rexx.h anymore
 *
 * Revision 1.2  1990/12/10  18:39:04  anders
 * Removed bug: the returncode from yyparse() was not checked, so
 *     interactive commands and interpret-statements that contained an
 *     parse error, reexecuted the main program.
 *
 * Revision 1.1  90/08/08  02:10:09  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <ctype.h>


extern nodeptr parseroot ;

void set_line_nos( treenode *ptr, int lineno, int charno ) 
{
   int i ;

   if (!ptr)
      return ;
 
   if (ptr->lineno >= 0)
   {
      ptr->lineno = lineno ;
      ptr->charnr = charno ;
   }

   for (i=0; i<5; i++)
      if (ptr->p[i])
         set_line_nos( ptr->p[i], lineno, charno ) ;

   if (ptr->next)
      set_line_nos( ptr->next, lineno, charno ) ;
}



static streng *ostring=NULL ;

void dointerpret( streng *string ) 
{
   treenode *newtree ;
   extern nodeptr currentnode ;
   int lineno, charno ;

   lineno = currentnode->lineno ;
   charno = currentnode->charnr ;

   if (ostring)
      Free_string(ostring) ;

   initinterpret( ostring=string ) ;
   parseroot = NULL ;
   if (!yyparse()) {
      newtree = parseroot ;
      parseroot = NULL ;
      kill_lines( first_source_line ) ;
      set_line_nos( newtree, lineno, charno ) ;
      treadit( newtree ) ;
      Free( string ) ;
      ostring = NULL ;
      interpret( newtree ) ;
      if (newtree) 
         destroytree( newtree ) ;
   }
   else
      Free_string( string ) ;
}



/* actually, this is rather useless .... */
streng *dovalue( streng *string ) 
{
   treenode *newtree ;
   streng *tstr ;

   initvalue( string ) ;
   parseroot = NULL ;
   yyparse() ;
   kill_lines( first_source_line ) ;
   newtree = parseroot ;
   parseroot = NULL ;
   tstr = evaluate(newtree->p[0]->p[1]->p[0],NULL) ;
   destroytree(newtree) ;
   return tstr ;
}


