#define INCL_RXFUNC
/* #define RX_STRONGTYPING*/

#include "rexxsaa.h"

#undef TRUE
#undef FALSE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>

#include <sys/ioctl.h>



typedef struct cur_window *winptr ;
typedef struct cur_window 
{
   char name[32] ;
   WINDOW *win ;
   struct cur_window *prev, *next ;
} cur_window_type ;

winptr first=NULL, last=NULL ;


static void dropwindows( void )
{
   winptr ptr, nptr ;
 
   for (ptr=first; ptr; ptr=nptr)
   {
      nptr = ptr->next ;
      free( ptr->name ) ;
      free( ptr ) ;
   }
}

static void addwindow( WINDOW *win, char *name ) 
{
   winptr ptr ;

   ptr = malloc( sizeof(struct cur_window) ) ;
   strcpy( ptr->name, name ) ;
   ptr->win = win ;
   ptr->next = NULL ;
   ptr->prev = last ;

   if (last)
      last->prev->next = last = ptr ;

   if (!first)
      first = ptr ;
}


int strtoint( RXSTRING *ptr ) 
{
   int sum, i ;

   sum = 0 ;
   for (i=0; i<ptr->strlength; i++)
      sum = sum*10 + (ptr->strptr[i]-'0') ;

   return sum ;
}


/*====== Here come the real interface functions to curses ======*/

/*====== Initiate and terminate ================================*/

ULONG cur_initscr( 
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{ 
   if (pars!=0)
      return 1 ;

   initscr() ;

   addwindow( stdscr, "strscr" ) ;
   addwindow( curscr, "curscr" ) ;

   ptr->strptr = NULL ;
   return 0 ;
}


ULONG cur_endwin(
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   if (pars!=0)
      return 1 ;

   dropwindows() ;
   endwin() ;

   ptr->strptr = NULL ;
   return 0 ;
}


/*====== Cursor movements ======================================*/
   
ULONG cur_move( 
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   int x, y ;

   if (pars!=2)
      return 1 ;

   y = strtoint( &parm[0] ) ;
   x = strtoint( &parm[1] ) ;
   move( y, x ) ;

   ptr->strptr = NULL ;
   return 0  ;
}

ULONG cur_addch( 
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   if (pars!=1)
      return 1 ;

   if (parm[0].strlength!=1 || !parm[0].strptr)
      return 1 ;

   addch( parm[0].strptr[0] ) ;
   ptr->strptr = NULL ;
   return 0 ;
}
 

ULONG cur_addstr(
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   int i ;

   if (pars!=1 || !parm[0].strptr)
      return 1 ;

   for (i=0; i<parm[0].strlength; i++)
      addch( parm[0].strptr[i] ) ;

   ptr->strptr = NULL ;
   return 0 ;
}


ULONG cur_refresh( 
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   if (pars!=0)
      return 1 ;

   refresh() ;
   ptr->strptr = NULL ;
   return 0 ;
}


ULONG cur_erase( 
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   if (pars!=0)
      return 1 ;

   erase() ;
   ptr->strptr = NULL ;
   return NULL ;
}



ULONG cur_clear( 
   PSZ name, 
   LONG pars, 
   RXSTRING *parm, 
   PSZ stck, 
   RXSTRING *ptr)
{
   if (pars!=0)
      return 1 ;

   clear() ;
   ptr->strptr = NULL ;
   return 0 ;
}


/*====== Routines for handline new windows ======*/



int main( int argc, char *argv[] )
{
   RexxRegisterFunctionExe( "CUR_INITSCR", cur_initscr ) ;
   RexxRegisterFunctionExe( "CUR_ENDWIN", cur_endwin ) ;
   RexxRegisterFunctionExe( "CUR_CLEAR", cur_clear ) ;
   RexxRegisterFunctionExe( "CUR_ERASE", cur_erase ) ;
   RexxRegisterFunctionExe( "CUR_REFRESH", cur_refresh ) ;
   RexxRegisterFunctionExe( "CUR_MOVE", cur_move ) ;
   RexxRegisterFunctionExe( "CUR_ADDCH", cur_addch ) ;
   RexxRegisterFunctionExe( "CUR_ADDSTR", cur_addstr ) ;
   
   RexxStart( 0, NULL, "../demo/hanoi.rexx", NULL, NULL, RXCOMMAND, 
              NULL, NULL, NULL ) ;


   return 0 ;

}
