#ifndef lint
static char *RCSid = "$Id: funcs.c,v 1.14 1993/05/10 06:10:22 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: funcs.c,v $
 * Revision 1.14  1993/05/10  06:10:22  anders
 * Minor changes in order to kill compiler warnings.
 *
 * Revision 1.13  1993/05/07  16:31:13  anders
 * Added some comments and cleaned up the code. Added definitions for
 * the CMS functions find(), index() and justify(). Added support for
 * searching for external functions, and support for handling constant
 * parameters. Rewrote int_to_string in order not to call sprintf.
 *
 * Revision 1.12  1993/02/09  23:22:33  anders
 * Added more support for VMS
 *
 * Revision 1.11  1993/02/09  18:16:44  anders
 * Added new standard builtin functions b2x, x2b and stream.
 * Added VMS lexical functions as builtin functions.
 * Made some older Regina-specific functions available only in a
 * certain compatibilty mode (OLD_REGINA_FEATURES)
 * Changed the calculation of the size of the functions variable.
 * Renamed Str*() to Str_*() to keep case insensitive machines happy.
 * Changed nodeptr's misc to a union to avoid troublesome casting.
 * Removed (tail)recursion from deallocplink(), saving execution time
 * Fixed bug in int_to_string(), which allocated to little space
 * in the string that was to hold a number.
 * Plugged memory leakage in deallocplink()
 *
 * Revision 1.10  1992/07/24  03:11:31  anders
 * Added GPL. Added defs of CONDITION(). Added load/listlib(). Improved
 * builtinfunc(), allows dynamically linked in functions. Chached
 * paramboxes. Added getopionchar().
 *
 * Revision 1.9  1992/04/25  13:16:56  anders
 * Converted to REXX strings
 *
 * Revision 1.8  1992/04/05  20:19:19  anders
 * Added copyright notice
 * Added support for DATATYPE, DELWORD and TRACE
 * Moved getoption() to this file.
 *
 * Revision 1.7  1992/03/23  05:09:42  anders
 * Added several new builtin functions
 *
 * Revision 1.6  1992/03/22  01:35:44  anders
 * Added include for files removed from rexx.h
 * Added support for lots of functions
 *
 * Revision 1.5  1992/03/01  19:21:26  anders
 * Added support for traceing memory-lossed better.
 * Added routine to mark memory used temporarily by the routine
 *    that find lost memory.
 * Removed some memory-loss
 *
 * Revision 1.4  1991/04/05  23:21:09  anders
 * Added support for dbg_memorystats() and std_strip()
 * Put #ifdef's around code spesific for TRACEMEM
 *
 * Revision 1.3  90/08/26  01:52:00  anders
 * Added support for new function, eof()
 * 
 * Revision 1.2  90/08/19  02:27:47  anders
 * Added support for makebuf, dropbuf, desbuf and buftype
 * 
 * Revision 1.1  90/08/08  02:09:54  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <string.h>
#include <ctype.h>
#include <stdio.h>
#include <assert.h>

/* 
 * Prototypes for the standard Rexx builtin functions 
 */
streng *std_abbrev( paramboxptr parms ) ;
streng *std_abs( paramboxptr parms ) ;
streng *std_address( paramboxptr parms ) ;
streng *std_arg( paramboxptr parms ) ;
streng *std_b2x( paramboxptr parms ) ;
streng *std_bitand( paramboxptr parms ) ;
streng *std_bitor( paramboxptr parms ) ;
streng *std_bitxor( paramboxptr parms ) ;
streng *std_c2d( paramboxptr parms ) ;
streng *std_c2x( paramboxptr parms ) ;
streng *std_center( paramboxptr parms ) ;
streng *std_charin( paramboxptr parms ) ;
streng *std_charout( paramboxptr parms ) ;
streng *std_chars( paramboxptr parms ) ;
streng *std_compare( paramboxptr parms ) ;
streng *std_condition( paramboxptr parms ) ;
streng *std_copies( paramboxptr parms ) ;
streng *std_d2c( paramboxptr parms ) ;
streng *std_d2x( paramboxptr parms ) ;
streng *std_datatype( paramboxptr parms ) ;
streng *std_date( paramboxptr parms ) ;
streng *std_delstr( paramboxptr parms ) ;
streng *std_delword( paramboxptr parms ) ;
streng *std_digits( paramboxptr parms ) ;
streng *std_errortext( paramboxptr parms ) ;
streng *std_form( paramboxptr parms ) ;
streng *std_format( paramboxptr parms ) ;
streng *std_fuzz( paramboxptr parms ) ;
streng *std_insert( paramboxptr parms ) ;
streng *std_lastpos( paramboxptr parms ) ;
streng *std_length( paramboxptr parms ) ;
streng *std_left( paramboxptr parms ) ;
streng *std_linein( paramboxptr parms ) ;
streng *std_lineout( paramboxptr parms ) ;
streng *std_lines( paramboxptr parms ) ;
streng *std_max( paramboxptr parms ) ;
streng *std_min( paramboxptr parms ) ;
streng *std_overlay( paramboxptr parms ) ;
streng *std_pos( paramboxptr parms ) ;
streng *std_queued( paramboxptr parms ) ;
streng *std_right( paramboxptr parms ) ;
streng *std_reverse( paramboxptr parms ) ;
streng *std_random( paramboxptr parms ) ;
streng *std_sign( paramboxptr parms ) ;
streng *std_sourceline( paramboxptr parms ) ;
streng *std_space( paramboxptr parms ) ;
streng *std_stream( paramboxptr parms ) ;
streng *std_strip( paramboxptr parms ) ;
streng *std_substr( paramboxptr parms ) ;
streng *std_subword( paramboxptr parms ) ;
streng *std_symbol( paramboxptr parms ) ;
streng *std_time( paramboxptr parms ) ;
streng *std_trace( paramboxptr parms ) ;
streng *std_translate( paramboxptr parms ) ;
streng *std_trunc( paramboxptr parms ) ;
streng *std_value( paramboxptr parms ) ;
streng *std_verify( paramboxptr parms ) ;
streng *std_word( paramboxptr parms ) ;
streng *std_wordindex( paramboxptr parms ) ;
streng *std_wordlength( paramboxptr parms ) ;
streng *std_wordpos( paramboxptr parms ) ;
streng *std_words( paramboxptr parms ) ;
streng *std_x2b( paramboxptr parms ) ;
streng *std_x2c( paramboxptr parms ) ;
streng *std_x2d( paramboxptr parms ) ;
streng *std_xrange( paramboxptr parms ) ;

/*
 * Extra builtins in Regina, used for debugging purposes, and not 
 * available when compiling without debugging support.
 */
#ifndef NDEBUG
#ifdef TRACEMEM
streng *dbg_allocated( paramboxptr parms ) ;
#endif
streng *dbg_dumpvars( paramboxptr parms ) ;
streng *dbg_dumptree( paramboxptr parms ) ;
streng *dbg_traceback( paramboxptr parms ) ;     
streng *dbg_dumpfiles( paramboxptr parms ) ;
#ifdef TRACEMEM
streng *dbg_listleaked( paramboxptr parms ) ;
streng *dbg_memorystats( paramboxptr parms ) ;    
#endif /* TRACEMEM */
#endif /* !NDEBUG */

/*
 * Extra builtin, intended to give CMS compatibility support
 */
streng *cms_find( paramboxptr parms ) ;
streng *cms_index( paramboxptr parms ) ;
streng *cms_justify( paramboxptr parms ) ;
streng *cms_sleep( paramboxptr parms ) ;
streng *cms_state( paramboxptr parms ) ;
streng *cms_makebuf( paramboxptr parms ) ;
streng *cms_dropbuf( paramboxptr parms ) ;
streng *cms_desbuf( paramboxptr parms ) ;
streng *cms_buftype( paramboxptr parms ) ;

/*
 * Extra builtins in Regina
 */
streng *rex_userid( paramboxptr parms ) ;
streng *rex_loadlib( paramboxptr parms ) ;
streng *rex_listlib( paramboxptr parms ) ;

/*
 * Extra builtins, intended for VMS lexical function compatibility. 
 */
#ifdef VAXC
streng *vms_f_cvsi( paramboxptr parms ) ; 
streng *vms_f_cvtime( paramboxptr parms ) ; 
streng *vms_f_cvui( paramboxptr parms ) ; 
streng *vms_f_directory( paramboxptr parms ) ;
streng *vms_f_edit( paramboxptr parms ) ; 
streng *vms_f_element( paramboxptr parms ) ; 
/* streng *vms_f_environment( paramboxptr parms ) ; */
streng *vms_f_extract( paramboxptr parms ) ;
streng *vms_f_fao( paramboxptr parms ) ;
streng *vms_f_file_attributes( paramboxptr parms ) ; 
streng *vms_f_getdvi( paramboxptr parms ) ;
streng *vms_f_getjpi( paramboxptr parms ) ;
streng *vms_f_getqui( paramboxptr parms ) ;
streng *vms_f_getsyi( paramboxptr parms ) ;
streng *vms_f_identifier( paramboxptr parms ) ;
streng *vms_f_integer( paramboxptr parms ) ;
streng *vms_f_length( paramboxptr parms ) ;
streng *vms_f_locate( paramboxptr parms ) ;
streng *vms_f_logical( paramboxptr parms ) ; 
streng *vms_f_message( paramboxptr parms ) ;
streng *vms_f_mode( paramboxptr parms ) ;
streng *vms_f_parse( paramboxptr parms ) ; 
streng *vms_f_pid( paramboxptr parms ) ;
streng *vms_f_privilege( paramboxptr parms ) ;
streng *vms_f_process( paramboxptr parms ) ;
streng *vms_f_search( paramboxptr parms ) ; 
streng *vms_f_setprv( paramboxptr parms ) ;
streng *vms_f_string( paramboxptr parms ) ;
streng *vms_f_time( paramboxptr parms ) ;
streng *vms_f_trnlnm( paramboxptr parms ) ;
streng *vms_f_type( paramboxptr parms ) ; 
streng *vms_f_user( paramboxptr parms ) ; 
/* streng *vms_f_verify( paramboxptr parms ) ; */
#endif

/*
 * Extra builtin functions, giving Unix compatibility
 */
streng *unx_getenv( paramboxptr parms ) ;
streng *unx_getpath( paramboxptr parms ) ;  /* not working ... */
streng *unx_chdir( paramboxptr parms ) ;
streng *unx_unixerror( paramboxptr parms ) ;
streng *unx_eof( paramboxptr parms ) ;
streng *unx_popen( paramboxptr parms ) ;
streng *unx_getpid( paramboxptr parms ) ;     
#ifdef OLD_REGINA_FEATURES
streng *unx_open( paramboxptr parms ) ;
streng *unx_close( paramboxptr parms ) ;
#endif

struct function_type
{
   int length ;
   streng *(*function)() ;
   char *funcname ; 
} ;

struct function_type functions[] = {
      { 6, std_abbrev, "ABBREV" },     
      { 3, std_abs, "ABS" }, 
      { 7, std_address, "ADDRESS" }, 
#ifdef TRACEMEM
      { 9, dbg_allocated, "ALLOCATED" },
#endif
      { 3, std_arg, "ARG" },    
      { 3, std_b2x, "B2X" },
      { 6, std_bitand, "BITAND" },  
      { 5, std_bitor, "BITOR" },  
      { 6, std_bitxor, "BITXOR" }, 
      { 7, cms_buftype, "BUFTYPE" },
      { 3, std_c2d, "C2D" },     
      { 3, std_c2x, "C2X" },
      { 2, unx_chdir, "CD" },
      { 6, std_center, "CENTER" },
      { 6, std_center, "CENTRE" },  
      { 6, std_charin, "CHARIN" }, 
      { 7, std_charout, "CHAROUT" }, 
      { 5, std_chars, "CHARS" }, 
      { 5, unx_chdir, "CHDIR" },
#ifdef OLD_REGINA_FEATURES
      { 5, unx_close, "CLOSE" },
#endif
      { 7, std_compare, "COMPARE" },
      { 9, std_condition, "CONDITION" },
      { 6, std_copies, "COPIES" }, 
      { 3, std_d2c, "D2C" },
      { 3, std_d2x, "D2X" },
      { 8, std_datatype, "DATATYPE" },
      { 4, std_date, "DATE" },   
      { 6, std_delstr, "DELSTR" },
      { 7, std_delword, "DELWORD" }, 
      { 6, cms_desbuf, "DESBUF" },
      { 6, std_digits, "DIGITS" }, 
      { 7, cms_dropbuf, "DROPBUF" },
#ifndef NDEBUG
      { 9, dbg_dumpfiles, "DUMPFILES" },
      { 8, dbg_dumptree, "DUMPTREE" },
      { 8, dbg_dumpvars, "DUMPVARS" },
#endif
      { 3, unx_eof, "EOF" },
      { 9, std_errortext, "ERRORTEXT" },
#ifdef VAXC
      {  6, vms_f_cvsi, "F$CVSI" },
      {  8, vms_f_cvtime, "F$CVTIME" },
      {  6, vms_f_cvui, "F$CVUI" },
      { 11, vms_f_directory, "F$DIRECTORY" },
      {  9, vms_f_element, "F$ELEMENT" },
      {  9, vms_f_extract, "F$EXTRACT" },
      {  5, vms_f_fao, "F$FAO" },
      { 17, vms_f_file_attributes, "F$FILE_ATTRIBUTES" },
      {  8, vms_f_getdvi, "F$GETDVI" },
      {  8, vms_f_getjpi, "F$GETJPI" },
      {  8, vms_f_getqui, "F$GETQUI" },
      {  8, vms_f_getsyi, "F$GETSYI" },
      { 12, vms_f_identifier, "F$IDENTIFIER" },
      {  9, vms_f_integer, "F$INTEGER" },
      {  7, vms_f_length, "F$LENGTH" },
      {  8, vms_f_locate, "F$LOCATE" },
      {  9, vms_f_logical, "F$LOGICAL" },
      {  9, vms_f_message, "F$MESSAGE" },
      {  6, vms_f_mode, "F$MODE" },
      {  7, vms_f_parse, "F$PARSE" },
      {  5, vms_f_pid, "F$PID" },
      { 11, vms_f_privilege, "F$PRIVILEGE" },
      {  9, vms_f_process, "F$PROCESS" },
      {  8, vms_f_search, "F$SEARCH" },
      {  8, vms_f_setprv, "F$SETPRV" },
      {  8, vms_f_string, "F$STRING" },
      {  6, vms_f_time, "F$TIME" },
      {  8, vms_f_trnlnm, "F$TRNLNM" },
      {  6, vms_f_type, "F$TYPE" },
      {  6, vms_f_user, "F$USER" },
/*    {  8, vms_f_verify, "F$VERIFY" }, */
#endif
      { 4, cms_find, "FIND" },
#ifdef OLD_REGINA_FEATURES
      { 5, unx_close, "FINIS" },
#endif /* OLD_REGINA_FEATURES */
      { 4, std_form, "FORM" }, 
      { 6, std_format, "FORMAT" },
      { 4, std_fuzz, "FUZZ" }, 
      { 6, unx_getenv, "GETENV" }, 
      { 7, unx_getpath, "GETPATH" },
      { 6, unx_getpid, "GETPID" },
      { 5, cms_index, "INDEX" },
      { 6, std_insert, "INSERT" },
      { 7, cms_justify, "JUSTIFY" },
      { 7, std_lastpos, "LASTPOS" }, 
      { 4, std_left, "LEFT" },
      { 6, std_length, "LENGTH" },
      { 6, std_linein, "LINEIN" },
      { 7, std_lineout, "LINEOUT" },
      { 5, std_lines, "LINES" },
#ifdef TRACEMEM
      { 10, dbg_listleaked, "LISTLEAKED" },
#endif
      { 7, rex_listlib, "LISTLIB" },
      { 7, rex_loadlib, "LOADLIB" },
      { 7, cms_makebuf, "MAKEBUF" },
      { 3, std_max, "MAX" },
#ifdef TRACEMEM
      { 11, dbg_memorystats, "MEMORYSTATS" },
#endif
      { 3, std_min, "MIN" },
#ifdef OLD_REGINA_FEATURES
      { 4, unx_open, "OPEN" },
#endif /* OLD_REGINA_FEATURES */
      { 7, std_overlay, "OVERLAY" },
      { 5, unx_popen, "POPEN" },
      { 3, std_pos, "POS" }, 
      { 6, std_queued, "QUEUED" }, 
      { 6, std_random, "RANDOM" }, 
      { 7, std_reverse, "REVERSE" }, 
      { 5, std_right, "RIGHT" }, 
      { 4, std_sign, "SIGN" },
      { 5, cms_sleep, "SLEEP" },
      { 10, std_sourceline, "SOURCELINE" },
      { 5, std_space, "SPACE" },
      { 5, cms_state, "STATE" },
      { 6, std_stream, "STREAM" }, 
      { 5, std_strip, "STRIP" },
      { 6, std_substr, "SUBSTR" },
      { 7, std_subword, "SUBWORD" },
      { 6, std_symbol, "SYMBOL" }, 
      { 4, std_time, "TIME" },
      { 5, std_trace, "TRACE" },
#ifndef NDEBUG
      { 9, dbg_traceback, "TRACEBACK" },
#endif
      { 9, std_translate, "TRANSLATE" },
      { 5, std_trunc, "TRUNC" }, 
      { 9, unx_unixerror, "UNIXERROR" },
      { 6, rex_userid, "USERID" },
      { 5, std_value, "VALUE" }, 
      { 6, std_verify, "VERIFY" }, 
      { 4, std_word, "WORD" },
      { 9, std_wordindex, "WORDINDEX" }, 
      { 10, std_wordlength, "WORDLENGTH" }, 
      { 7, std_wordpos, "WORDPOS" }, 
      { 5, std_words, "WORDS" },
      { 3, std_x2b, "X2B" },
      { 3, std_x2c, "X2C" },
      { 3, std_x2d, "X2D" },
      { 6, std_xrange, "XRANGE" },
      { 0, NULL, NULL } 
} ;

static int num_funcs = sizeof(functions)/(sizeof(struct function_type)) - 1 ;


#ifdef TRACEMEM
static paramboxptr listleaked_params ;

void mark_listleaked_params()
{
   extern paramboxptr listleaked_params ;
   paramboxptr pptr ;

   for (pptr=listleaked_params; pptr; pptr=pptr->next) 
   {
      markmemory( pptr, TRC_PROCARG ) ;
      if (pptr->value) 
         markmemory( pptr->value, TRC_PROCARG ) ;
   }
}
#endif


streng nofunc = { 1, 1, "" } ;
   
streng *buildtinfunc( nodeptr this ) 
{
   static paramboxptr first=NULL ;
   int low=0, topp, mid, end=1, up=num_funcs-1, i ;
   streng *ptr ;
   int ext=0 ;
   streng *(*func)(paramboxptr)=NULL ;

#ifndef CHEATING
   func = loaded_lib_func( this->name ) ;
#endif

   if (!func)
   {
      ext = external_func( this->name ) ;
      if (ext)
         func = std_center ; /* e.g. */
   }

   if (!func)
   {
      topp = Str_len( this->name ) ;

      if (this->u.func) 
	 func = this->u.func ;
      else
      {
         mid = 0 ;  /* too keep the compiler happy */
         while ((end)&&(up>=low)) 
         {
            mid = (up+low)/2 ;
            for (i=0; i<topp; i++ )
               if (this->name->value[i] != functions[mid].funcname[i]) 
	          break ;

            if (i==topp) 
               end = (functions[mid].funcname[i]!=0x00) ;
            else
               end = ( functions[mid].funcname[i] - this->name->value[i] ) ;

            if (end>0) 
               up = mid-1 ;
            else 
               low = mid+1 ; 
         }
         if (!end)
            this->u.func = func = functions[mid].function ;
      }
   }

   if (func)
   {
      if (first)
         deallocplink( first ) ;
      
      first = initplist( this ) ;
      if (ext)
         ptr = do_an_external( this->name, first ) ;
      else
         ptr = (*func)(first /* ->next */ ) ;

      deallocplink( first ) ;
      first = NULL ;
      return ptr ;
   }
   else
      return &nofunc ;
}


paramboxptr par_stack = NULL ;


paramboxptr initplist( nodeptr this )
{
#ifdef TRACEMEM
   extern paramboxptr listleaked_params ;
#endif
   paramboxptr first, new, currnt ;
   streng *pptr ;
   streng *junk ;

   first = currnt = NULL ;
   for (this=this->p[0]; this; this=this->p[1])
   {
      if (par_stack)
      {
         new = par_stack ;
         par_stack = new->next ;
      }
      else
         new = Malloc( sizeof( parambox )) ;

      if (!first)
         first = currnt = new ;
      else
      {
         currnt->next = new ;
         currnt = new ;
      }

      if (this->type==X_CEXPRLIST && trace_stat!='I')
      {
         if (this->u.strng)
            pptr = this->u.strng ;
         else
            pptr = NULL ;

         currnt->dealloc = 0 ;
      }
      else
      {
         currnt->dealloc = 1 ;
         if (this->p[0])
            pptr = evaluate( this->p[0], &junk ) ;
         else
            pptr = NULL ;

         if (!junk)
/*            pptr = Str_dup( pptr ) ; */
            currnt->dealloc = 0 ;
      }

      currnt->value = pptr ;
   }
#ifdef TRACEMEM
   listleaked_params = first ;
#endif
   currnt->next = NULL ;
   return first ;
}


void deallocplink( paramboxptr first ) 
{
   paramboxptr this ;

   for (;first;)
   {
      this = first ;
      first = first->next ;
      if (this->dealloc && this->value) 
         Free_string( this->value ) ;

      this->next = par_stack ;
      par_stack = this ;
   }
}


#ifdef TRACEMEM
void mark_param_cache()
{
   paramboxptr ptr ;
  
   ptr = par_stack ;
   for (; ptr; ptr=ptr->next ) 
      markmemory( ptr, TRC_P_CACHE ) ;
}
#endif



int myatol( streng *text )
{
   char *ch, *end ;
   int utput=0, sign=0 ;

   end = (ch=text->value) + Str_len(text) ;
   for (; isspace(*ch) && (ch<end); ch++) ;
   if ((*ch=='-')||(*ch=='+'))
   {
      sign = (*ch++=='-') ;
      for (; isspace(*ch) && ch<end; ch++) ;
   }
  
   for (; isdigit(*ch) && (ch<end); ch++ ) 
      utput = (utput*10) + ((*ch)-'0') ;

   for (; isspace(*ch) && (ch<end); ch++) ;
   if (ch!=end)
      exiterror( ERR_INVALID_INTEGER ) ; 

   if (sign)
      utput = - utput ;

   return utput ;
}


int atozpos( streng *text )
{ 
   int result ;

   if ((result=myatol(text))<0)
      exiterror(ERR_INCORRECT_CALL) ;

   return result ;
}


char getoptionchar( streng *text, char *choices ) 
{
   char ch ;

   if (text->len==0) 
      exiterror( ERR_INCORRECT_CALL ) ;
   
   ch = toupper( text->value[0] ) ;

   for (; *choices; choices++) 
      if (*choices==ch)
         return ch ;

   exiterror( ERR_INCORRECT_CALL ) ;
   return 0x00 ; /* just to please the compiler */
}


char getonechar( streng *text )
{
   if ((!text)||(Str_len(text)!=1))
      exiterror( ERR_INCORRECT_CALL ) ;
   
   return text->value[0] ;
}

int atopos( streng *text )
{ 
   int result ;

   if ((result=myatol(text))<=0)
      exiterror( ERR_INCORRECT_CALL ) ;

   return result ;
}



streng *int_to_streng( int input )
{
   streng *output ;
   char *cptr, *start, *top ;

   output = Str_make( sizeof(int)*3 + 2 ) ;
   start = output->value ;
   cptr = start + sizeof(int)*3 + 2 ;
   if (input)
   {
      if (input<0)
      {
         input = - input ;
         *(start++) = '-' ;
      } 

      for (top=cptr;input;)
      {
         *(--cptr) = input % 10 + '0' ;
         input = input / 10 ;
      }

      memmove( start, cptr, top-cptr ) ;
      output->len = top-cptr + start-output->value ;
   }
   else
   {
      *start = '0' ;
      output->len = 1 ;
   }

   return output ;
}


void checkparam( paramboxptr params, int min, int max )
{
   int i ;

   for (i=0;i<min;i++,params=params->next)
      if ((!params)||(!params->value)) 
         exiterror(ERR_INCORRECT_CALL) ;

   for (;(i<max)&&(params);i++,params=params->next) ;
   if (((i==max)&&(params))&&((max)||(params->value)))
      exiterror(ERR_INCORRECT_CALL) ;
}
   

streng *cpy( streng *source )
{
   return Str_dup( source ) ;
}


streng *param( paramboxptr ptr, int num )
{
   int i ;
   for (i=1;i<num;i++,ptr=ptr->next) 
      if (!ptr)
         exiterror( ERR_INTERPRETER_FAILURE ) ;

   return ((ptr)&&(ptr->value)) ? ptr->value : NULL ;
}

char getoption( streng *test ) 
{ 
   if ((!test)||(!Str_len(test)))
      return 0x00 ;
  
   return toupper(test->value[0]) ; 
}
