#ifndef lint
static char *RCSid = "$Id: extlib.c,v 1.1 1993/05/07 21:36:04 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: extlib.c,v 1.1 1993/05/07 21:36:04 anders Exp anders $
 */

#include "rexx.h"

static struct funcbox {
   struct funcbox *next, *prev ;
   streng *name ;
   int type ;
} *firstfunc=NULL ;


static struct funcbox *findfunc( streng *name )
{
   struct funcbox *fptr ;
   for (fptr=firstfunc; fptr; fptr=fptr->prev) 
      if (!Str_cmp(name, fptr->name))
         return fptr ;

   return NULL ;
}


int delfunc( streng *name )
{
   struct funcbox *old ;
  
   old = findfunc( name ) ;
   if (!old)
      return 1 ;

   Free_string( old->name ) ;
   if (old==firstfunc)
      firstfunc = old->prev ;
   else 
      old->next->prev = old->prev ;

   if (old->prev)
      old->prev->next = old->next ;

   Free( old ) ;
   return 0 ;
}


int addfunc( streng *name, int type ) 
{
   struct funcbox *new ;

   if (findfunc( name ))
      return 1 ;

   new = Malloc( sizeof(struct funcbox )) ;
   if (!new)
      return 1 ;

   new->name = name ;
   new->type = type ;
   new->next = NULL ;
   new->prev = firstfunc ;
   if (firstfunc)
      firstfunc->next = new ;
   firstfunc = new ;

   return 0 ;
}



int external_func( streng *name )
{
   struct funcbox *ptr ;

   ptr = findfunc( name ) ;
   if (ptr)
      return 1 ;
   else
      return 0 ;
}


