#ifndef lint
static char *RCSid = "$Id: debug.c,v 1.11 1993/05/07 20:10:58 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: debug.c,v $
 * Revision 1.11  1993/05/07  20:10:58  anders
 * Changed the error handling routines to allow applications to hook into
 * it. Improved storing of source code to allow reentrant execution.
 *
 * Revision 1.10  1993/02/09  18:13:19  anders
 * Renamed Str*() to Str_*() to humor case insensitive machines.
 * Renamed firstline to src_firstline, to avoid name confusion.
 * Fixed various compiler warnings.
 *
 * Revision 1.9  1992/07/24  03:27:10  anders
 * Added GPL. Fixed problems with old-type strings.
 *
 * Revision 1.8  1992/04/25  13:18:30  anders
 * Converted to REXX strings
 *
 * Revision 1.7  1992/04/05  20:27:00  anders
 * Added copyright notice, and ANSI-fied the code
 *
 * Revision 1.6  1992/03/22  00:51:45  anders
 * Added support for writing out the default value for associative
 *    arrays, or "<none>" it the default is not set.
 * #included <stdio.h> and <strings.h>, as these are removed from rexx.h
 * Fixed bug: tried to read variable value as a hashtable, this was
 *    once a quick'n dirty sideeffect and had been changed elsewhere,
 *    but still existed in this file.
 *
 * Revision 1.5  1991/04/05  23:30:25  anders
 * Put #ifdef's around markmemory()
 *
 * Revision 1.4  90/12/11  00:02:58  anders
 * Removed two bugs connected to line continuation.
 *     1) The first character in the continuation line was omitted when
 *     the line was written out during tracing.
 *     2) If to symbols were separated by just line continuation (and 
 *     not any white-space) they were concatenated when written out during
 *     traceing.
 * 
 * Revision 1.3  90/12/10  00:30:26  anders
 * Casted a pointer to (char*), to avoid compiler warning.
 * 
 * Revision 1.2  90/08/09  04:01:38  anders
 * Changed magic numbers with TRC_* macros
 * 
 * Revision 1.1  90/08/08  02:09:11  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>

#ifndef NDEBUG

void dumpvars( variableptr *hashptr ) 
{ 
   variableptr ptr, tptr ;
   extern proclevel currlevel ;
   int i, j ;

   if (hashptr==NULL)
      hashptr = currlevel->vars ;
   
   printf("\nDumping variables to <stdout>\n") ;
   for (i=0;i!=256;i++) {
      if (hashptr[i]!=NULL)
         printf("   Variables from bin no %d\n",i) ;
      for (ptr=hashptr[i];ptr!=NULL;ptr=ptr->next)  
         if ((ptr->name->value)[strlen(ptr->name->value)-1]=='.') {
            printf("   >>> Stem    : //%s// Default: //%s//  Values:\n",
                  ptr->name->value,(ptr->value)?(ptr->value->value):"<none>") ;
            for (j=0;j<256;j++) {
               if ((tptr=((ptr->index))[j])) {
                  printf("      Sub-bin no %d\n",j) ;
                  for (;tptr;tptr=tptr->next) 
                     if ((tptr->value)&&(tptr->name))
                        printf("      >>> Variable: //%s// Value: //%s//\n",
                              tptr->name->value,tptr->value->value) ; } ; } ; }
         else 
            printf("   >>> Variable: //%s// Value: //%s//\n",
                                    ptr->name->value,ptr->value->value) ; }

   return ;
}


void dumptree(treenode *this, int level) 
{
   int i, j ;

   for (i=0;i!=level;i++)
      printf("  ") ;
   
   printf(">>> in type=%d == %s\n", this->type, getsym(this->type)) ; 
/*
   if ((this->value)!=NULL) {
      for (i=0;i!=level;i++) printf("  ") ;
      printf("Value: //%s//\n", this->value) ; } ;
 */
   if ((this->name)!=NULL) {
      for (i=0;i!=level;i++) printf("  ") ;
      printf("Name: //%s//\n", this->name->value) ; } ;

   if ((this->charnr)!=0) {
      for (i=0;i!=level;i++) printf("  ") ;
      printf("Lineno: %d   Charno: %d\n", this->lineno, this->charnr) ; } ;

   for (j=0;j!=5;j++)
      if (this->p[j]!=NULL) {
         for (i=0;i!=level;i++) 
            printf("  ") ;
         printf("==> (%d) going down in branch %d, type %d = %s\n",
                this->type,j+1,this->p[j]->type,getsym(this->p[j]->type)) ;
         dumptree( this->p[j], level+1 ) ; }
         
   for (i=0;i!=level;i++) 
      printf("  ") ;
   printf("<<< out of type=%d = %s\n", this->type,getsym(this->type)) ; 

}

#endif /* !NDEBUG */


extern sysinfobox *systeminfo ;

int numsourcelines( void )
{
   extern sysinfobox *systeminfo ;
   return (systeminfo->lastline) ? systeminfo->lastline->lineno : 0 ;
}



#ifdef TRACEMEM
void marksource( lineboxptr ptr )
{
   for (;ptr;ptr=ptr->next) {
      markmemory( ptr->line,TRC_SOURCEL ) ;
      markmemory( (char *)ptr, TRC_SOURCE ) ; }
}
#endif


streng *sourceline( int line, lineboxptr first, lineboxptr last ) 
{
   static lineboxptr ptr=NULL ;
/*
   extern sysinfo systeminfo ;

   if (!ptr) 
      ptr = systeminfo->firstline ; 
 */
   ptr = first ;

   for (;ptr;) 
   {
      if (ptr->lineno==line)
         return ptr->line ;
      else 
         ptr = (ptr->lineno<line) ? ptr->next : ptr->prev ;
   }

   return NULL ;
}



streng *getsourceline( int line, int charnr, lineboxptr first, lineboxptr last )
{
   int dquote=0, squote=0 ;
   streng *string, *ptr ;
   char *chptr, *chend, *outptr, *tmptr ;

   assert( charnr>=0 ) ;
   if (!charnr)
     charnr++ ;

   ptr = sourceline(line,first,last) ;
/*   assert( ptr ) ; */
   if (!ptr)
      return nullstringptr() ;

   chptr = ptr->value + --charnr ;
   chend = ptr->value + ptr->len ;
   for (; isspace(*chptr); chptr++) ;
   string = Str_make(BUFFERSIZE+1) ;
   outptr = string->value ;

   for (;;)
   {
      if (chptr>=chend)
         break ;

      if (!squote && *chptr=='\"')
         dquote = !dquote ;

      else if (!dquote && *chptr=='\'')
         squote = !squote ;

      else if (!(dquote || squote))
      {
         switch (*chptr)
         {
            case ',':
               for(tmptr=chptr+1; isspace(*tmptr); tmptr++ ) ;
               assert( tmptr<=chend ) ;
               if (tmptr==chend)
               {
                  *(outptr++) = ' ' ;
                  ptr = sourceline(++line,first,last) ;
                  chptr = ptr->value ;
                  chend = chptr + ptr->len ;
                  for(; isspace(*tmptr); tmptr++) ;
               }
               break ;
           
            case ':':
               *(outptr++) = *chptr ;

            case ';':
               goto endloop ;

         }
      }

      *(outptr++) = *(chptr++) ;
   }

endloop:
   assert( outptr - string->value <= BUFFERSIZE ) ;   
   string->len = outptr - string->value ;
   return string ;
}
      
         
      
      



