#ifndef lint
static char *RCSid = "$Id: dbgfuncs.c,v 1.9 1993/05/07 20:12:35 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: dbgfuncs.c,v $
 * Revision 1.9  1993/05/07  20:12:35  anders
 * Made code reentrant (wrt systeminfo)
 *
 * Revision 1.8  1992/07/24  03:27:59  anders
 * Added GPL. #ifdefs out debugging if NDEBUG. Removed some bugs
 *
 * Revision 1.7  1992/04/25  13:21:27  anders
 * Converted to REXX strings
 *
 * Revision 1.6  1992/04/05  20:27:56  anders
 * Added copyright notice
 * Added options to listleaked()
 *
 * Revision 1.5  1992/03/22  01:27:18  anders
 * #include'd stdio.h, which was removed from rexx.h
 * Added support for options in allocated()
 *
 * Revision 1.4  1992/03/01  04:00:14  anders
 * Rewrote use of sprintf(), since it can not be trusted to return
 *    the string it has been writing to.
 * Added support for a parameter to listleaked() (quick and dirty)
 *
 * Revision 1.3  1991/05/28  23:40:26  anders
 * Removed calls to cleareverything() and markall(), since these two
 * routines are incorporated in listleaked()
 *
 * Revision 1.2  91/04/05  23:23:32  anders
 * Added dbg_memorystats()
 * Put #ifdef's around list_leaked()
 * 
 * Revision 1.1  90/08/08  02:08:51  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#include <stdio.h>
#include <ctype.h>

#ifndef NDEBUG

streng *dbg_traceback( paramboxptr parms )
{
   traceback() ;
   return nullstringptr() ;
}


char *dbg_dumpvars( paramboxptr parms ) 
{
   char *ptr ;
   extern proclevel currlevel ;

   dumpvars(currlevel->vars) ;
   ptr = Malloc(1+STRHEAD) ;
   *ptr = '\000' ;  
   return ptr ;
}


#ifdef TRACEMEM
streng *dbg_memorystats( paramboxptr parms )
{
/*    memory_stats() ; */
   return nullstringptr() ;
}


char *dbg_allocated( paramboxptr parms )
{
   char ch, *ptr ;

   checkparam( parms, 0, 1 ) ;
   if (!parms->value)
      ch = 'A' ;
   else
      ch = getonechar(parms->value) & 0xdf ;

   switch ( ch ) 
   {
      case 'A' :
         sprintf(ptr=Malloc(SMALLSTR+STRHEAD),"%d",have_allocated(MEM_ALLOC)) ;
         break ;

      case 'L' :
         sprintf(ptr=Malloc(SMALLSTR+STRHEAD),"%d",have_allocated(MEM_LEAKED)) ;
         break ;

      case 'C' : 
         sprintf(ptr=Malloc(SMALLSTR+STRHEAD),"%d",have_allocated(MEM_CURRENT)) ;
         break ;

      case 'S' :
         sprintf(ptr=Malloc(80+STRHEAD),"Memory: Allocated=%d, Current=%d, Leaked=%d",
                 have_allocated(MEM_ALLOC), have_allocated(MEM_CURRENT),
                 have_allocated(MEM_LEAKED)) ;     
          break ;

      default:
          exiterror( ERR_INCORRECT_CALL ) ;
   }

   return( ptr ) ;
}
#endif


char *dbg_dumptree( paramboxptr parms ) 
{
   extern sysinfobox *systeminfo ;
   char *ptr ;

   dumptree( systeminfo->rootnode, 1 ) ;
   ptr = Malloc(1+STRHEAD) ;
   *ptr = '\000' ;
   return ptr ;
}


#ifdef TRACEMEM


char *dbg_listleaked( paramboxptr parms )
{
   char *ptr, ch ;
   int i ;

   checkparam( parms, 0, 1 ) ;
   if (parms->value)
      ch = toupper(getonechar(parms->value)) ;
   else 
      ch = 'L' ;

   if (ch=='N')
      i = listleaked( MEMTRC_NONE ) ;
   else if (ch=='L')
      i = listleaked( MEMTRC_LEAKED ) ;
   else if (ch=='A')
      i = listleaked( MEMTRC_ALL ) ;
   else
      exiterror( ERR_INCORRECT_CALL ) ;

   ptr = Malloc(SMALLSTR+STRHEAD) ;
   sprintf(ptr,"%d",i) ;
   return ptr ;
}
#endif

#endif /* !NDEBUG */
