/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: config.h,v 1.11 1993/05/10 06:08:55 anders Exp anders $
 *
 * $Log: config.h,v $
 * Revision 1.11  1993/05/10  06:08:55  anders
 * Removed kludges that was not needed anymore.
 *
 * Revision 1.10  1993/02/09  18:04:35  anders
 * Added code to cope with Sun's inabilities (more SunKlugdes)
 * Removed the non-POSIX features, by undef'ing the HAS_* macros.
 * Added OLD_REGINA_FEATURES to allow for compatibility
 *
 * Revision 1.9  1992/07/24  03:03:51  anders
 * Added GPL. HASHTABLENGTH was far to high. Added flag for availability
 * of putenv(). Added kludge  to get struct timeval under HP/UX.
 * Added CHEATING to avoid using unfinished libraries. Added YY_TYPE_CHAR
 * to circumvent problems in lexsrc.l with type of char. Added flag for
 * availability of ftruncate()
 *
 * Revision 1.8  1992/04/25  13:16:56  anders
 * Converted to REXX strings
 *
 * Revision 1.7  1992/04/05  20:30:52  anders
 * Added copyright notice
 * Added macros for isolation of gettimeofday() and ftruncate()
 * Added macro for isolation of rand() and srand()
 * Added soim code needed for Dolphin
 *
 * Revision 1.6  1992/03/22  18:52:42  anders
 * Added support for CRAY
 *
 * Revision 1.5  1992/03/22  01:23:26  anders
 * Added FIX_PROTOS to switch patching of prototypes.
 * Added support for configuring wether to use rand() or random()
 * Added cpp-macros for most OS'es i compile on.
 *
 * Revision 1.4  1992/03/01  18:57:58  anders
 * Removed EIGHTBITCLEAN from m88k ... I don't remember why ... ?
 *
 * Revision 1.3  1991/06/03  02:52:55  anders
 * On ultrix-mashines, HAS_USLEEP is #ifdef'ed away
 * Added defaults for numeric fuzz and size, and default math type
 *
 * Revision 1.2  91/04/05  23:45:48  anders
 * Addet support for configurable directory separator character
 * Added flag for the existence of usleep()
 * 
 * Revision 1.1  90/08/08  02:04:01  anders
 * Initial revision
 * 
 */

/* Configurable values */


/* The macro MAXLEVELS is the maximum number of levels that the 
 *   interpreter shall handle. One level is used for functioncalls and
 *   the commands CALL, IF, DO and SELECT
 */
#define MAXLEVELS        1024

/* The macro HASHTABLENGTH is the number of sloths in the hash table
 *   containing the values of the rexx variables
 */
#define HASHTABLENGTH     256

/* The macro MAX_INDEX_LENGTH defines the maximum length that the name
 *   of an compund variable might expand to.
 */
#define MAX_INDEX_LENGTH  256

/*
 * Define the following macro if you have 'struct timeval' and gettimeofday()
 *   these should be in /usr/include/sys/time.h
 */
#define HAS_TIMEVAL

/* 
 * Define the following if your machine has putenv(), unfortunately, 
 *   Standard C does not include a way to set environmentvariables, just 
 *   to read them. But most machines have the putenv() function.
 * If it is not defined, you will not be able to set the environment 
 *   variables throught the VALUE() builtin function. 
 */
#define HAS_PUTENV

/* 
 * The FILE_SEPARATOR is one character, and defines the char that separates
 *    directories, and filename from directories
 */

#ifdef MSDOS
# define FILE_SEPARATOR	   '\\'
#else
# define FILE_SEPARATOR    '/'
#endif


#define FIX_PROTOS



   /* don't properly include dyn. libraries, since they don't work yet */
#define CHEATING   


extern unsigned char u_to_l[] ;
#define RXTOLOW(a) (u_to_l[(unsigned char)(a)])



#if defined(hpux) || defined(__hpux)
# define HPUX
# define YY_CHAR_TYPE unsigned char
/* # undef HAS_TIMEVAL */
#endif

#ifdef sun
# define SUNOS 1
#endif

#ifdef SunKludges
  extern char *sys_errlist[] ;
# define memmove(a,b,c) bcopy(b,a,c)
# define strerror(a)    sys_errlist[a]
#endif

#if defined(sgi) || defined(__sgi)
# define SGI 1
#endif

#if defined(__osf__)
# define OSF 1
# define YY_CHAR_TYPE unsigned char
#endif

#if defined(ultrix) || defined(__ultrix__)
# define ULTRIX 1
#endif

/* 
 * Define HAS_USLEEP if you have the usleep() function available. It will
 *    take the number of micro-seconds to sleep. If this is not defined, 
 *    the 'normal' sleep() will be used.
 */

#ifdef SUNOS
#define HAS_USLEEP
#endif


/*
 * Define HAS_RANDOM if your machine has the routines random() and 
 *    srandom(). If it is not defined, rand() and srand() are used
 *    instead. There are several reason why you might want to use 
 *    random() instead of rand()
 */

#if SUNOS || ULTRIX
# define HAS_RANDOM
#endif

#ifdef HAS_RANDOM
  extern long random( void ) ;
  extern void srandom( int ) ;
#endif 


#define DEFAULT_NUMERIC_FUZZ 0
#define DEFAULT_NUMERIC_SIZE 9
#define DEFAULT_MATH_TYPE 0


/* 
 * If you use gcc on a machine that does not have proper ANSI C 
 * libraries and the function div() is not defined, then you can 
 * define the symbol HAS_NO_DIV, which will try to kludge it. 
 *
 * This is necessary on Suns, and some other machines.
 */

/* #define HAS_NO_DIV */          /* does div() exist? */


#ifndef YY_CHAR_TYPE
# define YY_CHAR_TYPE char
#endif


/* Unfortunately, ftruncate() is not POSIX, so if you don't have it,
 * just ignore it, the effect is that lines written to the middle of a
 * file will not cause the rest of the file (after the linefeed
 * terminating the line written), also to truncate the file at that
 * point. If you wonder whether you have ftruncate(), the bsd portions
 * of you system (if it exist) is a good place to start looking. You
 * may have to link in a specific library too, maybe libbsd.a.
 */
#define HAS_FTRUNCATE 


#ifdef VAXC
# ifdef HAS_TIMEVAL
#  undef HAS_TIMEVAL
# endif
# ifdef HAS_PUTENV
#  undef HAS_PUTENV
# endif
# ifdef HAS_FTRUNCATE
#  undef HAS_FTRUNCATE
# endif
#endif


#if defined(__GNUC__) && defined(VMS)
# ifdef HAS_TIMEVAL
#  undef HAS_TIMEVAL
# endif
#endif

#define OLD_REGINA_FEATURES
