#ifndef lint
static char *RCSid = "$Id: cmsfuncs.c,v 1.14 1993/05/10 06:07:22 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: cmsfuncs.c,v $
 * Revision 1.14  1993/05/10  06:07:22  anders
 * Minor adjustments in order to kill compiler warnings.
 *
 * Revision 1.13  1993/05/07  20:18:06  anders
 * Implmented justify, and created index and find as 'frontends' to
 * pos and wordpos.
 *
 * Revision 1.12  1993/02/09  17:32:32  anders
 * Renamed Str*() to Str_*() to humor case insensitive machines
 * Ported to VMS, and had to include some other files.
 *
 * Revision 1.11  1992/07/24  03:38:32  anders
 * Added GPL. Some minor changes to buffer handling. Changes to
 * cms_state, might work better.
 *
 * Revision 1.10  1992/04/25  18:51:30  anders
 * Changed call from destroy_buffer() to drop_buffer(), since the
 *     destroy_buffer function is taken out of the code.
 *
 * Revision 1.9  1992/04/25  13:15:50  anders
 * converted to REXX strings
 *
 * Revision 1.8  1992/04/05  20:32:48  anders
 * Added copyright notice, and did some changes to make code more
 * compatible.
 *
 * Revision 1.7  1992/03/22  01:29:13  anders
 * #include'd some files, which were removed from rexx.h
 * Added explicit definition of sleep() for Ultrix
 * Added alternative cms_state for machines without scandir
 *
 * Revision 1.6  1992/03/01  19:10:16  anders
 * Fixed problems with returnvalue for sprintf
 *
 * Revision 1.5  1991/06/03  02:57:53  anders
 * Fixed a typo.
 *
 * Revision 1.4  91/05/28  23:39:03  anders
 * Initiated number of buffers til drop to correct number (drop the last
 * buffer, counted as "-1")
 * 
 * Revision 1.3  91/03/27  18:19:27  anders
 * Inserted #ifdef's for choosing usleep() or sleep(), which to use is 
 * defined in config.h by the macro HAS_USLEEP
 * Moved definitions of filename and select() further down in the file, 
 * and renamed select() to select_file() to avoid shaddowing select(2)
 * Swapped hardcoded '/' with macro FILE_SEPARATOR defined in config.h
 * 
 * Revision 1.2  90/08/19  02:26:58  anders
 * Implemented makebuf, dropbuf, desbuf and buftype
 * 
 * Revision 1.1  90/08/08  02:07:51  anders
 * Initial revision
 * 
 */

#include "rexx.h"
#ifdef VMS
# include <stat.h>
#else
# include <sys/stat.h>
# include <unistd.h>
#endif
#include <stdio.h>
#include <ctype.h>
#include <assert.h>


streng *cms_sleep( paramboxptr parms )
{
   checkparam( parms, 1, 1) ;
#ifdef HAS_USLEEP
   usleep( (int)((myatof(parms->value))*1000*1000) ) ;
#else
   sleep( atozpos( parms->value ) ) ;
#endif
   return nullstringptr() ;
}   


streng *cms_makebuf( paramboxptr parms )
{
   streng *ptr ;
   checkparam( parms, 0, 0 ) ;
   ptr = Str_make(SMALLSTR) ;
   sprintf(ptr->value,"%d",make_buffer()) ;
   return( ptr ) ;
}


streng *cms_justify( paramboxptr parms ) 
{
   int inspace, i, count, between, extra, initial, spaces, chars, length ;
   char *cend, *cp, *cptr, *out, *oend ;
   char pad ;
   streng *result ;

   checkparam( parms, 2, 3 ) ;

   cptr = parms->value->value ;
   cend = cptr + parms->value->len ;

   length = atozpos( parms->next->value ) ;
   if (parms->next->next && parms->next->next->value)
      pad = getonechar( parms->next->next->value ) ;
   else
      pad = ' ' ;

   inspace = 1 ;
   spaces = 0 ;
   chars = 0 ;
   for (cp=cptr; cp<cend; cp++)
   {
      if (inspace)
      {
         if (!isspace(*cp))
         {
            chars++ ;
            inspace = 0 ;
         }
      }
      else
      {
         if (!isspace(*cp))
            chars++ ;
         else
         {
            spaces++ ;
            inspace = 1 ;
         }
      }
   }

   if (inspace && spaces)
      spaces-- ;

   result = Str_make( length ) ;
   if (chars+spaces>length || spaces==0)
   {
      between = 1 ;
      extra = 0 ;
      initial = 0 ;
   }
   else
   {
      extra = (length - chars) % spaces ;
      between = (length - chars) / spaces ;
      initial = (spaces - extra) / 2 ;
   }   

   count = 0 ;
   out = result->value ;
   oend = out + length ;
   cp = cptr ;
   for (; cp<cend && isspace(*cp); cp++) ;
   for (; cp<cend && out<oend; cp++)
   {
      if (isspace(*cp))
      {
         for (;cp<cend && isspace(*cp); cp++) ;
         for (i=0; i<between && out<oend; i++)
            *(out++) = pad ;
         if (count<initial)
            count++ ;
         else if (extra && out<oend)
         {
            extra-- ;
            *(out++) = pad ;
         }  
         if (out<oend)
            *(out++) = *cp ;
      }
      else
         *(out++) = *cp ;
   }
      
   for (; out<oend; out++)
      *out = pad ;

   assert( out - result->value == length ) ;
   result->len = length ;

   return result ;
}
            


streng *cms_find( paramboxptr parms )
{
   paramboxptr ptmp ;
   extern streng *std_wordpos( paramboxptr ) ;
  
   checkparam( parms, 2, 3 ) ;
   ptmp = parms->next ;
   parms->next = ptmp->next ;
   ptmp->next = parms ;

   return std_wordpos( ptmp ) ;
}

   
streng *cms_index( paramboxptr parms )
{
   paramboxptr ptmp ;
   extern streng *std_pos( paramboxptr ) ;

   checkparam( parms, 2, 3 ) ;
   ptmp = parms->next ;
   parms->next = ptmp->next ;
   ptmp->next = parms ;

   return std_pos( ptmp ) ;
}

streng *cms_desbuf( paramboxptr parms )
{
   streng *ptr ;
   checkparam( parms, 0, 0 ) ;
   ptr = Str_make(SMALLSTR) ;
   sprintf(ptr->value,"%d",drop_buffer(0)) ;      
   return( ptr ) ;
}


streng *cms_buftype( paramboxptr parms )
{
   checkparam( parms, 0, 0 ) ;
   type_buffer() ;
   return (nullstringptr()) ;
}


streng *cms_dropbuf( paramboxptr parms )
{
   int buffer=(-1) ;
   streng *ptr ;

   checkparam( parms, 0, 1 ) ;
   if (parms->value)
      buffer = atopos(parms->value) ;

   ptr = Str_make(SMALLSTR) ;
   sprintf(ptr->value,"%d",drop_buffer(buffer)) ;      
   return( ptr ) ;
}
 

#ifdef HAS_SCANDIR
/* this part of the code is not used */
char *filename ;

int select_file( struct direct *entry )
{
   extern char *filename ;
   return !(strcmp(entry->d_name,filename)) ;
}


char *cms_state( paramboxptr parms ) 
{
   extern char *filename ;
   struct direct *names ;
   int last, result ;
   char *dir, *string, *retval ;

   checkparam( parms, 1, 1 ) ;
   last = strlen(string=parms->value) ;
   for (;(string[last]!=FILE_SEPARATOR)&&(last>0);last--) ;
   if (last) {
      string[last] = '\000' ;
      filename = &string[last+1] ;
      dir = string ; }
   else {
      dir = "." ;
      filename = &string[last] ; }

   result = scandir(dir,&names,&select_file,NULL) ;
   if (last)
      string[last] = FILE_SEPARATOR ;
   retval = Malloc(BOOL_STR_LENGTH) ;
   sprintf(retval,"%d",(result==1)) ;

   /* Ought to open or stat the file to check if it is readable */

   return retval ;
}
#else


streng *cms_state( paramboxptr parms )
{
   /* this is a bit too easy ... but STREAM() function should handle it */
   streng *retval ;
   int rcode ;
   struct stat buffer ;
   
   checkparam( parms, 1, 1 ) ;
   retval = Str_make( BOOL_STR_LENGTH ) ;

   /* will generate warning under Ultrix, don't care */   
   rcode = stat( Str_ify(parms->value)->value, &buffer ) ;
   return int_to_streng(rcode!=0) ;
   
}
#endif

