#ifndef lint
static char *RCSid = "$Id: cmath.c,v 1.9 1993/02/09 17:56:15 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Log: cmath.c,v $
 * Revision 1.9  1993/02/09  17:56:15  anders
 * Renamed Str*() to Str_*() to humor case insensitive machines
 * Fixed some spelling errors.
 * Added new routine myisinteger(), which detemines whether a string
 * is a valid integer.
 *
 * Revision 1.8  1992/07/24  03:47:15  anders
 * Added GPL. Removed most routines. Changed the rest.
 *
 * Revision 1.7  1992/04/25  13:15:50  anders
 * converted to REXX strings
 *
 * Revision 1.6  1992/04/05  20:33:56  anders
 * Added copyright notice
 * Made a kludge for Dolphin, which has a bad /usr/include
 *
 * Revision 1.5  1992/03/22  01:07:53  anders
 * #include'd stdio.h and ctype.h, as these are not included in rexx.h now
 * Removed references to EIGHTBITCLEAN, not really a good way to
 *    do it anyway.
 *
 * Revision 1.4  1992/03/01  19:08:21  anders
 * Included proper includefiles ( <math.h> and "rexx.h" )
 * Fixed types for strtod(), both parameters and returnvalues
 *
 * Revision 1.3  91/06/03  02:55:57  anders
 * Kludged away the definition of RCSid, this file should not be included
 *    into another .c file!!
 *
 * Revision 1.2  91/03/27  17:46:29  anders
 * Made a warning about overflow and underflow conditions.
 * Removed local prototype of myatof, since it is prototyped in rexx.h
 * Put GCC-specific code in #ifdef's -- over/under-flow conditions.
 * Removed to redundant calls to myatof()
 * Fixed type conflict error in arguments of a sprintf() call
 * Added test for a devide-by-zero condition
 * Deleted unreferenced (and redundant) function myatod
 * 
 * Revision 1.1  90/08/08  02:06:11  anders
 * Initial revision
 * 
 */

/* 
 * More attention should be paid to overflow and underflow conditions. 
 * This *is* done in some of the routines for the GCC compiler, but should
 * be done in an ANSI-compatible manner.
 */


#include "rexx.h"
#include <math.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>


#ifdef SunKludges
extern double strtod( char *, char ** ) ;
#endif




double myatof( streng *string )
{
   char *ptr ;
   double answer ;
#if 0
   extern int minus_zero ;
#endif

   string = Str_ify(Str_dup(string)) ;
   answer = strtod(string->value,&ptr) ;
   
   for (;(*ptr)&&(isspace(*ptr));ptr++) ;
#ifdef SUN_STRTOD_BUG
   for (;*ptr=='0';ptr++) ;
#endif /* SUN_STRTOD_BUG */
   if (*ptr)
      exiterror(ERR_BAD_ARITHMETIC) ;
   Free( string ) ;

/* only for special machines */
#if 0
   if (answer == minus_zero)
      answer = 0 ;
#endif

   return answer ;
}


int myisnumber( streng *string )
{
   register char *ptr, *eptr ;
   int num=0 ;

   if (!string->len)
      return 0 ;

   ptr = string->value ;
   eptr = Str_end( string ) ;

   for (; (ptr<eptr) && (isspace(*ptr)); ptr++) ;
   if ((ptr<eptr) && ((*ptr=='-') || (*ptr=='+')))
      for (ptr++; (ptr<eptr) && (isspace(*ptr)); ptr++) ;

   for (; (ptr<eptr) && isdigit(*ptr); ptr++, num++) ;
   if ((ptr<eptr) && *ptr=='.')                 
      for (ptr++;(ptr<eptr) && isdigit(*ptr); ptr++, num++) ;

   if (!num)
      return 0 ;

   if ((ptr<eptr) && ((*ptr=='e') || (*ptr=='E')))
   {
      ptr++ ;
      num = 0 ;
      if ((ptr<eptr) && ((*ptr=='-') || (*ptr=='+')))
         ptr++ ;

      for (ptr++; (ptr<eptr) && isdigit(*ptr); ptr++, num++ ) ;
      if (!num)
         return 0 ;
   }

   for (; (ptr<eptr) && (isspace(*ptr)); ptr++) ;
   return (ptr==eptr) ;
}


/* 
 * Takes 'string' as parameter, analyze whether it is an integer, and 
 * return a boolean variable which is true iff 'string' is a legal 
 * integer. The format of a legal integer is (the regexpr):
 *        [ ]*([-+][ ]*)?[0-9]+[ ]*
 */
int myisinteger( streng *string )
{
   char *cptr, *eptr ;
   
   cptr = string->value ;
   eptr = cptr + string->len ;
  
   for (;cptr<eptr && isspace(*cptr); cptr++) ;
   if (cptr<eptr && (*cptr=='-' || *cptr=='+'))
      for (cptr++; cptr<eptr && isspace(*cptr); cptr++) ;

   if (cptr>=eptr)
      return 0 ;

   for (;cptr<eptr && isdigit(*cptr); cptr++) ;
   for (;cptr<eptr && isspace(*cptr); cptr++) ;
   return (cptr==eptr) ;
}
