#ifndef lint
static char *RCSid = "$Id: client.c,v 1.2 1993/05/10 05:57:55 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1993  Anders Christensen <anders@solan.unit.no>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. 
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: client.c,v 1.2 1993/05/10 05:57:55 anders Exp anders $
 */

#include "rexx.h"

#include <unistd.h>
#include "rxiface.h"
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
#include <stdarg.h>

int isclient=0 ;
static int torexx=0, toappl=0 ;

static streng *environment=NULL ;

void GetSymVariable( void ) ;
void SetSymVariable( void ) ;

/* #define DEBUG_CLIENT */

int ReMapHook( int NetHook ) ;


int map_type( int in ) 
{
   if (in==RX_TYPE_COMMAND)
      return INVO_COMMAND ;
   else if (in==RX_TYPE_FUNCTION)
      return INVO_FUNCTION ;
   else
   {
      assert( in == RX_TYPE_SUBROUTINE ) ;
      return INVO_SUBROUTINE ;
   }
}


void closedown( void )
{
   exit( 0 ) ;
}


int ReadNumber( void ) 
{
   int rc, number ;
   rc = read( torexx, &number, sizeof(number)) ;
   if (rc!=sizeof(number))
      closedown() ;

   return number ;
}


streng *ReadStreng( void )
{
   streng *sptr ;
   int rc, length ;

   length = ReadNumber() ;
   if (length==RX_NO_STRING)
      return NULL ;

   sptr = Str_make( length ) ;
   rc = read( torexx, sptr->value, sptr->len=length ) ;
   if (rc!=length)
      closedown() ;

   return sptr ;
}

void SendNumber( int number ) 
{
   int rc ;
   rc = write( toappl, &number, sizeof(number)) ;
}


void SendData( char *data, int length ) 
{
   int rc ;
 
   rc = write( toappl, data, length ) ;
}

void SendChar( char ch ) 
{
   int rc ;
   rc = write( toappl, &ch, 1 ) ;
}


void SendStreng( streng *sptr ) 
{
   if (sptr)
   {
      SendNumber( sptr->len ) ;
      SendData( sptr->value, sptr->len ) ;
   }
   else
      SendNumber( RX_NO_STRING ) ;
}



void SetupClient( char *pipes ) 
{
   environment = Str_make( strlen(pipes)) ;
   sscanf( pipes, "%d,%d,%s", &torexx, &toappl, environment->value ) ;
   environment->len = strlen(environment->value) ;
   add_envir( Str_dup(environment), ENVIR_PIPE, 0 ) ;
   isclient=1 ;

   SendNumber( RX_VERSION) ;
   SendNumber( RXVERSION_MAJ ) ;
   SendNumber( RXVERSION_MIN ) ;
}


paramboxptr parametrize( void ) 
{
   paramboxptr parms, root ;
   int count ;

   root = parms = NULL ;

   count = ReadNumber() ;
   for (; count--; ) 
   {
      if (parms)
      {
         parms->next = Malloc( sizeof(parambox)) ;
         parms = parms->next ;
      }
      else
         parms = root = Malloc( sizeof(parambox )) ;
      parms->value = ReadStreng() ;
   }

   if (parms)
      parms->next = NULL ;

   return root ;
}



void execute_an_external( void )
{
   streng *command, *result ;
   int RetCode ;
   int hooks, num, ctype ;
   int type=0 ;
   paramboxptr params ;

   command = ReadStreng() ;
   assert(command) ;
   params = parametrize() ;

   ctype = map_type(ReadNumber()) ;

   for (hooks=0; (num=ReadNumber())!=RX_LASTHOOK; )
      hooks |= 1 << (ReMapHook(num)) ;

   environment = ReadStreng() ;
   if (!environment)
      environment = Str_cre( "" ) ;
   
   add_envir( Str_dup(environment), ENVIR_PIPE, 0 ) ;

   type = ReadNumber() ;
   if (type==RX_TYPE_EXTERNAL)
      result=execute_external(command,params,environment,&RetCode,hooks,
                              ctype);
   else if (type==RX_TYPE_INSTORE)
   {
      int serial = ReadNumber() ;
      result=do_instore(command,params,environment,&RetCode,hooks,type,
                              serial, ctype);
   }
   else if (type==RX_TYPE_MACRO)
      result= nullstringptr() ;
   else if (type==RX_TYPE_SOURCE)
   {
      streng *SrcStr = ReadStreng() ;
      int serial ;
      serial=enter_macro( SrcStr, command ) ;
      Free_string( SrcStr ) ;
      SendNumber( RX_INSTORE ) ;
      SendNumber( serial ) ;
      result=do_instore(command,params,environment,&RetCode,hooks,type,
                              serial,ctype);
   }
   else
   {
      exiterror( ERR_INTERPRETER_FAILURE ) ;
      return ;
   }
   
   del_envir( environment ) ;
   Free_string( environment ) ;

   SendNumber( RX_RETURN ) ;
   SendNumber( RetCode ) ;
   SendStreng( result ) ;
}


void handle_source( void )
{
   int infile, called, total, invoked ;
   char *stype ;
   int sleng ;
   extern sysinfo systeminfo ;

   SendNumber( RX_RETURN ) ;
   SendNumber( 0 ) ;
 
   stype = system_type() ;
   sleng = strlen( stype ) ;
   infile = systeminfo->input_file->len ;
   called = systeminfo->called_as->len ;
   invoked = strlen(invo_strings[systeminfo->invoked]) ;
   total = sleng + 1 + invoked + 1 + infile + 1 + called ;

   SendNumber( total ) ;
   SendData( stype, sleng ) ;
   SendData( " ", 1 ) ;
   SendData( invo_strings[systeminfo->invoked], invoked ) ;
   SendData( " ", 1 ) ; 
   SendData( systeminfo->called_as->value, called ) ;
   SendData( " ", 1 ) ;
   SendData( systeminfo->input_file->value, infile ) ;
}


void handle_params( void ) 
{
   extern proclevel currlevel ;
   paramboxptr ptr ;
   streng *value=NULL ;   
   int count=0 ;
   int number ;

   number = ReadNumber() ;
   assert( number >= 0 ) ;

   ptr = currlevel->args ;
   if (number) 
      value = get_parameter( ptr, number ) ;
   else 
      count = count_params( ptr, PARAM_TYPE_HARD ) ;
   
   SendNumber( RX_RETURN ) ;
   SendNumber( count ) ;
   SendStreng( value ) ;
}


void handle_queue( void )
{
   SendNumber( RX_RETURN ) ;
   SendNumber( 0 ) ;
   SendNumber( 7 ) ;
   SendData( "default", 7 ) ;
}


void handle_version( void ) 
{
   int length ;
 
   SendNumber( RX_RETURN ) ;
   SendNumber( 0 ) ;
   SendNumber( length=strlen(PARSE_VERSION_STRING)) ;
   SendData( PARSE_VERSION_STRING, length) ;
}



static int var_indicator=0 ;
static void get_next_var( void )
{
   variableptr value, rval, rrval ;

   if (var_indicator==0)
   {
      get_next_variable( 1 ) ;
      var_indicator = 1 ;
   }

   for (;;)
   {
      value = get_next_variable( 0 ) ;
      for (rval=value; rval && rval->realbox; rval=rval->realbox) ;
      if (rval && !(rval->flag & VFLAG_STR))
      {
         if (rval->flag & VFLAG_NUM)
         {
            expand_to_str( rval ) ;
            break ;
         }

         if (!rval->stem)
            continue ;

         for (rrval=rval->stem; rrval && rrval->realbox; rrval=rrval->realbox);
         if (rrval && !(rrval->flag & VFLAG_STR))
            if (rval->flag & VFLAG_NUM)
            {
               expand_to_str( rval );
               break ;
            }
            else
               continue ;
      }
      break ;
   }

   SendNumber( RX_STRINGS ) ;
   if (rval)
   {
      SendNumber( 2 ) ;
      if (value->stem)
      {
         SendNumber( value->stem->name->len + value->name->len ) ;
         SendData( value->stem->name->value, value->stem->name->len ) ;
         SendData( value->name->value, value->name->len ) ;
      }
      else
         SendStreng( value->name ) ;

      if (rval->value)
         SendStreng( rval->value ) ;
      else
      {
         assert( rval->stem && rrval->value ) ;
         SendNumber( rval->stem->name->len + rval->name->len ) ;
         SendData( rval->stem->name->value, value->stem->name->len ) ;
         SendData( rval->name->value, rval->name->len ) ;
      }
   }
   else
      SendNumber( 0 ) ;
}

 



streng *WaitForReturn( int *rc )
{
   int code ;

   while (1) 
   {
      code = ReadNumber() ;

      switch (code) 
      {
         case RX_RETURN:
            *rc = ReadNumber() ;
            var_indicator = 0 ;
            return ReadStreng() ;
   
         case RX_DROP_INSTORE:
            kill_macro( NULL, ReadNumber()) ;
            SendNumber( RX_RETVOID ) ;
            break ;       

         case RX_EXECUTE:
            var_indicator = 0 ;
            execute_an_external() ;
            break ;

         case RX_ADDFUNC:
            addfunc( ReadStreng(), 1) ;
            SendNumber( RX_RETVOID ) ;
            break ;
 
         case RX_DELFUNC:
            delfunc( ReadStreng()) ;
            SendNumber( RX_RETVOID ) ;
            break ;

         case RX_CODE_PARAM:
            handle_params() ;
            break ;

         case RX_CODE_SOURCE:
            handle_source() ;
            break ;

         case RX_CODE_VERSION:
            handle_version() ;
            break ;

         case RX_CODE_QUEUE:
            handle_queue() ;
            break ;

         case RX_NEXTVAR:
            get_next_var() ;
            break ;

         case RX_GETSVAR:
            GetSymVariable() ;
            break ;

         case RX_SETSVAR:
            SetSymVariable() ;
            break ;

         default:
            exiterror( ERR_INTERPRETER_FAILURE ) ;
      }
   }
}





void RunClient( void ) 
{
   int rc ;
/*
   int code ;

   while (1)
   {
      code = ReadNumber() ;
      if (code==RX_EXECUTE)
         execute_an_external() ;
      else if (code==RX_DROP_INSTORE)
      {
         kill_macro( NULL, ReadNumber()) ;
         SendNumber( RX_RETVOID ) ;
      }
      else 
         exiterror( ERR_INTERPRETER_FAILURE ) ;

   }
 */

   Free_string( WaitForReturn( &rc ) ) ;
}


int MapHook( int RexxHook ) 
{
   switch ( RexxHook ) 
   {
      case HOOK_STDOUT: return RX_EXIT_STDOUT ;
      case HOOK_STDERR: return RX_EXIT_STDERR ;
      case HOOK_TRCIN:  return RX_EXIT_TRCIN ;
      case HOOK_PULL:   return RX_EXIT_PULL ;

      case HOOK_INIT:   return RX_EXIT_INIT ;
      case HOOK_TERMIN: return RX_EXIT_TERMIN ;

      default: 
         closedown() ;
   }

   return 0 ;
}
         

int ReMapHook( int NetHook ) 
{
   switch ( NetHook ) 
   {
      case RX_EXIT_STDOUT: return HOOK_STDOUT ;
      case RX_EXIT_STDERR: return HOOK_STDERR ;
      case RX_EXIT_TRCIN:  return HOOK_TRCIN ;
      case RX_EXIT_PULL:   return HOOK_PULL ;

      case RX_EXIT_TERMIN: return HOOK_TERMIN ;
      case RX_EXIT_INIT:   return HOOK_INIT ;

      default: 
         closedown() ;
   }

   return 0 ;
}
         


int hookup( int hook, ... )
{
   int rc, rcode ;
   va_list ap ;
   streng *indata, **outdata, *retstring ;

   va_start( ap, hook ) ;
   SendNumber( RX_DO_HOOK ) ;
   SendNumber( MapHook(hook) ) ;

#ifdef lint 
   outdata = NULL ;
   rcode = 0 ;
#endif
   switch ( MapHook(hook))
   {
      case RX_EXIT_STDOUT:
      case RX_EXIT_STDERR:
         indata = va_arg(ap, streng*) ;
         if (indata)
            SendStreng( indata ) ;
         else
            SendNumber( RX_NO_STRING ) ;
         break ;

      case RX_EXIT_PULL:
      case RX_EXIT_TRCIN:
         outdata = va_arg(ap, streng**) ;
         SendNumber( RX_NO_STRING ) ;
         break ;

      case RX_EXIT_INIT:
      case RX_EXIT_TERMIN:
         SendNumber( RX_NO_STRING ) ;
         break ;

      default:
         exiterror( ERR_INTERPRETER_FAILURE ) ;
   }
   va_end( ap ) ;

   retstring = WaitForReturn( &rc ) ;
   if (rc==RX_HOOK_ERROR)
      exiterror( ERR_SYSTEM_FAILURE ) ;
   else if (rc==RX_HOOK_GO_ON)
      rcode = HOOK_GO_ON ;
   else if (rc==RX_HOOK_NOPE)
      rcode = HOOK_NOPE ;
   else
      exiterror( ERR_INTERPRETER_FAILURE ) ;

   switch ( MapHook(hook))
   {
      case RX_EXIT_STDOUT:
      case RX_EXIT_STDERR:
         if (retstring)
            Free_string( retstring ) ;
         break ;

      case RX_EXIT_PULL:
      case RX_EXIT_TRCIN:
         (*outdata) = retstring ;
         break ;

      case RX_EXIT_INIT:
      case RX_EXIT_TERMIN:
         break ;

      default:
         exiterror( ERR_INTERPRETER_FAILURE ) ;
   }

   return rcode ;
}



streng *SubCom( streng *command, streng *envir, int *rc ) 
{
   streng *TmpPtr ;

   SendNumber( RX_SUBCOM ) ;
   if (envir)
      SendStreng( envir ) ;
   else
      SendStreng( nullstringptr()) ;

   SendStreng( command ) ;
   TmpPtr = WaitForReturn( rc ) ;
   return (TmpPtr ? TmpPtr : nullstringptr()) ;
}


void GetSymVariable( void ) 
{
   streng *varbl, *value ;
   int rcode ;

   varbl = ReadStreng() ;
   assert( varbl ) ;

   rcode = RX_CODE_OK ;
   if (!valid_var_symbol(varbl))
   {
      rcode = RX_CODE_INVNAME ;
      value = NULL ;
   }
   else
   {
      value = getvalue( varbl, 1 ) ;
      if (!var_was_found())
         rcode = RX_CODE_NOVALUE ;
   }

   SendNumber( RX_VALUE ) ;
   SendNumber( rcode ) ;
   SendStreng( value ) ;
   Free_string( varbl ) ;
}


void SetSymVariable( void ) 
{
   streng *varbl, *value ;
   int rcode ;

   varbl = ReadStreng() ;
   value = ReadStreng() ;
   assert( varbl ) ;

   rcode = RX_CODE_OK ;
   if (!valid_var_symbol(varbl))
   {
      rcode = RX_CODE_INVNAME ;
      value = NULL ;
   }
   else
   {
      if (value)
         setvalue( varbl, value ) ;
      else
         drop_var( varbl ) ;

      if (!var_was_found())
         rcode = RX_CODE_NOVALUE ;
   }

   SendNumber( RX_RETVOID ) ;
   SendNumber( rcode ) ;
   Free_string( varbl ) ;
}



streng *do_an_external( streng *name, paramboxptr parms )
{
   int rc ;
   int i, j ;
   streng *str ;
   paramboxptr p ;

   SendNumber( RX_EXECFUNC ) ;
   SendStreng( name ) ;
   for (j=i=0,p=parms; p; p=p->next,i++) 
      if (p->value)
         j=i+1 ;

   SendNumber( j ) ;
   for (i=0;i<j;i++)
   {
      SendStreng( parms->value ) ;
      parms=parms->next ;
   }
   str = WaitForReturn( &rc ) ;

   if (rc)
   {
      if (str)
         Free_string( str ) ;
      exiterror( ERR_INCORRECT_CALL ) ;
      return NULL ;
   }
   else
      return str ;
}

