                 Installation of REXX/imc

Summary:

The REXX/imc sources, written in C, are compiled into object files.
Some of the object files are assembled into a library, and the rest
are linked into executables.

Note: As from release 1.6, it is possible to create a shared library object
of REXX/imc.  The location of this library must be decided at compile time,
because the system places a reference to it into the executable "rexx".
If the library is moved after compilation, the user will have to set the
environment variable LD_LIBRARY_PATH before executing "rexx" in order to
tell the system where the library is.  Note that this does not apply if
the static library is used.  On some systems other than SunOS, the setting
of LD_LIBRARY_PATH may be mandatory in any case unless the REXX/imc library
will be installed in a system libraries directory.

The executables may be installed into a binaries directory or left in the
current directory.  The object files will always be moved into the binaries
directory, but may be removed after the installation process (the binaries
directory will be chosen at compilation time, but may be left as "." - i.e.,
the current directory).  After installation, the executables may be moved
by the user, and REXX/imc may be told where to find these files by setting
the environment variable REXXIMC - otherwise REXX/imc will search for these
files itself.

The following instructions apply mainly to SunOS, but see the notes
following the instructions for installation on other systems.

Prerequisites:

Please first determine the following information.

 - Which compiler to use ("gcc" or "cc").
 
   NOTE:  The "cc" compiler is used as the linker in both cases.  This is
   because our version of gcc does not appear to know about the -ldl library.

   (since the above note was written, a new version of gcc has been
   installed which seems to be able to cope.  The make file has not
   been changed to make use of this, but this may happen in the future).

 - If the compiler is "gcc", it may be necessary to know the name of the
   directory in which the GNU library file "libgcc.a" resides.

 - The name of a "binaries" directory.  This data will be stored in the
   BINDIR environment variable, and the named directory will be used to
   store the following files:

   calc.o globals.o rexx.o rxfn.o shell.o util.o
       [these are the object files, which may be removed after installation,
       if desired]

   rexx rxmathfn.rxfn rxque rxstack
       [these are the REXX/imc binaries which will be installed]

   rxmathfn.rxlib
       [this is a function dictionary for rxmathfn.rxfn or rxmathfn.exec]

   rxmathfn.exec
       [this file is optional and is not required on Sun systems; the notes
       for compiling on other systems will tell you to install rxmathfn.exec]

   Note:  The "Make" program will first try the BINDIR value.  BINDIR may be
          left undefined if desired; in that case, "Make" will try
          $HOME/`arch`.  Failing that, it will use the current directory.

   Note:  When a user invokes "rexx", then the final value of REXXIMC saved
          at compile time will be used to find the other REXX/imc files when
          "rexx" is invoked by a user.  However, the final location may have
          been unknown at compile-time, or the REXX/imc binaries may be
          moved at some time after compilation.  In that case the user may
          optionally set REXXIMC in his environment - otherwise, REXX/imc
          will search for the files itself.
          
   Note:  If executables came with this distribution, then /usr/local/bin is
          the name of the directory which is compiled in.  Initialisation
          will be most efficient if the binaries are moved to /usr/local/bin, 
          or if the user sets REXXIMC to the correct directory before
          running "rexx".  This is not essential, however.

   The value of REXXIMC which is saved at compile time will usually be the
   name of the binaries directory (mentioned above).  That will usually be
   the most convenient option.  However, if you plan to move the REXX/imc
   binaries after making them and know the final location, then note down
   this location in order to set the environment variable REXXIMC before
   compilation.  Then, "Make" will compile this new location into REXX/imc.

 - Whether the REXX/imc library is to be linked statically or dynamically.
   If statically, then all the code needed from the library will be included
   at compile time, and the library file is not needed in order to execute
   REXX/imc.  If dynamically, then the library will not be included at
   compile time, and a much smaller executable will result.  The library
   file will be needed in order to execute REXX/imc, and should therefore
   not be moved after compilation.  If it is moved, then the user will
   have to set LD_LIBRARY_PATH to reflect its new location before executing
   REXX/imc.

 - The name of a library directory.  This will be used to store the
   library file.  This information will be stored in the LIBDIR environment
   variable.  This may be left undefined, in which case Make will use the
   BINDIR instead.

Customizing the "Make" file:

 - Change to the directory containing the REXX/imc source files.

 - Copy the "Make.orig" file as "Make".
   This way you can always restart from scratch with a fresh copy of the
   "Make.orig" file.

   NOTE: the capital M in "Make" serves to distinguish this program from the
   Unix utility, "make".  You may use any other name you choose, provided it
   does not conflict with a name that is already used.  If you use the name
   "make", then you may execute it by typing "./make" instead of just "make".

 - Edit the file "Make" with your favorite editor.

 - If you will be compiling using "gcc", then the following may be
   necessary.  Try first without, and if the compiler complains "-lgcc:
   no such file", make this alteration and try again (the work which Make
   did before reporting the error will not be lost; Make will continue
   where it left off).  Locate the line starting with "GNULIB=".  Erase
   all text after the "=" character and type in the path to the GNU library
   file "libgcc.a" on your machine with the characters "-L" prepended, for
   example:

   GNULIB = -L/usr/local/gnu/lib

   This step is not required when compiling using "cc".

 - If you opted to use "cc" instead of "gcc", then find the line

   CC=/usr/local/bin/gcc

   and replace the whole path with "cc".  Else modify the specified path to
   reflect the correct path to "gcc" itself on your machine.

 - Definitions of compiler and linker flags may be found in blocks shortly
   after the line

   #Makefile for REXX/imc

   in the Make program.  You may add extra options for the compiler by
   changing the definition of MORECCFLAGS.  If you wish to change the
   other options that the program gives to the compiler (namely "-O2"),
   then you may add a line which defines CCFLAG.  If you wish to change
   the options that the program gives to the link command (namely "-s -n
   -Bdynamic") then you may add a line which defines LDFLAG.  Alternatively,
   you may change the program as follows.  Locate the line in the Make
   program with:

      *) CCFLAG="-O2";LDFLAG="-s -n -Bdynamic";;

   and insert your preferred compiler options instead of the string "-O2"
   (keeping the quotes).  Also insert your preferred linker options instead
   of the string "-s -n -Bdynamic" (remembering that these options are
   actually given to "cc" for it to pass on to the linker).

   The advantage of changing the program in this way is that the single-
   letter parameters to Make (described below) may be used.

   NOTE: I suspect that our version of "cc" has a bug which causes REXX/imc
   to crash whenever the "trace O" instruction is executed if "cc" was used
   with optimization on and with the -PIC option.  I suspect this because I
   have managed to produce a working copy by editing the assembler output
   of "cc".  It may therefore be necessary either to compile "rexx.c"
   with optimization turned off or to make a static library instead of
   a dynamic one, if you use "cc".  An easy way to do the former is to
   delete the characters "-O4" from the line "CCFLAG = -O4".  Try first
   with optimization, and if that does not work then make this alteration,
   delete rexx.o from the binaries directory and try again.

   NOTE:  The linker options are configured to create smaller executables
          (with flags -n -s -Bdynamic) for minimal use of disk space.  If
          executables came with this distribution, then they might have been
          linked with more usual flags.

 - File the "Make" file.

Creating environment variables needed when running "Make":

 - If your choice for the location of the REXX/imc binaries after
   compilation is other than $HOME/`arch` (or if that is non-existent
   the current directory), then set the environment variable BINDIR to
   the value you wish it to be.  Alternatively, you could alter the Make
   program and replace the line

   if [ ! -d ${BINDIR:=${HOME}/`/bin/arch`} ]; then BINDIR=`pwd`; fi

   with the line

   BINDIR = <name of binaries directory>.

 - If your choice for the location of the REXX/imc library after
   compilation is other than the location of the other binaries, then
   set the environment variable LIBDIR to the value you wish it to be.

 - If you are opting to move the REXX/imc binaries after compilation to a
   known final location, then set the environment variable REXXIMC to that
   value.

Running the "Make" file:

A more detailed description on what the "Make" file can do is written at the
end of this file; however, the following information suffices for normal
installation.

You can choose between full or partial installation.  The partial
installation can be useful in running tests before moving the files to their
final location.

 - For partial installation, simply type:
      Make
   This creates the executables, but leaves them in the current directory.
   It will, however, move the object files (that is, the files ending
   with .o) into the binaries directory in case they are needed again
   later.  The library file is always created in its final location.

 - For full installation, type:
      Make install
   This will move the binary files as well as the object files to the
   (final) location as specified by BINDIR.

   NOTE:  If any "Warning" options (such as "-W") are given to gcc,
          various warnings may be issued.  Sorry!

Cleanup of work files:

IMPORTANT:
   If there are files in the current directory you do not want to lose, do
   NOT type this command; it will delete all executables and ".o" files in
   the current directory.  It will also delete all ".o" files from the
   "binaries" directory.

Type:
   Make clobber

This will delete all ".o" files from the current directory and from the
binaries directory.  It will also delete (from the current directory) the
executables rexx, rxque, rxstack and rxmathfn.rxfn, and any editor backup
files (ending with "^") which were made from editing any of the following
files: *.c *.h Make rexx.ref rexx.summary rexx.info rexx.tech.  REXX/imc
executables which have been installed into a binaries directory (other than
the current directory) will not be erased.

Alternatively, you may type:
   Make clean

This will do the same cleanup as described above, except that it will only
erase files which are in the current directory.

Test run "rexx".

Final disposition of binaries and doc files:

 - Move the doc files to their final location.  The documentation files are
   listed in the files README and README.docs

 - If you opted for partial installation, then move the following
   files to their final location:
      rexx, rxque, rxstack, rxmathfn.rxfn
   Also, copy the file rxmathfn.rxlib into the same directory as
   rxmathfn.rxfn.

Final notes:

1: If you have opted to let the users specify where to find the REXX/imc
   binaries, then inform them of the fact that they may optionally set
   the REXXIMC environment variable before "rexx" is invoked.  Note that
   REXX/imc should still work even if they do not do this.

2: Also inform the users of the location of the documentation on
   REXX/imc.

Notes on compiling REXX/imc on systems other than SunOS:

Definitions of macros which vary from system to system can be found by
searching for /###/ in Make.  Definitions for SunOS, AIX, HP-UX, IRIX
and Linux are currently included.  If your system is mentioned here, then
comment out or delete the lines for SunOS and un-comment the definitions
for your system.  REXX/imc should then compile.  You may wish to tweak
the definitions.  Some information about the preprocessor macros used
in REXX/imc may be found below these definitions and also here in this
documentation.

The macros MORECCFLAGS and LIBRARIES defined in the Make file should be
defined to indicate the available features/requirements of your system.  For
instance, REXX/imc requires signed characters, so the -fsigned-char flag may
be required in MORECCFLAGS.  Preprocessor macros which may be defined in
MORECCFLAGS are:

   NO_LDL       the system does not have the functions dlopen(), dlsym(),
                dlclose(), dlerror() for dynamic loading.  The effect of
                defining NO_LDL will be to remove support for external
                compiled functions.
   HAS_MALLOPT  The malloc library has the function mallopt() as in SunOS.
                This is by no means essential.
   HAS_TTYCOM   The system requires <sys/ttycom.h> to be included before
                the TIOCGWINSZ ioctl can be used, as in SunOS.  If this
                is not defined, then <termios.h> will be included instead.
   FSTAT_FOR_CHARS
                Do not trust the FIONREAD ioctl for finding the number of
                unread characters in a regular file, but instead call fstat
                to find the file's size.
   NO_CNT       Do not use the hack of inspecting fp->_cnt (where fp is a
                FILE pointer) to find the number of characters read but
                not returned to the program.  If this symbol is defined
                then the chars() call may not work correctly.  However,
                most systems do have a way of calculating this number.
                If the method exists but requires something other than
                inspecting fp->_cnt, then change the _CNT macro in rxfn.c
                accordingly.
   STUFF_STACK  Stuff surplus stacked data into the keyboard buffer before
                terminating the stack.  The <sys/termios.h> file should define
                a TIOCSTI ioctl call.

Possible libraries which might be required are -ldl (for the dynamic loading
functions), -lbsd (for systems with BSD compatibility libraries, as in AIX),
-lsocket, and so on.

If you define NO_LDL, you will not be able to use compiled function
packages, such as rxmathfn.rxfn (the math library).  This file should be
removed from the binaries directory.  However, it will still be possible
to use external functions written in Rexx.  You will be able to use the
REXX math library by copying the Rexx file rxmathfn.exec into the binaries
directory together with rxmathfn.rxlib.  You can prevent the Make file
from trying to compile the math library by defining MATH to be blank,
as mentioned in the Make file.

A recent article on comp.unix.programmer stated that dlopen(), dlsym() and
dlclose() functions have been written for AIX.  It said:
>you might have a look at the `libdl emulation library' for AIX that has
>been published in USENET a while ago (I believe its author is
>jum@helios.de).  This library emulates the dlopen(), dlsym(), and
>dlclose() functions of the dynamic linker interface of SysVR4 and
>SunOS 4.1/5.x under AIX.
(this text was from article <220l5e$on@news.cs.tu-berlin.de>, sent by
net@cs.tu-berlin.de (Oliver Laumann))


The REXX/imc installation instructions were written with the kind help of
Scott Ophof.

------------------------

Make file description:

The full syntax for invoking Make is:

   Make [letter] [targets]

where "letter" is a single letter from [adgnop] and "targets" is one or more
of the targets which are defined in the Make file.  The single-letter option
is a convenient way of altering the compilation environment without having
to use separately customised Make files, and they are currently set up as
follows:

 a  uses cc with the "-a" flag to compile a version of REXX/imc which will
    output profiling statistics when executed.
 d  uses the "-g" compilation flag and also defines the DEBUG preprocessor
    macro in order to make a debug version of REXX/imc with memory tracing.
 g  uses the "-g" compilation flag to produce an ordinary debug version of
    REXX/imc.
 n  uses no compiler flags at all, which reduces compilation time at the cost
    of making REXX/imc slightly slower.
 o  uses optimisation flags to produce faster, smaller executables.
 p  uses the "-p" compiler flag to compile a version of REXX/imc which will
    output profiling statistics when executed.

If the single-letter option is omitted, then the flags are defined by the
line of the Make file which starts with "*)".  This is ordinarily the same
as typing the "o" option.

Note that by default "Make" will not recompile objects which have already
been compiled, even if they were compiled with a different set of flags.

Note that the single-letter options will not work properly if you have
inserted an extra "CCFLAG=" or "LDFLAG=" line into the Make file.  In
particular, note that of the system definitions only the "gcc on SunOS"
definition allows the use of single-letter options.

The possible targets to Make are listed below.  Note that unless otherwise
stated all object files are moved to the binaries directory and all other
files are left in the current directory.

all:     (same as omitting the target entirely)
         compile the executables rexx, rxstack, rxque and rxmathfn
install: compile as for "all" and move the executables into the binaries
         directory.
rexx:    compile the "rexx" executable
         (Note that compiling the "rexx" executable implies compiling the six
         objects rexx.o, rxfn.o, calc.o, util.o, shell.o and types.o)
rxque:   compile the "rxque" executable
rxstack: compile the "rxstack" executable
rex:     compile rexx.o
rxfn:    compile rxfn.o
calc:    compile calc.o
util:    compile util.o
shell:   compile shell.o
api:     compile interface.o
main:    compile main.o
math:    compile the "rxmathfn.rxfn" executable
rexxlib.a:  compile the REXX/imc static library
rexxlib.so: compile the REXX/imc dynamic library
clean:   erase all "junk" files from the current directory, as described
         earlier
clobber: erase all "junk" files from the current directory and also all
         object files from the binaries directory, as described earlier
lint:    run all the source files through "lint", accumulating the messages
         into a file (called /tmp/lint)

More than one target may be named on the command line, but mixing "clean"
and "clobber" with other options is sure to lead to surprises!

------------------------

REXX/imc is copyright, but free.  Permission is granted to use, copy
and redistribute this code, provided that the same permission is
granted to all recipients, and that due acknowledgement is given to
the author.

