/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\key.h 1.4 1993/09/01 16:26:37 MH Interim MH $
*/

#include "getch.h"

struct key_values
{
 char *mnemonic;
 unsigned short key_value;
};
typedef struct key_values KEYS;

#if defined(DOS) || defined(OS2)
#define MAX_NUMBER_KEYS 312
#else
#define MAX_NUMBER_KEYS 247
#endif

KEYS key_table[MAX_NUMBER_KEYS] =
{
#if defined(DOS) || defined(OS2)
/* normal characters */
  {(char *)"A",KEY_a },
  {(char *)"B",KEY_b },
  {(char *)"C",KEY_c },
  {(char *)"D",KEY_d },
  {(char *)"E",KEY_e },
  {(char *)"F",KEY_f },
  {(char *)"G",KEY_g },
  {(char *)"H",KEY_h },
  {(char *)"I",KEY_i },
  {(char *)"J",KEY_j },
  {(char *)"K",KEY_k },
  {(char *)"L",KEY_l },
  {(char *)"M",KEY_m },
  {(char *)"N",KEY_n },
  {(char *)"O",KEY_o },
  {(char *)"P",KEY_p },
  {(char *)"Q",KEY_q },
  {(char *)"R",KEY_r },
  {(char *)"S",KEY_s },
  {(char *)"T",KEY_t },
  {(char *)"U",KEY_u },
  {(char *)"V",KEY_v },
  {(char *)"W",KEY_w },
  {(char *)"X",KEY_x },
  {(char *)"Y",KEY_y },
  {(char *)"Z",KEY_z },
  {(char *)"0",KEY_0 },
  {(char *)"1",KEY_1 },
  {(char *)"2",KEY_2 },
  {(char *)"3",KEY_3 },
  {(char *)"4",KEY_4 },
  {(char *)"5",KEY_5 },
  {(char *)"6",KEY_6 },
  {(char *)"7",KEY_7 },
  {(char *)"8",KEY_8 },
  {(char *)"9",KEY_9 },
  {(char *)"`",KEY_BQUOTE },
  {(char *)"-",KEY_MINUS },
  {(char *)"=",KEY_EQUAL },
  {(char *)"[",KEY_LBRACKET },
  {(char *)"]",KEY_RBRACKET },
  {(char *)"\\",KEY_BSLASH },
  {(char *)";",KEY_SEMICOLON },
  {(char *)"'",KEY_FQUOTE },
  {(char *)",",KEY_COMMA },
  {(char *)".",KEY_STOP },
  {(char *)"/",KEY_FSLASH },
  {(char *)"SPACE",KEY_SPACE },
  {(char *)"ENTER",KEY_RETURN },
  {(char *)"TAB",KEY_TAB },
  {(char *)"ESC",KEY_ESC },
  {(char *)"BKSP",KEY_BKSP },
  {(char *)"F1",KEY_F1},
  {(char *)"F2",KEY_F2},
  {(char *)"F3",KEY_F3},
  {(char *)"F4",KEY_F4},
  {(char *)"F5",KEY_F5},
  {(char *)"F6",KEY_F6},
  {(char *)"F7",KEY_F7},
  {(char *)"F8",KEY_F8},
  {(char *)"F9",KEY_F9},
  {(char *)"F10",KEY_F10},
  {(char *)"F11",KEY_F11},
  {(char *)"F12",KEY_F12},
  {(char *)"HOME",KEY_HOME},
  {(char *)"PGUP",KEY_PGUP},
  {(char *)"PGDN",KEY_PGDN},
  {(char *)"CURU",KEY_CURU},
  {(char *)"CURD",KEY_CURD},
  {(char *)"CURL",KEY_CURL},
  {(char *)"CURR",KEY_CURR},
  {(char *)"END",KEY_END},
  {(char *)"INS",KEY_INS},
  {(char *)"DEL",KEY_DEL},
  {(char *)"CENTER",KEY_NUMCENTER },
  {(char *)"PLUS",KEY_NUMPLUS},
  {(char *)"MINUS",KEY_NUMMINUS},
  {(char *)"SLASH",KEY_NUMSLASH},
  {(char *)"STAR",KEY_NUMSTAR},
  {(char *)"NUMENTER",KEY_NUMENTER},
/* shifted characters */
  {(char *)"S-A",KEY_S_a  },
  {(char *)"S-B",KEY_S_b  },
  {(char *)"S-C",KEY_S_c  },
  {(char *)"S-D",KEY_S_d  },
  {(char *)"S-E",KEY_S_e  },
  {(char *)"S-F",KEY_S_f  },
  {(char *)"S-G",KEY_S_g  },
  {(char *)"S-H",KEY_S_h  },
  {(char *)"S-I",KEY_S_i  },
  {(char *)"S-J",KEY_S_j  },
  {(char *)"S-K",KEY_S_k  },
  {(char *)"S-L",KEY_S_l  },
  {(char *)"S-M",KEY_S_m  },
  {(char *)"S-N",KEY_S_n  },
  {(char *)"S-O",KEY_S_o  },
  {(char *)"S-P",KEY_S_p  },
  {(char *)"S-Q",KEY_S_q  },
  {(char *)"S-R",KEY_S_r  },
  {(char *)"S-S",KEY_S_s  },
  {(char *)"S-T",KEY_S_t  },
  {(char *)"S-U",KEY_S_u  },
  {(char *)"S-V",KEY_S_v  },
  {(char *)"S-W",KEY_S_w  },
  {(char *)"S-X",KEY_S_x  },
  {(char *)"S-Y",KEY_S_y  },
  {(char *)"S-Z",KEY_S_z  },
  {(char *)"S-0",KEY_S_0  },
  {(char *)"S-1",KEY_S_1  },
  {(char *)"S-2",KEY_S_2  },
  {(char *)"S-3",KEY_S_3  },
  {(char *)"S-4",KEY_S_4  },
  {(char *)"S-5",KEY_S_5  },
  {(char *)"S-6",KEY_S_6  },
  {(char *)"S-7",KEY_S_7  },
  {(char *)"S-8",KEY_S_8  },
  {(char *)"S-9",KEY_S_9  },
  {(char *)"S-`",KEY_S_BQUOTE  },
  {(char *)"S--",KEY_S_MINUS  },
  {(char *)"S-=",KEY_S_EQUAL  },
  {(char *)"S-[",KEY_S_LBRACKET  },
  {(char *)"S-]",KEY_S_RBRACKET  },
  {(char *)"S-\\",KEY_S_BSLASH  },
  {(char *)"S-;",KEY_S_SEMICOLON  },
  {(char *)"S-'",KEY_S_FQUOTE  },
  {(char *)"S-,",KEY_S_COMMA  },
  {(char *)"S-.",KEY_S_STOP  },
  {(char *)"S-/",KEY_S_FSLASH  },
  {(char *)"S-TAB",KEY_S_TAB },
  {(char *)"S-F1",KEY_S_F1},
  {(char *)"S-F2",KEY_S_F2},
  {(char *)"S-F3",KEY_S_F3},
  {(char *)"S-F4",KEY_S_F4},
  {(char *)"S-F5",KEY_S_F5},
  {(char *)"S-F6",KEY_S_F6},
  {(char *)"S-F7",KEY_S_F7},
  {(char *)"S-F8",KEY_S_F8},
  {(char *)"S-F9",KEY_S_F9},
  {(char *)"S-F10",KEY_S_F10},
  {(char *)"S-F11",KEY_S_F11},
  {(char *)"S-F12",KEY_S_F12},
  {(char *)"S-HOME",KEY_S_HOME},
  {(char *)"S-PGUP",KEY_S_PGUP},
  {(char *)"S-PGDN",KEY_S_PGDN},
  {(char *)"S-CURU",KEY_S_CURU},
  {(char *)"S-CURD",KEY_S_CURD},
  {(char *)"S-CURL",KEY_S_CURL},
  {(char *)"S-CURR",KEY_S_CURR},
  {(char *)"S-END",KEY_S_END},
  {(char *)"S-INS",KEY_S_INS},
  {(char *)"S-DEL",KEY_S_DEL},
  {(char *)"S-CENTER",KEY_S_NUMCENTER},
  {(char *)"S-NUMSTOP",KEY_S_NUMSTOP},
  {(char *)"S-NUM0",KEY_S_NUM0},
  {(char *)"S-NUM1",KEY_S_NUM1},
  {(char *)"S-NUM2",KEY_S_NUM2},
  {(char *)"S-NUM3",KEY_S_NUM3},
  {(char *)"S-NUM4",KEY_S_NUM4},
  {(char *)"S-NUM6",KEY_S_NUM6},
  {(char *)"S-NUM7",KEY_S_NUM7},
  {(char *)"S-NUM8",KEY_S_NUM8},
  {(char *)"S-NUM9",KEY_S_NUM9},
/* control characters */
  {(char *)"C-A",KEY_C_a  },
  {(char *)"C-B",KEY_C_b  },
  {(char *)"C-C",KEY_C_c  },
  {(char *)"C-D",KEY_C_d  },
  {(char *)"C-E",KEY_C_e  },
  {(char *)"C-F",KEY_C_f  },
  {(char *)"C-G",KEY_C_g  },
  {(char *)"C-H",KEY_C_h  },
  {(char *)"C-I",KEY_C_i  },
  {(char *)"C-J",KEY_C_j  },
  {(char *)"C-K",KEY_C_k  },
  {(char *)"C-L",KEY_C_l  },
  {(char *)"C-M",KEY_C_m  },
  {(char *)"C-N",KEY_C_n  },
  {(char *)"C-O",KEY_C_o  },
  {(char *)"C-P",KEY_C_p  },
  {(char *)"C-Q",KEY_C_q  },
  {(char *)"C-R",KEY_C_r  },
  {(char *)"C-S",KEY_C_s  },
  {(char *)"C-T",KEY_C_t  },
  {(char *)"C-U",KEY_C_u  },
  {(char *)"C-V",KEY_C_v  },
  {(char *)"C-W",KEY_C_w  },
  {(char *)"C-X",KEY_C_x  },
  {(char *)"C-Y",KEY_C_y  },
  {(char *)"C-Z",KEY_C_z  },
  {(char *)"C-2",KEY_C_2  },
  {(char *)"C-6",KEY_C_6  },
  {(char *)"C--",KEY_C_MINUS  },
  {(char *)"C-[",KEY_C_LBRACKET  },
  {(char *)"C-]",KEY_C_RBRACKET  },
  {(char *)"C-\\",KEY_C_BSLASH  },
  {(char *)"C-ENTER",KEY_C_ENTER },
  {(char *)"C-TAB",KEY_C_TAB},
  {(char *)"C-BKSP",KEY_C_BKSP  },
  {(char *)"C-F1",KEY_C_F1},
  {(char *)"C-F2",KEY_C_F2},
  {(char *)"C-F3",KEY_C_F3},
  {(char *)"C-F4",KEY_C_F4},
  {(char *)"C-F5",KEY_C_F5},
  {(char *)"C-F6",KEY_C_F6},
  {(char *)"C-F7",KEY_C_F7},
  {(char *)"C-F8",KEY_C_F8},
  {(char *)"C-F9",KEY_C_F9},
  {(char *)"C-F10",KEY_C_F10},
  {(char *)"C-F11",KEY_C_F11},
  {(char *)"C-F12",KEY_C_F12},
  {(char *)"C-HOME",KEY_C_HOME},
  {(char *)"C-PGUP",KEY_C_PGUP},
  {(char *)"C-PGDN",KEY_C_PGDN},
  {(char *)"C-CURU",KEY_C_CURU},
  {(char *)"C-CURD",KEY_C_CURD},
  {(char *)"C-CURL",KEY_C_CURL},
  {(char *)"C-CURR",KEY_C_CURR},
  {(char *)"C-END",KEY_C_END},
  {(char *)"C-INS",KEY_C_INS},
  {(char *)"C-DEL",KEY_C_DEL},
  {(char *)"C-CENTER",KEY_C_NUMCENTER},
  {(char *)"C-NUMSTOP",KEY_C_NUMSTOP},
  {(char *)"C-NUM0",KEY_C_NUM0},
  {(char *)"C-NUM1",KEY_C_NUM1},
  {(char *)"C-NUM2",KEY_C_NUM2},
  {(char *)"C-NUM3",KEY_C_NUM3},
  {(char *)"C-NUM4",KEY_C_NUM4},
  {(char *)"C-NUM6",KEY_C_NUM6},
  {(char *)"C-NUM7",KEY_C_NUM7},
  {(char *)"C-NUM8",KEY_C_NUM8},
  {(char *)"C-NUM9",KEY_C_NUM9},
  {(char *)"C-PLUS",KEY_C_NUMPLUS},
  {(char *)"C-MINUS",KEY_C_NUMMINUS},
  {(char *)"C-SLASH",KEY_C_NUMSLASH},
  {(char *)"C-STAR",KEY_C_NUMSTAR},
  {(char *)"C-NUMENTER",KEY_C_NUMENTER},
/* alt characters */
  {(char *)"A-A",KEY_A_a},
  {(char *)"A-B",KEY_A_b},
  {(char *)"A-C",KEY_A_c},
  {(char *)"A-D",KEY_A_d},
  {(char *)"A-E",KEY_A_e},
  {(char *)"A-F",KEY_A_f},
  {(char *)"A-G",KEY_A_g},
  {(char *)"A-H",KEY_A_h},
  {(char *)"A-I",KEY_A_i},
  {(char *)"A-J",KEY_A_j},
  {(char *)"A-K",KEY_A_k},
  {(char *)"A-L",KEY_A_l},
  {(char *)"A-M",KEY_A_m},
  {(char *)"A-N",KEY_A_n},
  {(char *)"A-O",KEY_A_o},
  {(char *)"A-P",KEY_A_p},
  {(char *)"A-Q",KEY_A_q},
  {(char *)"A-R",KEY_A_r},
  {(char *)"A-S",KEY_A_s},
  {(char *)"A-T",KEY_A_t},
  {(char *)"A-U",KEY_A_u},
  {(char *)"A-V",KEY_A_v},
  {(char *)"A-W",KEY_A_w},
  {(char *)"A-X",KEY_A_x},
  {(char *)"A-Y",KEY_A_y},
  {(char *)"A-Z",KEY_A_z},
  {(char *)"A-0",KEY_A_0},
  {(char *)"A-1",KEY_A_1},
  {(char *)"A-2",KEY_A_2},
  {(char *)"A-3",KEY_A_3},
  {(char *)"A-4",KEY_A_4},
  {(char *)"A-5",KEY_A_5},
  {(char *)"A-6",KEY_A_6},
  {(char *)"A-7",KEY_A_7},
  {(char *)"A-8",KEY_A_8},
  {(char *)"A-9",KEY_A_9},
  {(char *)"A-`",KEY_A_BQUOTE},
  {(char *)"A--",KEY_A_MINUS},
  {(char *)"A-=",KEY_A_EQUAL},
  {(char *)"A-[",KEY_A_LBRACKET},
  {(char *)"A-]",KEY_A_RBRACKET},
  {(char *)"A-\\",KEY_A_BSLASH},
  {(char *)"A-;",KEY_A_SEMICOLON},
  {(char *)"A-'",KEY_A_FQUOTE},
  {(char *)"A-,",KEY_A_COMMA},
  {(char *)"A-.",KEY_A_STOP},
  {(char *)"A-/",KEY_A_FSLASH},
  {(char *)"A-ENTER",KEY_A_ENTER},
  {(char *)"A-TAB",KEY_A_TAB},
  {(char *)"A-ESC",KEY_A_ESC },
  {(char *)"A-BKSP",KEY_A_BKSP },
  {(char *)"A-F1",KEY_A_F1},
  {(char *)"A-F2",KEY_A_F2},
  {(char *)"A-F3",KEY_A_F3},
  {(char *)"A-F4",KEY_A_F4},
  {(char *)"A-F5",KEY_A_F5},
  {(char *)"A-F6",KEY_A_F6},
  {(char *)"A-F7",KEY_A_F7},
  {(char *)"A-F8",KEY_A_F8},
  {(char *)"A-F9",KEY_A_F9},
  {(char *)"A-F10",KEY_A_F10},
  {(char *)"A-F11",KEY_A_F11},
  {(char *)"A-F12",KEY_A_F12},
  {(char *)"A-HOME",KEY_A_HOME},
  {(char *)"A-PGUP",KEY_A_PGUP},
  {(char *)"A-PGDN",KEY_A_PGDN},
  {(char *)"A-CURU",KEY_A_CURU},
  {(char *)"A-CURD",KEY_A_CURD},
  {(char *)"A-CURL",KEY_A_CURL},
  {(char *)"A-CURR",KEY_A_CURR},
  {(char *)"A-END",KEY_A_END},
  {(char *)"A-INS",KEY_A_INS},
  {(char *)"A-DEL",KEY_A_DEL},
  {(char *)"A-PLUS",KEY_A_NUMPLUS},
  {(char *)"A-MINUS",KEY_A_NUMMINUS},
  {(char *)"A-SLASH",KEY_A_NUMSLASH},
  {(char *)"A-STAR",KEY_A_NUMSTAR},
  {(char *)"A-NUMENTER",KEY_A_NUMENTER}
#else
  {(char *)"KEY_MIN"      ,KEY_MIN },
  {(char *)"KEY_Help"     ,KEY_Help},
  {(char *)"KEY_Do"       ,KEY_Do},
  {(char *)"KEY_PF1"      ,KEY_PF1},
  {(char *)"KEY_PF2"      ,KEY_PF2},
  {(char *)"KEY_PF3"      ,KEY_PF3},
  {(char *)"KEY_PF4"      ,KEY_PF4},
  {(char *)"KEY_Pad0"     ,KEY_Pad0},
  {(char *)"KEY_Pad1"     ,KEY_Pad1},
  {(char *)"KEY_Pad2"     ,KEY_Pad2},
  {(char *)"KEY_Pad3"     ,KEY_Pad3},
  {(char *)"KEY_Pad4"     ,KEY_Pad4},
  {(char *)"KEY_Pad5"     ,KEY_Pad5},
  {(char *)"KEY_Pad6"     ,KEY_Pad6},
  {(char *)"KEY_Pad7"     ,KEY_Pad7},
  {(char *)"KEY_Pad8"     ,KEY_Pad8},
  {(char *)"KEY_Pad9"     ,KEY_Pad9},
  {(char *)"KEY_PadEnter" ,KEY_PadEnter},
  {(char *)"KEY_PadMinus" ,KEY_PadMinus},
  {(char *)"KEY_PadPeriod",KEY_PadPeriod},
  {(char *)"KEY_PadComma" ,KEY_PadComma},
  {(char *)"KEY_BackTab"  ,KEY_BackTab},
  {(char *)"KEY_Find"     ,KEY_Find},
  {(char *)"KEY_InsertHere",KEY_InsertHere},
  {(char *)"KEY_Remove"   ,KEY_Remove},
  {(char *)"KEY_Select"   ,KEY_Select},
  {(char *)"KEY_PrevScreen",KEY_PrevScreen},
  {(char *)"KEY_PrevScrn" ,KEY_PrevScrn},
  {(char *)"KEY_NextScreen",KEY_NextScreen},
  {(char *)"KEY_NextScrn" ,KEY_NextScrn},
  {(char *)"KEY_SF1"      ,KEY_SF1},
  {(char *)"KEY_SF2"      ,KEY_SF2},
  {(char *)"KEY_SF3"      ,KEY_SF3},
  {(char *)"KEY_SF4"      ,KEY_SF4},
  {(char *)"KEY_SF5"      ,KEY_SF5},
  {(char *)"KEY_SF6"      ,KEY_SF6},
  {(char *)"KEY_SF7"      ,KEY_SF7},
  {(char *)"KEY_SF8"      ,KEY_SF8},
  {(char *)"KEY_SF9"      ,KEY_SF9},
  {(char *)"KEY_SF10"     ,KEY_SF10},
  {(char *)"KEY_SF11"     ,KEY_SF11},
  {(char *)"KEY_SF12"     ,KEY_SF12},
  {(char *)"KEY_SF13"     ,KEY_SF13},
  {(char *)"KEY_SF14"     ,KEY_SF14},
  {(char *)"KEY_SF15"     ,KEY_SF15},
  {(char *)"KEY_SHelp"    ,KEY_SHelp},
  {(char *)"KEY_SF16"     ,KEY_SF16},
  {(char *)"KEY_SDo"      ,KEY_SDo},
  {(char *)"KEY_SF17"     ,KEY_SF17},
  {(char *)"KEY_SF18"     ,KEY_SF18},
  {(char *)"KEY_SF19"     ,KEY_SF19},
  {(char *)"KEY_SF20"     ,KEY_SF20},
  {(char *)"ControlA"     ,ControlA},
  {(char *)"ControlB"     ,ControlB},
  {(char *)"ControlC"     ,ControlC},
  {(char *)"ControlD"     ,ControlD},
  {(char *)"ControlE"     ,ControlE},
  {(char *)"ControlF"     ,ControlF},
  {(char *)"ControlG"     ,ControlG},
  {(char *)"ControlH"     ,ControlH},
  {(char *)"BackSpace"    ,BackSpace},
  {(char *)"ControlI"     ,ControlI},
  {(char *)"Tab"          ,Tab},
  {(char *)"ControlJ"     ,ControlJ},
  {(char *)"LineFeed"     ,LineFeed},
  {(char *)"ControlK"     ,ControlK},
  {(char *)"ControlL"     ,ControlL},
  {(char *)"ControlM"     ,ControlM},
  {(char *)"Return"       ,Return},
  {(char *)"ControlN"     ,ControlN},
  {(char *)"ControlO"     ,ControlO},
  {(char *)"ControlP"     ,ControlP},
  {(char *)"ControlQ"     ,ControlQ},
  {(char *)"ControlR"     ,ControlR},
  {(char *)"ControlS"     ,ControlS},
  {(char *)"ControlT"     ,ControlT},
  {(char *)"ControlU"     ,ControlU},
  {(char *)"ControlV"     ,ControlV},
  {(char *)"ControlW"     ,ControlW},
  {(char *)"ControlX"     ,ControlX},
  {(char *)"ControlY"     ,ControlY},
  {(char *)"ControlZ"     ,ControlZ},
  {(char *)"Escape"       ,Escape},
  {(char *)"Del"          ,Del},
  {(char *)"CSI"          ,CSI},
  {(char *)"KEY_BREAK"    ,KEY_BREAK },
  {(char *)"KEY_DOWN"     ,KEY_DOWN },
  {(char *)"KEY_UP"       ,KEY_UP },
  {(char *)"KEY_LEFT"     ,KEY_LEFT },
  {(char *)"KEY_RIGHT"    ,KEY_RIGHT},
  {(char *)"KEY_HOME"     ,KEY_HOME},
  {(char *)"KEY_BACKSPACE",KEY_BACKSPACE},
  {(char *)"KEY_F0"       ,KEY_F0},
  {(char *)"KEY_F1"       ,(KEY_F(0)+1)},
  {(char *)"KEY_F2"       ,(KEY_F(0)+2)},
  {(char *)"KEY_F3"       ,(KEY_F(0)+3)},
  {(char *)"KEY_F4"       ,(KEY_F(0)+4)},
  {(char *)"KEY_F5"       ,(KEY_F(0)+5)},
  {(char *)"KEY_F6"       ,(KEY_F(0)+6)},
  {(char *)"KEY_F7"       ,(KEY_F(0)+7)},
  {(char *)"KEY_F8"       ,(KEY_F(0)+8)},
  {(char *)"KEY_F9"       ,(KEY_F(0)+9)},
  {(char *)"KEY_F10"      ,(KEY_F(0)+10)},
  {(char *)"KEY_F11"      ,(KEY_F(0)+11)},
  {(char *)"KEY_F12"      ,(KEY_F(0)+12)},
  {(char *)"KEY_F13"      ,(KEY_F(0)+13)},
  {(char *)"KEY_F14"      ,(KEY_F(0)+14)},
  {(char *)"KEY_F15"      ,(KEY_F(0)+15)},
  {(char *)"KEY_F16"      ,(KEY_F(0)+16)},
  {(char *)"KEY_F17"      ,(KEY_F(0)+17)},
  {(char *)"KEY_F18"      ,(KEY_F(0)+18)},
  {(char *)"KEY_F19"      ,(KEY_F(0)+19)},
  {(char *)"KEY_F20"      ,(KEY_F(0)+20)},
  {(char *)"KEY_F21"      ,(KEY_F(0)+21)},
  {(char *)"KEY_F22"      ,(KEY_F(0)+22)},
  {(char *)"KEY_F23"      ,(KEY_F(0)+23)},
  {(char *)"KEY_F24"      ,(KEY_F(0)+24)},
  {(char *)"KEY_F25"      ,(KEY_F(0)+25)},
  {(char *)"KEY_F26"      ,(KEY_F(0)+26)},
  {(char *)"KEY_F27"      ,(KEY_F(0)+27)},
  {(char *)"KEY_F28"      ,(KEY_F(0)+28)},
  {(char *)"KEY_F29"      ,(KEY_F(0)+29)},
  {(char *)"KEY_F30"      ,(KEY_F(0)+30)},
  {(char *)"KEY_F31"      ,(KEY_F(0)+31)},
  {(char *)"KEY_F32"      ,(KEY_F(0)+32)},
  {(char *)"KEY_F33"      ,(KEY_F(0)+33)},
  {(char *)"KEY_F34"      ,(KEY_F(0)+34)},
  {(char *)"KEY_F35"      ,(KEY_F(0)+35)},
  {(char *)"KEY_F36"      ,(KEY_F(0)+36)},
  {(char *)"KEY_F37"      ,(KEY_F(0)+37)},
  {(char *)"KEY_F38"      ,(KEY_F(0)+38)},
  {(char *)"KEY_F39"      ,(KEY_F(0)+39)},
  {(char *)"KEY_F40"      ,(KEY_F(0)+40)},
  {(char *)"KEY_F41"      ,(KEY_F(0)+41)},
  {(char *)"KEY_F42"      ,(KEY_F(0)+42)},
  {(char *)"KEY_F43"      ,(KEY_F(0)+43)},
  {(char *)"KEY_F44"      ,(KEY_F(0)+44)},
  {(char *)"KEY_F45"      ,(KEY_F(0)+45)},
  {(char *)"KEY_F46"      ,(KEY_F(0)+46)},
  {(char *)"KEY_F47"      ,(KEY_F(0)+47)},
  {(char *)"KEY_F48"      ,(KEY_F(0)+48)},
  {(char *)"KEY_F49"      ,(KEY_F(0)+49)},
  {(char *)"KEY_F50"      ,(KEY_F(0)+50)},
  {(char *)"KEY_F51"      ,(KEY_F(0)+51)},
  {(char *)"KEY_F52"      ,(KEY_F(0)+52)},
  {(char *)"KEY_F53"      ,(KEY_F(0)+53)},
  {(char *)"KEY_F54"      ,(KEY_F(0)+54)},
  {(char *)"KEY_F55"      ,(KEY_F(0)+55)},
  {(char *)"KEY_F56"      ,(KEY_F(0)+56)},
  {(char *)"KEY_F57"      ,(KEY_F(0)+57)},
  {(char *)"KEY_F58"      ,(KEY_F(0)+58)},
  {(char *)"KEY_F59"      ,(KEY_F(0)+59)},
  {(char *)"KEY_F60"      ,(KEY_F(0)+60)},
  {(char *)"KEY_F61"      ,(KEY_F(0)+61)},
  {(char *)"KEY_F62"      ,(KEY_F(0)+62)},
  {(char *)"KEY_F63"      ,(KEY_F(0)+63)},
  {(char *)"KEY_F64"      ,(KEY_F(0)+64)},
  {(char *)"KEY_DL"       ,KEY_DL},
  {(char *)"KEY_IL"       ,KEY_IL},
  {(char *)"KEY_DC"       ,KEY_DC},
  {(char *)"KEY_IC"       ,KEY_IC},
  {(char *)"KEY_EIC"      ,KEY_EIC},
  {(char *)"KEY_CLEAR"    ,KEY_CLEAR},
  {(char *)"KEY_EOS"      ,KEY_EOS},
  {(char *)"KEY_EOL"      ,KEY_EOL},
  {(char *)"KEY_SF"       ,KEY_SF},
  {(char *)"KEY_SR"       ,KEY_SR},
  {(char *)"KEY_NPAGE"    ,KEY_NPAGE},
  {(char *)"KEY_PPAGE"    ,KEY_PPAGE},
  {(char *)"KEY_STAB"     ,KEY_STAB},
  {(char *)"KEY_CTAB"     ,KEY_CTAB},
  {(char *)"KEY_CATAB"    ,KEY_CATAB},
  {(char *)"KEY_ENTER"    ,KEY_ENTER},
  {(char *)"KEY_SRESET"   ,KEY_SRESET},
  {(char *)"KEY_RESET"    ,KEY_RESET},
  {(char *)"KEY_PRINT"    ,KEY_PRINT},
  {(char *)"KEY_LL"       ,KEY_LL},
  {(char *)"KEY_A1"       ,KEY_A1},
  {(char *)"KEY_A3"       ,KEY_A3},
  {(char *)"KEY_B2"       ,KEY_B2},
  {(char *)"KEY_C1"       ,KEY_C1},
  {(char *)"KEY_C3"       ,KEY_C3},
  {(char *)"KEY_BTAB"     ,KEY_BTAB},
  {(char *)"KEY_BEG"      ,KEY_BEG},
  {(char *)"KEY_CANCEL"   ,KEY_CANCEL},
  {(char *)"KEY_CLOSE"    ,KEY_CLOSE},
  {(char *)"KEY_COMMAND"  ,KEY_COMMAND},
  {(char *)"KEY_COPY"     ,KEY_COPY},
  {(char *)"KEY_CREATE"   ,KEY_CREATE},
  {(char *)"KEY_END"      ,KEY_END},
  {(char *)"KEY_EXIT"     ,KEY_EXIT},
  {(char *)"KEY_FIND"     ,KEY_FIND},
  {(char *)"KEY_HELP"     ,KEY_HELP},
  {(char *)"KEY_MARK"     ,KEY_MARK},
  {(char *)"KEY_MESSAGE"  ,KEY_MESSAGE},
  {(char *)"KEY_MOVE"     ,KEY_MOVE},
  {(char *)"KEY_NEXT"     ,KEY_NEXT},
  {(char *)"KEY_OPEN"     ,KEY_OPEN},
  {(char *)"KEY_OPTIONS"  ,KEY_OPTIONS},
  {(char *)"KEY_PREVIOUS" ,KEY_PREVIOUS},
  {(char *)"KEY_REDO"     ,KEY_REDO},
  {(char *)"KEY_REFERENCE",KEY_REFERENCE},
  {(char *)"KEY_REFRESH"  ,KEY_REFRESH},
  {(char *)"KEY_REPLACE"  ,KEY_REPLACE},
  {(char *)"KEY_RESTART"  ,KEY_RESTART},
  {(char *)"KEY_RESUME"   ,KEY_RESUME},
  {(char *)"KEY_SAVE"     ,KEY_SAVE},
  {(char *)"KEY_SBEG"     ,KEY_SBEG},
  {(char *)"KEY_SCANCEL"  ,KEY_SCANCEL},
  {(char *)"KEY_SCOMMAND" ,KEY_SCOMMAND},
  {(char *)"KEY_SCOPY"    ,KEY_SCOPY},
  {(char *)"KEY_SCREATE"  ,KEY_SCREATE},
  {(char *)"KEY_SDC"      ,KEY_SDC},
  {(char *)"KEY_SDL"      ,KEY_SDL},
  {(char *)"KEY_SELECT"   ,KEY_SELECT},
  {(char *)"KEY_SEND"     ,KEY_SEND},
  {(char *)"KEY_SEOL"     ,KEY_SEOL},
  {(char *)"KEY_SEXIT"    ,KEY_SEXIT},
  {(char *)"KEY_SFIND"    ,KEY_SFIND},
  {(char *)"KEY_SHELP"    ,KEY_SHELP},
  {(char *)"KEY_SHOME"    ,KEY_SHOME},
  {(char *)"KEY_SIC"      ,KEY_SIC},
  {(char *)"KEY_SLEFT"    ,KEY_SLEFT},
  {(char *)"KEY_SMESSAGE" ,KEY_SMESSAGE},
  {(char *)"KEY_SMOVE"    ,KEY_SMOVE},
  {(char *)"KEY_SNEXT"    ,KEY_SNEXT},
  {(char *)"KEY_SOPTIONS" ,KEY_SOPTIONS},
  {(char *)"KEY_SPREVIOUS",KEY_SPREVIOUS},
  {(char *)"KEY_SPRINT"   ,KEY_SPRINT},
  {(char *)"KEY_SREDO"    ,KEY_SREDO},
  {(char *)"KEY_SREPLACE" ,KEY_SREPLACE},
  {(char *)"KEY_SRIGHT"   ,KEY_SRIGHT},
  {(char *)"KEY_SRSUME"   ,KEY_SRSUME},
  {(char *)"KEY_SSAVE"    ,KEY_SSAVE},
  {(char *)"KEY_SSUSPEND" ,KEY_SSUSPEND},
  {(char *)"KEY_SUNDO"    ,KEY_SUNDO},
  {(char *)"KEY_SUSPEND"  ,KEY_SUSPEND},
  {(char *)"KEY_UNDO"     ,KEY_UNDO},
  {(char *)"KEY_CLEFT"    ,KEY_CLEFT},
  {(char *)"KEY_CRIGHT"   ,KEY_CRIGHT},
  {(char *)"KEY_CUP"      ,KEY_CUP},
  {(char *)"KEY_CDOWN"    ,KEY_CDOWN},
  {(char *)"KEY_CHOME"    ,KEY_CHOME},
  {(char *)"KEY_CEND"     ,KEY_CEND},
  {(char *)"KEY_CPGUP"    ,KEY_CPGUP},
  {(char *)"KEY_CPGDN"    ,KEY_CPGDN},
  {(char *)"KEY_MAX"      ,KEY_MAX}
#endif
};
