/***********************************************************************/
/* COMM5.C - Commands T-Z                                              */
/* This file contains all commands that can be assigned to function    */
/* keys or typed on the command line.                                  */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\comm5.c 1.4 1993/09/01 16:25:46 MH Interim MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"

/*#define DEBUG 1*/

/*-------------------------- external data ----------------------------*/
extern LINE *next_line,*curr_line;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char current_file;         /* pointer to current file */
extern WINDOW *foot,*error_window;
extern bool error_on_screen;
extern char *rec;
extern unsigned short rec_len;
extern char *cmd_rec;
extern unsigned short cmd_rec_len;
extern char mode_insert;        /* defines insert mode toggle */
/*man-start*********************************************************************
COMMAND
     tabcmd - switch windows (main/prefix command) for the current file

SYNTAX
     TABCmd
     ** effective only if bound to a key **

DESCRIPTION
     The TABCMD command switches the focus of the editor from the
     main or prefix windows to the command line and vice versa, depending
     on which window is currently active.

COMPATIBILITY
     XEDIT: Equivalent of CURSOR HOME.
     KEDIT: Equivalent of CURSOR HOME.

SEE ALSO
     tabpre

STATUS
     Complete. Will be replaced by CURSOR HOME in the future.
**man-end**********************************************************************/
#ifdef PROTO
int Tabcmd(char *params)
#else
int Tabcmd(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 char last_win;
 unsigned short x,y;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabcmd");
#endif
 last_win = CURRENT_VIEW->previous_window;
 CURRENT_VIEW->previous_window =
              CURRENT_VIEW->current_window;
 if (CURRENT_VIEW->current_window != WINDOW_COMMAND)
    {
     post_process_line(CURRENT_VIEW->focus_line);
     CURRENT_VIEW->current_window = WINDOW_COMMAND;
     wmove(CURRENT_WINDOW,0,0);
    }
 else
    {
     pre_process_line(CURRENT_VIEW->focus_line);
     CURRENT_VIEW->current_window = last_win;
     getyx(CURRENT_WINDOW,y,x);
     y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                                CURRENT_VIEW->focus_line,
                                CURRENT_VIEW->current_line);
     wmove(CURRENT_WINDOW,y,x);
    }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     tabpre - switch windows (main/prefix) for the current file

SYNTAX
     TABPre
     ** effective only if bound to a key **

DESCRIPTION
     The TABPRE command switches the focus of the editor from the
     main window to the prefix window and vice versa, depending
     on which window is currently active.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Equivalent of SOS LEFTEDGE and SOS PREFIX

SEE ALSO
     tabcmd

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Tabpre(char *params)
#else
int Tabpre(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 char last_win;
 unsigned short y,x;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Tabpre");
#endif
/*---------------------------------------------------------------------*/
/* If the cursor is in the command line or there is no prefix on, exit.*/
/*---------------------------------------------------------------------*/
 if (CURRENT_VIEW->current_window == WINDOW_COMMAND
 ||  !CURRENT_VIEW->prefix)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }

 getyx(CURRENT_WINDOW,y,x);

 last_win = CURRENT_VIEW->previous_window;
 CURRENT_VIEW->previous_window =
              CURRENT_VIEW->current_window;
 if (CURRENT_VIEW->current_window == WINDOW_MAIN)
   {
    post_process_line(CURRENT_VIEW->focus_line);
    CURRENT_VIEW->current_window = WINDOW_PREFIX;
   }
 else
   {
    pre_process_line(CURRENT_VIEW->focus_line);
    CURRENT_VIEW->current_window = WINDOW_MAIN;
   }
 wmove(CURRENT_WINDOW,y,0);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     text - simulate keyboard entry of characters

SYNTAX
     TEXT text

DESCRIPTION
     The TEXT command simulates the entry of characters from the
     keyboard. This command is actually called when you enter text
     from the keyboard.

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Compatible.
            Does not allow leading or trailing spaces in text (at the
            moment)

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Text(char *params)
#else
int Text(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern bool extended_display_mode;
 extern bool CMDARROWSTABLRx;
 extern bool prefix_changed;
 extern char *pre_rec;
 extern unsigned short pre_rec_len;
/*--------------------------- local data ------------------------------*/
 register int i;
 char real_key;
 chtype chtype_key;
 unsigned short y,x;
 bool save_CMDARROWSTABLRx;
 int len_params;
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Text");
#endif
/*---------------------------------------------------------------------*/
/* If no parameters, return without doing anything.                    */
/*---------------------------------------------------------------------*/
 save_CMDARROWSTABLRx = CMDARROWSTABLRx;
 if (CURRENT_VIEW->hex == ON)
   {
    if ((len_params = convert_hex_strings(params)) == (-1))
      {
       display_error(32,(char *)"");
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND);
      }
   }
 else
   len_params = strlen(params);
 for (i=0;i<len_params;i++)
   {
    real_key = case_translate((char)*(params+i));
    chtype_key = (chtype)(real_key & A_CHARTEXT);
    switch(CURRENT_VIEW->current_window)
      {
       case WINDOW_MAIN:
            if (CURRENT_VIEW->focus_line == 0
            ||  CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines + 1)
               break;
            getyx(CURRENT_WINDOW,y,x);
            if (x+CURRENT_VIEW->verify_start > CURRENT_VIEW->verify_end)
               break;
            if (mode_insert)
              {
               rec = (char *)meminschr((char *)rec,
                               real_key,CURRENT_VIEW->verify_col-1+x,
                               max_line_length,rec_len);
               if (extended_display_mode)
                  winsch(CURRENT_WINDOW,chtype_key);
               else
                  put_char(CURRENT_WINDOW,chtype_key,INSCHAR);
              }
            else
              {
               rec[CURRENT_VIEW->verify_col-1+x] = real_key;
               if (x == CURRENT_SCREEN.cols-1)
                 {
                  if (extended_display_mode)
                     winsch(CURRENT_WINDOW,chtype_key);
                  else
                     put_char(CURRENT_WINDOW,chtype_key,INSCHAR);
                 }
               else
                 {
                  if (extended_display_mode)
                     waddch(CURRENT_WINDOW,chtype_key);
                  else
                     put_char(CURRENT_WINDOW,chtype_key,ADDCHAR);
                 }
              }
            rc = memrevne(rec,' ',max_line_length);
            if (rc == (-1))
               rec_len = 0;
            else
               rec_len = rc+1;
            /* check for the cursor moving past the right   */
            /* margin when WORDWRAP is ON. If true, then    */
            /* don't execute the Right_arrow() function, as */
            /* this could cause a window scroll.            */
            if (CURRENT_VIEW->wordwrap
            &&  x+CURRENT_VIEW->verify_start+CURRENT_VIEW->verify_col > CURRENT_VIEW->margin_right)
               execute_wrap_word(x+CURRENT_VIEW->verify_col);
            else    
               {
               /* this is done here so that the show_page() in */
               /* Right_arrow() is executed AFTER we get the   */
               /* new length of rec_len.                       */
               CMDARROWSTABLRx = FALSE;
               if (mode_insert
               || x == CURRENT_SCREEN.cols-1)
                  Right_arrow("");
               CMDARROWSTABLRx = save_CMDARROWSTABLRx;
               }
            break;
       case WINDOW_COMMAND:
            getyx(CURRENT_WINDOW,y,x);
            if (mode_insert)
              {
               cmd_rec = (char *)meminschr((char *)cmd_rec,
                               real_key,x,
                               COLS,cmd_rec_len);
               if (extended_display_mode)
                  winsch(CURRENT_WINDOW,chtype_key);
               else
                  put_char(CURRENT_WINDOW,chtype_key,INSCHAR);
               Right_arrow("");
              }
            else
              {
               cmd_rec[x] = real_key;
               if (extended_display_mode)
                  waddch(CURRENT_WINDOW,chtype_key);
               else
                  put_char(CURRENT_WINDOW,chtype_key,ADDCHAR);
              }
            rc = memrevne(cmd_rec,' ',COLS);
            if (rc == (-1))
               cmd_rec_len = 0;
            else
               cmd_rec_len = rc+1;
            break;
       case WINDOW_PREFIX:
            getyx(CURRENT_WINDOW,y,x);
            prefix_changed = TRUE;
            if (pre_rec_len == 0)
              {
               wmove(CURRENT_WINDOW,y,0);
               my_wclrtoeol(CURRENT_WINDOW);
               wrefresh(CURRENT_WINDOW);
               x = 0;
              }
            if (mode_insert)
              {
               pre_rec = (char *)meminschr((char *)pre_rec,
                               real_key,x,
                               PREFIX_WIDTH,pre_rec_len);
               if (extended_display_mode)
                  winsch(CURRENT_WINDOW,chtype_key);
               else
                  put_char(CURRENT_WINDOW,chtype_key,INSCHAR);
               Right_arrow("");
              }
            else
              {
               pre_rec[x] = real_key;
               if (extended_display_mode)
                  waddch(CURRENT_WINDOW,chtype_key);
               else
                  put_char(CURRENT_WINDOW,chtype_key,ADDCHAR);
              }
            rc = memrevne(pre_rec,' ',PREFIX_WIDTH);
            if (rc == (-1))
               pre_rec_len = 0;
            else
               pre_rec_len = rc+1;
            break;
      }
   }
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     top - move to the top of the file

SYNTAX
     TOP

DESCRIPTION
     The TOP command moves to the very start of the current file.
     The "Top-of-file" line is set to the current_line.

     "TOP" is equivalent to "BACKWARD *".

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     backward,bottom

STATUS
     Complete
**man-end**********************************************************************/
#ifdef PROTO
int Top(char *params)
#else
int Top(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 short rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Top");
#endif
 rc = Backward("*");
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     up - move backward in the file a number of lines

SYNTAX
     Up [n|*]

DESCRIPTION
     The UP command moves the current_line backwards the number of
     lines specified by 'n'. Negative values of 'n' move forwards
     through the file.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: Compatible.

SEE ALSO
     Next

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Up(char *params)
#else
int Up(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
#define UP_PARAMS  1
 char *word[UP_PARAMS+1];
 unsigned short num_params;
 long num_lines;
 unsigned short y,x;
 char cmd_line[10];
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Up");
#endif
 num_params = param_split(params,word,UP_PARAMS,WORD_DELIMS,TEMP_PARAM);
 if (num_params == 0)
   {
    num_params = 1;
    word[0] = (char *)"1";
   }
 if (num_params != 1)
   {
    display_error(1,word[1]);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 if (equal((char *)"all",word[0],3))         /* all is not a valid target here */
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 if (!valid_integer(word[0]))
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 sprintf(cmd_line,"-%s",word[0]);
 if ((num_lines = valid_target(cmd_line,get_true_line())) == TARGET_ERROR)
   {
    display_error(4,word[0]);
#ifdef TRACE
    trace_return();
#endif
    return(RC_INVALID_OPERAND);
   }
 sprintf(cmd_line,"%-ld",num_lines);
 rc = Next(cmd_line);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     up_arrow - move the cursor up one line

SYNTAX
     ** effective only if bound to a key **

DESCRIPTION
     The up_arrow command moves the cursor up one line in the main
     window. Scrolling of the window occurs if the cursor is on the first
     line of the window.

     When on the command line, this command moves backward through the
     list of previous command line commands or tabs to the last line of
     the main window depending on the value set by the function
     cmdarrows. (default is the former)

COMPATIBILITY
     XEDIT: N/A
     KEDIT: Equivalent of CURSOR UP

SEE ALSO
     Down_arrow

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Up_arrow(char *params)
#else
int Up_arrow(params)
char *params;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern char CMDARROWSTABCMDx;
extern char CMDARROWSTABTXTx;
/*--------------------------- local data ------------------------------*/
 unsigned short x,y;
 int rc=RC_OK;
 char *current_command;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Up_arrow");
#endif
 switch(CURRENT_VIEW->current_window)
  {
   case WINDOW_MAIN:
   case WINDOW_PREFIX:
        getyx(CURRENT_WINDOW,y,x);
/*---------------------------------------------------------------------*/
/* If the cursor is on the last line of the window or on the last line */
/* of the file and tabbibg to the command line is set, tab to the      */
/* command line.                                                       */
/*---------------------------------------------------------------------*/
        if (CMDARROWSTABTXTx
        && ( y == 0 || FOCUS_TOF))
          {
           Tabcmd("");
           break;
          }
/*---------------------------------------------------------------------*/
/* If the cursor is on the first line of the file...                   */
/* ... and the first line of the file is on the current row, stay there.*/
/*---------------------------------------------------------------------*/
        if (CURRENT_VIEW->current_line == 0
        && y == CURRENT_VIEW->current_row)
           break;
/*---------------------------------------------------------------------*/
/* If the cursor is on the first line of the file...                   */
/* ... and the first line of the file is above the current row,        */
/* scroll the window down one line.                                    */
/*---------------------------------------------------------------------*/
        if (CURRENT_VIEW->current_line+y
            == CURRENT_VIEW->current_row)
           {
            CURRENT_VIEW->current_line--;
            show_page();
            wmove(CURRENT_WINDOW,y+1,x);
            break;
           }
/*---------------------------------------------------------------------*/
/* If on the top line of the window, scroll the window down 1 line.    */
/*---------------------------------------------------------------------*/
        if (y == 0)
           {
            CURRENT_VIEW->current_line--;
            post_process_line(CURRENT_VIEW->focus_line);
            CURRENT_VIEW->focus_line--;
            pre_process_line(CURRENT_VIEW->focus_line);
            show_page();
            wmove(CURRENT_WINDOW,y,x);
            break;
           }
/*---------------------------------------------------------------------*/
/* We are in the middle of the window, so just move the cursor up      */
/* 1 line.                                                             */
/*---------------------------------------------------------------------*/
        wmove(CURRENT_WINDOW,y-1,x);
        post_process_line(CURRENT_VIEW->focus_line);
        CURRENT_VIEW->focus_line--;
        pre_process_line(CURRENT_VIEW->focus_line);
        break;
   case WINDOW_COMMAND:
/*---------------------------------------------------------------------*/
/* Cycle backward through the command list or tab to last line.        */
/*---------------------------------------------------------------------*/
        if (CMDARROWSTABCMDx)
          {
           getyx(CURRENT_WINDOW,y,x);
           if (CURRENT_VIEW->prefix != PREFIX_LEFT)
              x += 6;
           if (CURRENT_FILE->number_lines >= CURRENT_SCREEN.rows -
                                           CURRENT_VIEW->current_row +
                                           CURRENT_VIEW->current_line - 1)
             {
              CURRENT_VIEW->focus_line = CURRENT_SCREEN.rows -
                                        CURRENT_VIEW->current_row +
                                        CURRENT_VIEW->current_line - 1;
              y = CURRENT_SCREEN.rows -1;
             }
           else
             {
              CURRENT_VIEW->focus_line = CURRENT_FILE->number_lines + 1;
              y = get_row_for_focus_line(CURRENT_VIEW->current_row,
                                         CURRENT_VIEW->focus_line,
                                         CURRENT_VIEW->current_line);
             }
           pre_process_line(CURRENT_VIEW->focus_line);
           CURRENT_VIEW->current_window = WINDOW_MAIN;
           wmove(CURRENT_WINDOW,y,x);
          }
        else
          {
           char *current_command;
           current_command = get_next_command(DIRECTION_FORWARD);
           wmove(CURRENT_WINDOW_COMMAND,0,0);
           my_wclrtoeol(CURRENT_WINDOW_COMMAND);
           if (current_command != (char *)NULL)
              Cmsg(current_command);
          }
        break;
   default:
        display_error(2,(char *)"");
        rc = RC_INVALID_OPERAND;
        break;
  }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     uppercase - change lowercase characters to uppercase

SYNTAX
     UPPercase [target]

DESCRIPTION
     The UPPERCASE command changes all lowercase characters in the target
     to uppercase. All other characters remain untouched.

COMPATIBILITY
     XEDIT: Equivalent of UPPERCAS
     KEDIT: Compatible.

SEE ALSO
     lowercase

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Uppercase(char *params)
#else
int Uppercase(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 int rc;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm3.c:   Uppercase");
#endif
 rc = execute_change_case(params,CASE_UPPER);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     xedit - edit another file

SYNTAX
     Xedit [filename]
     THE   [filename]
     Edit  [filename]

DESCRIPTION
     The EDIT command allows the user to edit another file. The new file
     is placed in the file ring. The previous file being edited remains
     in memory and can be returned to by issuing an EDIT command without
     any parameters. Several files can be edited at once, and all files
     are arranged in a ring, with subsequent EDIT commands moving through
     the ring, one file at a time.

COMPATIBILITY
     XEDIT: Does not provide options switches.
     KEDIT: Does not provide options switches.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Xedit(char *params)
#else
int Xedit(params)
char *params;
#endif
/***********************************************************************/
{
/*-------------------------- external data ----------------------------*/
 extern bool REPROFILEx;
 extern char number_of_files;
 extern char *prf_arg;
 extern short file_start;
 extern char *dirfilename;
 extern char in_profile;
 extern bool execute_profile;
/*--------------------------- local data ------------------------------*/
 char old_current_file;
 unsigned short y,x;
 int rc=RC_OK;
#ifndef VMS
 SCREEN_DETAILS *screen0 = &screen[0];
 SCREEN_DETAILS *screen1 = &screen[1];
#endif
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm5.c:   Xedit");
#endif
 if (strcmp(params,"") == 0)
   {
    if (CURRENT_VIEW->next == (VIEW_DETAILS *)NULL
    &&  CURRENT_VIEW->prev == (VIEW_DETAILS *)NULL)
      {
#ifdef TRACE
       trace_return();
#endif
       return(RC_OK);
      }
    wmove(CURRENT_WINDOW_COMMAND,0,0);
    my_wclrtoeol(CURRENT_WINDOW_COMMAND);
    memset(cmd_rec,' ',COLS);
    cmd_rec_len = 0;
    post_process_line(CURRENT_VIEW->focus_line);
    if (CURRENT_VIEW->next == (VIEW_DETAILS *)NULL)
       CURRENT_VIEW = vd_first;
    else
       CURRENT_VIEW = CURRENT_VIEW->next;
    pre_process_line(CURRENT_VIEW->focus_line);
    show_page();
    if (CURRENT_VIEW->prefix)
       touchwin(CURRENT_WINDOW_PREFIX);
    touchwin(CURRENT_WINDOW_COMMAND);
    touchwin(CURRENT_WINDOW_IDLINE);
    touchwin(CURRENT_WINDOW_MAIN);
    CURRENT_SCREEN.screen_view = CURRENT_VIEW;
#ifdef TRACE
    trace_return();
#endif
    return(RC_OK);
   }
/*---------------------------------------------------------------------*/
/* If there are still file(s) in the ring, clear the command line and  */
/* save any changes to the focus line.                                 */
/*---------------------------------------------------------------------*/
 if (number_of_files > 0)
   {
    wmove(CURRENT_WINDOW_COMMAND,0,0);
    my_wclrtoeol(CURRENT_WINDOW_COMMAND);
    post_process_line(CURRENT_VIEW->focus_line);
   }
 memset(cmd_rec,' ',COLS);
 cmd_rec_len = 0;
 if ((rc = get_file(strtrans(params,OSLASH,ISLASH))) != RC_OK)
   {
#ifdef TRACE
    trace_return();
#endif
    return(rc);
   }
 pre_process_line(CURRENT_VIEW->focus_line);
 if (REPROFILEx && !in_profile)
   {
    in_profile = TRUE;
    if (execute_profile)
       (void)get_profile(prf_arg);
    in_profile = FALSE;
   }
 pre_process_line(CURRENT_VIEW->focus_line);
/*---------------------------------------------------------------------*/
/* If we are currently running the profile, do no set up any windows.  */
/* We can't, because curses hasn't started yet.                        */
/*---------------------------------------------------------------------*/
 if (!in_profile)
   {
    if ((rc = set_up_windows()) != RC_OK)
      {
#ifdef TRACE
       trace_return();
#endif
       return(rc);
      }
    show_page();
    if (strcmp(CURRENT_FILE->fname,dirfilename) == 0)
       wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,file_start-1);
    else
       wmove(CURRENT_WINDOW_MAIN,CURRENT_VIEW->current_row,0);
    wmove(CURRENT_WINDOW_COMMAND,0,0);
    if (CURRENT_VIEW->prefix)
       touchwin(CURRENT_WINDOW_PREFIX);
    touchwin(CURRENT_WINDOW_COMMAND);
    touchwin(CURRENT_WINDOW_IDLINE);
    touchwin(CURRENT_WINDOW_MAIN);
   }
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/*man-start*********************************************************************
COMMAND
     retrieve - return the next/prior command

SYNTAX
     ?[+]

DESCRIPTION
     The ? command returns the next or prior command from the command
     line stack and displays it on the command line.
     With no parameters, the most recent command entered on the command
     line is retrieved.

COMPATIBILITY
     XEDIT: Compatible.
     KEDIT: See below..
     Does not support multiple '?' as in ??? to retrieve the third last
     command.
     This command is bound to the up and down arrows when on the
     command line depending on the setting of CMDARROWS.

SEE ALSO
     cmdarrows

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Retrieve(char *params)
#else
int Retrieve(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 char *current_command;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Retrieve");
#endif
 if (strcmp(params,"") == 0)
   {
    current_command = get_next_command(DIRECTION_FORWARD);
    current_command = get_next_command(DIRECTION_FORWARD);
   }
 else
    if (strcmp(params,"+") == 0)
      current_command = get_next_command(DIRECTION_BACKWARD);
    else
      {
       display_error(1,params);
#ifdef TRACE
       trace_return();
#endif
       return(RC_INVALID_OPERAND);
      }

 wmove(CURRENT_WINDOW_COMMAND,0,0);
 my_wclrtoeol(CURRENT_WINDOW_COMMAND);
 if (current_command != (char *)NULL)
    Cmsg(current_command);
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/*man-start*********************************************************************
COMMAND
     = re-execute the last command issued on the command line

SYNTAX
     =

DESCRIPTION
     The = command retrieves the most recently issued command from
     the command line and re-executes it.

COMPATIBILITY
     XEDIT: Does not support optional [subcommand] option.
     KEDIT: Does not support optional [command] option.

STATUS
     Complete.
**man-end**********************************************************************/
#ifdef PROTO
int Reexecute(char *params)
#else
int Reexecute(params)
char *params;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 char *current_command;
 int rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("comm4.c:   Reexecute");
#endif
 if (strcmp(params,""))
    {
     display_error(1,params);
#ifdef TRACE
     trace_return();
#endif
     return(RC_INVALID_OPERAND);
    }
/*---------------------------------------------------------------------*/
/* Retrieve the last command and execute it.                           */
/*---------------------------------------------------------------------*/
 current_command = get_next_command(DIRECTION_NONE);
 if (current_command != NULL)
    rc = command_line(current_command,COMMAND_ONLY_FALSE);
#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
