/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\the.h 1.4 1993/09/01 16:27:20 MH Interim MH $
*/

#include "defines.h"

#if defined(USE_NCURSES)
#   include <ncurses.h>
#   define SYSVR32
#else
#   if defined(USE_EXTCURSES)
#      include <cur00.h>
#      define SYSVR32
#      define A_COLOR
#      define COLOR_BLACK		0
#      define COLOR_BLUE		1
#      define COLOR_GREEN		2
#      define COLOR_CYAN		3
#      define COLOR_RED		4
#      define COLOR_MAGENTA		5
#      define COLOR_YELLOW		6
#      define COLOR_WHITE		7
       typedef char bool;
#      define chtype NLSCHAR
#      define COLOR_PAIRS 64
       extern chtype color_pair[COLOR_PAIRS];
#      define COLOR_PAIR(n) color_pair[n]
#      define wattrset(win,attr) xstandout(win,attr)
#      define attrset(attr) xstandout(stdscr,attr)
#      define nocbreak() nocrmode()
#      define cbreak() crmode()
#      define wnoutrefresh(win) wrefresh(win)
#   else
#      include <curses.h>
#   endif
#endif

#ifdef __OS2__
#  undef MSDOS                 /* in case you are using MSC 6.0 for OS/2 */
#  undef SYSV                  /* set in curses.h */
#  undef BSD                   /* set in curses.h */
#  define SYSVR32curses
#  define SYSVR31curses
#  define SYSVR3curses
#  include <stdlib.h>
#  include <memory.h>
#  include <string.h>
#  include <process.h>
#  include <errno.h>
#  include <ctype.h>
#  include <sys\types.h>
#  include <sys\stat.h>
#  define         W_OK          02
#  define         F_OK          00
#  define         R_OK          04
#  define ESLASH '\\'
#  define ESTR_SLASH (char *)"\\"
#  ifdef EMX
#    define OSLASH '\\'
#    define OSTR_SLASH (char *)"\\"
#    define ISLASH '/'
#    define ISTR_SLASH (char *)"/"
#  else
#    define OSLASH '/'
#    define OSTR_SLASH (char *)"/"
#    define ISLASH '\\'
#    define ISTR_SLASH (char *)"\\"
#  endif
#  define CURRENT_DIR (char *)"."
#  define FMODE (0)
#  ifdef MSC
/* the following 2 defines are to make MSC recognise the new names */
/* of the following OS/2 calls */
#    define DosSetDefaultDisk DosSelectDisk
#    define DosQueryCurrentDisk DosQCurDisk
#  endif
#endif

#if defined(__MSDOS__) || defined(MSDOS)
#  define SYSVR32curses
#  define SYSVR31curses
#  define SYSVR3curses
#  undef SYSV                  /* set in curses.h */
#  undef BSD                   /* set in curses.h */
#  include <stdlib.h>
#  include <memory.h>
#  include <string.h>
#  ifdef GO32
#    include <dir.h>
#  else
#    include <process.h>
#    include <direct.h>
#  endif
#  include <errno.h>
#  include <io.h>
#  include <ctype.h>
#  include <sys\types.h>
#  include <sys\stat.h>
#  define         W_OK          02
#  define         F_OK          00
#  define         R_OK          04
#  define ESLASH '\\'
#  define ESTR_SLASH (char *)"\\"
#  ifdef GO32
#    define OSLASH '\\'
#    define OSTR_SLASH (char *)"\\"
#    define ISLASH '/'
#    define ISTR_SLASH (char *)"/"
#  else
#    define OSLASH '/'
#    define OSTR_SLASH (char *)"/"
#    define ISLASH '\\'
#    define ISTR_SLASH (char *)"\\"
#  endif
#  define CURRENT_DIR (char *)"."
#  define FMODE (0)
/*#define FMODE (S_IREAD | S_IWRITE)*/
#endif

#ifdef SYSVR4
#  undef BSD
#  ifndef SYSV
#    define SYSV
#  endif
#  include <ctype.h>
#  include <unistd.h>
#  define SYSVR4curses
#  define SYSVR32curses
#  define SYSVR31curses
#  define SYSVR3curses
#endif

#ifdef SYSVR32
#  undef BSD
#  ifndef SYSV
#    define SYSV
#  endif
#  include <ctype.h>
#  include <unistd.h>
#  define SYSVR32curses
#  define SYSVR31curses
#  define SYSVR3curses
#endif

#ifdef SYSVR31
#  undef BSD
#  ifndef SYSV
#    define SYSV
#  endif
#  define SYSVR31curses
#  define SYSVR3curses
#endif

#ifdef SYSVR3
#  undef BSD
#  ifndef SYSV
#    define SYSV
#  endif
#  define SYSVR3curses
#endif

#ifdef SYSV
#  undef BSD
#  define SYSVcurses
#  if !defined(ATT)
#    include <stdlib.h>
#    include <sys/file.h>
#  endif
#  include <memory.h>
#  include <string.h>
#  include <sys/types.h>
#  include <sys/stat.h>
#  define FMODE (0)
#  define UNIX 1
#endif


#ifdef BSD
#  include <stdlib.h>
#  include <memory.h>
#  include <string.h>
#  include <sys/file.h>
#  include <sys/types.h>
#  include <sys/stat.h>
#  define FMODE (0)
#  define chtype short
#  define UNIX 1
#  define BSDcurses 1
#  define NO_KEYPAD 1
#  define attrset(attr) wattrset(stdscr,attr)
#  ifdef linux
#    include <unistd.h>
#  endif
#endif

#ifdef M_XENIX
#  include <ctype.h>
#  include <sys/types.h>
#  include <sys/stat.h>
#  include <memory.h>
#  include <string.h>
#  include <sys/file.h>
#  define         F_OK          00
#  define         W_OK          02
#  define         R_OK          04
#  define touchline(WIN,START,NUM)       touchwin(WIN)
#  define FMODE (0)
#  define UNIX 1
#endif

#ifdef MINIX
#  include <string.h>
#  define short int
#  define UNIX 1
#endif

#ifdef UNIX
#  define ESLASH '/'
#  define ESTR_SLASH (char *)"/"
#  define OSLASH '\\'
#  define OSTR_SLASH (char *)"\\"
#  define ISLASH ESLASH
#  define ISTR_SLASH ESTR_SLASH
#  define CURRENT_DIR (char *)"."
#endif

#ifdef VMS
#  include <string.h>
#  include <file.h>
#  include <types.h>
#  include <stat.h>
#  include <ctype.h>
#  define         W_OK          02
#  define         F_OK          00
#  define         R_OK          04
#  define ISLASH ']'
#  define ISTR_SLASH (char *)"]"
#  define OSLASH ISLASH
#  define OSTR_SLASH ISTR_SLASH
#  define ESLASH ISLASH
#  define ESTR_SLASH ISTR_SLASH
#  define CURRENT_DIR (char *)"[]"
/*#define FMODE (S_IRWXU | S_IRGRP | S_IROTH)*/
#  define FMODE (0)
#  ifdef BSD
#    define chtype short
#    define BSDcurses 1
#  endif
#  define touchline(WIN,START,NUM)       touchwin(WIN)
/* #define isdigit(c)   (_ctype[(c) + 1] & 2)
#  define islower(c)   (_ctype[(c) + 1] & 8)
#  define isupper(c)   (_ctype[(c) + 1] & 4)*/
#  define NO_KEYPAD 1
#endif
/*---------------------------------------------------------------------*/
/* End of OS-specific defines                                          */
/*---------------------------------------------------------------------*/

#ifndef A_NORMAL
/* Various video attributes */
#ifdef BSD
#define A_STANDOUT      _STANDOUT    /* for compatability with old curses */
#define A_REVERSE       _STANDOUT    /* for compatability with old curses */
#define A_UNDERLINE     0
#define A_BLINK         0
#define A_DIM           0
#define A_BOLD          _STANDOUT

/* The next two are subject to change so don't depend on them */
#define A_INVIS         0
#define A_PROTECT       0

#define A_NORMAL        0
#define A_CHARTEXT      0x007F
#define A_ATTRIBUTES    ~A_CHARTEXT
#define A_ALTCHARSET    0

#else

#define A_STANDOUT      000000200000L
#define A_UNDERLINE     000000400000L
#define A_REVERSE       000001000000L
#define A_BLINK         000002000000L
#define A_DIM           000004000000L
#define A_BOLD          000010000000L
#define A_ALTCHARSET    000100000000L

/* The next two are subject to change so don't depend on them */
#define A_INVIS         000020000000L
#define A_PROTECT       000040000000L

#define A_NORMAL        000000000000L
#define A_ATTRIBUTES    037777600000L   /* 0xFFFF0000 */
#define A_CHARTEXT      000000177777L   /* 0x0000FFFF */

#endif
#endif

#ifndef max
#define max(a,b)        (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)        (((a) < (b)) ? (a) : (b))
#endif

#ifndef getmaxy
#ifdef VMS
#define getmaxy(win)    ((win)->_max_y)
#else
#define getmaxy(win)    ((win)->_maxy)
#endif
#endif

#ifndef getmaxx
#ifdef VMS
#define getmaxx(win)    ((win)->_max_x)
#else
#define getmaxx(win)    ((win)->_maxx)
#endif
#endif

#ifndef getmaxyx
#define getmaxyx(win,y,x)  ((y) = getmaxy(win), (x) = getmaxx(win))
#endif

#define OFF             0
#define ON              1
#define NO              0
#define YES             1
#define NA              2

/*#define ERROR         (-128)*/
#define QUIT          (-127)
#define SKIP          (-126)
#define QUITOK        (-125)
#define RAW_KEY       (128)

#define MAX_SCREENS         2             /* maximum number of screens*/
#define VIEW_WINDOWS        5             /* number of windows per view */
#define MAX_INT             32766         /* maximum size for integer */
#define MAX_LONG            2147483001    /* maximum size for long */
#define TARGET_ERROR        -2147483000   /* number returned as target error */
#define TARGET_NOT_FOUND    -2147482999   /* number returned not found target */
#define WORD_DELIMS         " \t"         /* word delimiter characters */

#define TOP_OF_FILE         (char *)"*** Top of File ***"
#define BOTTOM_OF_FILE      (char *)"*** Bottom of File ***"
#define DIRECTION_NONE      0
#define DIRECTION_FORWARD   1
#define DIRECTION_BACKWARD  (-1)

#define UNDEFINED_OPERAND (-1)

#define WINDOW_MAIN     0
#define WINDOW_PREFIX   1
#define WINDOW_COMMAND  2
#define WINDOW_ARROW    3
#define WINDOW_IDLINE   4
#define WINDOW_FOOTING  5
#define WINDOW_ERROR    6
#define WINDOW_DIVIDER  7
#define WINDOW_RESERVED 8

#define PREFIX_WIDTH    6

#define CURRENT_VIEW              (vd_current)
#define PREVIOUS_VIEW             (vd_current->prev)
#define NEXT_VIEW                 (vd_current->next)

#define CURRENT_FILE              (vd_current->file_for_view)
#define CURRENT_WINDOW            (vd_current->win[vd_current->current_window])
#define PREVIOUS_WINDOW           (vd_current->win[vd_current->previous_window])
#define CURRENT_WINDOW_MAIN       (vd_current->win[WINDOW_MAIN])
#define CURRENT_WINDOW_PREFIX     (vd_current->win[WINDOW_PREFIX])
#define CURRENT_WINDOW_COMMAND    (vd_current->win[WINDOW_COMMAND])
#define CURRENT_WINDOW_ARROW      (vd_current->win[WINDOW_ARROW])
#define CURRENT_WINDOW_IDLINE     (vd_current->win[WINDOW_IDLINE])

#define MARK_VIEW (vd_mark)
#define MARK_FILE (vd_mark->file_for_view)

#define CURRENT_SCREEN (screen[current_screen])
#define OTHER_SCREEN (screen[(current_screen == 0) ? 1 : 0])

#define COMMAND_COPY             1
#define COMMAND_DELETE           2
#define COMMAND_DUPLICATE        3
#define COMMAND_MOVE_COPY_SAME   4
#define COMMAND_MOVE_COPY_DIFF   5
#define COMMAND_MOVE_DELETE_SAME 6
#define COMMAND_MOVE_DELETE_DIFF 7

#define SOURCE_COMMAND      1
#define SOURCE_PREFIX       2
#define SOURCE_BLOCK        3
#define SOURCE_BLOCK_RESET  4

struct line
 {
  struct line *prev;                  /* pointer to previous line */
  struct line *next;                  /* pointer to next line */
  unsigned short length;              /* number of characters in line */
  char *line;                /* pointer to contents of line */
  char *name;                /* pointer to name of line (for SET POINT)*/
  char display;              /* display level for each line */
  int pre;                            /* index to contents of prefix command */
 };
typedef struct line LINE;

struct targets
 {
  char *prefix;              /* pointer to target prefix */
  int length;                         /* length of prefix */
  char delim;                /* target delimiter */
  int direction;                      /* search direction for target */
 };
typedef struct targets SEARCH_TARGET;

struct prefix_commands
 {
  char *cmd;                 /* prefix command */
  int cmd_len;                        /* length of prefix command */
  bool action_prefix;                 /* is command an action or a target */
  bool multiples_allowed;             /* are multiples allowed */
  bool full_target_allowed;           /* full target multiple allowed */
  bool block_prefix_command;          /* is command a block command */
  bool target_required;               /* does command require target */
  bool valid_on_tof;                  /* is command allowed on Top of File line */
  bool valid_on_bof;                  /* is command allowed on Bottom of File line */
#ifdef PROTO
 int (*function)(int,int,long);
#else
 int (*function)();
#endif
 };
typedef struct prefix_commands PREFIX_COMMAND;

struct pending_prefix_command
 {
  char ppc_command[PREFIX_WIDTH+1];     /* prefix command */
  long ppc_line_number;               /* line number in file */
  long ppc_cmd_param;                 /* prefix command parameter */
  int ppc_cmd_idx;                    /* prefix command index */
  bool ppc_block_command;             /* is it a BLOCK command */
 };
typedef struct pending_prefix_command PENDING_PREFIX_COMMAND;

typedef struct
 {
  char backup;               /* indicates if backup file kept */
  char autosave;             /* number of alterations before autosaving */
  char eolout;               /* indicates how lines are terminated on output */
  char status_row;           /* row on which status line is displayed */
  char tabsout_on;           /* indicates if tabs to replace spaces on file */
  char tabsout_num;          /* length of tab stops on file */
  char pseudo_file;          /* indicates if file is a "pseudo" file and if so, what sort */
  unsigned short autosave_alt;        /* number of alterations since last autosave */
  unsigned short save_alt;            /* number of alterations since last save */
  FILE *fp;                           /* file handle for this file */
  char *fname;               /* file name */
  char *fpath;               /* file path */
  unsigned short fmode;               /* file mode of file */
  LINE *first_line;                   /* pointer to first line */
  LINE *curr_line;                    /* pointer to current line */
  LINE *last_line;                    /* pointer to last line */
  unsigned long  number_lines;        /* number of actual lines in file */
  char file_views;           /* number of views of current file */
 } FILE_DETAILS;

struct view_details
 {
  struct view_details *prev;          /* pointer to previous view */
  struct view_details *next;          /* pointer to next view */
  char arbchar_status;       /* indicates if arbchar is on */
  char arbchar_char;         /* arbitrary character value */
  char cmd_line;             /* line where command line is displayed */
  char command_row;          /* row on which command line is displayed */
  char error_row;            /* row on which errors are to be displayed */
  char tab_row;              /* row on which tab line is displayed */
  char tab_on;               /* indicates if tab line is to be displayed */
  char scale_row;            /* row on which scale row is displayed */
  char scale_on;             /* indicates if scale is displayed */
  char current_row;          /* row which is current row */
  char current_base;         /* indicates relative position of current line */
  char current_off;                   /* offset from current_base for current_row */
  char prefix;               /* indicates if and where prefix is displayed */
  char number;               /* indicates if numbers in prefix are to be displayed */
  char message_mode;         /* indicates if messages are to be displayed */
  char imp_macro;            /* indicates if implied macro processing is on */
  char imp_os;               /* indicates if implied os processing is on */
  char case_enter;           /* indicates case of data entered */
  char case_locate;          /* indicates case of data located */
  char case_change;          /* indicates case of data changed */
  char case_sort;            /* indicates case significance for sorting */
  char display_low;          /* low range of display level */
  char display_high;         /* high range of display level */
  char scope;                /* indicates if commands act on All lines or only those Displayed */
  char stay;                 /* indicates status of STAY */
  char tabs;                 /* tab stop increments */
  char newline_aligned;      /* TRUE if adding a new line results in cursor appearing under 1st non-blank of previous line */
  char hex;                  /* TRUE if hex conversion is done on string operands */
  unsigned short margin_left;         /* left margin column 1 based */
  unsigned short margin_right;        /* right margin column 1 based */
  short margin_indent;                /* paragraph indentation */
  bool margin_indent_offset;          /* TRUE if paragraph indentation is an offset from left column */
  unsigned short verify_col;          /* left col for current verify */
  unsigned short verify_start;        /* col of start of verify */
  unsigned short verify_end;          /* col of end of verify */
  bool wordwrap;                      /* wordwrap setting */
  unsigned short zone_start;          /* col of start of zone */
  unsigned short zone_end;            /* col of end of zone */
  bool linend_status;                 /* indicates if multiple commands allowed on command line */
  char linend_value;         /* specifies command delimiter */
  long  current_line;                 /* line in file displayed on current row */
  long  focus_line;                   /* line in file where cursor is */
  short mark_type;                    /* type of marked block */
  long  mark_start_line;              /* first line to be marked */
  long  mark_end_line;                /* last line to be marked */
  short mark_start_col;               /* first column marked */
  short mark_end_col;                 /* last column marked */
  WINDOW *win[VIEW_WINDOWS];          /* curses windows for the file contents */
  char current_window;       /* current window for current file */
  char previous_window;      /* previous window for current file */
  PENDING_PREFIX_COMMAND ppc[MAX_PENDING_PREFIX_COMMANDS];
  unsigned short prefix_command_index;
  FILE_DETAILS *file_for_view;        /* pointer to file structure */
 };
typedef struct view_details VIEW_DETAILS;

typedef struct
 {
  char origin_x;             /* top left corner of physical screen */
  char origin_y;
  char screen_rows;          /* physical rows */
  char screen_cols;          /* physical cols */
  char rows;                 /* rows in data window */
  char cols;                 /* cols in data window */
  char top_row;              /* start row of data window */
  char top_col;              /* start col of data window */
  VIEW_DETAILS *screen_view;          /* view being displayed in this screen */
 } SCREEN_DETAILS;

#define STATUS_ROW         (screen_rows-1)
#define COMMAND_ROW        (screen_rows-2)
#define ERROR_ROW          1
#define TAB_ROW            6
#define TAB_ON             NO
#define SCALE_ROW          6
#define SCALE_ON           NO
#define CURSOR_ROW         COMMAND_ROW
#define CURSOR_COL         5
#define CURRENT_ROW_POS    0
#define CURRENT_ROW        0
#define ZONE_START         1
#define ZONE_END           MAX_INT

/* defines for current_base */
#define CURLINE_TOP        0
#define CURLINE_MIDDLE     1
#define CURLINE_BOTTOM     2

/* defines for pseudo file types */
#define PSEUDO_REAL        0
#define PSEUDO_DIR         1
#define PSEUDO_REXX        2

/* defines for prefix settings */
#define PREFIX_OFF         0
#define PREFIX_LEFT        1
#define PREFIX_RIGHT       2

/* defines for query types */
#define QUERY_NONE         0
#define QUERY_QUERY        1
#define QUERY_STATUS       2
#define QUERY_EXTRACT      4
#define QUERY_FUNCTION     8
#define QUERY_MODIFY      16

/* defines for case settings */
#define CASE_MIXED         'M'
#define CASE_UPPER         'U'
#define CASE_LOWER         'L'
#define CASE_IGNORE        'I'
#define CASE_RESPECT       'R'

/* type of marked blocks */
#define M_LINE             1
#define M_BOX              2
#define M_STREAM           3

/* defines for temporary space allocation */
#define TEMP_PARAM         1
#define TEMP_MACRO         2
#define TEMP_TMP_CMD       3
#define TEMP_TEMP_CMD      4

/* split/join commands */
#define SPLIT_TRUE         TRUE
#define SPLIT_FALSE        FALSE
#define ALIGNED_TRUE       TRUE
#define ALIGNED_FALSE      FALSE

/* box opertaions */
#define BOX_C           1
#define BOX_M           2
#define BOX_D           3
#define BOX_F           4

#ifndef FILE_NORMAL
#define FILE_NORMAL        0
#endif

#ifndef FILE_READONLY
#define FILE_READONLY      1
#endif

#ifndef FILE_NEW
#define FILE_NEW          99
#endif

#define COMMAND_ONLY_TRUE    TRUE
#define COMMAND_ONLY_FALSE   FALSE

#define ADDCHAR            0
#define INSCHAR            1

#ifndef getbegyx
#define getbegyx(win,y,x)       (y = (win)->_begy, x = (win)->_begx)
#endif

#define HIT_ANY_KEY "Hit any key to continue..."

/*---------------------- return code constants ------------------------*/
#define     RC_OK               0
#define     RC_NOT_COMMAND     -1
#define     RC_INVALID_ENVIRON -3
#define     RC_TOF_EOF_REACHED  1
#define     RC_TARGET_NOT_FOUND 2
#define     RC_TRUNCATED        3
#define     RC_NO_LINES_CHANGED 4
#define     RC_INVALID_OPERAND  5
#define     RC_COMMAND_NO_FILES 6
#define     RC_FILE_CHANGED    12
#define     RC_ACCESS_DENIED   12
#define     RC_DISK_FULL       13
#define     RC_BAD_FILEID      20
#define     RC_BAD_DRIVE       24
#define     RC_FILE_NOT_FOUND  28
#define     RC_OUT_OF_MEMORY   94
#define     RC_SYSTEM_ERROR    99
/*---------------------- useful macros --------------------------------*/
#define     TOF(line)           ((line == 0L) ? TRUE : FALSE)
#define     BOF(line)           ((line == CURRENT_FILE->number_lines+1L) ? TRUE : FALSE)
#define     CURRENT_TOF         ((CURRENT_VIEW->current_line == 0L) ? TRUE : FALSE)
#define     CURRENT_BOF         ((CURRENT_VIEW->current_line == CURRENT_FILE->number_lines+1L) ? TRUE : FALSE)
#define     FOCUS_TOF           ((CURRENT_VIEW->focus_line == 0L) ? TRUE : FALSE)
#define     FOCUS_BOF           ((CURRENT_VIEW->focus_line == CURRENT_FILE->number_lines+1L) ? TRUE : FALSE)
#define     IN_VIEW(view,line)   ((line >= (view->current_line - (long)view->current_row)) && (line <= (view->current_line + ((long)CURRENT_SCREEN.rows - (long)view->current_row))))
/*---------------------- system specific redefines --------------------*/
#ifdef VAX
#define     wattrset     wsetattr
#define     A_REVERSE    _REVERSE
#define     A_BOLD       _BOLD
#endif
/*---------------------- global parameters ----------------------------*/
#define EOLOUT_LF                0
#define EOLOUT_CRLF              1
/*---------------------- extract return codes -------------------------*/
#define EXTRACT_ARG_ERROR        (-2)
#define EXTRACT_VARIABLES_SET    (-1)
/*---------------------- attribute defines ----------------------------*/
#define ATTR_FILEAREA   0
#define ATTR_CURLINE    1
#define ATTR_BLOCK      2
#define ATTR_CBLOCK     3
#define ATTR_CMDLINE    4
#define ATTR_IDLINE     5
#define ATTR_MSGLINE    6
#define ATTR_ARROW      7
#define ATTR_PREFIX     8
#define ATTR_PENDING    9
#define ATTR_SCALE     10
#define ATTR_TOFEOF    11
#define ATTR_CTOFEOF   12
#define ATTR_TABLINE   13
#define ATTR_SHADOW    14
#define ATTR_STATAREA  15
#define ATTR_DIVIDER   16
#define ATTR_RESERVED  17
#define ATTR_MAX       18

#ifdef MAIN
/*---------------------------------------------------------------------*/
/* Following is  for colour support.                                   */
/*---------------------------------------------------------------------*/

chtype colour[ATTR_MAX];
chtype save_fg[ATTR_MAX];
chtype save_bg[ATTR_MAX];
chtype save_mod[ATTR_MAX];

short max_line_length=MAX_LENGTH_OF_LINE;

#else

extern chtype colour[ATTR_MAX];
extern chtype save_fg[ATTR_MAX];
extern chtype save_bg[ATTR_MAX];
extern chtype save_mod[ATTR_MAX];

extern short max_line_length;
#endif

#define PARACOL (CURRENT_VIEW->margin_indent_offset ? CURRENT_VIEW->margin_left + CURRENT_VIEW->margin_indent : CURRENT_VIEW->margin_indent)

/* structure for passing box parameters */
struct _boxp
 {
  int action;
  int src_start_col;
  int dst_start_col;
  int num_cols;
  long src_start_line;
  long dst_start_line;
  long num_lines;
  LINE *curr_src;
  LINE *curr_dst;
 };
typedef struct _boxp BOXP;

/* structure for passing queryable values parameters */
struct query_values
 {
  char *value;                       /* value of item */
  int len;                 /* length of string representation of value */
 };
typedef struct query_values VALUE;

/* structure for function key redefinition */
struct defines
{
 struct defines *prev;
 struct defines *next;
 unsigned int def_funkey;
 short def_command;
 char *def_params;
 char def_delim;
};
typedef struct defines DEFINE;
