/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\proto.h 1.4 1993/09/01 16:26:59 MH Interim MH $
*/

#ifdef PROTO
                                                         /* commutil.c */
char *get_key_definition(unsigned short );
int function_key(int );
int command_line(char *,bool);
void cleanup_command_line(void);
void split_command(char *,char *,char *);
int param_split(char *,char *[],int,char *,char);
int command_split(char *,char *[],int,char *,char *);
long valid_target(char *,long);
long get_true_line(void);
LINE *find_named_line(char *,long *);
long search_target(char *,char,long ,int );
int get_row_for_focus_line(int ,long ,long );
int calculate_focus_line(int ,long ,long );
void print_line(char ,long ,short ,char *,char *,bool);
char next_char(LINE *,short *,int);
int add_define(int,char *);
int remove_define(int);
int append_define(int,int,char *);
int find_key_value(char *);
short find_command(char *);
short split_change_params(char *,char *,char *,char *,char *,char *);
void init_command(void);
void add_command(char *);
char *get_next_command( int );
int parse_colours(char *,chtype *,chtype *,chtype *);
void set_colour(int ,chtype,chtype,chtype);
int tabs_convert(LINE *,bool);
int convert_hex_strings(char *);
int marked_block(bool);
int suspend_curses(void);
int resume_curses(void);
int restore_THE(void);
int execute_set_sos_command(bool,char *);
int valid_command_type(bool,char *);
int allocate_temp_space(unsigned int,char);
void free_temp_space(char);
char calculate_current_row(char,char,char);
int get_valid_macro_file_name(char *,char *,int *);
                                                              /* box.c */
void box_operations(int ,char ,bool ,char );
int box_delete(BOXP *);
int box_move(BOXP *,bool);
int box_copy(BOXP *,bool);
int box_fill(BOXP *,char);
                                                          /* execute.c */
int execute_os_command(char *,bool ,bool );
int execute_change_command(char *,bool );
short selective_change(char *,int,char *,int,long ,long ,short );
int insert_new_line(char *,int,long,long,bool,bool);
int execute_makecurr(long);
int execute_shift_command(int,int,long,long);
int execute_change_case(char *,char);
int change_case(char *,int,int,char);
int rearrange_line_blocks(char,char,long,long,long,int,VIEW_DETAILS*,VIEW_DETAILS*);
int execute_set_point(char *,long ,bool);
int execute_wrap_word(unsigned short);
int execute_split_join(bool,bool);
int execute_put(char *,bool);
int execute_macro(char *,bool);
                                                          /* default.c */
void set_defaults(void);
void set_default_colours(void);
short get_profile(char *);
short defaults_for_first_file(void);
short defaults_for_other_files(void);
short default_file_attributes(void);
void set_screen_defaults(void);
                                                             /* edit.c */
void editor(void);
                                                            /* error.c */
void display_error(unsigned short ,char *);
                                                             /* file.c */
short get_file(char *);
LINE *read_file(FILE *,LINE *,char *);
short save_file(FILE_DETAILS *,char *,char,long,long,char,int,int);
int write_char(char ,FILE *);
int increment_alt(FILE_DETAILS *);
char *new_filename(char *,char *,char *,char *);
int remove_aus_file(FILE_DETAILS *);
int free_view_memory(void);
void free_a_view(void);
int free_file_memory(void);
int read_directory(void);
VIEW_DETAILS *find_file(char *,char *);
int execute_command_file(FILE *);
int process_command_line(char *);
                                                            /* getch.c */
int my_getch (WINDOW *);
                                                          /* nonansi.c */
int file_readable(char *);
int file_writable(char *);
int file_exists(char *);
int remove_file(char *);
short splitpath(char *);
#ifdef NO_RENAME
int rename(char *,char *);
#endif
#ifdef OS2
bool LongFileNames(char *);
#endif
                                                           /* prefix.c */
int execute_prefix_commands(void);
void clear_pending_prefix_command(int,LINE *);
void add_prefix_command(LINE *,long,bool);
int add_prefix_synonym(char *,char *);
char *find_prefix_synonym(char *);
char *find_prefix_oldname(char *);
                                                             /* show.c */
void show_heading(void);
void show_footing(void);
void clear_footing(void);
void show_page(void);
void show_one_row(char *,unsigned short,unsigned short ,LINE *);
void highlight_line(char,chtype,chtype);
void show_marked_block(void);
void redraw_window(WINDOW *);
void repaint_screen(void);
                                                              /* the.c */
void init_signals(void);
void handle_signal(int );
void display_info(char *);
void exit_clean(short );
                                                             /* util.c */
short memrevne(char *,char ,short );
char *meminschr(char *,char ,short ,short ,short );
char *meminsmem(char *,char *,short ,short ,short ,short );
char *memdelchr(char *,short ,short,short );
short strzne(char *,char );
short memne(char *,char ,short );
short strzrevne(char *,char );
short strzreveq(char *,char );
char *strtrunc(char *);
int memfind(char *,char *,int ,int ,bool ,bool ,char );
short memcmpi(char *,char *,short );
char *make_upper(char *);
unsigned short equal(char *,char *,short );
int valid_integer(char *);
int valid_positive_integer(char *);
int strzeq(char *,char );
char *strtrans(char *,char,char);
void *ll_add(void *,void *,unsigned short );
void *ll_del(void *,void *,int );
void ll_free(void *);
void *ll_find(void *,unsigned long );
LINE *lll_add(LINE *,LINE *,unsigned short );
LINE *lll_del(LINE **,LINE **,LINE *,int );
LINE *lll_free(LINE *);
LINE *lll_find(LINE *,unsigned long );
LINE *add_line(LINE *,LINE *,char *,unsigned short );
LINE *delete_line(LINE *,LINE *,int);
VIEW_DETAILS *vll_add(VIEW_DETAILS *,VIEW_DETAILS *,unsigned short );
VIEW_DETAILS *vll_del(VIEW_DETAILS **,VIEW_DETAILS **,VIEW_DETAILS *,int );
DEFINE *dll_add(DEFINE *,DEFINE *,unsigned short );
DEFINE *dll_del(DEFINE **,DEFINE **,DEFINE *,int );
DEFINE *dll_free(DEFINE *);
long find_string(long ,short *,char *,int ,int ,int ,char );
void put_string(WINDOW *,int ,int ,char *,int);
void put_char(WINDOW *,chtype ,char );
int set_up_windows(void);
void delete_windows(void);
void pre_process_line(long );
void post_process_line(long );
short blank_field(char *);
void adjust_marked_lines(bool ,long ,long );
void adjust_pending_prefix(VIEW_DETAILS *,bool ,long ,long );
char case_translate(char );
void add_to_recovery_list(char *,int );
void get_from_recovery_list(int );
WINDOW *adjust_window(WINDOW *,int ,int ,int ,int );
void draw_cursor(int );
int my_wclrtoeol(WINDOW *);
                                                             /* rexx.c */
#if !defined(NOREXX)
int initialise_rexx(void);
int finalise_rexx(void);
int execute_macro_file(char *,char *);
int set_extract_variables(char *);
int set_rexx_variable(char *,char *,int);
#endif
                                                            /* query.c */
int find_item(char *,char);
int show_status(void);
int save_status(char *);
int get_item_values(int,char *,char,unsigned long,char *,unsigned long);
                                                         /* directry.c */
int set_dirtype(char *);
                                                          /* fnmatch.c */
int fnmatch(char *,char *,int);
                                                             /* sort.c */
int execute_sort(char *);
                                                            /* comm*.c */
int Add(char *);
int All(char *);
int Arbchar(char *);
int Autosave(char *);
int Backup(char *);
int Backward(char *);
int BeepSound(char *);
int Bottom(char *);
int Cancel(char *);
int Case(char *);
int Ccancel(char *);
int Change(char *);
int Clearscreen(char *);
int Clock(char *);
int Cmatch(char *);
int Cmdarrows(char *);
int Cmdline(char *);
int Cmsg(char *);
int Colour(char *);
int Command(char *);
int Control_char(char *);
int Copy(char *);
int Curline(char *);
int Define(char *);
int DeleteLine(char *);
int Directory(char *);
int Dirinclude(char *);
int Display(char *);
int Down_arrow(char *);
int Duplicate(char *);
int Emsg(char *);
int Enter(char *);
int Etmode(char *);
int Eolout(char *);
int Expand(char *);
int Extract(char *);
int Ffile(char *);
int File(char *);
int Fillbox(char *);
int Forward(char *);
int Get(char *);
int Help(char *);
int Hex(char *);
int Hexdisplay(char *);
int Impmacro(char *);
int Impos(char *);
int Input(char *);
int Insertmode(char *);
int Join(char *);
int Left_arrow(char *);
int Linend(char *);
int Locate(char *);
int Lowercase(char *);
int Macro(char *);
int Macroext(char *);
int Macropath(char *);
int Margins(char *);
int Mark(char *);
int Modify(char *);
int Move(char *);
int Msg(char *);
int Msgmode(char *);
int Newlines(char *);
int Next(char *);
int Nextwindow(char *);
int Nomsg(char *);
int Nondisp(char *);
int Nop(char *);
int Number(char *);
int Overlaybox(char *);
int Os(char *);
int Osnowait(char *);
int Osquiet(char *);
int Pending(char *);
int Point(char *);
int Prefix(char *);
int Print(char *);
int Printer(char *);
int Put(char *);
int Putd(char *);
int Qquit(char *);
int Quit(char *);
int Query(char *);
int Recover(char *);
int Reexecute(char *);
int Redraw(char *);
int Refresh(char *);
int Replace(char *);
int Reprofile(char *);
int Reserved(char *);
int Reset(char *);
int Retrieve(char *);
int Rexxoutput(char *);
int Right_arrow(char *);
int Save(char *);
int Scope(char *);
int Select(char *);
int Set(char *);
int Schange(char *);
int Screen(char *);
int Shift(char *);
int ShowKey(char *);
int Sort(char *);
int Sos(char *);
int Sos_addline(char *);
int Sos_cursoradj(char *);
int Sos_delback(char *);
int Sos_delchar(char *);
int Sos_delend(char *);
int Sos_delline(char *);
int Sos_delword(char *);
int Sos_doprefix(char *);
int Sos_edit(char *);
int Sos_endchar(char *);
int Sos_execute(char *);
int Sos_makecurr(char *);
int Sos_tabf(char *);
int Sos_tabwordb(char *);
int Sos_tabwordf(char *);
int Sos_undo(char *);
int Split(char *);
int Spltjoin(char *);
int Ssave(char *);
int Status(char *);
int Stay(char *);
int Suspend(char *);
int Tabcmd(char *);
int Tabkey(char *);
int Tabpre(char *);
int Tabs(char *);
int Tabsin(char *);
int Tabsout(char *);
int Text(char *);
int Top(char *);
int Up(char *);
int Up_arrow(char *);
int Uppercase(char *);
int Verify(char *);
int Wordwrap(char *);
int Xedit(char *);
int Zone(char *);

#else
                                                         /* commutil.c */
char *get_key_definition();
int function_key();
int command_line();
void cleanup_command_line();
void split_command();
int param_split();
int command_split();
long valid_target();
long get_true_line();
LINE *find_named_line();
long search_target();
int get_row_for_focus_line();
int calculate_focus_line();
void print_line();
char next_char();
int add_define();
int remove_define();
int append_define();
int find_key_value();
short find_command();
short split_change_params();
void init_command();
void add_command();
char *get_next_command();
int parse_colours();
void set_colour();
int tabs_convert();
int convert_hex_strings();
int marked_block();
int suspend_curses();
int resume_curses();
int restore_THE();
int execute_set_sos_command();
int valid_command_type();
int allocate_temp_space();
void free_temp_space();
char calculate_current_row();
int get_valid_macro_file_name();
                                                              /* box.c */
void box_operations();
int box_delete();
int box_move();
int box_copy();
int box_fill();
                                                          /* execute.c */
int execute_os_command();
int execute_change_command();
short selective_change();
int insert_new_line();
int execute_makecurr();
int execute_shift_command();
int execute_change_case();
int change_case();
int rearrange_line_blocks();
int execute_set_point();
int execute_wrap_word();
int execute_split_join();
int execute_put();
int execute_macro();
                                                          /* default.c */
void set_defaults();
void set_default_colours();
short get_profile();
short defaults_for_first_file();
short defaults_for_other_files();
short default_file_attributes();
void set_screen_defaults();
                                                            /* error.c */
void display_error();
                                                             /* file.c */
short get_file();
LINE *read_file();
short save_file();
int write_char();
int increment_alt();
char *new_filename();
int remove_aus_file();
int free_view_memory();
void free_a_view();
int free_file_memory();
int read_directory();
VIEW_DETAILS *find_file();
int execute_command_file();
int process_command_line();
                                                            /* getch.c */
int my_getch ();
                                                          /* nonansi.c */
int file_readable();
int file_writable();
int file_exists();
int remove_file();
short splitpath();
#ifdef NO_RENAME
int rename();
#endif
#ifdef OS2
bool LongFileName();
#endif
                                                           /* prefix.c */
int execute_prefix_commands();
void clear_pending_prefix_command();
void add_prefix_command();
#if !defined(NOREXX)
int add_prefix_synonym();
char *find_prefix_synonym();
char *find_prefix_oldname();
#endif
                                                             /* show.c */
void show_heading();
void show_footing();
void clear_footing();
void show_page();
void show_one_row();
void highlight_line();
void show_marked_block();
void redraw_window();
void repaint_screen();
                                                              /* the.c */
void init_signals();
void handle_signal();
void display_info();
void exit_clean();
                                                             /* util.c */
short memrevne();
char *meminschr();
char *meminsmem();
char *memdelchr();
short strzne();
short memne();
short strzrevne();
short strzreveq();
char *strtrunc();
int memfind();
short memcmpi();
char *make_upper();
unsigned short equal();
int valid_integer();
int valid_positive_integer();
int strzeq();
char *strtrans();
void *ll_add();
void *ll_del();
void ll_free();
void *ll_find();
LINE *lll_add();
LINE *lll_del();
LINE *lll_free();
LINE *lll_find();
LINE *add_line();
LINE *delete_line();
VIEW_DETAILS *vll_add();
VIEW_DETAILS *vll_del();
DEFINE *dll_add();
DEFINE *dll_del();
DEFINE *dll_free();
long find_string();
void put_string();
void put_char();
int set_up_windows();
void delete_windows();
void pre_process_line();
void post_process_line();
short blank_field();
void adjust_marked_lines();
void adjust_pending_prefix();
char case_translate();
void add_to_recovery_list();
void get_from_recovery_list();
WINDOW *adjust_window();
void draw_cursor();
int my_wclrtoeol();
                                                             /* rexx.c */
#if !defined(NOREXX)
int initialise_rexx();
int finalise_rexx();
int execute_macro_file();
int set_extract_variables();
int set_rexx_variable();
#endif
                                                            /* query.c */
int find_item();
int show_status();
int save_status();
int get_item_values();
                                                         /* directry.c */
int set_dirtype();
                                                          /* fnmatch.c */
int fnmatch();
                                                             /* sort.c */
int execute_sort();
                                                            /* comm*.c */
int Add();
int All();
int Arbchar();
int Autosave();
int Backup();
int Backward();
int BeepSound();
int Bottom();
int Cancel();
int Case();
int Ccancel();
int Change();
int Clearscreen();
int Clock();
int Cmatch();
int Cmdarrows();
int Cmdline();
int Cmsg();
int Colour();
int Command();
int Control_char();
int Copy();
int Curline();
int Define();
int DeleteLine();
int Directory();
int Dirinclude();
int Display();
int Down_arrow();
int Duplicate();
int Emsg();
int Enter();
int Eolout();
int Etmode();
int Expand();
int Extract();
int Ffile();
int File();
int Fillbox();
int Forward();
int Get();
int Help();
int Hex();
int Hexdisplay();
int Impmacro();
int Impos();
int Input();
int Insertmode();
int Join();
int Left_arrow();
int Linend();
int Locate();
int Lowercase();
int Macro();
int Macroext();
int Macropath();
int Margins();
int Mark();
int Modify();
int Move();
int Msg();
int Msgmode();
int Newlines();
int Next();
int Nextwindow();
int Nomsg();
int Nondisp();
int Nop();
int Number();
int Overlaybox();
int Os();
int Osnowait();
int Osquiet();
int Pending();
int Point();
int Prefix();
int Print();
int Printer();
int Put();
int Putd();
int Qquit();
int Quit();
int Query();
int Recover();
int Reexecute();
int Redraw();
int Refresh();
int Replace();
int Reprofile();
int Reserved();
int Reset();
int Retrieve();
int Rexxoutput();
int Right_arrow();
int Save();
int Scope();
int Select();
int Schange();
int Screen();
int Set();
int Shift();
int ShowKey();
int Sort();
int Sos();
int Sos_addline();
int Sos_cursoradj();
int Sos_delback();
int Sos_delchar();
int Sos_delend();
int Sos_delline();
int Sos_delword();
int Sos_doprefix();
int Sos_edit();
int Sos_endchar();
int Sos_execute();
int Sos_makecurr();
int Sos_tabf();
int Sos_tabwordb();
int Sos_tabwordf();
int Sos_undo();
int Split();
int Spltjoin();
int Ssave();
int Stay();
int Suspend();
int Status();
int Tabcmd();
int Tabkey();
int Tabpre();
int Tabs();
int Tabsin();
int Tabsout();
int Text();
int Top();
int Up();
int Up_arrow();
int Uppercase();
int Verify();
int Wordwrap();
int Xedit();
int Zone();

#endif
