/***********************************************************************/
/* DEFAULT.C - Default settings and profile processing                 */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1993 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                     email: M.Hessling@gu.edu.au
 * 36 David Road                     Phone: +61 7 849 7731
 * Holland Park                      Fax:   +61 7 875 5314
 * QLD 4121
 * Australia
 */

/*
$Header: C:\THE\RCS\default.c 1.4 1993/09/01 16:26:04 MH Interim MH $
*/

#include <stdio.h>

#include "the.h"
#include "proto.h"

/*#define DEBUG 1*/

/*--------------------------- extern data -----------------------------*/
extern WINDOW *foot;
extern VIEW_DETAILS *vd_current,*vd_first;
extern char current_screen;
extern SCREEN_DETAILS screen[MAX_SCREENS];        /* screen structures */
extern char display_screens;                      /* number of screens */
extern bool horizontal;
extern char current_file;                   /* pointer to current file */
extern LINE *next_line,*curr_line;
extern char *rec;
extern char in_profile;    /* indicates if processing profile */
extern char number_of_views;                        /* number of files */
extern char number_of_files;                   /* number of open files */

/*--------------------------- global data -----------------------------*/

 char CMD_LINEx;
 char ERROR_ROWx;
 char TAB_ROWx;
 char TAB_ONx;
 char SCALE_ROWx;
 char SCALE_ONx;
 char PREFIXx;
 char CURRENT_ROW_POSx;
 char STAYx;
 char HEXx;
 char NEWLx;
 char MSGMx;
 char CASE_Ex;
 char CASE_Lx;
 char CASE_Cx;
 char CASE_Sx;
 char TABI_ONx;
 char TABI_Nx;
 char TABO_ONx;
 char TABO_Nx;
 char TABSx;
 char CMDARROWSTABCMDx;
 char CMDARROWSTABTXTx;
 char CMDARROWSTABLRx;
 char AUSx;
 char EOLx;
 unsigned short VER_STAx;
 unsigned short VER_ENDx;
 unsigned short VER_COLx;
 unsigned short ZON_STAx;
 unsigned short ZON_ENDx;
 char  ARB_STSx;
 char  ARB_CHRx;
 char  DISPLAY_LOWx;
 char  DISPLAY_HIGHx;
 bool LINEND_STATUSx;
 char  LINEND_VALUEx;
 char NONDISPx;
 bool REPROFILEx;
 bool CLEARSCREENx;
 bool IMPMACROx;
 bool IMPOSx;
 bool NUMBERx;
 bool BACKUPx;
 bool BEEPx;
 bool CLOCKx;
 bool HEXDISPLAYx;
 bool CAPREXXOUTx;
 long CAPREXXMAXx;

/***********************************************************************/
#ifdef PROTO
void set_defaults(void)
#else
void set_defaults()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_defaults");
#endif
 CMD_LINEx = 'B';
 ERROR_ROWx = 1;
 TAB_ROWx = 6;
 TAB_ONx = FALSE;
 SCALE_ROWx = 6;
 SCALE_ONx = FALSE;
 PREFIXx = PREFIX_LEFT;
 CURRENT_ROW_POSx = 0;
 STAYx = ON;
 HEXx = OFF;
 NEWLx = TRUE;
 MSGMx = TRUE;

 CASE_Ex = CASE_MIXED;
 CASE_Lx = CASE_IGNORE;
 CASE_Cx = CASE_RESPECT;
 CASE_Sx = CASE_RESPECT;

 LINEND_STATUSx = FALSE;
 LINEND_VALUEx = '#';

 NONDISPx = '#';

 TABI_ONx = FALSE;
 TABI_Nx = 8;
 TABO_ONx = FALSE;
 TABO_Nx = 8;
 TABSx = 8;
 CMDARROWSTABCMDx = FALSE;
 CMDARROWSTABTXTx = FALSE;
 CMDARROWSTABLRx = FALSE;
 BACKUPx = TRUE;
 BEEPx = FALSE;
 CLOCKx = TRUE;
 HEXDISPLAYx = TRUE;
 IMPMACROx = TRUE;
 IMPOSx = TRUE;
 NUMBERx = TRUE;
 CAPREXXOUTx = FALSE;
 CAPREXXMAXx = 1000L;

 VER_STAx = 1;
 VER_ENDx = max_line_length;
 VER_COLx = 1;
 ZON_STAx = 1;
 ZON_ENDx = max_line_length;
 DISPLAY_LOWx = DISPLAY_HIGHx = 0;
 CLEARSCREENx = FALSE;
 REPROFILEx = FALSE;

 AUSx = 0;
 ARB_CHRx = '?';
 ARB_STSx = OFF;
#ifdef UNIX
 EOLx = EOLOUT_LF;
#endif
#if defined(DOS) || defined(OS2)
 EOLx = EOLOUT_CRLF;
#endif
#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
void set_default_colours(void)
#else
void set_default_colours()
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
extern bool colour_support;
/*--------------------------- local data ------------------------------*/
 chtype dflt_colour[ATTR_MAX];
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_default_colours");
#endif
/*---------------------------------------------------------------------*/
/* Set up default colours.                                             */
/*---------------------------------------------------------------------*/
#ifdef A_COLOR
 if (colour_support)
   {
    init_pair(1,COLOR_WHITE,COLOR_BLUE);
    init_pair(2,COLOR_WHITE,COLOR_BLUE);
    init_pair(3,COLOR_BLUE,COLOR_WHITE);
    init_pair(4,COLOR_RED,COLOR_WHITE);
    init_pair(5,COLOR_BLACK,COLOR_CYAN);
    init_pair(6,COLOR_BLUE,COLOR_WHITE);
    init_pair(7,COLOR_RED,COLOR_WHITE);
    init_pair(8,COLOR_BLACK,COLOR_CYAN);
    init_pair(9,COLOR_BLACK,COLOR_CYAN);
    init_pair(10,COLOR_RED,COLOR_WHITE);
    init_pair(11,COLOR_RED,COLOR_WHITE);
    init_pair(12,COLOR_WHITE,COLOR_BLUE);
    init_pair(13,COLOR_WHITE,COLOR_BLUE);
    init_pair(14,COLOR_RED,COLOR_WHITE);
    init_pair(15,COLOR_RED,COLOR_WHITE);
    init_pair(16,COLOR_BLUE,COLOR_WHITE);
    init_pair(17,COLOR_RED,COLOR_WHITE);
    for (i=0;i<ATTR_MAX;i++)
        dflt_colour[i] = COLOR_PAIR(i+1);
    dflt_colour[ATTR_CURLINE] |= A_BOLD;
    dflt_colour[ATTR_TOFEOF] |= A_BOLD;
    dflt_colour[ATTR_CTOFEOF] |= A_BOLD;
    for (i=0;i<ATTR_MAX;i++)
      if (colour[i])            /* a colour has been set up in profile */
         set_colour(i,save_fg[i],save_bg[i],save_mod[i]);
      else
         colour[i] = dflt_colour[i];
   }
 else
   {
    dflt_colour[ATTR_FILEAREA] = A_NORMAL;           /* main window text lines */
    dflt_colour[ATTR_CURLINE]  = A_BOLD;                       /* current line */
    dflt_colour[ATTR_BLOCK]    = A_REVERSE;           /* text in markded block */
    dflt_colour[ATTR_CBLOCK]   = A_BOLD | A_REVERSE;
                                       /* current line if in marked block */
    dflt_colour[ATTR_CMDLINE]  = A_BOLD;                       /* command line */
    dflt_colour[ATTR_IDLINE]   = A_REVERSE;                    /* id line (top)*/
    dflt_colour[ATTR_MSGLINE]  = A_BLINK;                      /* message line */
    dflt_colour[ATTR_ARROW]    = A_BOLD;                       /* arrow prompt */
    dflt_colour[ATTR_PREFIX]   = A_BOLD;                        /* prefix area */
    dflt_colour[ATTR_PENDING]  = A_BOLD;            /* pending prefix commands */
    dflt_colour[ATTR_SCALE]    = A_BOLD;                         /* scale line */
    dflt_colour[ATTR_TOFEOF]   = A_BOLD;                      /* tof eof lines */
    dflt_colour[ATTR_CTOFEOF]  = A_BOLD;     /* current line if on t/eof lines */
    dflt_colour[ATTR_TABLINE]  = A_BOLD;                           /* tab line */
    dflt_colour[ATTR_SHADOW]   = A_BOLD;                       /* shadow lines */
    dflt_colour[ATTR_STATAREA] = A_REVERSE;             /* status line (bottom)*/
    dflt_colour[ATTR_DIVIDER]  = A_BOLD;                            /* divider */
    for (i=0;i<ATTR_MAX;i++)
      if (colour[i])            /* a colour has been set up in profile */
         set_colour(i,save_fg[i],save_bg[i],save_mod[i]);
      else
         colour[i] = dflt_colour[i];
   }
#else
 dflt_colour[ATTR_FILEAREA] = A_NORMAL;           /* main window text lines */
 dflt_colour[ATTR_CURLINE]  = A_BOLD;                       /* current line */
 dflt_colour[ATTR_BLOCK]    = A_REVERSE;           /* text in markded block */
 dflt_colour[ATTR_CBLOCK]   = A_BOLD | A_REVERSE;
                                    /* current line if in marked block */
 dflt_colour[ATTR_CMDLINE]  = A_BOLD;                       /* command line */
 dflt_colour[ATTR_IDLINE]   = A_REVERSE;                    /* id line (top)*/
 dflt_colour[ATTR_MSGLINE]  = A_BLINK;                      /* message line */
 dflt_colour[ATTR_ARROW]    = A_BOLD;                       /* arrow prompt */
 dflt_colour[ATTR_PREFIX]   = A_REVERSE;                        /* prefix area */
 dflt_colour[ATTR_PENDING]  = A_BOLD;            /* pending prefix commands */
 dflt_colour[ATTR_SCALE]    = A_BOLD;                         /* scale line */
 dflt_colour[ATTR_TOFEOF]   = A_BOLD;                      /* tof eof lines */
 dflt_colour[ATTR_CTOFEOF]  = A_BOLD | A_REVERSE;     /* current line if on t/eof lines */
 dflt_colour[ATTR_TABLINE]  = A_BOLD;                           /* tab line */
 dflt_colour[ATTR_SHADOW]   = A_BOLD;                       /* shadow lines */
 dflt_colour[ATTR_STATAREA] = A_REVERSE;             /* status line (bottom)*/
 dflt_colour[ATTR_DIVIDER]  = A_BOLD;                            /* divider */
 for (i=0;i<ATTR_MAX;i++)
      if (colour[i])            /* a colour has been set up in profile */
         set_colour(i,save_fg[i],save_bg[i],save_mod[i]);
      else
         colour[i] = dflt_colour[i];
#endif

#ifdef TRACE
 trace_return();
#endif
 return;
}
/***********************************************************************/
#ifdef PROTO
short get_profile(char *prf_arg)
#else
short get_profile(prf_arg)
char *prf_arg;
#endif
/***********************************************************************/
{
/*------------------------- external data -----------------------------*/
 extern char in_macro;
 extern char the_profile_file[MAX_FILE_NAME+1];
 extern bool profile_specified;
/*--------------------------- local data ------------------------------*/
 FILE *fp;
 short rc=RC_OK;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: get_profile");
#endif
/*---------------------------------------------------------------------*/
/* Check to see if the profile file exists and is readable. If the file*/
/* does not exists or is not readable, return. If a profile file was   */
/* explicitly specified, display an error if it doesn't exist. If the  */
/* file is not readable, whether we specified it or not, display error.*/
/*---------------------------------------------------------------------*/
 if (!file_exists(the_profile_file))
   {
    if (profile_specified)
       display_error(9,the_profile_file);
#ifdef TRACE
    trace_return();
#endif
    return(RC_FILE_NOT_FOUND);
   }
/*---------------------------------------------------------------------*/
/* If the file is not readable, error.                                 */
/*---------------------------------------------------------------------*/
 if (!file_readable(the_profile_file))
   {
    display_error(8,the_profile_file);
#ifdef TRACE
    trace_return();
#endif
    return(RC_ACCESS_DENIED);
   }
/*---------------------------------------------------------------------*/
/* To get here, we either have a specified a valid profile name or we  */
/* haven't specified a profile file at all.                            */
/*---------------------------------------------------------------------*/
 in_macro = TRUE;
#if !defined(NOREXX)
 if (!in_profile)
    post_process_line(CURRENT_VIEW->focus_line);
 rc = execute_macro_file(the_profile_file,prf_arg);
 if (rc != RC_OK)
   {
    display_error(54,(char *)"");
    in_macro = FALSE;
#ifdef TRACE
    trace_return();
#endif
    return(RC_SYSTEM_ERROR);
   }
#else
 if ((fp = fopen(the_profile_file,"r")) == NULL)
   {
    in_macro = FALSE;
#ifdef TRACE
    trace_return();
#endif
    return(RC_ACCESS_DENIED);
   }
 if (!in_profile)
    post_process_line(CURRENT_VIEW->focus_line);
 rc = execute_command_file(fp);
 fclose(fp);
#endif
 in_macro = FALSE;

#ifdef TRACE
 trace_return();
#endif
 return(rc);
}
/***********************************************************************/
#ifdef PROTO
short defaults_for_first_file(void)
#else
short defaults_for_first_file()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: defaults_for_first_file");
#endif
/*---------------------------------------------------------------------*/
/* Add to view linked list.                                            */
/*---------------------------------------------------------------------*/
#ifdef USE_VOID
 if ((CURRENT_VIEW = (VIEW_DETAILS *)ll_add((void *)vd_first,(void *)vd_current,sizeof(VIEW_DETAILS)))
#else
 if ((CURRENT_VIEW = vll_add(vd_first,vd_current,sizeof(VIEW_DETAILS)))
#endif
                   == (VIEW_DETAILS *)NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }
 if (vd_first == (VIEW_DETAILS *)NULL)
    vd_first = CURRENT_VIEW;

 CURRENT_VIEW->current_row = 6;
 CURRENT_VIEW->current_base = CURLINE_TOP;
 CURRENT_VIEW->current_off = CURRENT_VIEW->current_row;
 CURRENT_VIEW->cmd_line = CMD_LINEx;
 CURRENT_VIEW->error_row = ERROR_ROWx;
 CURRENT_VIEW->tab_row = TAB_ROWx;
 CURRENT_VIEW->tab_on = TAB_ONx;
 CURRENT_VIEW->scale_row = SCALE_ROWx;
 CURRENT_VIEW->scale_on = SCALE_ONx;
 CURRENT_VIEW->focus_line = CURRENT_ROW_POSx;
 CURRENT_VIEW->current_line = CURRENT_ROW_POSx;
 CURRENT_VIEW->stay = STAYx;
 CURRENT_VIEW->hex = HEXx;
 CURRENT_VIEW->arbchar_status = ARB_STSx;
 CURRENT_VIEW->arbchar_char = ARB_CHRx;
 CURRENT_VIEW->tabs = TABSx;
 CURRENT_VIEW->linend_status = LINEND_STATUSx;
 CURRENT_VIEW->linend_value = LINEND_VALUEx;
 CURRENT_VIEW->case_enter = CASE_Ex;
 CURRENT_VIEW->case_locate = CASE_Lx;
 CURRENT_VIEW->case_change = CASE_Cx;
 CURRENT_VIEW->case_sort = CASE_Sx;
 CURRENT_VIEW->prefix = PREFIXx;
 CURRENT_VIEW->message_mode = MSGMx;
 CURRENT_VIEW->verify_start = VER_STAx;
 CURRENT_VIEW->verify_col = VER_COLx;
 CURRENT_VIEW->verify_end = VER_ENDx;
 CURRENT_VIEW->zone_start = ZON_STAx;
 CURRENT_VIEW->zone_end = ZON_ENDx;
 CURRENT_VIEW->mark_type = 0;
 CURRENT_VIEW->mark_start_line = (-1L);
 CURRENT_VIEW->mark_end_line = (-1L);
 CURRENT_VIEW->mark_start_col = (-1);
 CURRENT_VIEW->mark_end_col = (-1);
 CURRENT_VIEW->display_high = DISPLAY_HIGHx;
 CURRENT_VIEW->display_low = DISPLAY_LOWx;
 CURRENT_VIEW->scope = 'D';
 CURRENT_VIEW->newline_aligned = NEWLx;
 CURRENT_VIEW->imp_macro = IMPMACROx;
 CURRENT_VIEW->imp_os = IMPOSx;
 CURRENT_VIEW->number = NUMBERx;
 CURRENT_VIEW->margin_left = 1;
 CURRENT_VIEW->margin_right = 72;
 CURRENT_VIEW->margin_indent = 0;
 CURRENT_VIEW->margin_indent_offset = TRUE;
 CURRENT_VIEW->wordwrap = FALSE;

 CURRENT_VIEW->current_window = WINDOW_COMMAND;
 CURRENT_VIEW->previous_window = WINDOW_COMMAND;

 for (i=0;i<VIEW_WINDOWS;i++)
     CURRENT_VIEW->win[i] = (WINDOW *)NULL;

 CURRENT_FILE = (FILE_DETAILS *)NULL;

 CURRENT_SCREEN.screen_view = CURRENT_VIEW;

 number_of_views++;
/*---------------------------------------------------------------------*/
/* Initialise pending prefix command array.                            */
/*---------------------------------------------------------------------*/
 for (i=0;i<MAX_PENDING_PREFIX_COMMANDS;i++)
    {
     strcpy(CURRENT_VIEW->ppc[i].ppc_command,"");
     CURRENT_VIEW->ppc[i].ppc_line_number = (-1L);
     CURRENT_VIEW->ppc[i].ppc_cmd_idx = (-1L);
    }
 CURRENT_VIEW->prefix_command_index = 0;
#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
#ifdef PROTO
short defaults_for_other_files(void)
#else
short defaults_for_other_files()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 register int i;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: defaults_for_other_files");
#endif
#ifdef USE_VOID
 if ((CURRENT_VIEW = (VIEW_DETAILS *)ll_add((void *)vd_first,(void *)vd_current,sizeof(VIEW_DETAILS)))
#else
 if ((CURRENT_VIEW = vll_add(vd_first,vd_current,sizeof(VIEW_DETAILS)))
#endif
                   == (VIEW_DETAILS *)NULL)
   {
#ifdef TRACE
    trace_return();
#endif
    return(RC_OUT_OF_MEMORY);
   }
 if (vd_first == (VIEW_DETAILS *)NULL)
    vd_first = CURRENT_VIEW;

 CURRENT_VIEW->command_row =     PREVIOUS_VIEW->command_row;
 CURRENT_VIEW->cmd_line =        PREVIOUS_VIEW->cmd_line;
 CURRENT_VIEW->error_row =       PREVIOUS_VIEW->error_row;
 CURRENT_VIEW->tab_row =         PREVIOUS_VIEW->tab_row;
 CURRENT_VIEW->tab_on =          PREVIOUS_VIEW->tab_on;
 CURRENT_VIEW->scale_row =       PREVIOUS_VIEW->scale_row;
 CURRENT_VIEW->scale_on =        PREVIOUS_VIEW->scale_on;
 CURRENT_VIEW->current_row =     PREVIOUS_VIEW->current_row;
 CURRENT_VIEW->current_base =    PREVIOUS_VIEW->current_base;
 CURRENT_VIEW->current_off =     PREVIOUS_VIEW->current_off;
 CURRENT_VIEW->current_line =    CURRENT_ROW_POSx;
 CURRENT_VIEW->focus_line =      CURRENT_ROW_POSx;
 CURRENT_VIEW->tabs =            TABSx;
 CURRENT_VIEW->stay =            STAYx;
 CURRENT_VIEW->hex =             HEXx;
 CURRENT_VIEW->arbchar_status =  PREVIOUS_VIEW->arbchar_status;
 CURRENT_VIEW->arbchar_char =    PREVIOUS_VIEW->arbchar_char;
 CURRENT_VIEW->linend_status =   PREVIOUS_VIEW->linend_status;
 CURRENT_VIEW->linend_value =    PREVIOUS_VIEW->linend_value;
 CURRENT_VIEW->case_enter =      PREVIOUS_VIEW->case_enter;
 CURRENT_VIEW->case_locate =     PREVIOUS_VIEW->case_locate;
 CURRENT_VIEW->case_change =     PREVIOUS_VIEW->case_change;
 CURRENT_VIEW->case_sort =       PREVIOUS_VIEW->case_sort;
 CURRENT_VIEW->message_mode =    PREVIOUS_VIEW->message_mode;
 CURRENT_VIEW->prefix =          PREVIOUS_VIEW->prefix;
 CURRENT_VIEW->verify_start =    VER_STAx;
 CURRENT_VIEW->verify_col =      VER_COLx;
 CURRENT_VIEW->verify_end =      VER_ENDx;
 CURRENT_VIEW->zone_start =      ZON_STAx;
 CURRENT_VIEW->zone_end =        ZON_ENDx;
 CURRENT_VIEW->mark_type =       0;
 CURRENT_VIEW->mark_start_line = (-1L);
 CURRENT_VIEW->mark_end_line =   (-1L);
 CURRENT_VIEW->mark_start_col =  (-1);
 CURRENT_VIEW->mark_end_col =    (-1);
 CURRENT_VIEW->display_high =    DISPLAY_HIGHx;
 CURRENT_VIEW->display_low =     DISPLAY_LOWx;
 CURRENT_VIEW->scope =           'D';
 CURRENT_VIEW->newline_aligned = NEWLx;
 CURRENT_VIEW->imp_macro =       PREVIOUS_VIEW->imp_macro;
 CURRENT_VIEW->imp_os =          PREVIOUS_VIEW->imp_os;
 CURRENT_VIEW->number =          PREVIOUS_VIEW->number;
 CURRENT_VIEW->margin_left =     PREVIOUS_VIEW->margin_left;
 CURRENT_VIEW->margin_right =    PREVIOUS_VIEW->margin_right;
 CURRENT_VIEW->margin_indent =   PREVIOUS_VIEW->margin_indent;
 CURRENT_VIEW->margin_indent_offset = PREVIOUS_VIEW->margin_indent_offset;
 CURRENT_VIEW->wordwrap =        PREVIOUS_VIEW->wordwrap;

 CURRENT_VIEW->current_window =  WINDOW_COMMAND;
 CURRENT_VIEW->previous_window =    WINDOW_COMMAND;

 for (i=0;i<VIEW_WINDOWS;i++)
     CURRENT_VIEW->win[i] = (WINDOW *)NULL;

 CURRENT_FILE = (FILE_DETAILS *)NULL;

 CURRENT_SCREEN.screen_view = CURRENT_VIEW;

 number_of_views++;
/*---------------------------------------------------------------------*/
/* Initialise pending prefix command array.                            */
/*---------------------------------------------------------------------*/
 for (i=0;i<MAX_PENDING_PREFIX_COMMANDS;i++)
    {
     strcpy(CURRENT_VIEW->ppc[i].ppc_command,"");
     CURRENT_VIEW->ppc[i].ppc_line_number = (-1L);
     CURRENT_VIEW->ppc[i].ppc_cmd_idx = (-1L);
    }
 CURRENT_VIEW->prefix_command_index = 0;

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
#ifdef PROTO
short default_file_attributes(void)
#else
short default_file_attributes()
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: default_file_attributes");
#endif

 CURRENT_FILE->fmode =           FMODE;
 CURRENT_FILE->file_views =      1;
 CURRENT_FILE->first_line  =     NULL;
 CURRENT_FILE->autosave_alt =    0;
 CURRENT_FILE->autosave =        AUSx;
 CURRENT_FILE->backup =          BACKUPx;
 CURRENT_FILE->save_alt =        0;
 CURRENT_FILE->eolout =          EOLx;
 CURRENT_FILE->tabsout_on =      TABO_ONx;
 CURRENT_FILE->tabsout_num =     TABO_Nx;
 CURRENT_FILE->pseudo_file =     PSEUDO_REAL;

 CURRENT_FILE->fname =           (char *)NULL;
 CURRENT_FILE->fpath =           (char *)NULL;

#ifdef TRACE
 trace_return();
#endif
 return(RC_OK);
}
/***********************************************************************/
#ifdef PROTO
void set_screen_defaults(void)
#else
void set_screen_defaults()
#endif
/***********************************************************************/
{
 extern int reserved_top,reserved_bottom;
/*--------------------------- local data ------------------------------*/
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("default.c: set_screen_defaults");
#endif

 CURRENT_SCREEN.origin_x =         0;
 CURRENT_SCREEN.origin_y =         reserved_top;
 if (horizontal)
   {
    CURRENT_SCREEN.screen_rows =   (LINES - 1 - reserved_top + reserved_bottom ) / display_screens;
    CURRENT_SCREEN.screen_cols =   COLS;
   }
 else
   {
    CURRENT_SCREEN.screen_rows =   LINES - 1 - reserved_top + reserved_bottom;
    CURRENT_SCREEN.screen_cols =   (COLS / display_screens)-((display_screens == 1) ? 0 : 1); /**/
   }
 if (display_screens == 1)
   {
    OTHER_SCREEN.origin_x =        0;
    OTHER_SCREEN.origin_y =        reserved_top;
    OTHER_SCREEN.screen_rows =     LINES - 1 - reserved_top + reserved_bottom;
    OTHER_SCREEN.screen_cols =     COLS;
   }
 else
   {
    if (horizontal)
      {
       OTHER_SCREEN.origin_x =     0;
       OTHER_SCREEN.origin_y =     CURRENT_SCREEN.screen_rows + reserved_top;
       OTHER_SCREEN.screen_rows =  LINES - 1 - CURRENT_SCREEN.screen_rows - reserved_top + reserved_bottom;
       OTHER_SCREEN.screen_cols =  COLS;
      }
    else
      {
       OTHER_SCREEN.origin_x =     CURRENT_SCREEN.screen_cols+((display_screens == 1) ? 0 : 2); /**/
       OTHER_SCREEN.origin_y =     reserved_top;
       OTHER_SCREEN.screen_rows =  LINES - 1 - reserved_top + reserved_bottom;
       OTHER_SCREEN.screen_cols =  COLS - CURRENT_SCREEN.screen_cols-((display_screens == 1) ? 0 : 2);/**/
      }
   }

#ifdef TRACE
 trace_return();
#endif
 return;
}
