
# Platform-specific built stuff goes in here.
# Really, this should be split into multiple files, 
# one for each platform, but let's keep it all together
# until a grand tidy-up epoch.


# In here, and elsewhere, we want $(PLATFORM) to be one of:
# WINNT, AIX, IRIX, HPUX, SOLARIS, (and more later...)
# Today, we do NOT differentiate between OS revisions.
# This is deliberate, the idea is that we're only targeting
# one binary build per OS at any one time. If we ever want to
# build for more than one at a time, we'll need to define 
# completely new  platforms with revision numbers in.

# This file defines things like what the names of object files, 
# library files and so on look like; now to compile souce code;
# how to link static libraries, dll's and suchlike.
ifeq ($(PLATFORM),)
PLATFORM=$(shell uname -s)
endif

# HP, in their infinite lameness, changed the name of their OS !!!
ifeq ($(PLATFORM),HP-UX)
PLATFORM=HPUX
endif

# SGI, in their infinite lameness, changed the name of their OS !!!
ifeq ($(PLATFORM),IRIX64)
PLATFORM=IRIX
endif

# Sun, in their wisdom, has kept the old name of their OS
ifeq ($(PLATFORM),SunOS)
PLATFORM=SOLARIS
CPU=$(shell uname -p)
ifneq ($(CPU),sparc)
ifeq ($(CPU),x86)
PLATFORM=SOLARISx86
else
PLATFORM="Unable to figure out platform"
endif
endif
endif

# Add new platforms to this list:
platformlist=WINNT AIX IRIX HPUX SOLARIS Linux ReliantUNIX SOLARISx86 SCOOS BSDI UnixWare

# We enter the chasm between windows and unix here:
ifeq ($(PLATFORM),WINNT)

# ------------------------
# NT-specific stuff now
# ------------------------

# Debug-specific stuff first
ifeq ($(DEBUG),full)
CDEBUGFLAGS+=-MD -Od -Z7 
RCDEBUGFLAGS=-DDEBUG -D_DEBUG
#-Fd$(OBJDIR)/
else
CDEBUGFLAGS+=-MD -O2 -Ob2 -Z7
endif

# no debug-specific NT stuff after here.
PLATDLL_DEBUGFLAGS=-debug -debugtype:both -pdb:none
BUILDTRASH=$(OBJDIR)/vc40.pdb
OBJ_SUFFIX:=.obj
OBJ_OUT_COMMAND:=-Fo
PLATCFLAGS:=-nologo -W3 -DWIN32 -D_WINDOWS
ifdef MSCBROWSEINFO
PLATCFLAGS+=-FR$(OBJDIR)/
endif
PLATDLL_LDFLAGS=-nologo -subsystem:windows -dll -incremental:no \
	-machine:I386 $(PLATDLL_DEBUGFLAGS) \
	-implib:$(@:$(DLL_SUFFIX)=$(LIB_SUFFIX)) \
	-def:$(subst .dll,.def,$(def_dir)/$(notdir $@))
PLAT_LINKFLAGS:=-incremental:no
LINK_STATIC_LIB=lib -out:$@ $(OBJS) advapi32.lib
LINK_DLL=link $(DLL_LDFLAGS) $(PLATDLL_LDFLAGS) -out:$@ $(OBJS) $(LOBJS) -base:$(NT_DLL_BASE) advapi32.lib
STRIP_DLL=rebase -x $(dir $@) -p -a -b $(NT_DLL_BASE) $@
ifdef INTEL_COMPILER
CC=	icl
else
CC=	cl
endif
rm=	rm
DLL_SUFFIX:=.dll
LIB_SUFFIX:=.lib
EXE_SUFFIX:=.exe

RC=rc
RCFLAGS=$(RCDEBUGFLAGS) -l 0x409
RESOURCE_COMPILE=$(RC) $(RCFLAGS) $(OBJ_OUT_COMMAND)$@ $<

ifneq ($(MT),yes)
	@echo Single-Threaded build not supported on NT
	exit 1
endif

else			# NOT NT, so UNIX, we hope !

# ------------------------
# UNIX-specific stuff now
# ------------------------

# No debug-specific stuff now.
# Most UNIX stuff is the same for all platforms
# We don't specify explicit paths for commands, because we expect the
# machine's path to be setup properly. If is isn't , fix it.

ar=ar cq
ranlib=ranlib
CC=	cc
rm=	rm
test=	test

DLL_SUFFIX:=.so
LIB_SUFFIX:=.a
EXE_SUFFIX:=
LINK_STATIC_LIB= $(ar) $@ $(OBJS) ; $(ranlib) $@
LINK_DLL=$(LD) $(DLL_LDFLAGS) $(PLATDLL_LDFLAGS) -o $@ $(OBJS) $(LOBJS) $(LLIBS)
OBJ_SUFFIX:=.o
OBJ_OUT_COMMAND:=-o 

# Stuff specific to each UNIX platform now:

ifeq ($(PLATFORM),AIX)
CC=xlC_r
PLATDLL_LDFLAGS=-bM:SRE -bnoentry \
	-L.:/usr/lib/threads:/usr/lpp/xlC/lib:/usr/lib:/lib \
	-bI:/usr/lib/lowsys.exp -lC_r -lC -lc_r -lpthreads \
	/usr/lib/libc.a -lm \
	-bE:$(subst $(DLL_SUFFIX),.exp,../os_unix/AIX/libdb.exp)
libdb_exp = libdb.exp
libdb.exp:
	cp ../os_unix/AIX/libdb.exp $@
LD=ld
endif

ifeq ($(PLATFORM),HPUX)
PLATCFLAGS = +z +DAportable
ifeq ($(USE_64),1)
PLATCFLAGS = +z +DA2.0W +DChpux -D_LARGEFILE64_SOURCE
LDFLAGS = +DA2.0W
endif
PLATDLL_LDFLAGS:=-b
DLL_SUFFIX:=.sl
LD=ld
endif

ifeq ($(PLATFORM),IRIX)
PLATDLL_LDFLAGS=-shared -soname $(notdir $@) -all
LD=ld
endif

ifeq ($(PLATFORM),OSF1)
PLATDLL_LDFLAGS:=-shared -all -expect_unresolved "*" -taso
LD=ld
endif

ifeq ($(PLATFORM),SOLARIS)
CC=/tools/ns/workshop/bin/cc
PLATCFLAGS+=-KPIC
PLATDLL_LDFLAGS:=-G -z defs
LD=$(CC)
LLIBS=-lpthread -lc
endif

ifeq ($(PLATFORM),SOLARISx86)
ranlib=true
PLATCFLAGS+=-KPIC
PLATDLL_LDFLAGS:=-G
LD=ld
endif

ifeq ($(PLATFORM),Linux)
PLATCFLAGS+=-fPIC
PLATDLL_LDFLAGS:=-shared
LD=ld
endif

ifeq ($(PLATFORM),ReliantUNIX)
ranlib=true
LINK_DLL=$(CC) $(DLL_LDFLAGS) $(PLATDLL_LDFLAGS) -o $@ $(OBJS) $(LOBJS)
PLATDLL_LDFLAGS:=-G -Blargedynsym 
#-lmproc for spinlock.  
extra_nt_stuff=-lmproc
LD=ld
endif

ifeq ($(PLATFORM),BSDI)
CC=shlicc2
ranlib=ranlib
PLATDLL_LDFLAGS:=-r
LD=ld
endif

ifeq ($(PLATFORM),SCOOS)
ranlib=true
PLATCFLAGS+=-b elf -KPIC
PLATDLL_LDFLAGS+=-G
LD=ld
endif

ifeq ($(PLATFORM),UnixWare)
ranlib=true
rm=   rm -r
PLATCFLAGS+=-KPIC
PLATDLL_LDFLAGS:=-G
LD=ld
endif

endif

CFLAGS += $(PLATCFLAGS)
