use strict;
use warnings;
use utf8;

use Test::More;
use DBD::IngresII;
use DBI;

sub get_dbname {
    # find the name of a database on which test are to be performed
    my $dbname = $ENV{DBI_DBNAME} || $ENV{DBI_DSN};
    if (defined $dbname && $dbname !~ /^dbi:IngresII/) {
	    $dbname = "dbi:IngresII:$dbname";
    }
    return $dbname;
}

sub connect_db ($) {
    # Connects to the database.
    # If this fails everything else is in vain!
    my ($dbname) = @_;
    $ENV{II_DATE_FORMAT}='SWEDEN';       # yyyy-mm-dd

    my $dbh = DBI->connect($dbname, "", "",
		    { AutoCommit => 0, RaiseError => 0, PrintError => 1, ShowErrorStatement=>1 })
	or die 'Unable to connect to database!';
    $dbh->{ChopBlanks} = 0;

    return $dbh;
}

my $dbname = get_dbname();

############################
# BEGINNING OF TESTS       #
############################

unless (defined $dbname) {
    plan skip_all => 'DBI_DBNAME and DBI_DSN aren\'t present';
}
else {
    plan tests => 2;
}

my $dbh = connect_db($dbname);

ok(($dbh->ing_utf8_quote(q{ąść'}) eq q{U&'\\+000105\\+00015b\\+000107'''}), 'Testing UTF-8 quoting');
ok(($dbh->ing_utf8_quote(q{\\+000105}) eq q{U&'\\\\+000105'}), 'Testing UTF-8 quoting with backslashes');

$dbh and $dbh->commit;
$dbh and $dbh->disconnect;

exit(0);
