#!/usr/bin/env perl
#
# This file is part of Hash-Override
#
# This software is copyright (c) 2012 by Stefan Petrea.
#
# This is free software; you can redistribute it and/or modify it under
# the same terms as the Perl 5 programming language system itself.
#
use strict;
use warnings;
use strict;
use warnings;
use Test::More;
use Test::Deep;
use Hash::Override;

my ($A,$B);
####################################################################################
#7). Hashes containing undef values
####################################################################################

$A = {
  key1 => 'v1',
  key2 => 'v2',
};


$B = {
  key1 => 'v1',
  key2 => undef,
};

Hash::Override::merge($A,$B);
cmp_deeply(
  $A,
  {
    key1 => 'v1',
    key2 => 'v2',
  },
  '7). A is unchanged after the merge'
);
done_testing;
