/*
 * FILE : Solve.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 883)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* $Header: /users/micas/verhaege/CVS/master/Math-LP-Solve/src/Solve.c,v 1.6 2000/10/31 14:47:34 verhaege Exp $ */
/* Implementation : PERL 5 */

#define SWIGPERL
#define SWIGPERL5
#ifdef __cplusplus
/* Needed on some windows machines---since MS plays funny
   games with the header files under C++ */
#include <math.h>
#include <stdlib.h>
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* Get rid of free and malloc defined by perl */
#undef free
#undef malloc

#include <string.h>
#ifdef __cplusplus
}
#endif
/* Definitions for compiling Perl extensions on a variety of machines */

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a) __declspec(dllexport) a
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a) a _export 
#	else
#	    define SWIGEXPORT(a) a 
#	endif
#   endif
#else
#   define SWIGEXPORT(a) a 
#endif

#ifdef PERL_OBJECT
#define MAGIC_PPERL  CPerlObj *pPerl = (CPerlObj *) this;
#define MAGIC_CAST   (int (CPerlObj::*)(SV *, MAGIC *))
#define SWIGCLASS_STATIC 
#else
#define MAGIC_PPERL
#define MAGIC_CAST
#define SWIGCLASS_STATIC static
#endif

#if defined(WIN32) && defined(PERL_OBJECT) && !defined(PerlIO_exportFILE)
#define PerlIO_exportFILE(fh,fl) (FILE*)(fh)
#endif

/* Modifications for newer Perl 5.005 releases */

#if !defined(PERL_REVISION) || ((PERL_REVISION >= 5) && ((PERL_VERSION < 5) || ((PERL_VERSION == 5) && (PERL_SUBVERSION < 50))))
#ifndef PL_sv_yes
#define PL_sv_yes sv_yes
#endif
#ifndef PL_sv_undef
#define PL_sv_undef sv_undef
#endif
#ifndef PL_na
#define PL_na na
#endif
#endif

/******************************************************************************
 * Pointer type-checking code
 *****************************************************************************/

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SWIG_NOINCLUDE
extern void SWIG_MakePtr(char *, void *, char *);
#ifndef PERL_OBJECT
extern void SWIG_RegisterMapping(char *, char *, void *(*)(void *));
#else
#define SWIG_RegisterMapping(a,b,c) _SWIG_RegisterMapping(pPerl,a,b,c);
extern void _SWIG_RegisterMapping(CPerlObj *,char *, char *, void *(*)(void *),int);
#endif
#ifndef PERL_OBJECT
extern char *SWIG_GetPtr(SV *, void **, char *);
#else
extern char *_SWIG_GetPtr(CPerlObj *, SV *, void **, char *);
#define SWIG_GetPtr(a,b,c) _SWIG_GetPtr(pPerl,a,b,c)
#endif

#else

#ifdef SWIG_GLOBAL
#define SWIGSTATICRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGSTATICRUNTIME(a) static a
#endif

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */
static int SwigStart[256];             /* Table containing starting positions    */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

#ifndef PERL_OBJECT
SWIGSTATICRUNTIME(void) 
SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {
#else
#define SWIG_RegisterMapping(a,b,c) _SWIG_RegisterMapping(pPerl, a,b,c)
SWIGSTATICRUNTIME(void)
_SWIG_RegisterMapping(CPerlObj *pPerl, char *origtype, char *newtype, void *(*cast)(void *)) {
#endif

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATICRUNTIME(void) 
SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Function for getting a pointer value */

#ifndef PERL_OBJECT
SWIGSTATICRUNTIME(char *) 
SWIG_GetPtr(SV *sv, void **ptr, char *_t)
#else
#define SWIG_GetPtr(a,b,c) _SWIG_GetPtr(pPerl,a,b,c)
SWIGSTATICRUNTIME(char *)
_SWIG_GetPtr(CPerlObj *pPerl, SV *sv, void **ptr, char *_t)
#endif
{
  char temp_type[256];
  char *name,*_c;
  int  len,i,start,end;
  IV   tmp;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;

  /* If magical, apply more magic */

  if (SvGMAGICAL(sv))
    mg_get(sv);

  /* Check to see if this is an object */
  if (sv_isobject(sv)) {
    SV *tsv = (SV*) SvRV(sv);
    if ((SvTYPE(tsv) == SVt_PVHV)) {
      MAGIC *mg;
      if (SvMAGICAL(tsv)) {
	mg = mg_find(tsv,'P');
	if (mg) {
	  SV *rsv = mg->mg_obj;
	  if (sv_isobject(rsv)) {
	    tmp = SvIV((SV*)SvRV(rsv));
	  }
	}
      } else {
	return "Not a valid pointer value";
      }
    } else {
      tmp = SvIV((SV*)SvRV(sv));
    }
    if (!_t) {
      *(ptr) = (void *) tmp;
      return (char *) 0;
    }
  } else if (! SvOK(sv)) {            /* Check for undef */
    *(ptr) = (void *) 0;
    return (char *) 0;
  } else if (SvTYPE(sv) == SVt_RV) {       /* Check for NULL pointer */
    *(ptr) = (void *) 0;
    if (!SvROK(sv)) 
      return (char *) 0;
    else
      return "Not a valid pointer value";
  } else {                                 /* Don't know what it is */
      *(ptr) = (void *) 0;
      return "Not a valid pointer value";
  }
  if (_t) {
    /* Now see if the types match */      

    if (!sv_isa(sv,_t)) {
      _c = HvNAME(SvSTASH(SvRV(sv)));
      if (!SwigPtrSort) {
	qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort);  
	for (i = 0; i < 256; i++) {
	  SwigStart[i] = SwigPtrN;
	}
	for (i = SwigPtrN-1; i >= 0; i--) {
	  SwigStart[SwigPtrTable[i].name[0]] = i;
	}
	for (i = 255; i >= 1; i--) {
	  if (SwigStart[i-1] > SwigStart[i])
	    SwigStart[i-1] = SwigStart[i];
	}
	SwigPtrSort = 1;
	for (i = 0; i < SWIG_CACHESIZE; i++)  
	  SwigCache[i].stat = 0;
      }
      /* First check cache for matches.  Uses last cache value as starting point */
      cache = &SwigCache[SwigLastCache];
      for (i = 0; i < SWIG_CACHESIZE; i++) {
	if (cache->stat) {
	  if (strcmp(_t,cache->name) == 0) {
	    if (strcmp(_c,cache->mapped) == 0) {
	      cache->stat++;
	      *ptr = (void *) tmp;
	      if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
	      return (char *) 0;
	    }
	  }
	}
	SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	if (!SwigLastCache) cache = SwigCache;
	else cache++;
      }

      start = SwigStart[_t[0]];
      end = SwigStart[_t[0]+1];
      sp = &SwigPtrTable[start];
      while (start < end) {
	if (swigcmp(_t,sp) == 0) break;
	sp++;
	start++;
      }
      if (start > end) sp = 0;
      while (start <= end) {
	if (swigcmp(_t,sp) == 0) {
	  name = sp->name;
	  len = sp->len;
	  tp = sp->next;
	  while(tp) {
	    if (tp->len >= 255) {
	      return _c;
	    }
	    strcpy(temp_type,tp->name);
	    strncat(temp_type,_t+len,255-tp->len);
	    if (sv_isa(sv,temp_type)) {
	      /* Get pointer value */
	      *ptr = (void *) tmp;
	      if (tp->cast) *ptr = (*(tp->cast))(*ptr);

	      strcpy(SwigCache[SwigCacheIndex].mapped,_c);
	      strcpy(SwigCache[SwigCacheIndex].name,_t);
	      SwigCache[SwigCacheIndex].stat = 1;
	      SwigCache[SwigCacheIndex].tp = tp;
	      SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
	      return (char *) 0;
	    }
	    tp = tp->next;
	  } 
	}
	sp++;
	start++;
      }
      /* Didn't find any sort of match for this data.  
	 Get the pointer value and return the received type */
      *ptr = (void *) tmp;
      return _c;
    } else {
      /* Found a match on the first try.  Return pointer value */
      *ptr = (void *) tmp;
      return (char *) 0;
    }
  } 
  *ptr = (void *) tmp;
  return (char *) 0;
}

#endif
#ifdef __cplusplus
}
#endif






/* Magic variable code */
#ifndef PERL_OBJECT
#define swig_create_magic(s,a,b,c) _swig_create_magic(s,a,b,c)
static void _swig_create_magic(SV *sv, char *name, int (*set)(SV *, MAGIC *), int (*get)(SV *,MAGIC *)) {
#else
#define swig_create_magic(s,a,b,c) _swig_create_magic(pPerl,s,a,b,c)
static void _swig_create_magic(CPerlObj *pPerl, SV *sv, char *name, int (CPerlObj::*set)(SV *, MAGIC *), int (CPerlObj::*get)(SV *, MAGIC *)) {
#endif
  MAGIC *mg;
  sv_magic(sv,sv,'U',name,strlen(name));
  mg = mg_find(sv,'U');
  mg->mg_virtual = (MGVTBL *) malloc(sizeof(MGVTBL));
  mg->mg_virtual->svt_get = get;
  mg->mg_virtual->svt_set = set;
  mg->mg_virtual->svt_len = 0;
  mg->mg_virtual->svt_clear = 0;
  mg->mg_virtual->svt_free = 0;
}

#define SWIG_init    boot_Math__LP__Solve

#define SWIG_name   "Math::LP::Solve::boot_Math__LP__Solve"
#define SWIG_varinit "Math::LP::Solve::var_Math__LP__Solve_init();"
#ifdef __cplusplus
extern "C"
#endif
#ifndef PERL_OBJECT
SWIGEXPORT(void) boot_Math__LP__Solve(CV* cv);
#else
SWIGEXPORT(void) boot_Math__LP__Solve(CV *cv, CPerlObj *);
#endif

/* the following macro's are double defined by Perl and lp_solve 
 * (needed because setting/unsetting the POLLUTE variable to Makefile.PL 
 *  has no effect)
 */
#undef FALSE
#undef TRUE
#undef invert

#include "lpkit.h"

/* since lp_solve uses (f)lex, the following is needed to keep the
 * autoloader happy
 */
int yywrap(void) 
{
  return 1;
}

/* Manipulation of string data fields of struct lprec is a bit awkward
 * The following functions take care of this problem
 */
static void _my_strcpy(char* dest, char* src) {
  strncpy(dest,src,MAXSTRL); /* cuts off too long strings */
  dest[MAXSTRL+1] = (char)0; /* ensures zero-termination */
}
char* lprec_lp_name_get(lprec* lp) {
  return lp->lp_name;
}
void lprec_lp_name_set(lprec* lp, char* name) {
  _my_strcpy(lp->lp_name,name);
}
char* lprec_row_name_get(lprec* lp, int i) {
  return (lp->row_name)[i];
}
void lprec_row_name_set(lprec* lp, int i, char* name) { 
  _my_strcpy((lp->row_name)[i],name);
}
char* lprec_col_name_get(lprec* lp, int i) {
  return (lp->col_name)[i];
}
void lprec_col_name_set(lprec* lp, int i, char* name) { 
  _my_strcpy((lp->col_name)[i],name);
}

/* filehandles */
FILE* open_file(char* filename, char* mode) {
  FILE* fd;
  if(!(fd = fopen(filename,mode))) {
    croak("Could not open file `%s' in mode `%s'",filename,mode);
  }
  return fd;
}
void close_file(FILE* fd) {
  fclose(fd);
}

/* Direct reading from stdin fails due to no EOF detection
 * The following functions are therefore deprecated */
/*
lprec* read_lp_from_stdin(short verbose, char* lp_name) {
  return read_lp_file(stdin,verbose,lp_name);
}
void write_lp_to_stdout(lprec* lp) {
  write_LP(lp,stdout);
}
lprec* read_mps_from_stdin(short verbose) {
  return read_mps(stdin,verbose);
}
void write_mps_to_stdout(lprec* lp) {
  write_MPS(lp,stdout);
}
*/
#ifndef PERL_OBJECT
#define swig_setnv(a,b) _swig_setnv(a,b)
static void _swig_setnv(char *name, double value) { 
#else
#define swig_setnv(a,b) _swig_setnv(pPerl,a,b)
static void _swig_setnv(CPerlObj *pPerl, char *name, double value) { 
#endif
     SV *sv; 
     sv = perl_get_sv(name,TRUE | 0x2);
     sv_setnv(sv, value);
     SvREADONLY_on(sv);
}

#ifndef PERL_OBJECT
#define swig_setiv(a,b) _swig_setiv(a,b)
static void _swig_setiv(char *name, long value) { 
#else
#define swig_setiv(a,b) _swig_setiv(pPerl,a,b)
static void _swig_setiv(CPerlObj *pPerl, char *name, long value) { 
#endif
     SV *sv; 
     sv = perl_get_sv(name,TRUE | 0x2);
     sv_setiv(sv, (IV) value);
     SvREADONLY_on(sv);
}



#ifdef WIN32
#undef isspace
#define isspace(c) (c == ' ')
#endif

/*------------------------------------------------------------------
  ptrcast(value,type)

  Constructs a new pointer value.   Value may either be a string
  or an integer. Type is a string corresponding to either the
  C datatype or mangled datatype.

  ptrcast(0,"Vector *")
               or
  ptrcast(0,"Vector_p")   
  ------------------------------------------------------------------ */
#ifdef PERL_OBJECT
static SV *_ptrcast(CPerlObj *pPerl, SV *_PTRVALUE, char *type) {
#define ptrcast(a,b)  _ptrcast(pPerl,a,b)
#else
static SV *_ptrcast(SV *_PTRVALUE, char *type) {
#define ptrcast(a,b)  _ptrcast(a,b)
#endif
  char *r,*s;
  void *ptr;
  SV *obj;
  char *typestr,*c;

  /* Produce a "mangled" version of the type string.  */

  typestr = (char *) malloc(strlen(type)+20);

  /* Go through and munge the typestring */
  
  r = typestr;
  c = type;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	strcpy(r,"Ptr");
	r+=3;
      } else *(r++) = *c;
    } 
    c++;
  }
  *(r++) = 0;
    
  /* Check to see if the input value is an integer */
  if (SvIOK(_PTRVALUE)) {
    ptr = (void *) SvIV(_PTRVALUE);
    /* Received a numerical value. Make a pointer out of it */
    obj = sv_newmortal();
    sv_setref_pv(obj,typestr,ptr);
  } else if (sv_isobject(_PTRVALUE)) {
    /* Have a real pointer value now.  Try to strip out the pointer value */
    /* Now extract the pointer value */
    if (!SWIG_GetPtr(_PTRVALUE,&ptr,0)) {
      obj = sv_newmortal();
      sv_setref_pv(obj,typestr,ptr);
    }
  } else {
    croak("ptrcast(). Not a reference.");
  }
  free(typestr);
  return obj;
}



/*------------------------------------------------------------------
  ptrvalue(ptr,type = 0)

  Attempts to dereference a pointer value.  If type is given, it 
  will try to use that type.  Otherwise, this function will attempt
  to "guess" the proper datatype by checking against all of the 
  builtin C datatypes. 
  ------------------------------------------------------------------ */

#ifdef PERL_OBJECT
static SV *_ptrvalue(CPerlObj *pPerl,SV *_PTRVALUE, int index, char *type) {
#define ptrvalue(a,b,c) _ptrvalue(pPerl,a,b,c)
#else
static SV *_ptrvalue(SV *_PTRVALUE, int index, char *type) {
#define ptrvalue(a,b,c) _ptrvalue(a,b,c)
#endif

  void     *ptr;
  SV       *obj = 0;


  if (SWIG_GetPtr(_PTRVALUE,&ptr,0)) {
    croak("Type error it ptrvalue. Argument is not a valid pointer value.");
  } else {
    /* If no datatype was passed, try a few common datatypes first */
    if (!type) {

      /* No datatype was passed.   Type to figure out if it's a common one */
      
      if (!SWIG_GetPtr(_PTRVALUE,&ptr,"intPtr")) {
	type = "int";
      } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"doublePtr")) {
	type = "double";
      } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"shortPtr")) {
	type = "short";
      } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"longPtr")) {
	type = "long";
      } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"floatPtr")) {
	type = "float";
      } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"charPtr")) {
	type = "char";
      } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"charPtrPtr")) {
	type = "char *";
      } else {
	type = "unknown";
      }
    }
    
    if (!ptr) {
      croak("Unable to dereference NULL pointer.");
      return 0;
    }

    /* Now we have a datatype.  Try to figure out what to do about it */
    if (strcmp(type,"int") == 0) {
      obj = sv_newmortal();
      sv_setiv(obj,(IV) *(((int *) ptr) + index));
    } else if (strcmp(type,"double") == 0) {
      obj = sv_newmortal();
      sv_setnv(obj,(double) *(((double *) ptr)+index));
    } else if (strcmp(type,"short") == 0) {
      obj = sv_newmortal();
      sv_setiv(obj,(IV) *(((short *) ptr) + index));
    } else if (strcmp(type,"long") == 0) {
      obj = sv_newmortal();
      sv_setiv(obj,(IV) *(((long *) ptr) + index));
    } else if (strcmp(type,"float") == 0) {
      obj = sv_newmortal();
      sv_setnv(obj,(double) *(((float *) ptr)+index));
    } else if (strcmp(type,"char") == 0) {
      obj = sv_newmortal();
      sv_setpv(obj,((char *) ptr)+index);
    } else if (strcmp(type,"char *") == 0) {
      char *c = *(((char **) ptr)+index);
      obj = sv_newmortal();
      if (c) 
	sv_setpv(obj,c);
      else 
	sv_setpv(obj,"NULL");
    } else {
      croak("Unable to dereference unsupported datatype.");
      obj = 0;
    }
  }
  return obj;
}

/*------------------------------------------------------------------
  ptrcreate(type,value = 0,numelements = 1)

  Attempts to create a new object of given type.  Type must be
  a basic C datatype.  Will not create complex objects.
  ------------------------------------------------------------------ */
#ifdef PERL_OBJECT
static SV *_ptrcreate(CPerlObj *pPerl, char *type, SV *value, int numelements) {
#define ptrcreate(a,b,c) _ptrcreate(pPerl,a,b,c)
#else
static SV *_ptrcreate(char *type, SV *value, int numelements) {
#define ptrcreate(a,b,c) _ptrcreate(a,b,c)
#endif

  void     *ptr;
  SV       *obj;
  int       sz;
  char     *cast;
  char      temp[40];

  /* Check the type string against a variety of possibilities */

  if (strcmp(type,"int") == 0) {
    sz = sizeof(int)*numelements;
    cast = "intPtr";
  } else if (strcmp(type,"short") == 0) {
    sz = sizeof(short)*numelements;
    cast = "shortPtr";
  } else if (strcmp(type,"long") == 0) {
    sz = sizeof(long)*numelements;
    cast = "longPtr";
  } else if (strcmp(type,"double") == 0) {
    sz = sizeof(double)*numelements;
    cast = "doublePtr";
  } else if (strcmp(type,"float") == 0) {
    sz = sizeof(float)*numelements;
    cast = "floatPtr";
  } else if (strcmp(type,"char") == 0) {
    sz = sizeof(char)*numelements;
    cast = "charPtr";
  } else if (strcmp(type,"char *") == 0) {
    sz = sizeof(char *)*(numelements+1);
    cast = "charPtrPtr";
  } else if (strcmp(type,"void") == 0) {
    sz = numelements;
    cast = "voidPtr";
  } else {
    croak("Unable to create unknown datatype."); 
    return 0;
  }
   
  /* Create the new object */
  
  ptr = (void *) malloc(sz);
  if (!ptr) {
    croak("Out of memory in ptrcreate."); 
    return 0;
  }

  /* Now try to set its default value */

  if (value) {
    if (strcmp(type,"int") == 0) {
      int *ip,i,ivalue;
      ivalue = (int) SvIV(value);
      ip = (int *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"short") == 0) {
      short *ip,ivalue;
      int i;
      ivalue = (short) SvIV(value);
      ip = (short *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"long") == 0) {
      long *ip,ivalue;
      int i;
      ivalue = (long) SvIV(value);
      ip = (long *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"double") == 0) {
      double *ip,ivalue;
      int i;
      ivalue = (double) SvNV(value);
      ip = (double *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"float") == 0) {
      float *ip,ivalue;
      int i;
      ivalue = (float) SvNV(value);
      ip = (float *) ptr;
      for (i = 0; i < numelements; i++)
	ip[i] = ivalue;
    } else if (strcmp(type,"char") == 0) {
      char *ip,*ivalue;
      ivalue = (char *) SvPV(value,PL_na);
      ip = (char *) ptr;
      strncpy(ip,ivalue,numelements-1);
    } else if (strcmp(type,"char *") == 0) {
      char **ip, *ivalue;
      int  i;
      ivalue = (char *) SvPV(value,PL_na);
      ip = (char **) ptr;
      for (i = 0; i < numelements; i++) {
	if (ivalue) {
	  ip[i] = (char *) malloc(strlen(ivalue)+1);
	  strcpy(ip[i],ivalue);
	} else {
	  ip[i] = 0;
	}
      }
      ip[numelements] = 0;
    }
  } 
  /* Create the pointer value */
  
  SWIG_MakePtr(temp,ptr,cast);
  obj = sv_newmortal();
  sv_setref_pv(obj,cast,ptr);
  return obj;
}

/*------------------------------------------------------------------
  ptrset(ptr,value,index = 0,type = 0)

  Attempts to set the value of a pointer variable.  If type is
  given, we will use that type.  Otherwise, we'll guess the datatype.
  ------------------------------------------------------------------ */

#ifdef PERL_OBJECT
static void _ptrset(CPerlObj *pPerl,SV *_PTRVALUE, SV *value, int index, char *type) {
#define ptrset(a,b,c,d) _ptrset(pPerl,a,b,c,d)
#else
static void _ptrset(SV *_PTRVALUE, SV *value, int index, char *type) {
#define ptrset(a,b,c,d) _ptrset(a,b,c,d)
#endif
  void     *ptr;
  SV       *obj;

  if (SWIG_GetPtr(_PTRVALUE,&ptr,0)) {
    croak("Type error in ptrset. Argument is not a valid pointer value.");
    return;
  }

  /* If no datatype was passed, try a few common datatypes first */

  if (!type) {

    /* No datatype was passed.   Type to figure out if it's a common one */

    if (!SWIG_GetPtr(_PTRVALUE,&ptr,"intPtr")) {
      type = "int";
    } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"doublePtr")) {
      type = "double";
    } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"shortPtr")) {
      type = "short";
    } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"longPtr")) {
      type = "long";
    } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"floatPtr")) {
      type = "float";
    } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"charPtr")) {
      type = "char";
    } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"charPtrPtr")) {
      type = "char *";
    } else {
      type = "unknown";
    }
  }

  if (!ptr) {
    croak("Unable to set NULL pointer.");
    return;
  }
  
  /* Now we have a datatype.  Try to figure out what to do about it */
  if (strcmp(type,"int") == 0) {
    *(((int *) ptr)+index) = (int) SvIV(value);
  } else if (strcmp(type,"double") == 0) {
    *(((double *) ptr)+index) = (double) SvNV(value);
  } else if (strcmp(type,"short") == 0) {
    *(((short *) ptr)+index) = (short) SvIV(value);
  } else if (strcmp(type,"long") == 0) {
    *(((long *) ptr)+index) = (long) SvIV(value);
  } else if (strcmp(type,"float") == 0) {
    *(((float *) ptr)+index) = (float) SvNV(value);
  } else if (strcmp(type,"char") == 0) {
    char *c = SvPV(value,PL_na);
    strcpy(((char *) ptr)+index, c);
  } else if (strcmp(type,"char *") == 0) {
    char *c = SvPV(value,PL_na);
    char **ca = (char **) ptr;
    if (ca[index]) free(ca[index]);
    if (strcmp(c,"NULL") == 0) {
      ca[index] = 0;
    } else {
      ca[index] = (char *) malloc(strlen(c)+1);
      strcpy(ca[index],c);
    }
  } else {
    croak("Unable to set unsupported datatype.");
    return;
  }
}

/*------------------------------------------------------------------
  ptradd(ptr,offset)

  Adds a value to an existing pointer value.  Will do a type-dependent
  add for basic datatypes.  For other datatypes, will do a byte-add.
  ------------------------------------------------------------------ */

#ifdef PERL_OBJECT
static SV *_ptradd(CPerlObj *pPerl, SV *_PTRVALUE, int offset) {
#define ptradd(a,b) _ptradd(pPerl,a,b)
#else
static SV *_ptradd(SV *_PTRVALUE, int offset) {
#define ptradd(a,b) _ptradd(a,b)
#endif

  void *ptr,*junk;
  SV   *obj;
  char *type;

  /* Try to handle a few common datatypes first */

  if (!SWIG_GetPtr(_PTRVALUE,&ptr,"intPtr")) {
    ptr = (void *) (((int *) ptr) + offset);
  } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"doublePtr")) {
    ptr = (void *) (((double *) ptr) + offset);
  } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"shortPtr")) {
    ptr = (void *) (((short *) ptr) + offset);
  } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"longPtr")) {
    ptr = (void *) (((long *) ptr) + offset);
  } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"floatPtr")) {
    ptr = (void *) (((float *) ptr) + offset);
  } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,"charPtr")) {
    ptr = (void *) (((char *) ptr) + offset);
  } else if (!SWIG_GetPtr(_PTRVALUE,&ptr,0)) {
    ptr = (void *) (((char *) ptr) + offset);
  } else {
    croak("Type error in ptradd. Argument is not a valid pointer value.");
    return 0;
  }
  type = SWIG_GetPtr(_PTRVALUE,&junk,"INVALID POINTER");
  obj = sv_newmortal();
  sv_setref_pv(obj,type,ptr);
  return obj;
}

/*------------------------------------------------------------------
  ptrmap(type1,type2)

  Allows a mapping between type1 and type2. (Like a typedef)
  ------------------------------------------------------------------ */

#ifdef PERL_OBJECT
static void _ptrmap(CPerlObj *pPerl,char *type1, char *type2) {
#define ptrmap(a,b) _ptrmap(pPerl,a,b)
#else
static void _ptrmap(char *type1, char *type2) {
#define ptrmap(a,b) _ptrmap(a,b)
#endif
  char *typestr1,*typestr2,*c,*r;
  /* Produce a "mangled" version of the type string.  */

  typestr1 = (char *) malloc(strlen(type1)+20);


  /* Go through and munge the typestring */
  
  r = typestr1;
  *(r++) = '_';
  c = type1;

  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	strcpy(r,"Ptr");
	r+=3;
      }
      else *(r++) = *c;
    } 
    c++;
  }
  *(r++) = 0;

  typestr2 = (char *) malloc(strlen(type2)+20);

  /* Go through and munge the typestring */
  
  r = typestr2;
  *(r++) = '_';
  c = type2;
  while (*c) {
    if (!isspace(*c)) {
      if ((*c == '*') || (*c == '&')) {
	strcpy(r,"Ptr");
	r+=3;
      }
      else *(r++) = *c;
    }
    c++;
  }
  *(r++) = 0;
  SWIG_RegisterMapping(typestr1,typestr2,0);
  SWIG_RegisterMapping(typestr2,typestr1,0);
}

/*------------------------------------------------------------------
  ptrfree(ptr)

  Destroys a pointer value
  ------------------------------------------------------------------ */
#ifdef PERL_OBJECT
void _ptrfree(CPerlObj *pPerl, SV *_PTRVALUE) {
#define ptrfree(a) _ptrfree(pPerl, a)
#else
void _ptrfree(SV *_PTRVALUE) {
#define ptrfree(a) _ptrfree(a)
#endif

  void *ptr, *junk;

  if (SWIG_GetPtr(_PTRVALUE,&ptr,0)) {
    croak("Type error in ptrfree. Argument is not a valid pointer value.");
    return;
  }

  /* Check to see if this pointer is a char ** */
  if (!SWIG_GetPtr(_PTRVALUE,&junk,"charPtrPtr")) {
    char **c = (char **) ptr;
    if (c) {
      int i = 0;
      while (c[i]) {
	free(c[i]);
	i++;
      }
    }
  } 
  if (ptr)
    free((char *) ptr);
}

#ifdef PERL_OBJECT
#define MAGIC_CLASS _wrap_Math__LP__Solve_var::
class _wrap_Math__LP__Solve_var : public CPerlObj {
public:
#else
#define MAGIC_CLASS
#endif
SWIGCLASS_STATIC int swig_magic_readonly(SV *sv, MAGIC *mg) {
    MAGIC_PPERL
    sv = sv; mg = mg;
    croak("Value is read-only.");
    return 0;
}


#ifdef PERL_OBJECT
};
#endif

XS(_wrap_ptrcast) {

    SV * _result;
    SV * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: ptrcast(ptr,type);");
{
  _arg0 = ST(0);
}
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _result = (SV *)ptrcast(_arg0,_arg1);
{
  ST(argvi) = _result;
  argvi++;
}
    XSRETURN(argvi);
}

XS(_wrap_ptrvalue) {

    SV * _result;
    SV * _arg0;
    int  _arg1 = (int ) 0;
    char * _arg2 = (char *) 0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 3)) 
        croak("Usage: ptrvalue(ptr,index,type);");
{
  _arg0 = ST(0);
}
    if (items > 1) {
    _arg1 = (int )SvIV(ST(1));
    } 
    if (items > 2) {
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    } 
    _result = (SV *)ptrvalue(_arg0,_arg1,_arg2);
{
  ST(argvi) = _result;
  argvi++;
}
    XSRETURN(argvi);
}

XS(_wrap_ptrset) {

    SV * _arg0;
    SV * _arg1;
    int  _arg2 = (int ) 0;
    char * _arg3 = (char *) 0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 4)) 
        croak("Usage: ptrset(ptr,value,index,type);");
{
  _arg0 = ST(0);
}
{
  _arg1 = ST(1);
}
    if (items > 2) {
    _arg2 = (int )SvIV(ST(2));
    } 
    if (items > 3) {
    if (! SvOK((SV*) ST(3))) { _arg3 = 0; }
    else { _arg3 = (char *) SvPV(ST(3),PL_na); }
    } 
    ptrset(_arg0,_arg1,_arg2,_arg3);
    XSRETURN(argvi);
}

XS(_wrap_ptrcreate) {

    SV * _result;
    char * _arg0;
    SV * _arg1 = (SV *) 0;
    int  _arg2 = (int ) 1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 3)) 
        croak("Usage: ptrcreate(type,value,nitems);");
    if (! SvOK((SV*) ST(0))) { _arg0 = 0; }
    else { _arg0 = (char *) SvPV(ST(0),PL_na); }
    if (items > 1) {
{
  _arg1 = ST(1);
}
    } 
    if (items > 2) {
    _arg2 = (int )SvIV(ST(2));
    } 
    _result = (SV *)ptrcreate(_arg0,_arg1,_arg2);
{
  ST(argvi) = _result;
  argvi++;
}
    XSRETURN(argvi);
}

XS(_wrap_ptrfree) {

    SV * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: ptrfree(ptr);");
{
  _arg0 = ST(0);
}
    ptrfree(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_ptradd) {

    SV * _result;
    SV * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: ptradd(ptr,offset);");
{
  _arg0 = ST(0);
}
    _arg1 = (int )SvIV(ST(1));
    _result = (SV *)ptradd(_arg0,_arg1);
{
  ST(argvi) = _result;
  argvi++;
}
    XSRETURN(argvi);
}

XS(_wrap_ptrmap) {

    char * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: ptrmap(type1,type2);");
    if (! SvOK((SV*) ST(0))) { _arg0 = 0; }
    else { _arg0 = (char *) SvPV(ST(0),PL_na); }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    ptrmap(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_make_lp) {

    lprec * _result;
    int  _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: make_lp(rows,columns);");
    _arg0 = (int )SvIV(ST(0));
    _arg1 = (int )SvIV(ST(1));
    _result = (lprec *)make_lp(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"lprecPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_read_lp_file) {

    lprec * _result;
    FILE * _arg0;
    short  _arg1 = (short ) 0;
    char * _arg2 = (char *) "no_name";
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 3)) 
        croak("Usage: read_lp_file(input,verbose,lp_name);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"FILEPtr")) {
        croak("Type error in argument 1 of read_lp_file. Expected FILEPtr.");
        XSRETURN(1);
    }
    if (items > 1) {
    _arg1 = (short )SvIV(ST(1));
    } 
    if (items > 2) {
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    } 
    _result = (lprec *)read_lp_file(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"lprecPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_delete_lp) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: delete_lp(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of delete_lp. Expected lprecPtr.");
        XSRETURN(1);
    }
    delete_lp(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_copy_lp) {

    lprec * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: copy_lp(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of copy_lp. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (lprec *)copy_lp(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"lprecPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_set_mat) {

    lprec * _arg0;
    int  _arg1;
    int  _arg2;
    double  _arg3;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 4) || (items > 4)) 
        croak("Usage: set_mat(lp,row,column,value);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_mat. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (int )SvIV(ST(2));
    _arg3 = (double ) SvNV(ST(3));
    set_mat(_arg0,_arg1,_arg2,_arg3);
    XSRETURN(argvi);
}

XS(_wrap_set_obj_fn) {

    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: set_obj_fn(lp,row);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_obj_fn. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of set_obj_fn. Expected doublePtr.");
        XSRETURN(1);
    }
    set_obj_fn(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_str_set_obj_fn) {

    lprec * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: str_set_obj_fn(lp,row);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of str_set_obj_fn. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    str_set_obj_fn(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_add_constraint) {

    lprec * _arg0;
    double * _arg1;
    short  _arg2;
    double  _arg3;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 4) || (items > 4)) 
        croak("Usage: add_constraint(lp,row,constr_type,rh);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of add_constraint. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of add_constraint. Expected doublePtr.");
        XSRETURN(1);
    }
    _arg2 = (short )SvIV(ST(2));
    _arg3 = (double ) SvNV(ST(3));
    add_constraint(_arg0,_arg1,_arg2,_arg3);
    XSRETURN(argvi);
}

XS(_wrap_str_add_constraint) {

    lprec * _arg0;
    char * _arg1;
    short  _arg2;
    double  _arg3;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 4) || (items > 4)) 
        croak("Usage: str_add_constraint(lp,row_string,constr_type,rh);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of str_add_constraint. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (short )SvIV(ST(2));
    _arg3 = (double ) SvNV(ST(3));
    str_add_constraint(_arg0,_arg1,_arg2,_arg3);
    XSRETURN(argvi);
}

XS(_wrap_del_constraint) {

    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: del_constraint(lp,del_row);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of del_constraint. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    del_constraint(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_add_lag_con) {

    lprec * _arg0;
    double * _arg1;
    short  _arg2;
    double  _arg3;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 4) || (items > 4)) 
        croak("Usage: add_lag_con(lp,row,con_type,rhs);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of add_lag_con. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of add_lag_con. Expected doublePtr.");
        XSRETURN(1);
    }
    _arg2 = (short )SvIV(ST(2));
    _arg3 = (double ) SvNV(ST(3));
    add_lag_con(_arg0,_arg1,_arg2,_arg3);
    XSRETURN(argvi);
}

XS(_wrap_str_add_lag_con) {

    lprec * _arg0;
    char * _arg1;
    short  _arg2;
    double  _arg3;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 4) || (items > 4)) 
        croak("Usage: str_add_lag_con(lp,row,con_type,rhs);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of str_add_lag_con. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    _arg2 = (short )SvIV(ST(2));
    _arg3 = (double ) SvNV(ST(3));
    str_add_lag_con(_arg0,_arg1,_arg2,_arg3);
    XSRETURN(argvi);
}

XS(_wrap_add_column) {

    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: add_column(lp,column);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of add_column. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of add_column. Expected doublePtr.");
        XSRETURN(1);
    }
    add_column(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_str_add_column) {

    lprec * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: str_add_column(lp,col_string);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of str_add_column. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    str_add_column(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_del_column) {

    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: del_column(lp,column);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of del_column. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    del_column(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_set_upbo) {

    lprec * _arg0;
    int  _arg1;
    double  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_upbo(lp,column,value);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_upbo. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (double ) SvNV(ST(2));
    set_upbo(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_set_lowbo) {

    lprec * _arg0;
    int  _arg1;
    double  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_lowbo(lp,column,value);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_lowbo. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (double ) SvNV(ST(2));
    set_lowbo(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_set_int) {

    lprec * _arg0;
    int  _arg1;
    short  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_int(lp,column,must_be_int);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_int. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (short )SvIV(ST(2));
    set_int(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_set_rh) {

    lprec * _arg0;
    int  _arg1;
    double  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_rh(lp,row,value);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_rh. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (double ) SvNV(ST(2));
    set_rh(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_set_rh_vec) {

    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: set_rh_vec(lp,rh);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_rh_vec. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of set_rh_vec. Expected doublePtr.");
        XSRETURN(1);
    }
    set_rh_vec(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_str_set_rh_vec) {

    lprec * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: str_set_rh_vec(lp,rh_string);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of str_set_rh_vec. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    str_set_rh_vec(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_set_maxim) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: set_maxim(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_maxim. Expected lprecPtr.");
        XSRETURN(1);
    }
    set_maxim(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_set_minim) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: set_minim(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_minim. Expected lprecPtr.");
        XSRETURN(1);
    }
    set_minim(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_set_constr_type) {

    lprec * _arg0;
    int  _arg1;
    short  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_constr_type(lp,row,con_type);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_constr_type. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (short )SvIV(ST(2));
    set_constr_type(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_set_row_name) {

    lprec * _arg0;
    int  _arg1;
    char * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_row_name(lp,row,new_name);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_row_name. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    set_row_name(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_set_col_name) {

    lprec * _arg0;
    int  _arg1;
    char * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: set_col_name(lp,column,new_name);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of set_col_name. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    set_col_name(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_auto_scale) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: auto_scale(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of auto_scale. Expected lprecPtr.");
        XSRETURN(1);
    }
    auto_scale(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_unscale) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: unscale(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of unscale. Expected lprecPtr.");
        XSRETURN(1);
    }
    unscale(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_solve) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: solve(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of solve. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )solve(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_lag_solve) {

    int  _result;
    lprec * _arg0;
    double  _arg1;
    int  _arg2;
    short  _arg3;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 4) || (items > 4)) 
        croak("Usage: lag_solve(lp,start_bound,num_iter,verbose);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lag_solve. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _arg2 = (int )SvIV(ST(2));
    _arg3 = (short )SvIV(ST(3));
    _result = (int )lag_solve(_arg0,_arg1,_arg2,_arg3);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_reset_basis) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: reset_basis(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of reset_basis. Expected lprecPtr.");
        XSRETURN(1);
    }
    reset_basis(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_mat_elm) {

    double  _result;
    lprec * _arg0;
    int  _arg1;
    int  _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: mat_elm(lp,row,column);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of mat_elm. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _arg2 = (int )SvIV(ST(2));
    _result = (double )mat_elm(_arg0,_arg1,_arg2);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

XS(_wrap_get_row) {

    lprec * _arg0;
    int  _arg1;
    double * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: get_row(lp,row_nr,row);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of get_row. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (SWIG_GetPtr(ST(2),(void **) &_arg2,"doublePtr")) {
        croak("Type error in argument 3 of get_row. Expected doublePtr.");
        XSRETURN(1);
    }
    get_row(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_get_column) {

    lprec * _arg0;
    int  _arg1;
    double * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: get_column(lp,col_nr,column);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of get_column. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (SWIG_GetPtr(ST(2),(void **) &_arg2,"doublePtr")) {
        croak("Type error in argument 3 of get_column. Expected doublePtr.");
        XSRETURN(1);
    }
    get_column(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_get_reduced_costs) {

    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: get_reduced_costs(lp,rc);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of get_reduced_costs. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of get_reduced_costs. Expected doublePtr.");
        XSRETURN(1);
    }
    get_reduced_costs(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_is_feasible) {

    short  _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: is_feasible(lp,values);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of is_feasible. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of is_feasible. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (short )is_feasible(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_column_in_lp) {

    short  _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: column_in_lp(lp,column);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of column_in_lp. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of column_in_lp. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (short )column_in_lp(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

XS(_wrap_read_mps) {

    lprec * _result;
    FILE * _arg0;
    short  _arg1 = (short ) 0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 2)) 
        croak("Usage: read_mps(input,verbose);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"FILEPtr")) {
        croak("Type error in argument 1 of read_mps. Expected FILEPtr.");
        XSRETURN(1);
    }
    if (items > 1) {
    _arg1 = (short )SvIV(ST(1));
    } 
    _result = (lprec *)read_mps(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"lprecPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_write_MPS) {

    lprec * _arg0;
    FILE * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: write_MPS(lp,output);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of write_MPS. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"FILEPtr")) {
        croak("Type error in argument 2 of write_MPS. Expected FILEPtr.");
        XSRETURN(1);
    }
    write_MPS(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_write_LP) {

    lprec * _arg0;
    FILE * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: write_LP(lp,output);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of write_LP. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"FILEPtr")) {
        croak("Type error in argument 2 of write_LP. Expected FILEPtr.");
        XSRETURN(1);
    }
    write_LP(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_print_lp) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: print_lp(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of print_lp. Expected lprecPtr.");
        XSRETURN(1);
    }
    print_lp(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_print_solution) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: print_solution(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of print_solution. Expected lprecPtr.");
        XSRETURN(1);
    }
    print_solution(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_print_duals) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: print_duals(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of print_duals. Expected lprecPtr.");
        XSRETURN(1);
    }
    print_duals(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_print_scales) {

    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: print_scales(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of print_scales. Expected lprecPtr.");
        XSRETURN(1);
    }
    print_scales(_arg0);
    XSRETURN(argvi);
}

XS(_wrap_lprec_lp_name_get) {

    char * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lp_name_get(lp);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lp_name_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (char *)lprec_lp_name_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_lprec_lp_name_set) {

    lprec * _arg0;
    char * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lp_name_set(lp,name);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lp_name_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    lprec_lp_name_set(_arg0,_arg1);
    XSRETURN(argvi);
}

XS(_wrap_lprec_row_name_get) {

    char * _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_row_name_get(lp,i);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_row_name_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (char *)lprec_row_name_get(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_lprec_row_name_set) {

    lprec * _arg0;
    int  _arg1;
    char * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: lprec_row_name_set(lp,i,name);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_row_name_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    lprec_row_name_set(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_lprec_col_name_get) {

    char * _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_col_name_get(lp,i);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_col_name_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (char *)lprec_col_name_get(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setpv((SV*)ST(argvi++),(char *) _result);
    XSRETURN(argvi);
}

XS(_wrap_lprec_col_name_set) {

    lprec * _arg0;
    int  _arg1;
    char * _arg2;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 3) || (items > 3)) 
        croak("Usage: lprec_col_name_set(lp,i,name);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_col_name_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    if (! SvOK((SV*) ST(2))) { _arg2 = 0; }
    else { _arg2 = (char *) SvPV(ST(2),PL_na); }
    lprec_col_name_set(_arg0,_arg1,_arg2);
    XSRETURN(argvi);
}

XS(_wrap_open_file) {

    FILE * _result;
    char * _arg0;
    char * _arg1 = (char *) "r";
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 2)) 
        croak("Usage: open_file(filename,mode);");
    if (! SvOK((SV*) ST(0))) { _arg0 = 0; }
    else { _arg0 = (char *) SvPV(ST(0),PL_na); }
    if (items > 1) {
    if (! SvOK((SV*) ST(1))) { _arg1 = 0; }
    else { _arg1 = (char *) SvPV(ST(1),PL_na); }
    } 
    _result = (FILE *)open_file(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"FILEPtr", (void *) _result);
    XSRETURN(argvi);
}

XS(_wrap_close_file) {

    FILE * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: close_file(fd);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"FILEPtr")) {
        croak("Type error in argument 1 of close_file. Expected FILEPtr.");
        XSRETURN(1);
    }
    close_file(_arg0);
    XSRETURN(argvi);
}

#define lprec_verbose_set(_swigobj,_swigval) (_swigobj->verbose = _swigval,_swigval)
XS(_wrap_lprec_verbose_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_verbose_set(self,verbose);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_verbose_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_verbose_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_verbose_get(_swigobj) ((short ) _swigobj->verbose)
XS(_wrap_lprec_verbose_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_verbose_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_verbose_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_verbose_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_print_duals_set(_swigobj,_swigval) (_swigobj->print_duals = _swigval,_swigval)
XS(_wrap_lprec_print_duals_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_print_duals_set(self,print_duals);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_print_duals_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_print_duals_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_print_duals_get(_swigobj) ((short ) _swigobj->print_duals)
XS(_wrap_lprec_print_duals_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_print_duals_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_print_duals_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_print_duals_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_print_sol_set(_swigobj,_swigval) (_swigobj->print_sol = _swigval,_swigval)
XS(_wrap_lprec_print_sol_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_print_sol_set(self,print_sol);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_print_sol_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_print_sol_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_print_sol_get(_swigobj) ((short ) _swigobj->print_sol)
XS(_wrap_lprec_print_sol_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_print_sol_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_print_sol_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_print_sol_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_debug_set(_swigobj,_swigval) (_swigobj->debug = _swigval,_swigval)
XS(_wrap_lprec_debug_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_debug_set(self,debug);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_debug_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_debug_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_debug_get(_swigobj) ((short ) _swigobj->debug)
XS(_wrap_lprec_debug_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_debug_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_debug_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_debug_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_print_at_invert_set(_swigobj,_swigval) (_swigobj->print_at_invert = _swigval,_swigval)
XS(_wrap_lprec_print_at_invert_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_print_at_invert_set(self,print_at_invert);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_print_at_invert_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_print_at_invert_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_print_at_invert_get(_swigobj) ((short ) _swigobj->print_at_invert)
XS(_wrap_lprec_print_at_invert_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_print_at_invert_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_print_at_invert_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_print_at_invert_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_trace_set(_swigobj,_swigval) (_swigobj->trace = _swigval,_swigval)
XS(_wrap_lprec_trace_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_trace_set(self,trace);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_trace_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_trace_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_trace_get(_swigobj) ((short ) _swigobj->trace)
XS(_wrap_lprec_trace_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_trace_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_trace_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_trace_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_anti_degen_set(_swigobj,_swigval) (_swigobj->anti_degen = _swigval,_swigval)
XS(_wrap_lprec_anti_degen_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_anti_degen_set(self,anti_degen);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_anti_degen_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_anti_degen_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_anti_degen_get(_swigobj) ((short ) _swigobj->anti_degen)
XS(_wrap_lprec_anti_degen_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_anti_degen_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_anti_degen_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_anti_degen_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_do_presolve_set(_swigobj,_swigval) (_swigobj->do_presolve = _swigval,_swigval)
XS(_wrap_lprec_do_presolve_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_do_presolve_set(self,do_presolve);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_do_presolve_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_do_presolve_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_do_presolve_get(_swigobj) ((short ) _swigobj->do_presolve)
XS(_wrap_lprec_do_presolve_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_do_presolve_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_do_presolve_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_do_presolve_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_rows_set(_swigobj,_swigval) (_swigobj->rows = _swigval,_swigval)
XS(_wrap_lprec_rows_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_rows_set(self,rows);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rows_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_rows_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_rows_get(_swigobj) ((int ) _swigobj->rows)
XS(_wrap_lprec_rows_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_rows_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rows_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_rows_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_rows_alloc_set(_swigobj,_swigval) (_swigobj->rows_alloc = _swigval,_swigval)
XS(_wrap_lprec_rows_alloc_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_rows_alloc_set(self,rows_alloc);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rows_alloc_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_rows_alloc_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_rows_alloc_get(_swigobj) ((int ) _swigobj->rows_alloc)
XS(_wrap_lprec_rows_alloc_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_rows_alloc_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rows_alloc_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_rows_alloc_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_columns_set(_swigobj,_swigval) (_swigobj->columns = _swigval,_swigval)
XS(_wrap_lprec_columns_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_columns_set(self,columns);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_columns_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_columns_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_columns_get(_swigobj) ((int ) _swigobj->columns)
XS(_wrap_lprec_columns_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_columns_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_columns_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_columns_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_columns_alloc_set(_swigobj,_swigval) (_swigobj->columns_alloc = _swigval,_swigval)
XS(_wrap_lprec_columns_alloc_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_columns_alloc_set(self,columns_alloc);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_columns_alloc_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_columns_alloc_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_columns_alloc_get(_swigobj) ((int ) _swigobj->columns_alloc)
XS(_wrap_lprec_columns_alloc_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_columns_alloc_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_columns_alloc_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_columns_alloc_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_sum_set(_swigobj,_swigval) (_swigobj->sum = _swigval,_swigval)
XS(_wrap_lprec_sum_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_sum_set(self,sum);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_sum_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_sum_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_sum_get(_swigobj) ((int ) _swigobj->sum)
XS(_wrap_lprec_sum_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_sum_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_sum_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_sum_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_sum_alloc_set(_swigobj,_swigval) (_swigobj->sum_alloc = _swigval,_swigval)
XS(_wrap_lprec_sum_alloc_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_sum_alloc_set(self,sum_alloc);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_sum_alloc_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_sum_alloc_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_sum_alloc_get(_swigobj) ((int ) _swigobj->sum_alloc)
XS(_wrap_lprec_sum_alloc_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_sum_alloc_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_sum_alloc_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_sum_alloc_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_names_used_set(_swigobj,_swigval) (_swigobj->names_used = _swigval,_swigval)
XS(_wrap_lprec_names_used_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_names_used_set(self,names_used);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_names_used_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_names_used_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_names_used_get(_swigobj) ((short ) _swigobj->names_used)
XS(_wrap_lprec_names_used_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_names_used_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_names_used_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_names_used_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_non_zeros_set(_swigobj,_swigval) (_swigobj->non_zeros = _swigval,_swigval)
XS(_wrap_lprec_non_zeros_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_non_zeros_set(self,non_zeros);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_non_zeros_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_non_zeros_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_non_zeros_get(_swigobj) ((int ) _swigobj->non_zeros)
XS(_wrap_lprec_non_zeros_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_non_zeros_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_non_zeros_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_non_zeros_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_mat_alloc_set(_swigobj,_swigval) (_swigobj->mat_alloc = _swigval,_swigval)
XS(_wrap_lprec_mat_alloc_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_mat_alloc_set(self,mat_alloc);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_mat_alloc_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_mat_alloc_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_mat_alloc_get(_swigobj) ((int ) _swigobj->mat_alloc)
XS(_wrap_lprec_mat_alloc_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_mat_alloc_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_mat_alloc_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_mat_alloc_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_mat_set(_swigobj,_swigval) (_swigobj->mat = _swigval,_swigval)
XS(_wrap_lprec_mat_set) {

    matrec * _result;
    lprec * _arg0;
    matrec * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_mat_set(self,mat);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_mat_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"matrecPtr")) {
        croak("Type error in argument 2 of lprec_mat_set. Expected matrecPtr.");
        XSRETURN(1);
    }
    _result = (matrec *)lprec_mat_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"matrecPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_mat_get(_swigobj) ((matrec *) _swigobj->mat)
XS(_wrap_lprec_mat_get) {

    matrec * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_mat_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_mat_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (matrec *)lprec_mat_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"matrecPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_col_end_set(_swigobj,_swigval) (_swigobj->col_end = _swigval,_swigval)
XS(_wrap_lprec_col_end_set) {

    int * _result;
    lprec * _arg0;
    int * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_col_end_set(self,col_end);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_col_end_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"intPtr")) {
        croak("Type error in argument 2 of lprec_col_end_set. Expected intPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_col_end_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_col_end_get(_swigobj) ((int *) _swigobj->col_end)
XS(_wrap_lprec_col_end_get) {

    int * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_col_end_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_col_end_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_col_end_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_col_no_set(_swigobj,_swigval) (_swigobj->col_no = _swigval,_swigval)
XS(_wrap_lprec_col_no_set) {

    int * _result;
    lprec * _arg0;
    int * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_col_no_set(self,col_no);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_col_no_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"intPtr")) {
        croak("Type error in argument 2 of lprec_col_no_set. Expected intPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_col_no_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_col_no_get(_swigobj) ((int *) _swigobj->col_no)
XS(_wrap_lprec_col_no_get) {

    int * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_col_no_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_col_no_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_col_no_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_row_end_valid_set(_swigobj,_swigval) (_swigobj->row_end_valid = _swigval,_swigval)
XS(_wrap_lprec_row_end_valid_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_row_end_valid_set(self,row_end_valid);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_row_end_valid_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_row_end_valid_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_row_end_valid_get(_swigobj) ((short ) _swigobj->row_end_valid)
XS(_wrap_lprec_row_end_valid_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_row_end_valid_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_row_end_valid_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_row_end_valid_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_row_end_set(_swigobj,_swigval) (_swigobj->row_end = _swigval,_swigval)
XS(_wrap_lprec_row_end_set) {

    int * _result;
    lprec * _arg0;
    int * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_row_end_set(self,row_end);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_row_end_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"intPtr")) {
        croak("Type error in argument 2 of lprec_row_end_set. Expected intPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_row_end_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_row_end_get(_swigobj) ((int *) _swigobj->row_end)
XS(_wrap_lprec_row_end_get) {

    int * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_row_end_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_row_end_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_row_end_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_orig_rh_set(_swigobj,_swigval) (_swigobj->orig_rh = _swigval,_swigval)
XS(_wrap_lprec_orig_rh_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_orig_rh_set(self,orig_rh);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_orig_rh_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_orig_rh_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_orig_rh_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_orig_rh_get(_swigobj) ((double *) _swigobj->orig_rh)
XS(_wrap_lprec_orig_rh_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_orig_rh_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_orig_rh_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_orig_rh_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_rh_set(_swigobj,_swigval) (_swigobj->rh = _swigval,_swigval)
XS(_wrap_lprec_rh_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_rh_set(self,rh);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rh_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_rh_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_rh_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_rh_get(_swigobj) ((double *) _swigobj->rh)
XS(_wrap_lprec_rh_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_rh_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rh_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_rh_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_rhs_set(_swigobj,_swigval) (_swigobj->rhs = _swigval,_swigval)
XS(_wrap_lprec_rhs_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_rhs_set(self,rhs);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rhs_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_rhs_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_rhs_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_rhs_get(_swigobj) ((double *) _swigobj->rhs)
XS(_wrap_lprec_rhs_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_rhs_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rhs_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_rhs_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_must_be_int_set(_swigobj,_swigval) (_swigobj->must_be_int = _swigval,_swigval)
XS(_wrap_lprec_must_be_int_set) {

    short * _result;
    lprec * _arg0;
    short * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_must_be_int_set(self,must_be_int);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_must_be_int_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"shortPtr")) {
        croak("Type error in argument 2 of lprec_must_be_int_set. Expected shortPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_must_be_int_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_must_be_int_get(_swigobj) ((short *) _swigobj->must_be_int)
XS(_wrap_lprec_must_be_int_get) {

    short * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_must_be_int_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_must_be_int_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_must_be_int_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_orig_upbo_set(_swigobj,_swigval) (_swigobj->orig_upbo = _swigval,_swigval)
XS(_wrap_lprec_orig_upbo_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_orig_upbo_set(self,orig_upbo);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_orig_upbo_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_orig_upbo_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_orig_upbo_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_orig_upbo_get(_swigobj) ((double *) _swigobj->orig_upbo)
XS(_wrap_lprec_orig_upbo_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_orig_upbo_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_orig_upbo_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_orig_upbo_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_orig_lowbo_set(_swigobj,_swigval) (_swigobj->orig_lowbo = _swigval,_swigval)
XS(_wrap_lprec_orig_lowbo_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_orig_lowbo_set(self,orig_lowbo);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_orig_lowbo_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_orig_lowbo_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_orig_lowbo_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_orig_lowbo_get(_swigobj) ((double *) _swigobj->orig_lowbo)
XS(_wrap_lprec_orig_lowbo_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_orig_lowbo_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_orig_lowbo_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_orig_lowbo_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_upbo_set(_swigobj,_swigval) (_swigobj->upbo = _swigval,_swigval)
XS(_wrap_lprec_upbo_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_upbo_set(self,upbo);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_upbo_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_upbo_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_upbo_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_upbo_get(_swigobj) ((double *) _swigobj->upbo)
XS(_wrap_lprec_upbo_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_upbo_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_upbo_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_upbo_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lowbo_set(_swigobj,_swigval) (_swigobj->lowbo = _swigval,_swigval)
XS(_wrap_lprec_lowbo_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lowbo_set(self,lowbo);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lowbo_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_lowbo_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_lowbo_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lowbo_get(_swigobj) ((double *) _swigobj->lowbo)
XS(_wrap_lprec_lowbo_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lowbo_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lowbo_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_lowbo_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_basis_valid_set(_swigobj,_swigval) (_swigobj->basis_valid = _swigval,_swigval)
XS(_wrap_lprec_basis_valid_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_basis_valid_set(self,basis_valid);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_basis_valid_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_basis_valid_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_basis_valid_get(_swigobj) ((short ) _swigobj->basis_valid)
XS(_wrap_lprec_basis_valid_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_basis_valid_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_basis_valid_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_basis_valid_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_bas_set(_swigobj,_swigval) (_swigobj->bas = _swigval,_swigval)
XS(_wrap_lprec_bas_set) {

    int * _result;
    lprec * _arg0;
    int * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_bas_set(self,bas);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_bas_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"intPtr")) {
        croak("Type error in argument 2 of lprec_bas_set. Expected intPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_bas_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_bas_get(_swigobj) ((int *) _swigobj->bas)
XS(_wrap_lprec_bas_get) {

    int * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_bas_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_bas_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_bas_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_basis_set(_swigobj,_swigval) (_swigobj->basis = _swigval,_swigval)
XS(_wrap_lprec_basis_set) {

    short * _result;
    lprec * _arg0;
    short * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_basis_set(self,basis);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_basis_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"shortPtr")) {
        croak("Type error in argument 2 of lprec_basis_set. Expected shortPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_basis_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_basis_get(_swigobj) ((short *) _swigobj->basis)
XS(_wrap_lprec_basis_get) {

    short * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_basis_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_basis_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_basis_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lower_set(_swigobj,_swigval) (_swigobj->lower = _swigval,_swigval)
XS(_wrap_lprec_lower_set) {

    short * _result;
    lprec * _arg0;
    short * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lower_set(self,lower);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lower_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"shortPtr")) {
        croak("Type error in argument 2 of lprec_lower_set. Expected shortPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_lower_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lower_get(_swigobj) ((short *) _swigobj->lower)
XS(_wrap_lprec_lower_get) {

    short * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lower_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lower_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_lower_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_eta_valid_set(_swigobj,_swigval) (_swigobj->eta_valid = _swigval,_swigval)
XS(_wrap_lprec_eta_valid_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_eta_valid_set(self,eta_valid);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_valid_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_eta_valid_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_eta_valid_get(_swigobj) ((short ) _swigobj->eta_valid)
XS(_wrap_lprec_eta_valid_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_eta_valid_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_valid_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_eta_valid_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_eta_alloc_set(_swigobj,_swigval) (_swigobj->eta_alloc = _swigval,_swigval)
XS(_wrap_lprec_eta_alloc_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_eta_alloc_set(self,eta_alloc);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_alloc_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_eta_alloc_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_eta_alloc_get(_swigobj) ((int ) _swigobj->eta_alloc)
XS(_wrap_lprec_eta_alloc_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_eta_alloc_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_alloc_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_eta_alloc_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_eta_size_set(_swigobj,_swigval) (_swigobj->eta_size = _swigval,_swigval)
XS(_wrap_lprec_eta_size_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_eta_size_set(self,eta_size);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_size_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_eta_size_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_eta_size_get(_swigobj) ((int ) _swigobj->eta_size)
XS(_wrap_lprec_eta_size_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_eta_size_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_size_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_eta_size_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_num_inv_set(_swigobj,_swigval) (_swigobj->num_inv = _swigval,_swigval)
XS(_wrap_lprec_num_inv_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_num_inv_set(self,num_inv);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_num_inv_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_num_inv_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_num_inv_get(_swigobj) ((int ) _swigobj->num_inv)
XS(_wrap_lprec_num_inv_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_num_inv_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_num_inv_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_num_inv_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_max_num_inv_set(_swigobj,_swigval) (_swigobj->max_num_inv = _swigval,_swigval)
XS(_wrap_lprec_max_num_inv_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_max_num_inv_set(self,max_num_inv);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_max_num_inv_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_max_num_inv_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_max_num_inv_get(_swigobj) ((int ) _swigobj->max_num_inv)
XS(_wrap_lprec_max_num_inv_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_max_num_inv_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_max_num_inv_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_max_num_inv_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_eta_value_set(_swigobj,_swigval) (_swigobj->eta_value = _swigval,_swigval)
XS(_wrap_lprec_eta_value_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_eta_value_set(self,eta_value);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_value_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_eta_value_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_eta_value_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_eta_value_get(_swigobj) ((double *) _swigobj->eta_value)
XS(_wrap_lprec_eta_value_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_eta_value_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_value_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_eta_value_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_eta_row_nr_set(_swigobj,_swigval) (_swigobj->eta_row_nr = _swigval,_swigval)
XS(_wrap_lprec_eta_row_nr_set) {

    int * _result;
    lprec * _arg0;
    int * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_eta_row_nr_set(self,eta_row_nr);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_row_nr_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"intPtr")) {
        croak("Type error in argument 2 of lprec_eta_row_nr_set. Expected intPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_eta_row_nr_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_eta_row_nr_get(_swigobj) ((int *) _swigobj->eta_row_nr)
XS(_wrap_lprec_eta_row_nr_get) {

    int * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_eta_row_nr_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_row_nr_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_eta_row_nr_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_eta_col_end_set(_swigobj,_swigval) (_swigobj->eta_col_end = _swigval,_swigval)
XS(_wrap_lprec_eta_col_end_set) {

    int * _result;
    lprec * _arg0;
    int * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_eta_col_end_set(self,eta_col_end);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_col_end_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"intPtr")) {
        croak("Type error in argument 2 of lprec_eta_col_end_set. Expected intPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_eta_col_end_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_eta_col_end_get(_swigobj) ((int *) _swigobj->eta_col_end)
XS(_wrap_lprec_eta_col_end_get) {

    int * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_eta_col_end_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_eta_col_end_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int *)lprec_eta_col_end_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"intPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_bb_rule_set(_swigobj,_swigval) (_swigobj->bb_rule = _swigval,_swigval)
XS(_wrap_lprec_bb_rule_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_bb_rule_set(self,bb_rule);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_bb_rule_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_bb_rule_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_bb_rule_get(_swigobj) ((short ) _swigobj->bb_rule)
XS(_wrap_lprec_bb_rule_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_bb_rule_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_bb_rule_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_bb_rule_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_break_at_int_set(_swigobj,_swigval) (_swigobj->break_at_int = _swigval,_swigval)
XS(_wrap_lprec_break_at_int_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_break_at_int_set(self,break_at_int);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_break_at_int_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_break_at_int_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_break_at_int_get(_swigobj) ((short ) _swigobj->break_at_int)
XS(_wrap_lprec_break_at_int_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_break_at_int_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_break_at_int_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_break_at_int_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_break_value_set(_swigobj,_swigval) (_swigobj->break_value = _swigval,_swigval)
XS(_wrap_lprec_break_value_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_break_value_set(self,break_value);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_break_value_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_break_value_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_break_value_get(_swigobj) ((double ) _swigobj->break_value)
XS(_wrap_lprec_break_value_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_break_value_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_break_value_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_break_value_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_obj_bound_set(_swigobj,_swigval) (_swigobj->obj_bound = _swigval,_swigval)
XS(_wrap_lprec_obj_bound_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_obj_bound_set(self,obj_bound);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_obj_bound_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_obj_bound_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_obj_bound_get(_swigobj) ((double ) _swigobj->obj_bound)
XS(_wrap_lprec_obj_bound_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_obj_bound_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_obj_bound_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_obj_bound_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_iter_set(_swigobj,_swigval) (_swigobj->iter = _swigval,_swigval)
XS(_wrap_lprec_iter_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_iter_set(self,iter);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_iter_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_iter_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_iter_get(_swigobj) ((int ) _swigobj->iter)
XS(_wrap_lprec_iter_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_iter_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_iter_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_iter_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_total_iter_set(_swigobj,_swigval) (_swigobj->total_iter = _swigval,_swigval)
XS(_wrap_lprec_total_iter_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_total_iter_set(self,total_iter);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_total_iter_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_total_iter_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_total_iter_get(_swigobj) ((int ) _swigobj->total_iter)
XS(_wrap_lprec_total_iter_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_total_iter_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_total_iter_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_total_iter_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_max_level_set(_swigobj,_swigval) (_swigobj->max_level = _swigval,_swigval)
XS(_wrap_lprec_max_level_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_max_level_set(self,max_level);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_max_level_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_max_level_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_max_level_get(_swigobj) ((int ) _swigobj->max_level)
XS(_wrap_lprec_max_level_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_max_level_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_max_level_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_max_level_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_total_nodes_set(_swigobj,_swigval) (_swigobj->total_nodes = _swigval,_swigval)
XS(_wrap_lprec_total_nodes_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_total_nodes_set(self,total_nodes);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_total_nodes_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_total_nodes_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_total_nodes_get(_swigobj) ((int ) _swigobj->total_nodes)
XS(_wrap_lprec_total_nodes_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_total_nodes_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_total_nodes_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_total_nodes_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_solution_set(_swigobj,_swigval) (_swigobj->solution = _swigval,_swigval)
XS(_wrap_lprec_solution_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_solution_set(self,solution);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_solution_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_solution_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_solution_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_solution_get(_swigobj) ((double *) _swigobj->solution)
XS(_wrap_lprec_solution_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_solution_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_solution_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_solution_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_best_solution_set(_swigobj,_swigval) (_swigobj->best_solution = _swigval,_swigval)
XS(_wrap_lprec_best_solution_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_best_solution_set(self,best_solution);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_best_solution_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_best_solution_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_best_solution_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_best_solution_get(_swigobj) ((double *) _swigobj->best_solution)
XS(_wrap_lprec_best_solution_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_best_solution_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_best_solution_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_best_solution_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_duals_set(_swigobj,_swigval) (_swigobj->duals = _swigval,_swigval)
XS(_wrap_lprec_duals_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_duals_set(self,duals);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_duals_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_duals_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_duals_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_duals_get(_swigobj) ((double *) _swigobj->duals)
XS(_wrap_lprec_duals_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_duals_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_duals_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_duals_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_maximise_set(_swigobj,_swigval) (_swigobj->maximise = _swigval,_swigval)
XS(_wrap_lprec_maximise_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_maximise_set(self,maximise);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_maximise_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_maximise_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_maximise_get(_swigobj) ((short ) _swigobj->maximise)
XS(_wrap_lprec_maximise_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_maximise_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_maximise_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_maximise_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_floor_first_set(_swigobj,_swigval) (_swigobj->floor_first = _swigval,_swigval)
XS(_wrap_lprec_floor_first_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_floor_first_set(self,floor_first);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_floor_first_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_floor_first_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_floor_first_get(_swigobj) ((short ) _swigobj->floor_first)
XS(_wrap_lprec_floor_first_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_floor_first_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_floor_first_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_floor_first_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_ch_sign_set(_swigobj,_swigval) (_swigobj->ch_sign = _swigval,_swigval)
XS(_wrap_lprec_ch_sign_set) {

    short * _result;
    lprec * _arg0;
    short * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_ch_sign_set(self,ch_sign);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_ch_sign_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"shortPtr")) {
        croak("Type error in argument 2 of lprec_ch_sign_set. Expected shortPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_ch_sign_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_ch_sign_get(_swigobj) ((short *) _swigobj->ch_sign)
XS(_wrap_lprec_ch_sign_get) {

    short * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_ch_sign_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_ch_sign_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_ch_sign_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_scaling_used_set(_swigobj,_swigval) (_swigobj->scaling_used = _swigval,_swigval)
XS(_wrap_lprec_scaling_used_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_scaling_used_set(self,scaling_used);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_scaling_used_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_scaling_used_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_scaling_used_get(_swigobj) ((short ) _swigobj->scaling_used)
XS(_wrap_lprec_scaling_used_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_scaling_used_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_scaling_used_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_scaling_used_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_columns_scaled_set(_swigobj,_swigval) (_swigobj->columns_scaled = _swigval,_swigval)
XS(_wrap_lprec_columns_scaled_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_columns_scaled_set(self,columns_scaled);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_columns_scaled_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_columns_scaled_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_columns_scaled_get(_swigobj) ((short ) _swigobj->columns_scaled)
XS(_wrap_lprec_columns_scaled_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_columns_scaled_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_columns_scaled_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_columns_scaled_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_scale_set(_swigobj,_swigval) (_swigobj->scale = _swigval,_swigval)
XS(_wrap_lprec_scale_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_scale_set(self,scale);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_scale_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_scale_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_scale_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_scale_get(_swigobj) ((double *) _swigobj->scale)
XS(_wrap_lprec_scale_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_scale_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_scale_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_scale_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_nr_lagrange_set(_swigobj,_swigval) (_swigobj->nr_lagrange = _swigval,_swigval)
XS(_wrap_lprec_nr_lagrange_set) {

    int  _result;
    lprec * _arg0;
    int  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_nr_lagrange_set(self,nr_lagrange);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_nr_lagrange_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (int )SvIV(ST(1));
    _result = (int )lprec_nr_lagrange_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_nr_lagrange_get(_swigobj) ((int ) _swigobj->nr_lagrange)
XS(_wrap_lprec_nr_lagrange_get) {

    int  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_nr_lagrange_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_nr_lagrange_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (int )lprec_nr_lagrange_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_lag_row_set(_swigobj,_swigval) (_swigobj->lag_row = _swigval,_swigval)
XS(_wrap_lprec_lag_row_set) {

    double ** _result;
    lprec * _arg0;
    double ** _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lag_row_set(self,lag_row);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_row_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtrPtr")) {
        croak("Type error in argument 2 of lprec_lag_row_set. Expected doublePtrPtr.");
        XSRETURN(1);
    }
    _result = (double **)lprec_lag_row_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtrPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lag_row_get(_swigobj) ((double **) _swigobj->lag_row)
XS(_wrap_lprec_lag_row_get) {

    double ** _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lag_row_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_row_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double **)lprec_lag_row_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtrPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lag_rhs_set(_swigobj,_swigval) (_swigobj->lag_rhs = _swigval,_swigval)
XS(_wrap_lprec_lag_rhs_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lag_rhs_set(self,lag_rhs);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_rhs_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_lag_rhs_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_lag_rhs_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lag_rhs_get(_swigobj) ((double *) _swigobj->lag_rhs)
XS(_wrap_lprec_lag_rhs_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lag_rhs_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_rhs_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_lag_rhs_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lambda_set(_swigobj,_swigval) (_swigobj->lambda = _swigval,_swigval)
XS(_wrap_lprec_lambda_set) {

    double * _result;
    lprec * _arg0;
    double * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lambda_set(self,lambda);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lambda_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"doublePtr")) {
        croak("Type error in argument 2 of lprec_lambda_set. Expected doublePtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_lambda_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lambda_get(_swigobj) ((double *) _swigobj->lambda)
XS(_wrap_lprec_lambda_get) {

    double * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lambda_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lambda_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double *)lprec_lambda_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"doublePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lag_con_type_set(_swigobj,_swigval) (_swigobj->lag_con_type = _swigval,_swigval)
XS(_wrap_lprec_lag_con_type_set) {

    short * _result;
    lprec * _arg0;
    short * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lag_con_type_set(self,lag_con_type);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_con_type_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"shortPtr")) {
        croak("Type error in argument 2 of lprec_lag_con_type_set. Expected shortPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_lag_con_type_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lag_con_type_get(_swigobj) ((short *) _swigobj->lag_con_type)
XS(_wrap_lprec_lag_con_type_get) {

    short * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lag_con_type_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_con_type_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short *)lprec_lag_con_type_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"shortPtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_lag_bound_set(_swigobj,_swigval) (_swigobj->lag_bound = _swigval,_swigval)
XS(_wrap_lprec_lag_bound_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_lag_bound_set(self,lag_bound);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_bound_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_lag_bound_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_lag_bound_get(_swigobj) ((double ) _swigobj->lag_bound)
XS(_wrap_lprec_lag_bound_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_lag_bound_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_lag_bound_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_lag_bound_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_valid_set(_swigobj,_swigval) (_swigobj->valid = _swigval,_swigval)
XS(_wrap_lprec_valid_set) {

    short  _result;
    lprec * _arg0;
    short  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_valid_set(self,valid);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_valid_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (short )SvIV(ST(1));
    _result = (short )lprec_valid_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_valid_get(_swigobj) ((short ) _swigobj->valid)
XS(_wrap_lprec_valid_get) {

    short  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_valid_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_valid_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (short )lprec_valid_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setiv(ST(argvi++),(IV) _result);
    XSRETURN(argvi);
}

#define lprec_infinite_set(_swigobj,_swigval) (_swigobj->infinite = _swigval,_swigval)
XS(_wrap_lprec_infinite_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_infinite_set(self,infinite);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_infinite_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_infinite_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_infinite_get(_swigobj) ((double ) _swigobj->infinite)
XS(_wrap_lprec_infinite_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_infinite_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_infinite_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_infinite_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsilon_set(_swigobj,_swigval) (_swigobj->epsilon = _swigval,_swigval)
XS(_wrap_lprec_epsilon_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_epsilon_set(self,epsilon);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsilon_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_epsilon_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsilon_get(_swigobj) ((double ) _swigobj->epsilon)
XS(_wrap_lprec_epsilon_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_epsilon_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsilon_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_epsilon_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsb_set(_swigobj,_swigval) (_swigobj->epsb = _swigval,_swigval)
XS(_wrap_lprec_epsb_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_epsb_set(self,epsb);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsb_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_epsb_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsb_get(_swigobj) ((double ) _swigobj->epsb)
XS(_wrap_lprec_epsb_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_epsb_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsb_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_epsb_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsd_set(_swigobj,_swigval) (_swigobj->epsd = _swigval,_swigval)
XS(_wrap_lprec_epsd_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_epsd_set(self,epsd);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsd_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_epsd_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsd_get(_swigobj) ((double ) _swigobj->epsd)
XS(_wrap_lprec_epsd_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_epsd_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsd_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_epsd_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsel_set(_swigobj,_swigval) (_swigobj->epsel = _swigval,_swigval)
XS(_wrap_lprec_epsel_set) {

    double  _result;
    lprec * _arg0;
    double  _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_epsel_set(self,epsel);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsel_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    _arg1 = (double ) SvNV(ST(1));
    _result = (double )lprec_epsel_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_epsel_get(_swigobj) ((double ) _swigobj->epsel)
XS(_wrap_lprec_epsel_get) {

    double  _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_epsel_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_epsel_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (double )lprec_epsel_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setnv(ST(argvi++), (double) _result);
    XSRETURN(argvi);
}

#define lprec_rowname_hashtab_set(_swigobj,_swigval) (_swigobj->rowname_hashtab = _swigval,_swigval)
XS(_wrap_lprec_rowname_hashtab_set) {

    hashtable * _result;
    lprec * _arg0;
    hashtable * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_rowname_hashtab_set(self,rowname_hashtab);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rowname_hashtab_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"hashtablePtr")) {
        croak("Type error in argument 2 of lprec_rowname_hashtab_set. Expected hashtablePtr.");
        XSRETURN(1);
    }
    _result = (hashtable *)lprec_rowname_hashtab_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"hashtablePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_rowname_hashtab_get(_swigobj) ((hashtable *) _swigobj->rowname_hashtab)
XS(_wrap_lprec_rowname_hashtab_get) {

    hashtable * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_rowname_hashtab_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_rowname_hashtab_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (hashtable *)lprec_rowname_hashtab_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"hashtablePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_colname_hashtab_set(_swigobj,_swigval) (_swigobj->colname_hashtab = _swigval,_swigval)
XS(_wrap_lprec_colname_hashtab_set) {

    hashtable * _result;
    lprec * _arg0;
    hashtable * _arg1;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 2) || (items > 2)) 
        croak("Usage: lprec_colname_hashtab_set(self,colname_hashtab);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_colname_hashtab_set. Expected lprecPtr.");
        XSRETURN(1);
    }
    if (SWIG_GetPtr(ST(1),(void **) &_arg1,"hashtablePtr")) {
        croak("Type error in argument 2 of lprec_colname_hashtab_set. Expected hashtablePtr.");
        XSRETURN(1);
    }
    _result = (hashtable *)lprec_colname_hashtab_set(_arg0,_arg1);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"hashtablePtr", (void *) _result);
    XSRETURN(argvi);
}

#define lprec_colname_hashtab_get(_swigobj) ((hashtable *) _swigobj->colname_hashtab)
XS(_wrap_lprec_colname_hashtab_get) {

    hashtable * _result;
    lprec * _arg0;
    int argvi = 0;
    dXSARGS ;

    cv = cv;
    if ((items < 1) || (items > 1)) 
        croak("Usage: lprec_colname_hashtab_get(self);");
    if (SWIG_GetPtr(ST(0),(void **) &_arg0,"lprecPtr")) {
        croak("Type error in argument 1 of lprec_colname_hashtab_get. Expected lprecPtr.");
        XSRETURN(1);
    }
    _result = (hashtable *)lprec_colname_hashtab_get(_arg0);
    ST(argvi) = sv_newmortal();
    sv_setref_pv(ST(argvi++),"hashtablePtr", (void *) _result);
    XSRETURN(argvi);
}

/*
 * This table is used by the pointer type-checker
 */
static struct { char *n1; char *n2; void *(*pcnv)(void *); } _swig_mapping[] = {
    { "unsigned short","short",0},
    { "long","unsigned long",0},
    { "long","signed long",0},
    { "signed short","short",0},
    { "struct lprec","lprec",0},
    { "signed int","int",0},
    { "lprec","struct lprec",0},
    { "short","unsigned short",0},
    { "short","signed short",0},
    { "unsigned long","long",0},
    { "int","unsigned int",0},
    { "int","signed int",0},
    { "unsigned int","int",0},
    { "signed long","long",0},
{0,0,0}};

XS(_wrap_perl5_Math__LP__Solve_var_init) {
    dXSARGS;
    SV *sv;
    cv = cv; items = items;
    swig_setnv("Math::LP::Solve::DEF_INFINITE", (double) (1e24));
    swig_setiv("Math::LP::Solve::LE", (long) 0);
    swig_setiv("Math::LP::Solve::EQ", (long) 1);
    swig_setiv("Math::LP::Solve::GE", (long) 2);
    swig_setiv("Math::LP::Solve::OF", (long) 3);
    swig_setiv("Math::LP::Solve::FALSE", (long) 0);
    swig_setiv("Math::LP::Solve::TRUE", (long) 1);
    swig_setiv("Math::LP::Solve::OPTIMAL", (long) 0);
    swig_setiv("Math::LP::Solve::MILP_FAIL", (long) 1);
    swig_setiv("Math::LP::Solve::INFEASIBLE", (long) 2);
    swig_setiv("Math::LP::Solve::UNBOUNDED", (long) 3);
    swig_setiv("Math::LP::Solve::FAILURE", (long) 4);
    swig_setiv("Math::LP::Solve::RUNNING", (long) 5);
    swig_setiv("Math::LP::Solve::FEAS_FOUND", (long) 6);
    swig_setiv("Math::LP::Solve::NO_FEAS_FOUND", (long) 7);
    swig_setiv("Math::LP::Solve::BREAK_BB", (long) 8);
    XSRETURN(1);
}
#ifdef __cplusplus
extern "C"
#endif
XS(boot_Math__LP__Solve) {
	 dXSARGS;
	 char *file = __FILE__;
	 cv = cv; items = items;
	 newXS("Math::LP::Solve::var_Math__LP__Solve_init", _wrap_perl5_Math__LP__Solve_var_init, file);
	 newXS("Math::LP::Solve::ptrcast", _wrap_ptrcast, file);
	 newXS("Math::LP::Solve::ptrvalue", _wrap_ptrvalue, file);
	 newXS("Math::LP::Solve::ptrset", _wrap_ptrset, file);
	 newXS("Math::LP::Solve::ptrcreate", _wrap_ptrcreate, file);
	 newXS("Math::LP::Solve::ptrfree", _wrap_ptrfree, file);
	 newXS("Math::LP::Solve::ptradd", _wrap_ptradd, file);
	 newXS("Math::LP::Solve::ptrmap", _wrap_ptrmap, file);
	 newXS("Math::LP::Solve::make_lp", _wrap_make_lp, file);
	 newXS("Math::LP::Solve::read_lp_file", _wrap_read_lp_file, file);
	 newXS("Math::LP::Solve::delete_lp", _wrap_delete_lp, file);
	 newXS("Math::LP::Solve::copy_lp", _wrap_copy_lp, file);
	 newXS("Math::LP::Solve::set_mat", _wrap_set_mat, file);
	 newXS("Math::LP::Solve::set_obj_fn", _wrap_set_obj_fn, file);
	 newXS("Math::LP::Solve::str_set_obj_fn", _wrap_str_set_obj_fn, file);
	 newXS("Math::LP::Solve::add_constraint", _wrap_add_constraint, file);
	 newXS("Math::LP::Solve::str_add_constraint", _wrap_str_add_constraint, file);
	 newXS("Math::LP::Solve::del_constraint", _wrap_del_constraint, file);
	 newXS("Math::LP::Solve::add_lag_con", _wrap_add_lag_con, file);
	 newXS("Math::LP::Solve::str_add_lag_con", _wrap_str_add_lag_con, file);
	 newXS("Math::LP::Solve::add_column", _wrap_add_column, file);
	 newXS("Math::LP::Solve::str_add_column", _wrap_str_add_column, file);
	 newXS("Math::LP::Solve::del_column", _wrap_del_column, file);
	 newXS("Math::LP::Solve::set_upbo", _wrap_set_upbo, file);
	 newXS("Math::LP::Solve::set_lowbo", _wrap_set_lowbo, file);
	 newXS("Math::LP::Solve::set_int", _wrap_set_int, file);
	 newXS("Math::LP::Solve::set_rh", _wrap_set_rh, file);
	 newXS("Math::LP::Solve::set_rh_vec", _wrap_set_rh_vec, file);
	 newXS("Math::LP::Solve::str_set_rh_vec", _wrap_str_set_rh_vec, file);
	 newXS("Math::LP::Solve::set_maxim", _wrap_set_maxim, file);
	 newXS("Math::LP::Solve::set_minim", _wrap_set_minim, file);
	 newXS("Math::LP::Solve::set_constr_type", _wrap_set_constr_type, file);
	 newXS("Math::LP::Solve::set_row_name", _wrap_set_row_name, file);
	 newXS("Math::LP::Solve::set_col_name", _wrap_set_col_name, file);
	 newXS("Math::LP::Solve::auto_scale", _wrap_auto_scale, file);
	 newXS("Math::LP::Solve::unscale", _wrap_unscale, file);
	 newXS("Math::LP::Solve::solve", _wrap_solve, file);
	 newXS("Math::LP::Solve::lag_solve", _wrap_lag_solve, file);
	 newXS("Math::LP::Solve::reset_basis", _wrap_reset_basis, file);
	 newXS("Math::LP::Solve::mat_elm", _wrap_mat_elm, file);
	 newXS("Math::LP::Solve::get_row", _wrap_get_row, file);
	 newXS("Math::LP::Solve::get_column", _wrap_get_column, file);
	 newXS("Math::LP::Solve::get_reduced_costs", _wrap_get_reduced_costs, file);
	 newXS("Math::LP::Solve::is_feasible", _wrap_is_feasible, file);
	 newXS("Math::LP::Solve::column_in_lp", _wrap_column_in_lp, file);
	 newXS("Math::LP::Solve::read_mps", _wrap_read_mps, file);
	 newXS("Math::LP::Solve::write_MPS", _wrap_write_MPS, file);
	 newXS("Math::LP::Solve::write_LP", _wrap_write_LP, file);
	 newXS("Math::LP::Solve::print_lp", _wrap_print_lp, file);
	 newXS("Math::LP::Solve::print_solution", _wrap_print_solution, file);
	 newXS("Math::LP::Solve::print_duals", _wrap_print_duals, file);
	 newXS("Math::LP::Solve::print_scales", _wrap_print_scales, file);
	 newXS("Math::LP::Solve::lprec_lp_name_get", _wrap_lprec_lp_name_get, file);
	 newXS("Math::LP::Solve::lprec_lp_name_set", _wrap_lprec_lp_name_set, file);
	 newXS("Math::LP::Solve::lprec_row_name_get", _wrap_lprec_row_name_get, file);
	 newXS("Math::LP::Solve::lprec_row_name_set", _wrap_lprec_row_name_set, file);
	 newXS("Math::LP::Solve::lprec_col_name_get", _wrap_lprec_col_name_get, file);
	 newXS("Math::LP::Solve::lprec_col_name_set", _wrap_lprec_col_name_set, file);
	 newXS("Math::LP::Solve::open_file", _wrap_open_file, file);
	 newXS("Math::LP::Solve::close_file", _wrap_close_file, file);
	 newXS("Math::LP::Solve::lprec_verbose_set", _wrap_lprec_verbose_set, file);
	 newXS("Math::LP::Solve::lprec_verbose_get", _wrap_lprec_verbose_get, file);
	 newXS("Math::LP::Solve::lprec_print_duals_set", _wrap_lprec_print_duals_set, file);
	 newXS("Math::LP::Solve::lprec_print_duals_get", _wrap_lprec_print_duals_get, file);
	 newXS("Math::LP::Solve::lprec_print_sol_set", _wrap_lprec_print_sol_set, file);
	 newXS("Math::LP::Solve::lprec_print_sol_get", _wrap_lprec_print_sol_get, file);
	 newXS("Math::LP::Solve::lprec_debug_set", _wrap_lprec_debug_set, file);
	 newXS("Math::LP::Solve::lprec_debug_get", _wrap_lprec_debug_get, file);
	 newXS("Math::LP::Solve::lprec_print_at_invert_set", _wrap_lprec_print_at_invert_set, file);
	 newXS("Math::LP::Solve::lprec_print_at_invert_get", _wrap_lprec_print_at_invert_get, file);
	 newXS("Math::LP::Solve::lprec_trace_set", _wrap_lprec_trace_set, file);
	 newXS("Math::LP::Solve::lprec_trace_get", _wrap_lprec_trace_get, file);
	 newXS("Math::LP::Solve::lprec_anti_degen_set", _wrap_lprec_anti_degen_set, file);
	 newXS("Math::LP::Solve::lprec_anti_degen_get", _wrap_lprec_anti_degen_get, file);
	 newXS("Math::LP::Solve::lprec_do_presolve_set", _wrap_lprec_do_presolve_set, file);
	 newXS("Math::LP::Solve::lprec_do_presolve_get", _wrap_lprec_do_presolve_get, file);
	 newXS("Math::LP::Solve::lprec_rows_set", _wrap_lprec_rows_set, file);
	 newXS("Math::LP::Solve::lprec_rows_get", _wrap_lprec_rows_get, file);
	 newXS("Math::LP::Solve::lprec_rows_alloc_set", _wrap_lprec_rows_alloc_set, file);
	 newXS("Math::LP::Solve::lprec_rows_alloc_get", _wrap_lprec_rows_alloc_get, file);
	 newXS("Math::LP::Solve::lprec_columns_set", _wrap_lprec_columns_set, file);
	 newXS("Math::LP::Solve::lprec_columns_get", _wrap_lprec_columns_get, file);
	 newXS("Math::LP::Solve::lprec_columns_alloc_set", _wrap_lprec_columns_alloc_set, file);
	 newXS("Math::LP::Solve::lprec_columns_alloc_get", _wrap_lprec_columns_alloc_get, file);
	 newXS("Math::LP::Solve::lprec_sum_set", _wrap_lprec_sum_set, file);
	 newXS("Math::LP::Solve::lprec_sum_get", _wrap_lprec_sum_get, file);
	 newXS("Math::LP::Solve::lprec_sum_alloc_set", _wrap_lprec_sum_alloc_set, file);
	 newXS("Math::LP::Solve::lprec_sum_alloc_get", _wrap_lprec_sum_alloc_get, file);
	 newXS("Math::LP::Solve::lprec_names_used_set", _wrap_lprec_names_used_set, file);
	 newXS("Math::LP::Solve::lprec_names_used_get", _wrap_lprec_names_used_get, file);
	 newXS("Math::LP::Solve::lprec_non_zeros_set", _wrap_lprec_non_zeros_set, file);
	 newXS("Math::LP::Solve::lprec_non_zeros_get", _wrap_lprec_non_zeros_get, file);
	 newXS("Math::LP::Solve::lprec_mat_alloc_set", _wrap_lprec_mat_alloc_set, file);
	 newXS("Math::LP::Solve::lprec_mat_alloc_get", _wrap_lprec_mat_alloc_get, file);
	 newXS("Math::LP::Solve::lprec_mat_set", _wrap_lprec_mat_set, file);
	 newXS("Math::LP::Solve::lprec_mat_get", _wrap_lprec_mat_get, file);
	 newXS("Math::LP::Solve::lprec_col_end_set", _wrap_lprec_col_end_set, file);
	 newXS("Math::LP::Solve::lprec_col_end_get", _wrap_lprec_col_end_get, file);
	 newXS("Math::LP::Solve::lprec_col_no_set", _wrap_lprec_col_no_set, file);
	 newXS("Math::LP::Solve::lprec_col_no_get", _wrap_lprec_col_no_get, file);
	 newXS("Math::LP::Solve::lprec_row_end_valid_set", _wrap_lprec_row_end_valid_set, file);
	 newXS("Math::LP::Solve::lprec_row_end_valid_get", _wrap_lprec_row_end_valid_get, file);
	 newXS("Math::LP::Solve::lprec_row_end_set", _wrap_lprec_row_end_set, file);
	 newXS("Math::LP::Solve::lprec_row_end_get", _wrap_lprec_row_end_get, file);
	 newXS("Math::LP::Solve::lprec_orig_rh_set", _wrap_lprec_orig_rh_set, file);
	 newXS("Math::LP::Solve::lprec_orig_rh_get", _wrap_lprec_orig_rh_get, file);
	 newXS("Math::LP::Solve::lprec_rh_set", _wrap_lprec_rh_set, file);
	 newXS("Math::LP::Solve::lprec_rh_get", _wrap_lprec_rh_get, file);
	 newXS("Math::LP::Solve::lprec_rhs_set", _wrap_lprec_rhs_set, file);
	 newXS("Math::LP::Solve::lprec_rhs_get", _wrap_lprec_rhs_get, file);
	 newXS("Math::LP::Solve::lprec_must_be_int_set", _wrap_lprec_must_be_int_set, file);
	 newXS("Math::LP::Solve::lprec_must_be_int_get", _wrap_lprec_must_be_int_get, file);
	 newXS("Math::LP::Solve::lprec_orig_upbo_set", _wrap_lprec_orig_upbo_set, file);
	 newXS("Math::LP::Solve::lprec_orig_upbo_get", _wrap_lprec_orig_upbo_get, file);
	 newXS("Math::LP::Solve::lprec_orig_lowbo_set", _wrap_lprec_orig_lowbo_set, file);
	 newXS("Math::LP::Solve::lprec_orig_lowbo_get", _wrap_lprec_orig_lowbo_get, file);
	 newXS("Math::LP::Solve::lprec_upbo_set", _wrap_lprec_upbo_set, file);
	 newXS("Math::LP::Solve::lprec_upbo_get", _wrap_lprec_upbo_get, file);
	 newXS("Math::LP::Solve::lprec_lowbo_set", _wrap_lprec_lowbo_set, file);
	 newXS("Math::LP::Solve::lprec_lowbo_get", _wrap_lprec_lowbo_get, file);
	 newXS("Math::LP::Solve::lprec_basis_valid_set", _wrap_lprec_basis_valid_set, file);
	 newXS("Math::LP::Solve::lprec_basis_valid_get", _wrap_lprec_basis_valid_get, file);
	 newXS("Math::LP::Solve::lprec_bas_set", _wrap_lprec_bas_set, file);
	 newXS("Math::LP::Solve::lprec_bas_get", _wrap_lprec_bas_get, file);
	 newXS("Math::LP::Solve::lprec_basis_set", _wrap_lprec_basis_set, file);
	 newXS("Math::LP::Solve::lprec_basis_get", _wrap_lprec_basis_get, file);
	 newXS("Math::LP::Solve::lprec_lower_set", _wrap_lprec_lower_set, file);
	 newXS("Math::LP::Solve::lprec_lower_get", _wrap_lprec_lower_get, file);
	 newXS("Math::LP::Solve::lprec_eta_valid_set", _wrap_lprec_eta_valid_set, file);
	 newXS("Math::LP::Solve::lprec_eta_valid_get", _wrap_lprec_eta_valid_get, file);
	 newXS("Math::LP::Solve::lprec_eta_alloc_set", _wrap_lprec_eta_alloc_set, file);
	 newXS("Math::LP::Solve::lprec_eta_alloc_get", _wrap_lprec_eta_alloc_get, file);
	 newXS("Math::LP::Solve::lprec_eta_size_set", _wrap_lprec_eta_size_set, file);
	 newXS("Math::LP::Solve::lprec_eta_size_get", _wrap_lprec_eta_size_get, file);
	 newXS("Math::LP::Solve::lprec_num_inv_set", _wrap_lprec_num_inv_set, file);
	 newXS("Math::LP::Solve::lprec_num_inv_get", _wrap_lprec_num_inv_get, file);
	 newXS("Math::LP::Solve::lprec_max_num_inv_set", _wrap_lprec_max_num_inv_set, file);
	 newXS("Math::LP::Solve::lprec_max_num_inv_get", _wrap_lprec_max_num_inv_get, file);
	 newXS("Math::LP::Solve::lprec_eta_value_set", _wrap_lprec_eta_value_set, file);
	 newXS("Math::LP::Solve::lprec_eta_value_get", _wrap_lprec_eta_value_get, file);
	 newXS("Math::LP::Solve::lprec_eta_row_nr_set", _wrap_lprec_eta_row_nr_set, file);
	 newXS("Math::LP::Solve::lprec_eta_row_nr_get", _wrap_lprec_eta_row_nr_get, file);
	 newXS("Math::LP::Solve::lprec_eta_col_end_set", _wrap_lprec_eta_col_end_set, file);
	 newXS("Math::LP::Solve::lprec_eta_col_end_get", _wrap_lprec_eta_col_end_get, file);
	 newXS("Math::LP::Solve::lprec_bb_rule_set", _wrap_lprec_bb_rule_set, file);
	 newXS("Math::LP::Solve::lprec_bb_rule_get", _wrap_lprec_bb_rule_get, file);
	 newXS("Math::LP::Solve::lprec_break_at_int_set", _wrap_lprec_break_at_int_set, file);
	 newXS("Math::LP::Solve::lprec_break_at_int_get", _wrap_lprec_break_at_int_get, file);
	 newXS("Math::LP::Solve::lprec_break_value_set", _wrap_lprec_break_value_set, file);
	 newXS("Math::LP::Solve::lprec_break_value_get", _wrap_lprec_break_value_get, file);
	 newXS("Math::LP::Solve::lprec_obj_bound_set", _wrap_lprec_obj_bound_set, file);
	 newXS("Math::LP::Solve::lprec_obj_bound_get", _wrap_lprec_obj_bound_get, file);
	 newXS("Math::LP::Solve::lprec_iter_set", _wrap_lprec_iter_set, file);
	 newXS("Math::LP::Solve::lprec_iter_get", _wrap_lprec_iter_get, file);
	 newXS("Math::LP::Solve::lprec_total_iter_set", _wrap_lprec_total_iter_set, file);
	 newXS("Math::LP::Solve::lprec_total_iter_get", _wrap_lprec_total_iter_get, file);
	 newXS("Math::LP::Solve::lprec_max_level_set", _wrap_lprec_max_level_set, file);
	 newXS("Math::LP::Solve::lprec_max_level_get", _wrap_lprec_max_level_get, file);
	 newXS("Math::LP::Solve::lprec_total_nodes_set", _wrap_lprec_total_nodes_set, file);
	 newXS("Math::LP::Solve::lprec_total_nodes_get", _wrap_lprec_total_nodes_get, file);
	 newXS("Math::LP::Solve::lprec_solution_set", _wrap_lprec_solution_set, file);
	 newXS("Math::LP::Solve::lprec_solution_get", _wrap_lprec_solution_get, file);
	 newXS("Math::LP::Solve::lprec_best_solution_set", _wrap_lprec_best_solution_set, file);
	 newXS("Math::LP::Solve::lprec_best_solution_get", _wrap_lprec_best_solution_get, file);
	 newXS("Math::LP::Solve::lprec_duals_set", _wrap_lprec_duals_set, file);
	 newXS("Math::LP::Solve::lprec_duals_get", _wrap_lprec_duals_get, file);
	 newXS("Math::LP::Solve::lprec_maximise_set", _wrap_lprec_maximise_set, file);
	 newXS("Math::LP::Solve::lprec_maximise_get", _wrap_lprec_maximise_get, file);
	 newXS("Math::LP::Solve::lprec_floor_first_set", _wrap_lprec_floor_first_set, file);
	 newXS("Math::LP::Solve::lprec_floor_first_get", _wrap_lprec_floor_first_get, file);
	 newXS("Math::LP::Solve::lprec_ch_sign_set", _wrap_lprec_ch_sign_set, file);
	 newXS("Math::LP::Solve::lprec_ch_sign_get", _wrap_lprec_ch_sign_get, file);
	 newXS("Math::LP::Solve::lprec_scaling_used_set", _wrap_lprec_scaling_used_set, file);
	 newXS("Math::LP::Solve::lprec_scaling_used_get", _wrap_lprec_scaling_used_get, file);
	 newXS("Math::LP::Solve::lprec_columns_scaled_set", _wrap_lprec_columns_scaled_set, file);
	 newXS("Math::LP::Solve::lprec_columns_scaled_get", _wrap_lprec_columns_scaled_get, file);
	 newXS("Math::LP::Solve::lprec_scale_set", _wrap_lprec_scale_set, file);
	 newXS("Math::LP::Solve::lprec_scale_get", _wrap_lprec_scale_get, file);
	 newXS("Math::LP::Solve::lprec_nr_lagrange_set", _wrap_lprec_nr_lagrange_set, file);
	 newXS("Math::LP::Solve::lprec_nr_lagrange_get", _wrap_lprec_nr_lagrange_get, file);
	 newXS("Math::LP::Solve::lprec_lag_row_set", _wrap_lprec_lag_row_set, file);
	 newXS("Math::LP::Solve::lprec_lag_row_get", _wrap_lprec_lag_row_get, file);
	 newXS("Math::LP::Solve::lprec_lag_rhs_set", _wrap_lprec_lag_rhs_set, file);
	 newXS("Math::LP::Solve::lprec_lag_rhs_get", _wrap_lprec_lag_rhs_get, file);
	 newXS("Math::LP::Solve::lprec_lambda_set", _wrap_lprec_lambda_set, file);
	 newXS("Math::LP::Solve::lprec_lambda_get", _wrap_lprec_lambda_get, file);
	 newXS("Math::LP::Solve::lprec_lag_con_type_set", _wrap_lprec_lag_con_type_set, file);
	 newXS("Math::LP::Solve::lprec_lag_con_type_get", _wrap_lprec_lag_con_type_get, file);
	 newXS("Math::LP::Solve::lprec_lag_bound_set", _wrap_lprec_lag_bound_set, file);
	 newXS("Math::LP::Solve::lprec_lag_bound_get", _wrap_lprec_lag_bound_get, file);
	 newXS("Math::LP::Solve::lprec_valid_set", _wrap_lprec_valid_set, file);
	 newXS("Math::LP::Solve::lprec_valid_get", _wrap_lprec_valid_get, file);
	 newXS("Math::LP::Solve::lprec_infinite_set", _wrap_lprec_infinite_set, file);
	 newXS("Math::LP::Solve::lprec_infinite_get", _wrap_lprec_infinite_get, file);
	 newXS("Math::LP::Solve::lprec_epsilon_set", _wrap_lprec_epsilon_set, file);
	 newXS("Math::LP::Solve::lprec_epsilon_get", _wrap_lprec_epsilon_get, file);
	 newXS("Math::LP::Solve::lprec_epsb_set", _wrap_lprec_epsb_set, file);
	 newXS("Math::LP::Solve::lprec_epsb_get", _wrap_lprec_epsb_get, file);
	 newXS("Math::LP::Solve::lprec_epsd_set", _wrap_lprec_epsd_set, file);
	 newXS("Math::LP::Solve::lprec_epsd_get", _wrap_lprec_epsd_get, file);
	 newXS("Math::LP::Solve::lprec_epsel_set", _wrap_lprec_epsel_set, file);
	 newXS("Math::LP::Solve::lprec_epsel_get", _wrap_lprec_epsel_get, file);
	 newXS("Math::LP::Solve::lprec_rowname_hashtab_set", _wrap_lprec_rowname_hashtab_set, file);
	 newXS("Math::LP::Solve::lprec_rowname_hashtab_get", _wrap_lprec_rowname_hashtab_get, file);
	 newXS("Math::LP::Solve::lprec_colname_hashtab_set", _wrap_lprec_colname_hashtab_set, file);
	 newXS("Math::LP::Solve::lprec_colname_hashtab_get", _wrap_lprec_colname_hashtab_get, file);
{
   int i;
   for (i = 0; _swig_mapping[i].n1; i++)
        SWIG_RegisterMapping(_swig_mapping[i].n1,_swig_mapping[i].n2,_swig_mapping[i].pcnv);
}
	 ST(0) = &PL_sv_yes;
	 XSRETURN(1);
}
