<?php
/**
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Pierre Spring <pierre.spring@liip.ch>
 */
 
// must be run within Dokuwiki
if (!defined('DOKU_INC')) die();
 
class helper_plugin_fckg extends DokuWiki_Plugin {
 
  function getInfo(){
    return array(
      'author' => 'pierre spring, modified by Myron Turner',
      'email'  => 'pierre.spring@liip.ch',
      'date'   => '2007-05-15',
      'name'   => 'FCKW Plugin/FCKG',
      'desc'   => 'Various Helper Functions',
      'url'    => 'https://fosswiki.liip.ch/display/FCKW/Home',
    );
  }
 
  function getMethods(){
    $result = array();
    $result[] = array(
      'name'   => 'registerOnLoad',
      'desc'   => 'register some javascript to the window.onload js event',
      'params' => array('js' => 'string'),
      'return' => array('html' => 'string'),
    );
    return $result;
  }

  function registerOnLoad($js){
  global $ID;
  $media_tmp_ns = preg_match('/:/',$ID) ? preg_replace('/:\w+$/',"",$ID,1) : "";    
  $locktimer_msg = "Your lock for editing this page is about to expire in a minute\\n"
                . "\\nIf you have the necessary permissions you can \\n"
                . "disable the lock timer by checking off the lock timer unset box.\\n"  
                . "Otherwise you should click Save and then Edit.";

    return <<<end_of_string

<script type='text/javascript'>

var oldonload = window.onload;

if (typeof window.onload != 'function') {
  window.onload = function(){
    $js
    locktimer.old_reset = locktimer.reset;
    locktimer.old_warning = locktimer.warning;
    locktimer.msg = "$locktimer_msg";
  }
} else {
  window.onload = function() 
  {
    oldonload();
    $js  
    locktimer.old_reset = locktimer.reset;
    locktimer.old_warning = locktimer.warning;
    locktimer.msg = "$locktimer_msg";
  }
}

  function getCurrentWikiNS() {
        var DWikiMediaManagerCommand_ns = '$media_tmp_ns';
        return DWikiMediaManagerCommand_ns;
  }

 function unsetDokuWikiLockTimer() {
    locktimer.reset = function(){
        locktimer.clear();
    };

     locktimer.warning = function(){
        locktimer.clear();      
     };


   }
    

 function resetDokuWikiLockTimer() {
  if(locktimer.reset == locktimer.old_reset) {
        unsetDokuWikiLockTimer();
        return; 
  }
  locktimer.reset = locktimer.old_reset;
  locktimer.warning = locktimer.old_warning;
  locktimer.reset();
 }

</script>
end_of_string;
  }
}
?>
