#!/usr/bin/perl
#
# all-in-one, no frills, just the information you need, web page for mon
#
# If you want an interactive version with buttons and stuff, you want
# to use Art Chan's package!
#
# To configure, adjust $MONSERVER, $MONPORT, $IMG, and $REFRESH below.
# 
# Jim Trocki, trockij@transmeta.com
#
# $Id: opstatus.cgi,v 1.15 1999/06/17 18:06:48 trockij Exp $
#
#    Copyright (C) 1998, Jim Trocki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
use Mon::Client;
use Text::ParseWords;

#
# CONFIGURE THESE:
#
$MONSERVER="localhost";
#$MONPORT=2583;
$IMG="company-logo.gif";
$REFRESH=480;

$WORD = '[a-zA-Z0-9_-]+';
$SIG{'PIPE'} = 'IGNORE';
#
# operational statuses
#
%OPSTAT = %Mon::Client::OPSTAT;

$time = time;
$localtime = localtime(time);

$| = 1;

%clientargs = ();

if ($MONPORT) {
    $clientargs{"port"} = $MONPORT;
}

if ($MONSERVER ne "") {
    $clientargs{"host"} = $MONSERVER;
}

$c = new Mon::Client (%clientargs);

if ($MONSERVER eq "") {
    $MONSERVER = $c->host;
}

$c->connect;

if ($c->error ne "") {
    &html_die ("could not connect: " . $c->error . "\n");
}

#
# scheduler state
#
($sch_status, $sch_stopped) = $c->list_state();

if ($c->error ne "") {
    &html_die ("oops--unexpected error getting state: " . $c->error . "\n");
}

if ($sch_status == 0) {
    $STATE_LINE = "Scheduler status: <font color=#ff4040> scheduler stopped since " .
	localtime ($sch_stopped) . "</font>";
} else {
    $STATE_LINE = "Scheduler status: running";
}

#
# get what is disabled
#
%disabled = $c->list_disabled;

if ($c->error ne "") {
    &html_die ("oops--unexpected error getting disabled: " . $c->error . "\n");
}

#
# get the current operational status
#
%opstat = $c->list_opstatus;

if ($c->error ne "") {
    &html_die ("oops--unexpected error getting opstatus: " . $c->error . "\n");
}

foreach my $group (keys %opstat) {
    foreach my $service (keys %{$opstat{$group}}) {

	if (defined $disabled{"watches"}->{$group}) {
	    push (@dis_watch, \%{$opstat{$group}->{$service}});
	    next;

	} elsif (defined $disabled{"services"}->{$group}->{$service}) {
	    push (@dis_service, \%{$opstat{$group}->{$service}});
	    next;

	} elsif ($opstat{$group}->{$service}->{"opstatus"} == $OPSTAT{"ok"}) {
	    push (@op, \%{$opstat{$group}->{$service}});
	    next;

	} elsif ($opstat{$group}->{$service}->{"opstatus"} == $OPSTAT{"untested"}) {
	    push (@untested, \%{$opstat{$group}->{$service}});
	    next;

	} elsif ($opstat{$group}->{$service}->{"opstatus"} == $OPSTAT{"fail"}) {
	    push (@failures, \%{$opstat{$group}->{$service}});
	    next;

	} elsif ($opstat{$group}->{$service}->{"opstatus"} == $OPSTAT{"dependency"}) {
	    push (@depend, \%{$opstat{$group}->{$service}});
	    next;

	} else {
	    push (@other, \%{$opstat{$group}->{$service}});
	    next;
	}
    }
}


#
# get the group members
#
%groups = ();
foreach $i (@failures, @dis_watch, @dis_service, @depend, @untested, @other, @op) {

    next if (defined $groups{$i->{"group"}});

    my @l = $c->list_group ($i->{"group"});

    if ($c->error ne "") {
	&html_die ("oops--unexpected error getting group members: " . $c->error . "\n");
    }

    $groups{$i->{"group"}} = [@l];
}

#
# all done
#
$c->quit;

if ($c->error ne "") {
    &html_die ("oops--unexpected error quitting: " . $c->error . "\n");
}


#
# display the table
#
my %displayed = ();

print <<EOF;
Content-type: text/html

<HTML>

<meta http-equiv="Refresh" content=480>

<head>
<title> Mon Operational Status </title>
</head>

<body bgcolor="#e1e1e1">
<center>
<img src="$IMG" alt="Company Logo">
</center>

<em>This page will refresh in 8 minutes.</em>
<p>

Current operating status for mon server, running on host $MONSERVER, as of $localtime
<p>

$STATE_LINE
<p>

<font color=#0000ff>blue</font> means disabled watches, services, or hosts<br>
<font color=#ff4040>red</font> means a failure for a particular service
<p>

<table cellpadding=2 cellspacing=1 bgcolor="#CCCCCC">
<th>Group <th>Service <th>Member Hosts <th> Last check <th> Next check <th> Status

EOF

#
# show list of hosts
#
foreach $l (sort { $a{group} <=> $b{group} } (@failures),
	    sort { $a{group} <=> $b{group} } (@dis_watch),
	    sort { $a{group} <=> $b{group} } (@dis_service),
	    sort { $a{group} <=> $b{group} } (@depend),
	    sort { $a{group} <=> $b{group} } (@untested),
	    sort { $a{group} <=> $b{group} } (@other),
	    sort { $a{group} <=> $b{group} } (@op)) {

    &display ($l);
}

print <<EOF;
</table>
</HTML>
EOF
exit;


#
# display a row in HTML
#
sub display {
    my $l = shift;

    $l->{"last_summary"} = "(untested)"
	    if ($l->{"opstatus"} == $OPSTAT{"untested"});

    $l->{"last_summary"} = "(succeeded)"
	    if ($l->{"opstatus"} == $OPSTAT{"ok"});

    $l->{"last_summary"} = "(dependency)"
	    if ($l->{"opstatus"} == $OPSTAT{"dependency"});

    #
    # display group members in only one row
    #
    my $g = "";
    if ($displayed{$l->{"group"}} == 1) {
    	$g = "<pre> </pre>";

    } else {
	$displayed{$l->{"group"}} = 1;

	foreach my $h (@{$groups{$l->{"group"}}}) {
	    $h =~ s{\*}{}g;
	    if ($disabled{"hosts"}->{$l->{"group"}}->{$h}) {
		$g .= "<font color=#0000ff>$h</font> ";
	    } else {
		$g .= "$h ";
	    }
	}
    }

    my $last_check = $l->{"last_check"};
    my $last_check_fmt = sprintf ("%02d:%02d",
    		(localtime($last_check))[2,1]);

    my $next_check_fmt;
    if ($l->{"monitor"} ne "") {
	$next_check_fmt = sprintf ("%02d:%02d",
		(localtime ($time + $l->{"timer"}))[2,1]);

    } else {
    	$next_check_fmt = "(not polling)";
    }

    if ($disabled{"watches"}->{$l->{"group"}} == 1) {
    	$wcolor = "bgcolor=#a0a0ff";
    	$gcolor = "bgcolor=#a0a0ff";
	$scolor = "bgcolor=#a0a0ff";
    	$t1color = "bgcolor=#a0a0ff";
    	$t2color = "bgcolor=#a0a0ff";
    	$ocolor = "bgcolor=#a0a0ff";

    } else {
    	$wcolor = "";
	if ($disabled{"services"}->{$l->{"group"}}->{$l->{"service"}} == 1) {
	    $wcolor  = "bgcolor=#a0a0ff";
	    $gcolor  = "bgcolor=#a0a0ff";
	    $scolor  = "bgcolor=#a0a0ff";
	    $t1color = "bgcolor=#a0a0ff";
	    $t2color = "bgcolor=#a0a0ff";
	    $ocolor  = "bgcolor=#a0a0ff";

	} elsif ($l->{"opstatus"} == $OPSTAT{"fail"}) {
	    $wcolor = "bgcolor=#ff4040";
	    $gcolor = "bgcolor=#ff4040";
	    $scolor = "bgcolor=#ff4040";
	    $t1color = "bgcolor=#ff4040";
	    $t2color = "bgcolor=#ff4040";
	    $ocolor = "bgcolor=#ff4040";

	} elsif ($l->{"opstatus"} == $OPSTAT{"dependency"}) {
	    $wcolor  = "bgcolor=#909090";
	    $scolor  = "bgcolor=#909090";
	    $gcolor  = "bgcolor=#909090";
	    $t1color = "bgcolor=#909090";
	    $t2color = "bgcolor=#909090";
	    $ocolor  = "bgcolor=#909090";

	} else {
	    $wcolor = "";
	    $scolor = "";
	    $gcolor = "";
	    $t1color = "";
	    $t2color = "";
	    $ocolor = "";
	}
    }

    my $sum = $l->{"last_summary"};
    if ($l->{"last_summary"} =~ /^\s*$/) {
    	$sum = "<pre> </pre>";
    }

    print "<TR>";
    print "<TD align=center $wcolor> $l->{group}";
    print "<TD align=center $scolor> $l->{service}";
    print "<TD align=center $gcolor> $g";

    if ($last_check == 0) {
    	print "<td align=center $t1color> undefined";
    } else {
    	printf ("<td align=center $t1color> $last_check_fmt");
    }

    print "<td align=center $t2color> $next_check_fmt";

    print "<td align=center $ocolor> $sum\n";
}


#
# die with some HTML output
#
sub html_die {
    my ($str) = @_;
    print <<EOF;
Content-Type: text/html

<html>
<head>
<title> opstatus failure </title>
</head>
<pre>

opstatus failed with the following diagnostics:

$str

</pre>
</body>
</html>
EOF
    exit(1);
}
