#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::SiteIDFilterCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SiteIDFilterCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::SiteIDFilterCodeType

=head1 DESCRIPTION

Site criteria for filtering search results. The site value is determined by the
site specified in the request (the site ID in the SOAP URL or, for Unified
Schema XML requests, the site ID in the X-EBAY-API-SITEID HTTP Header).



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 ListedInCurrencyImplied

(in) Items listed in the currency implied by the site specified in the
request.



=cut


use constant ListedInCurrencyImplied => scalar('ListedInCurrencyImplied');


=head2 LocatedInCountryImplied

(in) Items located in the country implied by the site specified in the
request.



=cut


use constant LocatedInCountryImplied => scalar('LocatedInCountryImplied');


=head2 AvailableInCountryImplied

(in) Items available to the country implied by the site specified in the
request. For the US site, this implies listings from ALL English-language
countries that are available to the US.



=cut


use constant AvailableInCountryImplied => scalar('AvailableInCountryImplied');


=head2 SiteImplied

(in) Items listed on the site specified in the request, regardless of listing
currency.



=cut


use constant SiteImplied => scalar('SiteImplied');


=head2 BelgiumListing

(in) Items located in Belgium or listed on one of the two Belgian sites.



=cut


use constant BelgiumListing => scalar('BelgiumListing');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
