/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.expression;

import gnu.trove.TLinkableAdaptor;
import opennlp.common.unify.Substitution;
import opennlp.common.unify.Unifiable;
import opennlp.common.unify.UnifyFailure;
import opennlp.common.unify.Variable;
import opennlp.grok.expression.SlashMode;
import org.jdom.Element;

public final class Slash
extends TLinkableAdaptor
implements Unifiable {
    public static final byte L = 0;
    public static final byte B = 1;
    public static final byte R = 2;
    private final byte _dir;
    private final SlashMode _mode;

    public Slash(Element el) {
        String m;
        String d = el.getAttributeValue("d");
        if (d == null) {
            d = "|";
        }
        this._mode = (m = el.getAttributeValue("m")) == null ? new SlashMode() : new SlashMode(m.charAt(1));
        this._dir = Slash.encode(d.charAt(0));
    }

    public Slash() {
        this('|');
    }

    public Slash(char sd) {
        this._dir = Slash.encode(sd);
        this._mode = new SlashMode();
    }

    public Slash(char sd, char md) {
        this._dir = Slash.encode(sd);
        this._mode = new SlashMode(md);
    }

    private Slash(byte d, SlashMode m) {
        this._dir = d;
        this._mode = m;
    }

    public Slash copy() {
        return new Slash(this._dir, this._mode);
    }

    public boolean occurs(Variable v) {
        return false;
    }

    public void unifyCheck(Object u) throws UnifyFailure {
        if (u instanceof Slash) {
            if (!Slash.slashesMatch(this._dir, ((Slash)((Object)u))._dir)) {
                throw new UnifyFailure();
            }
        } else {
            throw new UnifyFailure();
        }
        this._mode.unifyCheck(((Slash)((Object)u))._mode);
    }

    public Object unify(Object u, Substitution sub) throws UnifyFailure {
        if (u instanceof Slash) {
            Slash s2 = (Slash)((Object)u);
            if (this._dir == 1) {
                return s2.copy();
            }
            if (s2._dir == 1) {
                return this.copy();
            }
            if (this._dir == 0 && s2._dir == 2 || this._dir == 2 && s2._dir == 0) {
                throw new UnifyFailure();
            }
            return this.copy();
        }
        throw new UnifyFailure();
    }

    public Object fill(Substitution sub) {
        return this.copy();
    }

    public boolean equals(Slash s) {
        return Slash.slashesMatch(this._dir, s._dir);
    }

    private static byte encode(char sd) {
        switch (sd) {
            case '/': {
                return 2;
            }
            case '\\': {
                return 0;
            }
        }
        return 1;
    }

    private static boolean slashesMatch(byte s1, byte s2) {
        if (s1 == 1 || s2 == 1) {
            return true;
        }
        return s1 == s2;
    }

    public String toString() {
        switch (this._dir) {
            case 2: {
                return "/";
            }
            case 0: {
                return "\\";
            }
        }
        return "|";
    }
}

