/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.MatrixParameters;
import org.apache.sis.parameter.MatrixParametersAlphaNum;
import org.apache.sis.parameter.TensorValues;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Matrix;

public class TensorParameters<E>
implements Serializable {
    private static final long serialVersionUID = -7386537348359343836L;
    public static final TensorParameters<Double> ALPHANUM;
    public static final TensorParameters<Double> WKT1;
    static final int CACHE_SIZE = 5;
    private static final int CACHE_RANK = 3;
    private final Class<E> elementType;
    private final ParameterDescriptor<Integer>[] dimensions;
    private final transient ParameterDescriptor<E>[] parameters;
    private transient E zero;
    private transient E one;
    protected final String prefix;
    protected final String separator;

    @SafeVarargs
    public TensorParameters(Class<E> clazz, String string, String string2, ParameterDescriptor<Integer> ... parameterDescriptorArray) {
        ArgumentChecks.ensureNonNull("elementType", clazz);
        ArgumentChecks.ensureNonNull("prefix", string);
        ArgumentChecks.ensureNonNull("separator", string2);
        ArgumentChecks.ensureNonNull("dimensions", parameterDescriptorArray);
        if (parameterDescriptorArray.length == 0) {
            throw new IllegalArgumentException(Errors.format((short)29, "dimensions"));
        }
        this.elementType = clazz;
        this.prefix = string;
        this.separator = string2;
        this.dimensions = new ParameterDescriptor[parameterDescriptorArray.length];
        for (int i = 0; i < parameterDescriptorArray.length; ++i) {
            this.dimensions[i] = parameterDescriptorArray[i];
            ArgumentChecks.ensureNonNullElement("dimensions", i, this.dimensions[i]);
        }
        this.parameters = this.createCache();
    }

    private <T> ParameterDescriptor<T>[] createCache() {
        if (Number.class.isAssignableFrom(this.elementType)) {
            try {
                this.one = Numbers.wrap(1L, this.elementType);
                this.zero = Numbers.wrap(0L, this.elementType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int n = 1;
        int n2 = Math.min(this.rank(), 3);
        while (--n2 >= 0) {
            n *= 5;
        }
        return new ParameterDescriptor[n];
    }

    public final Class<E> getElementType() {
        return this.elementType;
    }

    public final int rank() {
        return this.dimensions.length;
    }

    private void verifyRank(int[] nArray) {
        if (nArray.length != this.rank()) {
            throw new IllegalArgumentException(Errors.format((short)133, this.rank(), nArray.length));
        }
    }

    public final ParameterDescriptor<Integer> getDimensionDescriptor(int n) {
        return this.dimensions[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final ParameterDescriptor<E> getElementDescriptor(int ... nArray) {
        ParameterDescriptor<E> parameterDescriptor;
        ParameterDescriptor<E>[] parameterDescriptorArray;
        this.verifyRank(nArray);
        int n = TensorParameters.cacheIndex(nArray);
        if (n >= 0) {
            parameterDescriptorArray = this.parameters;
            // MONITORENTER : this.parameters
            parameterDescriptor = this.parameters[n];
            // MONITOREXIT : parameterDescriptorArray
            if (parameterDescriptor != null) {
                return parameterDescriptor;
            }
        }
        parameterDescriptor = this.createElementDescriptor(nArray);
        if (n < 0) return parameterDescriptor;
        parameterDescriptorArray = this.parameters;
        // MONITORENTER : this.parameters
        ParameterDescriptor<E> parameterDescriptor2 = this.parameters[n];
        if (parameterDescriptor2 != null) {
            // MONITOREXIT : parameterDescriptorArray
            return parameterDescriptor2;
        }
        this.parameters[n] = parameterDescriptor;
        // MONITOREXIT : parameterDescriptorArray
        return parameterDescriptor;
    }

    private static int cacheIndex(int[] nArray) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            ArgumentChecks.ensurePositive("indices", n2);
            if (i < 3) {
                if (n2 >= 0 && n2 < 5) {
                    n = n * 5 + n2;
                    continue;
                }
            } else if (n2 == 0) continue;
            return -1;
        }
        return n;
    }

    protected ParameterDescriptor<E> createElementDescriptor(int[] nArray) throws IllegalArgumentException {
        Citation citation = this.dimensions[0].getName().getAuthority();
        String string = this.indicesToName(nArray);
        return new DefaultParameterDescriptor<E>(Collections.singletonMap("name", new NamedIdentifier(citation, string)), 0, 1, this.elementType, null, null, this.getDefaultValue(nArray));
    }

    protected String indicesToName(int[] nArray) throws IllegalArgumentException {
        this.verifyRank(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.prefix;
        for (int n : nArray) {
            stringBuilder.append(string).append(n);
            string = this.separator;
        }
        return stringBuilder.toString();
    }

    protected int[] nameToIndices(String string) throws IllegalArgumentException {
        int n = this.prefix.length();
        if (!string.regionMatches(true, 0, this.prefix, 0, n)) {
            return null;
        }
        int[] nArray = new int[this.rank()];
        int n2 = nArray.length - 1;
        for (int i = 0; i < n2; ++i) {
            int n3 = string.indexOf(this.separator, n);
            if (n3 < 0) {
                return null;
            }
            nArray[i] = Integer.parseInt(string.substring(n, n3));
            n = n3 + 1;
        }
        nArray[n2] = Integer.parseInt(string.substring(n));
        return nArray;
    }

    protected E getDefaultValue(int[] nArray) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1]) continue;
            return this.zero;
        }
        return this.one;
    }

    final ParameterDescriptor<?> descriptor(ParameterDescriptorGroup parameterDescriptorGroup, String string, int[] nArray) throws ParameterNotFoundException {
        IllegalArgumentException illegalArgumentException = null;
        int[] nArray2 = null;
        try {
            nArray2 = this.nameToIndices(string);
        }
        catch (IllegalArgumentException illegalArgumentException2) {
            illegalArgumentException = illegalArgumentException2;
        }
        if (nArray2 != null && TensorParameters.isInBounds(nArray2, nArray)) {
            return this.getElementDescriptor(nArray2);
        }
        for (ParameterDescriptor<Integer> parameterDescriptor : this.dimensions) {
            if (!IdentifiedObjects.isHeuristicMatchForName(parameterDescriptor, string)) continue;
            return parameterDescriptor;
        }
        throw (ParameterNotFoundException)new ParameterNotFoundException(Resources.format((short)61, parameterDescriptorGroup.getName(), string), string).initCause(illegalArgumentException);
    }

    static boolean isInBounds(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n >= 0 && n < nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private int numElements(int[] nArray) {
        int n = 1;
        for (int n2 : nArray) {
            ArgumentChecks.ensurePositive("actualSize", n2);
            n *= n2;
        }
        return n;
    }

    public ParameterDescriptor<?>[] getAllDescriptors(int ... nArray) {
        this.verifyRank(nArray);
        int n = nArray.length;
        int n2 = this.numElements(nArray);
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[n + n2];
        System.arraycopy(this.dimensions, 0, parameterDescriptorArray, 0, n);
        int[] nArray2 = new int[this.rank()];
        block0: for (int i = 0; i < n2; ++i) {
            parameterDescriptorArray[n + i] = this.getElementDescriptor(nArray2);
            int n3 = nArray2.length;
            while (--n3 >= 0) {
                int n4 = n3;
                nArray2[n4] = nArray2[n4] + 1;
                if (nArray2[n4] < nArray[n3]) continue block0;
                nArray2[n3] = 0;
            }
        }
        return parameterDescriptorArray;
    }

    public ParameterValueGroup createValueGroup(Map<String, ?> map) {
        return new TensorValues(map, this);
    }

    public ParameterValueGroup createValueGroup(Map<String, ?> map, Matrix matrix) {
        if (this.rank() != 2) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull("matrix", matrix);
        TensorValues tensorValues = new TensorValues(map, this);
        tensorValues.setMatrix(matrix);
        return tensorValues;
    }

    public Matrix toMatrix(ParameterValueGroup parameterValueGroup) throws InvalidParameterNameException {
        if (this.rank() != 2) {
            throw new IllegalStateException();
        }
        ArgumentChecks.ensureNonNull("parameters", parameterValueGroup);
        if (parameterValueGroup instanceof TensorValues) {
            return ((TensorValues)parameterValueGroup).toMatrix();
        }
        ParameterValue<?> parameterValue = parameterValueGroup.parameter(this.dimensions[0].getName().getCode());
        ParameterValue<?> parameterValue2 = parameterValueGroup.parameter(this.dimensions[1].getName().getCode());
        MatrixSIS matrixSIS = Matrices.createDiagonal(parameterValue.intValue(), parameterValue2.intValue());
        List<GeneralParameterValue> list = parameterValueGroup.values();
        if (list != null) {
            for (GeneralParameterValue generalParameterValue : list) {
                if (generalParameterValue == parameterValue || generalParameterValue == parameterValue2) continue;
                String string = generalParameterValue.getDescriptor().getName().getCode();
                IllegalArgumentException illegalArgumentException = null;
                int[] nArray = null;
                try {
                    nArray = this.nameToIndices(string);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    illegalArgumentException = illegalArgumentException2;
                }
                if (nArray == null) {
                    throw (InvalidParameterNameException)new InvalidParameterNameException(Errors.format((short)140, string), string).initCause(illegalArgumentException);
                }
                matrixSIS.setElement(nArray[0], nArray[1], ((ParameterValue)generalParameterValue).doubleValue());
            }
        }
        return matrixSIS;
    }

    public int hashCode() {
        return Objects.hash(this.elementType, this.prefix, this.separator) ^ Arrays.hashCode(this.dimensions);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() == this.getClass()) {
            TensorParameters tensorParameters = (TensorParameters)object;
            return this.elementType.equals(tensorParameters.elementType) && this.prefix.equals(tensorParameters.prefix) && this.separator.equals(tensorParameters.separator) && Arrays.equals(this.dimensions, tensorParameters.dimensions);
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            Field field = TensorParameters.class.getDeclaredField("parameters");
            field.setAccessible(true);
            field.set(this, this.createCache());
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new AssertionError((Object)reflectiveOperationException);
        }
    }

    static {
        NumberRange<Integer> numberRange = NumberRange.create(1, true, 50, true);
        Integer n = 3;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("authority", Citations.OGC);
        hashMap.put("code", "num_row");
        DefaultParameterDescriptor<Integer> defaultParameterDescriptor = new DefaultParameterDescriptor<Integer>(hashMap, 1, 1, Integer.class, numberRange, null, n);
        hashMap.put("code", "num_col");
        DefaultParameterDescriptor<Integer> defaultParameterDescriptor2 = new DefaultParameterDescriptor<Integer>(hashMap, 1, 1, Integer.class, numberRange, null, n);
        WKT1 = new MatrixParameters(defaultParameterDescriptor, defaultParameterDescriptor2);
        defaultParameterDescriptor = new DefaultParameterDescriptor<Integer>(IdentifiedObjects.getProperties(defaultParameterDescriptor, new String[0]), 0, 1, Integer.class, numberRange, null, n);
        defaultParameterDescriptor2 = new DefaultParameterDescriptor<Integer>(IdentifiedObjects.getProperties(defaultParameterDescriptor2, new String[0]), 0, 1, Integer.class, numberRange, null, n);
        ALPHANUM = new MatrixParametersAlphaNum(defaultParameterDescriptor, defaultParameterDescriptor2);
    }
}

