/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.exceptions.WrappedIOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextNormalize;
import org.apache.pdfbox.util.TextPosition;
import org.apache.pdfbox.util.TextPositionComparator;

public class PDFTextStripper
extends PDFStreamEngine {
    private int currentPageNo = 0;
    private int startPage = 1;
    private int endPage = Integer.MAX_VALUE;
    private PDOutlineItem startBookmark = null;
    private int startBookmarkPageNumber = -1;
    private PDOutlineItem endBookmark = null;
    private int endBookmarkPageNumber = -1;
    private boolean suppressDuplicateOverlappingText = true;
    private boolean shouldSeparateByBeads = true;
    private boolean sortByPosition = false;
    private float spacingTolerance = 0.5f;
    private float averageCharTolerance = 0.3f;
    private List pageArticles = null;
    protected Vector charactersByArticle = new Vector();
    private Map characterListMapping = new HashMap();
    protected String lineSeparator = System.getProperty("line.separator");
    private String pageSeparator = System.getProperty("line.separator");
    private String wordSeparator = " ";
    protected String outputEncoding;
    protected PDDocument document;
    protected Writer output;
    private TextNormalize normalize = null;

    public PDFTextStripper() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFTextStripper.properties", true));
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFTextStripper(Properties props) throws IOException {
        super(props);
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFTextStripper(String encoding) throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFTextStripper.properties", true));
        this.outputEncoding = encoding;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public String getText(PDDocument doc) throws IOException {
        StringWriter outputStream = new StringWriter();
        this.writeText(doc, (Writer)outputStream);
        return outputStream.toString();
    }

    public String getText(COSDocument doc) throws IOException {
        return this.getText(new PDDocument(doc));
    }

    public void writeText(COSDocument doc, Writer outputStream) throws IOException {
        this.writeText(new PDDocument(doc), outputStream);
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        this.resetEngine();
        this.currentPageNo = 0;
        this.document = doc;
        this.output = outputStream;
        this.startDocument(this.document);
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new WrappedIOException("Error decrypting document, details: ", e);
            }
            catch (InvalidPasswordException e) {
                throw new WrappedIOException("Error: document is encrypted", e);
            }
        }
        this.processPages(this.document.getDocumentCatalog().getAllPages());
        this.endDocument(this.document);
    }

    protected void processPages(List pages) throws IOException {
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.getPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.getPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getCOSObject() == this.endBookmark.getCOSObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        for (PDPage nextPage : pages) {
            PDStream contentStream = nextPage.getContents();
            ++this.currentPageNo;
            if (contentStream == null) continue;
            COSStream contents = contentStream.getStream();
            this.processPage(nextPage, contents);
        }
    }

    private int getPageNumber(PDOutlineItem bookmark, List allPages) throws IOException {
        int pageNumber = -1;
        PDPage page = bookmark.findDestinationPage(this.document);
        if (page != null) {
            pageNumber = allPages.indexOf(page) + 1;
        }
        return pageNumber;
    }

    protected void startDocument(PDDocument pdf) throws IOException {
    }

    protected void endDocument(PDDocument pdf) throws IOException {
    }

    protected void processPage(PDPage page, COSStream content) throws IOException {
        if (!(this.currentPageNo < this.startPage || this.currentPageNo > this.endPage || this.startBookmarkPageNumber != -1 && this.currentPageNo < this.startBookmarkPageNumber || this.endBookmarkPageNumber != -1 && this.currentPageNo > this.endBookmarkPageNumber)) {
            this.startPage(page);
            this.pageArticles = page.getThreadBeads();
            int numberOfArticleSections = 1 + this.pageArticles.size() * 2;
            if (!this.shouldSeparateByBeads) {
                numberOfArticleSections = 1;
            }
            int originalSize = this.charactersByArticle.size();
            this.charactersByArticle.setSize(numberOfArticleSections);
            for (int i = 0; i < numberOfArticleSections; ++i) {
                if (numberOfArticleSections < originalSize) {
                    ((List)this.charactersByArticle.get(i)).clear();
                    continue;
                }
                this.charactersByArticle.set(i, new ArrayList());
            }
            this.characterListMapping.clear();
            this.processStream(page, page.findResources(), content);
            this.writePage();
            this.endPage(page);
        }
    }

    protected void startArticle() throws IOException {
        this.startArticle(true);
    }

    protected void startArticle(boolean isltr) throws IOException {
    }

    protected void endArticle() throws IOException {
    }

    protected void startPage(PDPage page) throws IOException {
    }

    protected void endPage(PDPage page) throws IOException {
    }

    protected void writePage() throws IOException {
        float maxYForLine = -1.0f;
        float minYTopForLine = Float.MAX_VALUE;
        float endOfLastTextX = -1.0f;
        float lastWordSpacing = -1.0f;
        float maxHeightForLine = -1.0f;
        TextPosition lastPosition = null;
        for (int i = 0; i < this.charactersByArticle.size(); ++i) {
            List textList = (List)this.charactersByArticle.get(i);
            if (this.sortByPosition) {
                TextPositionComparator comparator = new TextPositionComparator();
                Collections.sort(textList, comparator);
            }
            Iterator textIter = textList.iterator();
            int ltrCnt = 0;
            int rtlCnt = 0;
            while (textIter.hasNext()) {
                TextPosition position = (TextPosition)textIter.next();
                String stringValue = position.getCharacter();
                for (int a = 0; a < stringValue.length(); ++a) {
                    byte dir = Character.getDirectionality(stringValue.charAt(a));
                    if (dir == 0 || dir == 14 || dir == 15) {
                        ++ltrCnt;
                        continue;
                    }
                    if (dir != 1 && dir != 2 && dir != 16 && dir != 17) continue;
                    ++rtlCnt;
                }
            }
            boolean isRtlDominant = false;
            if (rtlCnt > ltrCnt) {
                isRtlDominant = true;
            }
            this.startArticle(!isRtlDominant);
            boolean hasRtl = false;
            if (rtlCnt > 0) {
                hasRtl = true;
            }
            String lineStr = "";
            textIter = textList.iterator();
            float previousAveCharWidth = -1.0f;
            while (textIter.hasNext()) {
                float positionHeight;
                float positionWidth;
                float positionY;
                float positionX;
                TextPosition position = (TextPosition)textIter.next();
                String characterValue = position.getCharacter();
                if (lastPosition != null && (position.getFont() != lastPosition.getFont() || position.getFontSize() != lastPosition.getFontSize())) {
                    previousAveCharWidth = -1.0f;
                }
                if (this.sortByPosition) {
                    positionX = position.getXDirAdj();
                    positionY = position.getYDirAdj();
                    positionWidth = position.getWidthDirAdj();
                    positionHeight = position.getHeightDir();
                } else {
                    positionX = position.getX();
                    positionY = position.getY();
                    positionWidth = position.getWidth();
                    positionHeight = position.getHeight();
                }
                int wordCharCount = position.getIndividualWidths().length;
                float wordSpacing = position.getWidthOfSpace();
                float deltaSpace = 0.0f;
                deltaSpace = wordSpacing == 0.0f || wordSpacing == Float.NaN ? Float.MAX_VALUE : (lastWordSpacing < 0.0f ? wordSpacing * this.spacingTolerance : (wordSpacing + lastWordSpacing) / 2.0f * this.spacingTolerance);
                float averageCharWidth = -1.0f;
                averageCharWidth = previousAveCharWidth < 0.0f ? positionWidth / (float)wordCharCount : (previousAveCharWidth + positionWidth / (float)wordCharCount) / 2.0f;
                float deltaCharWidth = averageCharWidth * this.averageCharTolerance;
                float expectedStartOfNextWordX = -1.0f;
                if (endOfLastTextX != -1.0f) {
                    expectedStartOfNextWordX = deltaCharWidth > deltaSpace ? endOfLastTextX + deltaSpace : endOfLastTextX + deltaCharWidth;
                }
                if (lastPosition != null) {
                    if (!this.overlap(positionY, positionHeight, maxYForLine, maxHeightForLine)) {
                        if (hasRtl) {
                            lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
                        }
                        lineStr = this.normalize.normalizePres(lineStr);
                        this.writeString(lineStr);
                        lineStr = "";
                        this.writeLineSeparator();
                        endOfLastTextX = -1.0f;
                        expectedStartOfNextWordX = -1.0f;
                        maxYForLine = -1.0f;
                        maxHeightForLine = -1.0f;
                        minYTopForLine = Float.MAX_VALUE;
                    }
                    if (expectedStartOfNextWordX != -1.0f && expectedStartOfNextWordX < positionX && lastPosition.getCharacter() != null && !lastPosition.getCharacter().endsWith(" ")) {
                        lineStr = lineStr + this.getWordSeparator();
                    }
                }
                if (positionY >= maxYForLine) {
                    maxYForLine = positionY;
                }
                endOfLastTextX = positionX + positionWidth;
                if (characterValue != null) {
                    lineStr = lineStr + characterValue;
                }
                maxHeightForLine = Math.max(maxHeightForLine, positionHeight);
                minYTopForLine = Math.min(minYTopForLine, positionY - positionHeight);
                lastPosition = position;
                lastWordSpacing = wordSpacing;
                previousAveCharWidth = averageCharWidth;
            }
            if (lineStr.length() > 0) {
                if (hasRtl) {
                    lineStr = this.normalize.makeLineLogicalOrder(lineStr, isRtlDominant);
                }
                lineStr = this.normalize.normalizePres(lineStr);
                this.writeString(lineStr);
            }
            this.endArticle();
        }
        this.writePageSeperator();
    }

    private boolean overlap(float y1, float height1, float y2, float height2) {
        return this.within(y1, y2, 0.1f) || y2 <= y1 && y2 >= y1 - height1 || y1 <= y2 && y1 >= y2 - height2;
    }

    protected void writePageSeperator() throws IOException {
        this.output.write(this.getPageSeparator());
        this.output.flush();
    }

    protected void writeLineSeparator() throws IOException {
        this.output.write(this.getLineSeparator());
    }

    protected void writeWordSeparator() throws IOException {
        this.output.write(this.getWordSeparator());
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        this.output.write(text.getCharacter());
    }

    protected void writeString(String text) throws IOException {
        this.output.write(text);
    }

    private boolean within(float first, float second, float variance) {
        return second < first + variance && second > first - variance;
    }

    protected void processTextPosition(TextPosition text) {
        int i;
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            ArrayList<TextPosition> sameTextCharacters = (ArrayList<TextPosition>)this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new ArrayList<TextPosition>();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            for (i = 0; i < sameTextCharacters.size() && textCharacter != null; ++i) {
                TextPosition character = (TextPosition)sameTextCharacters.get(i);
                String charCharacter = character.getCharacter();
                float charX = character.getX();
                float charY = character.getY();
                if (charCharacter == null || !this.within(charX, textX, tolerance) || !this.within(charY, textY, tolerance)) continue;
                suppressCharacter = true;
            }
            if (!suppressCharacter) {
                sameTextCharacters.add(text);
                showCharacter = true;
            }
        }
        if (showCharacter) {
            int foundArticleDivisionIndex = -1;
            int notFoundButFirstLeftAndAboveArticleDivisionIndex = -1;
            int notFoundButFirstLeftArticleDivisionIndex = -1;
            int notFoundButFirstAboveArticleDivisionIndex = -1;
            float x = text.getX();
            float y = text.getY();
            if (this.shouldSeparateByBeads) {
                for (i = 0; i < this.pageArticles.size() && foundArticleDivisionIndex == -1; ++i) {
                    PDThreadBead bead = (PDThreadBead)this.pageArticles.get(i);
                    if (bead != null) {
                        PDRectangle rect = bead.getRectangle();
                        if (rect.contains(x, y)) {
                            foundArticleDivisionIndex = i * 2 + 1;
                            continue;
                        }
                        if ((x < rect.getLowerLeftX() || y < rect.getUpperRightY()) && notFoundButFirstLeftAndAboveArticleDivisionIndex == -1) {
                            notFoundButFirstLeftAndAboveArticleDivisionIndex = i * 2;
                            continue;
                        }
                        if (x < rect.getLowerLeftX() && notFoundButFirstLeftArticleDivisionIndex == -1) {
                            notFoundButFirstLeftArticleDivisionIndex = i * 2;
                            continue;
                        }
                        if (!(y < rect.getUpperRightY()) || notFoundButFirstAboveArticleDivisionIndex != -1) continue;
                        notFoundButFirstAboveArticleDivisionIndex = i * 2;
                        continue;
                    }
                    foundArticleDivisionIndex = 0;
                }
            } else {
                foundArticleDivisionIndex = 0;
            }
            int articleDivisionIndex = -1;
            articleDivisionIndex = foundArticleDivisionIndex != -1 ? foundArticleDivisionIndex : (notFoundButFirstLeftAndAboveArticleDivisionIndex != -1 ? notFoundButFirstLeftAndAboveArticleDivisionIndex : (notFoundButFirstLeftArticleDivisionIndex != -1 ? notFoundButFirstLeftArticleDivisionIndex : (notFoundButFirstAboveArticleDivisionIndex != -1 ? notFoundButFirstAboveArticleDivisionIndex : this.charactersByArticle.size() - 1)));
            List textList = (List)this.charactersByArticle.get(articleDivisionIndex);
            if (textList.isEmpty()) {
                textList.add(text);
            } else {
                TextPosition previousTextPosition = (TextPosition)textList.get(textList.size() - 1);
                if (text.isDiacritic() && previousTextPosition.contains(text)) {
                    previousTextPosition.mergeDiacritic(text, this.normalize);
                } else if (previousTextPosition.isDiacritic() && text.contains(previousTextPosition)) {
                    text.mergeDiacritic(previousTextPosition, this.normalize);
                    textList.remove(textList.size() - 1);
                    textList.add(text);
                } else {
                    textList.add(text);
                }
            }
        }
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPageValue) {
        this.startPage = startPageValue;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPageValue) {
        this.endPage = endPageValue;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setPageSeparator(String separator) {
        this.pageSeparator = separator;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void setWordSeparator(String separator) {
        this.wordSeparator = separator;
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    public boolean shouldSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    protected int getCurrentPageNo() {
        return this.currentPageNo;
    }

    protected Writer getOutput() {
        return this.output;
    }

    protected List getCharactersByArticle() {
        return this.charactersByArticle;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingTextValue) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingTextValue;
    }

    public boolean shouldSeparateByBeads() {
        return this.shouldSeparateByBeads;
    }

    public void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
        this.shouldSeparateByBeads = aShouldSeparateByBeads;
    }

    public PDOutlineItem getEndBookmark() {
        return this.endBookmark;
    }

    public void setEndBookmark(PDOutlineItem aEndBookmark) {
        this.endBookmark = aEndBookmark;
    }

    public PDOutlineItem getStartBookmark() {
        return this.startBookmark;
    }

    public void setStartBookmark(PDOutlineItem aStartBookmark) {
        this.startBookmark = aStartBookmark;
    }

    public boolean shouldSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean newSortByPosition) {
        this.sortByPosition = newSortByPosition;
    }

    public float getSpacingTolerance() {
        return this.spacingTolerance;
    }

    public void setSpacingTolerance(float spacingToleranceValue) {
        this.spacingTolerance = spacingToleranceValue;
    }

    public float getAverageCharTolerance() {
        return this.averageCharTolerance;
    }

    public void setAverageCharTolerance(float averageCharToleranceValue) {
        this.averageCharTolerance = averageCharToleranceValue;
    }
}

