/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.RenderedImageSrc;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.StringSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.entropy.ProgressionSpec;
import jj2000.j2k.entropy.encoder.LayersInfo;
import jj2000.j2k.image.forwcomptransf.ForwCompTransfSpec;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;

public class J2KImageWriteParamJava
extends ImageWriteParam {
    private boolean packPacketHeaderInTile = false;
    private boolean packPacketHeaderInMain = false;
    private int packetPerTilePart = 0;
    private double encodingRate = Double.MAX_VALUE;
    private boolean lossless = true;
    private ForwCompTransfSpec componentTransformation = null;
    private boolean enableCT = true;
    private AnWTFilterSpec filters = null;
    private IntegerSpec decompositionLevel = null;
    private GuardBitsSpec guardBits = null;
    private QuantStepSizeSpec quantizationStep = null;
    private QuantTypeSpec quantizationType = null;
    private int startLevelROI = -1;
    private boolean alignROI = false;
    private MaxShiftSpec ROIs = null;
    private CBlkSizeSpec codeBlockSize = null;
    private StringSpec bypass = null;
    private StringSpec resetMQ = null;
    private StringSpec terminateOnByte = null;
    private StringSpec causalCXInfo = null;
    private StringSpec codeSegSymbol = null;
    private StringSpec methodForMQTermination = null;
    private StringSpec methodForMQLengthCalc = null;
    private PrecinctSizeSpec precinctPartition = null;
    private ProgressionSpec progressionType = null;
    private String progressionName = null;
    private String layers = "0.015 +20 2.0 +10";
    private StringSpec EPH = null;
    private StringSpec SOP = null;
    private int numTiles;
    private int numComponents;
    private RenderedImage imgsrc;
    private Raster raster;
    private int minX;
    private int minY;

    public J2KImageWriteParamJava(RenderedImage imgsrc, Locale locale) {
        super(locale);
        this.setDefaults(imgsrc);
    }

    public J2KImageWriteParamJava(IIOImage image, ImageWriteParam param) {
        super(param.getLocale());
        if (image != null) {
            if (image.hasRaster()) {
                this.setDefaults(image.getRaster());
            } else {
                this.setDefaults(image.getRenderedImage());
            }
        }
        this.setSourceRegion(param.getSourceRegion());
        this.setSourceBands(param.getSourceBands());
        try {
            this.setTiling(param.getTileWidth(), param.getTileHeight(), param.getTileGridXOffset(), param.getTileGridYOffset());
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.setDestinationOffset(param.getDestinationOffset());
        this.setSourceSubsampling(param.getSourceXSubsampling(), param.getSourceYSubsampling(), param.getSubsamplingXOffset(), param.getSubsamplingYOffset());
        this.setDestinationType(param.getDestinationType());
        J2KImageWriteParam j2kParam = param instanceof J2KImageWriteParam ? (J2KImageWriteParam)param : new J2KImageWriteParam();
        this.setDecompositionLevel("" + j2kParam.getNumDecompositionLevels());
        this.setEncodingRate(j2kParam.getEncodingRate());
        this.setLossless(j2kParam.getLossless());
        this.setFilters(j2kParam.getFilter());
        this.setEPH("" + j2kParam.getEPH());
        this.setSOP("" + j2kParam.getSOP());
        this.setProgressionName(j2kParam.getProgressionType());
        int[] size = j2kParam.getCodeBlockSize();
        this.setCodeBlockSize("" + size[0] + " " + size[1]);
        this.enableCT = j2kParam.getComponentTransformation();
        this.setComponentTransformation("" + this.enableCT);
    }

    public J2KImageWriteParamJava() {
        this.setSuperProperties();
    }

    public J2KImageWriteParamJava(RenderedImage imgsrc) {
        this.setDefaults(imgsrc);
    }

    public J2KImageWriteParamJava(Raster raster) {
        this.setDefaults(raster);
    }

    private void setSuperProperties() {
        this.canOffsetTiles = true;
        this.canWriteTiles = true;
        this.canOffsetTiles = true;
        this.canWriteProgressive = true;
        this.tilingMode = 2;
    }

    private void setDefaults(Raster raster) {
        this.setSuperProperties();
        if (raster != null) {
            this.raster = raster;
            this.tileGridXOffset = raster.getMinX();
            this.tileGridYOffset = raster.getMinY();
            this.tileWidth = raster.getWidth();
            this.tileHeight = raster.getHeight();
            this.tilingSet = true;
            this.numTiles = 1;
            this.numComponents = raster.getSampleModel().getNumBands();
        }
        this.setDefaults();
    }

    private void setDefaults(RenderedImage imgsrc) {
        this.setSuperProperties();
        this.tilingMode = 2;
        if (imgsrc != null) {
            this.imgsrc = imgsrc;
            this.tileGridXOffset = imgsrc.getTileGridXOffset();
            this.tileGridYOffset = imgsrc.getTileGridYOffset();
            this.tileWidth = imgsrc.getTileWidth();
            this.tileHeight = imgsrc.getTileHeight();
            this.tilingSet = true;
            this.numTiles = imgsrc.getNumXTiles() * imgsrc.getNumYTiles();
            this.numComponents = imgsrc.getSampleModel().getNumBands();
        }
        this.setDefaults();
    }

    private void setDefaults() {
        this.setROIs(null);
        this.setQuantizationType(null);
        this.setQuantizationStep(null);
        this.setGuardBits(null);
        this.setFilters(null);
        this.setDecompositionLevel(null);
        this.setComponentTransformation(null);
        this.setMethodForMQLengthCalc(null);
        this.setMethodForMQTermination(null);
        this.setCodeSegSymbol(null);
        this.setCausalCXInfo(null);
        this.setTerminateOnByte(null);
        this.setResetMQ(null);
        this.setBypass(null);
        this.setCodeBlockSize(null);
        this.setPrecinctPartition(null);
        this.setSOP(null);
        this.setEPH(null);
    }

    public void setEncodingRate(double rate) {
        this.encodingRate = rate;
    }

    public double getEncodingRate() {
        return this.encodingRate;
    }

    public void setLossless(boolean lossless) {
        this.lossless = lossless;
    }

    public boolean getLossless() {
        return this.lossless;
    }

    public void setPacketPerTilePart(int packetPerTilePart) {
        if (packetPerTilePart < 0) {
            throw new IllegalArgumentException(I18N.getString("J2KImageWriteParamJava0"));
        }
        this.packetPerTilePart = packetPerTilePart;
        if (packetPerTilePart > 0) {
            this.setSOP("true");
            this.setEPH("true");
        }
    }

    public int getPacketPerTilePart() {
        return this.packetPerTilePart;
    }

    public void setPackPacketHeaderInTile(boolean packPacketHeaderInTile) {
        this.packPacketHeaderInTile = packPacketHeaderInTile;
        if (packPacketHeaderInTile) {
            this.setSOP("true");
            this.setEPH("true");
        }
    }

    public boolean getPackPacketHeaderInTile() {
        return this.packPacketHeaderInTile;
    }

    public void setPackPacketHeaderInMain(boolean packPacketHeaderInMain) {
        this.packPacketHeaderInMain = packPacketHeaderInMain;
        if (packPacketHeaderInMain) {
            this.setSOP("true");
            this.setEPH("true");
        }
    }

    public boolean getPackPacketHeaderInMain() {
        return this.packPacketHeaderInMain;
    }

    public void setAlignROI(boolean align) {
        this.alignROI = align;
    }

    public boolean getAlignROI() {
        return this.alignROI;
    }

    public void setROIs(String values) {
        this.ROIs = new MaxShiftSpec(this.numTiles, this.numComponents, 2, values);
    }

    public MaxShiftSpec getROIs() {
        return this.ROIs;
    }

    public void setQuantizationType(String values) {
        this.quantizationType = new QuantTypeSpec(this.numTiles, this.numComponents, 2, this, values);
    }

    public QuantTypeSpec getQuantizationType() {
        return this.quantizationType;
    }

    public void setQuantizationStep(String values) {
        this.quantizationStep = new QuantStepSizeSpec(this.numTiles, this.numComponents, 2, this, values);
    }

    public QuantStepSizeSpec getQuantizationStep() {
        return this.quantizationStep;
    }

    public void setGuardBits(String values) {
        this.guardBits = new GuardBitsSpec(this.numTiles, this.numComponents, 2, this, values);
    }

    public GuardBitsSpec getGuardBits() {
        return this.guardBits;
    }

    public void setFilters(String values) {
        if ("w9x7".equals(values)) {
            this.setQuantizationType("expounded");
        } else {
            this.setQuantizationType("reversible");
        }
        this.filters = new AnWTFilterSpec(this.numTiles, this.numComponents, 2, this.quantizationType, this, values);
        this.setComponentTransformation("" + this.enableCT);
    }

    public AnWTFilterSpec getFilters() {
        return this.filters;
    }

    public void setDecompositionLevel(String values) {
        this.decompositionLevel = new IntegerSpec(this.numTiles, this.numComponents, 2, this, values, "5");
        this.setPrecinctPartition(null);
    }

    public IntegerSpec getDecompositionLevel() {
        return this.decompositionLevel;
    }

    public void setComponentTransformation(String values) {
        this.componentTransformation = new ForwCompTransfSpec(this.numTiles, this.numComponents, 1, this.filters, this, values);
    }

    public ForwCompTransfSpec getComponentTransformation() {
        return this.componentTransformation;
    }

    public void setMethodForMQLengthCalc(String values) {
        String[] strLcs = new String[]{"near_opt", "lazy_good", "lazy"};
        this.methodForMQLengthCalc = new StringSpec(this.numTiles, this.numComponents, 2, "near_opt", strLcs, this, values);
    }

    public StringSpec getMethodForMQLengthCalc() {
        return this.methodForMQLengthCalc;
    }

    public void setMethodForMQTermination(String values) {
        String[] strTerm = new String[]{"near_opt", "easy", "predict", "full"};
        this.methodForMQTermination = new StringSpec(this.numTiles, this.numComponents, 2, "near_opt", strTerm, this, values);
    }

    public StringSpec getMethodForMQTermination() {
        return this.methodForMQTermination;
    }

    public void setCodeSegSymbol(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.codeSegSymbol = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getCodeSegSymbol() {
        return this.codeSegSymbol;
    }

    public void setCausalCXInfo(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.causalCXInfo = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getCausalCXInfo() {
        return this.causalCXInfo;
    }

    public void setTerminateOnByte(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.terminateOnByte = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getTerminateOnByte() {
        return this.terminateOnByte;
    }

    public void setResetMQ(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.resetMQ = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getResetMQ() {
        return this.resetMQ;
    }

    public void setBypass(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.bypass = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getBypass() {
        return this.bypass;
    }

    public void setCodeBlockSize(String values) {
        this.codeBlockSize = new CBlkSizeSpec(this.numTiles, this.numComponents, 2, this, values);
    }

    public CBlkSizeSpec getCodeBlockSize() {
        return this.codeBlockSize;
    }

    public void setPrecinctPartition(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        if (this.imgsrc != null) {
            this.precinctPartition = new PrecinctSizeSpec(this.numTiles, this.numComponents, 2, new RenderedImageSrc(this.imgsrc, this, null), this.decompositionLevel, this, values);
        } else if (this.raster != null) {
            this.precinctPartition = new PrecinctSizeSpec(this.numTiles, this.numComponents, 2, new RenderedImageSrc(this.raster, this, null), this.decompositionLevel, this, values);
        }
    }

    public PrecinctSizeSpec getPrecinctPartition() {
        return this.precinctPartition;
    }

    public void setSOP(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.SOP = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getSOP() {
        return this.SOP;
    }

    public void setEPH(String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.EPH = new StringSpec(this.numTiles, this.numComponents, 2, "false", strBoolean, this, values);
    }

    public StringSpec getEPH() {
        return this.EPH;
    }

    public void setProgressionName(String values) {
        this.progressionName = values;
    }

    public String getProgressionName() {
        return this.progressionName;
    }

    public void setProgressionType(LayersInfo lyrs, String values) {
        String[] strBoolean = new String[]{"true", "false"};
        this.progressionType = new ProgressionSpec(this.numTiles, this.numComponents, lyrs.getTotNumLayers(), this.decompositionLevel, 2, this, values);
    }

    public ProgressionSpec getProgressionType() {
        return this.progressionType;
    }

    public void setStartLevelROI(int value) {
        this.startLevelROI = value;
    }

    public int getStartLevelROI() {
        return this.startLevelROI;
    }

    public void setLayers(String value) {
        this.layers = value;
    }

    public String getLayers() {
        return this.layers;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinY(int minY) {
        this.minY = minY;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getNumTiles() {
        Rectangle sourceRegion = this.getSourceRegion();
        sourceRegion = sourceRegion == null ? (this.imgsrc != null ? new Rectangle(this.imgsrc.getMinX(), this.imgsrc.getMinY(), this.imgsrc.getWidth(), this.imgsrc.getHeight()) : this.raster.getBounds()) : (this.imgsrc != null ? sourceRegion.intersection(new Rectangle(this.imgsrc.getMinX(), this.imgsrc.getMinY(), this.imgsrc.getWidth(), this.imgsrc.getHeight())) : sourceRegion.intersection(this.raster.getBounds()));
        int scaleX = this.getSourceXSubsampling();
        int scaleY = this.getSourceYSubsampling();
        int xOffset = this.getSubsamplingXOffset();
        int yOffset = this.getSubsamplingYOffset();
        int w = (sourceRegion.width - xOffset + scaleX - 1) / scaleX;
        int h = (sourceRegion.height - yOffset + scaleY - 1) / scaleY;
        this.minX = (sourceRegion.x + xOffset) / scaleX;
        this.minY = (sourceRegion.y + yOffset) / scaleY;
        this.numTiles = (int)((Math.floor(((double)(this.minX + w + this.tileWidth) - 1.0) / (double)this.tileWidth) - Math.floor((double)this.minX / (double)this.tileWidth)) * (Math.floor(((double)(this.minY + h + this.tileHeight) - 1.0) / (double)this.tileHeight) - Math.floor((double)this.minY / (double)this.tileHeight)));
        this.tileGridXOffset += (this.minX - this.tileGridXOffset) / this.tileWidth * this.tileWidth;
        this.tileGridYOffset += (this.minY - this.tileGridYOffset) / this.tileHeight * this.tileHeight;
        return this.numTiles;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public void setSourceBands(int[] bands) {
        super.setSourceBands(bands);
        if (bands != null) {
            this.numComponents = bands.length;
            this.setDefaults();
        }
    }

    public void setTiling(int tw, int th, int xOff, int yOff) {
        super.setTiling(tw, th, xOff, yOff);
        this.getNumTiles();
        this.setDefaults();
    }

    public void setSourceSubsampling(int sx, int sy, int xOff, int yOff) {
        super.setSourceSubsampling(sx, sy, xOff, yOff);
        this.getNumTiles();
        this.setDefaults();
    }
}

