use 5.008000;
use ExtUtils::MakeMaker;
use strict;

sub MY::metafile {
  package MY;
  my $self = shift;
  if (!eval { require YAML; 1 })
  {
    warn ("YAML not installed, 'make dist' will not override 'META.yml'.");
    return $self->SUPER::metafile_target(@_);
  };

  my $node = new YAML::Node {};

  $node->{name}                 = $self->{DISTNAME};
  $node->{version}              = $self->{VERSION};
  $node->{version_from}         = $self->{VERSION_FROM};
  $node->{license}              = 'gpl';
  $node->{distribution_type}    = 'module';
  $node->{generated_by}         = "$self->{DISTNAME} version $self->{VERSION}";
  $node->{installdirs}          = 'site';
  $node->{requires}             = $self->{PREREQ_PM};

  my $dump = YAML::Dump( $node );

  $dump =~ s/^(.*)$/\t\$(NOECHO) \$(ECHO) "$1" >>META.yml/gm;
  $dump =~ s/>>META\.yml/>META.yml/;

  return "metafile:\n$dump";
}

WriteMakefile(
  NAME			=> 'Devel::Graph',
  VERSION_FROM		=> 'lib/Devel/Graph.pm', # finds $VERSION
  PREREQ_PM		=> {
	PPI 	      => 1.104,
	'Graph::Flowchart' => 0.04,
	},
  ABSTRACT_FROM		=> 'lib/Devel/Graph.pm',
  AUTHOR		=> 'Tels <nospam-abuse@bloodgate.com>',
  PREREQ_FATAL		=> 1,	# can't work w/o proper prereqs
);
