package App::EventStreamr::Internal::Devmon;
use Method::Signatures;
use Moo;
use namespace::clean;

# ABSTRACT: An EventStreamr API Process

our $VERSION = '0.3'; # VERSION: Generated by DZP::OurPkg:Version


extends 'App::EventStreamr::Process';

has 'cmd'         => ( is => 'ro', default => sub { "eventstreamr-devmon.pl" } );
has 'name'        => ( is => 'ro', default => sub { 'devmon' } );
has 'id'          => ( is => 'ro', default => sub { 'devmon' } );
has 'type'        => ( is => 'ro', default => sub { 'internal' } );

# We're special, we should always be running
method _run() {
  $self->{config}{control}{$self->{id}}{run} = 1;
  return 1;
}

# And we shouldn't be restarted
method _restart() {
  return 0;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::EventStreamr::Internal::Devmon - An EventStreamr API Process

=head1 VERSION

version 0.3

=head1 SYNOPSIS

This manages the internal EventStreamr API

=head1 DESCRIPTION

This largely extends L<App::EventStreamr::Process>, provides
default cmds that can be overridden in the configuration.

=head1 AUTHOR

Leon Wright < techman@cpan.org >

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2014 by Leon Wright.

This is free software, licensed under:

  The GNU Affero General Public License, Version 3, November 2007

=cut
