package App::EventStreamr::DVswitch::Stream;
use Method::Signatures;
use Moo;
use namespace::clean;

# ABSTRACT: An IceCast Process

our $VERSION = '0.3'; # VERSION: Generated by DZP::OurPkg:Version


extends 'App::EventStreamr::Process';

has 'cmd'         => ( is => 'ro', lazy => 1, builder => 1 );
has 'cmd_regex'   => ( is => 'ro', lazy => 1, builder => 1 );
has 'id'          => ( is => 'ro', default => sub { 'icecast' } );
has 'type'        => ( is => 'ro', default => sub { 'stream' } );

method _build_cmd() {
  my $command = $self->{config}{commands}{stream} ? $self->{config}{commands}{stream} : 'dvsink-command -h $host -p $port -- ffmpeg2theora - -f dv -F 25:2 --speedlevel 0 -v 4  --optimize -V 420 --soft-target -a 4 -c 1 -H 44100 --title $id -o - | oggfwd $shost $sport $spassword /$stream';
  
  my %cmd_vars = (
                  host      => $self->{config}{mixer}{host},
                  port      => $self->{config}{mixer}{port},
                  id        => $self->{config}{stream}{stream},
                  shost     => $self->{config}{stream}{host},
                  sport     => $self->{config}{stream}{port},
                  spassword => $self->{config}{stream}{password},
                  stream    => $self->{config}{stream}{stream},
  );

  $command =~ s/\$(\w+)/$cmd_vars{$1}/g;
  return $command;
}

method _build_cmd_regex() {
    return qr:ffmpeg2theora.+--title.$self->{config}{stream}{stream}.+:;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::EventStreamr::DVswitch::Stream - An IceCast Process

=head1 VERSION

version 0.3

=head1 SYNOPSIS

This Provides a pre-configured IceCast process.

=head1 DESCRIPTION

This largely extends L<App::EventStreamr::Process>, provides
default cmds that can be overridden in the configuration.

=head1 AUTHOR

Leon Wright < techman@cpan.org >

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2014 by Leon Wright.

This is free software, licensed under:

  The GNU Affero General Public License, Version 3, November 2007

=cut
