#!perl
use strict;
use warnings;

use Test::More;
use InfluxDB::Client;

if ($ENV{INFLUXDB_URLS}) {
    plan tests => 2;
} else {
    plan skip_all => 'environment variable INFLUXDB_URLS not set';
}

# split our env variable
my @urls = split(/\s+/,$ENV{INFLUXDB_URLS});

subtest 'can ping valid host' => sub {
    my $client = InfluxDB::Client->new( url  => [ @urls ] );
    my $res = $client->ping();
    
    is($res->status,InfluxDB::Client::Response::Status::OK);
};

subtest 'can ping with one broken host' => sub {
    my $client = InfluxDB::Client->new( url  => [ 'http://invalid.url:112233/', @urls ] );
    my $res = $client->ping();
    
    is($res->status,InfluxDB::Client::Response::Status::OK);
};

done_testing;