use strict;
use Test::More tests => 66;

use_ok('Number::Phone::JP', 'ipphone');

my $tel  = Number::Phone::JP->new;
my $line = 45;

for (1..$line) {
	my $num = <DATA>;
	chomp $num;
	ok($tel->set_number($num)->is_valid_number);
}

while (<DATA>) {
	chomp;
	ok(! $tel->set_number($_)->is_valid_number);
}

__DATA__
050 10001234
050 11001234
050 11001234
050 12001234
050 13001234
050 14001234
050 15001234
050 20001234
050 20101234
050 24001234
050 25251234
050 30001234
050 30101234
050 30201234
050 30301234
050 30401234
050 33001234
050 34001234
050 34501234
050 39001234
050 39011234
050 50001234
050 50011234
050 52001234
050 52011234
050 55001234
050 55101234
050 55201234
050 55301234
050 55001234
050 55401234
050 55501234
050 55601234
050 66191234
050 66201234
050 70001234
050 70011234
050 71001234
050 75001234
050 75101234
050 75201234
050 75301234
050 80001234
050 86001234
050 88001234
050 15781234
050 15801234
050 20181234
050 24901234
050 25261234
050 30461234
050 34511234
050 39021234
050 50041234
050 52031234
050 55331234
050 55701234
050 66181234
050 66211234
050 70021234
050 71071234
050 75331234
050 80071234
050 86011234
050 88011234
