use 5.012;
use warnings;
use Test::More;
use Test::Deep;
use lib 't/lib'; use PDTest;

my $date = new Panda::Date(0);
is($date->epoch, 0);
is($date->year, 1970);
is($date->_year, 70);
is($date->yr, 70);
is($date->month, 1);
is($date->mon, 1);
is($date->_month, 0);
is($date->_mon, 0);
is($date->day, 1);
is($date->mday, 1);
is($date->day_of_month, 1);
is($date->hour, 3);
is($date->min, 0);
is($date->minute, 0);
is($date->sec, 0);
is($date->second, 0);
is($date->to_string, "1970-01-01 03:00:00");

$date = new Panda::Date(1000000000);
is($date->to_string, "2001-09-09 05:46:40");
is($date, "2001-09-09 05:46:40");
is("$date", "2001-09-09 05:46:40");
is($date->_year, 101);
is($date->yr, 1);
is($date, $date->to_string);
is($date, $date->string);
is($date, $date->as_string);
is($date->to_number, 1000000000);
is(int($date), $date->to_number);

$date = new Panda::Date($date);
is($date->epoch, 1000000000);

$date = new Panda::Date([2012,02,20,15,16,17]);
is($date, "2012-02-20 15:16:17");
$date = new Panda::Date([2012,02,20,15,16]);
is($date, "2012-02-20 15:16:00");
$date = new Panda::Date([2012,02,20,15]);
is($date, "2012-02-20 15:00:00");
$date = new Panda::Date([2012,02,20]);
is($date, "2012-02-20 00:00:00");
$date = new Panda::Date([2012,02]);
is($date, "2012-02-01 00:00:00");
$date = new Panda::Date([2012]);
is($date, "2012-01-01 00:00:00");
$date = new Panda::Date([]);
is($date, "2000-01-01 00:00:00");

$date = new Panda::Date({year => 2013, month => 06, day => 28, hour => 6, min => 6, sec => 6});
is($date, "2013-06-28 06:06:06");
$date = new Panda::Date({month => 06, day => 28, hour => 6, min => 6, sec => 6});
is($date, "2000-06-28 06:06:06");
$date = new Panda::Date({month => 06, hour => 6, min => 6, sec => 6});
is($date, "2000-06-01 06:06:06");
$date = new Panda::Date({month => 06, sec => 6});
is($date, "2000-06-01 00:00:06");
$date = new Panda::Date({});
is($date, "2000-01-01 00:00:00");

$date = new Panda::Date("2013-01-26 6:47:29\0");
is($date->yr, 13);
is($date->month, 1);
is($date->mday, 26);
is($date->hour, 6);
is($date->min, 47);
is($date->sec, 29);
is($date, "2013-01-26 06:47:29");
$date = new Panda::Date("2013-01-26 6:47:29\n");
is($date, "2013-01-26 06:47:29");
$date = new Panda::Date("2013-01-26 6:47:29.345341");
is($date, "2013-01-26 06:47:29");

$date = new Panda::Date("2013-02-26 6:47:");
is($date, "2013-02-26 06:47:00");
$date = new Panda::Date("2013-02-26 6:47");
is($date, "2013-02-26 06:47:00");
$date = new Panda::Date("2013-02-26 6:");
is($date, "2013-02-26 06:00:00");
$date = new Panda::Date("2013-02-26 6");
is($date, "2013-02-26 06:00:00");
$date = new Panda::Date("2013-02-26 ");
is($date, "2013-02-26 00:00:00");
$date = new Panda::Date("2013-02-");
is($date, "2013-02-01 00:00:00");
$date = new Panda::Date("2013-02");
is($date, "2013-02-01 00:00:00");
$date = new Panda::Date("2013-");
is($date, "2013-01-01 00:00:00");
$date = new Panda::Date("2013");
is($date, "1970-01-01 03:33:33");

$date = Panda::Date->new("2013-03-05 23:45:56");
is($date->wday, 3);
is($date->_wday, 2);
is($date->day_of_week, 3);
is($date->ewday, 2);
is($date->yday, 64);
is($date->day_of_year, 64);
is($date->_yday, 63);
ok(!$date->isdst);
ok(!$date->daylight_savings);
$date = Panda::Date->new("2013-03-10 23:45:56");
is($date->wday, 1);
is($date->_wday, 0);
is($date->day_of_week, 1);
is($date->ewday, 7);

tzset('Europe/Kiev');
$date = Panda::Date->new("2013-09-05 23:45:56");
ok($date->isdst);
ok($date->daylight_savings);
is($date->tzabbr, 'EEST');
$date = Panda::Date->new("2013-12-05 23:45:56");
ok(!$date->isdst);
ok(!$date->daylight_savings);
is($date->tzabbr, 'EET');

done_testing();
