package Google::Ads::AdWords::v201708::ConstantOperand;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201708' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201708::FunctionArgumentOperand);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %FunctionArgumentOperand__Type_of :ATTR(:get<FunctionArgumentOperand__Type>);
my %type_of :ATTR(:get<type>);
my %unit_of :ATTR(:get<unit>);
my %longValue_of :ATTR(:get<longValue>);
my %booleanValue_of :ATTR(:get<booleanValue>);
my %doubleValue_of :ATTR(:get<doubleValue>);
my %stringValue_of :ATTR(:get<stringValue>);

__PACKAGE__->_factory(
    [ qw(        FunctionArgumentOperand__Type
        type
        unit
        longValue
        booleanValue
        doubleValue
        stringValue

    ) ],
    {
        'FunctionArgumentOperand__Type' => \%FunctionArgumentOperand__Type_of,
        'type' => \%type_of,
        'unit' => \%unit_of,
        'longValue' => \%longValue_of,
        'booleanValue' => \%booleanValue_of,
        'doubleValue' => \%doubleValue_of,
        'stringValue' => \%stringValue_of,
    },
    {
        'FunctionArgumentOperand__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'type' => 'Google::Ads::AdWords::v201708::ConstantOperand::ConstantType',
        'unit' => 'Google::Ads::AdWords::v201708::ConstantOperand::Unit',
        'longValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'booleanValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'doubleValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
        'stringValue' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'FunctionArgumentOperand__Type' => 'FunctionArgumentOperand.Type',
        'type' => 'type',
        'unit' => 'unit',
        'longValue' => 'longValue',
        'booleanValue' => 'booleanValue',
        'doubleValue' => 'doubleValue',
        'stringValue' => 'stringValue',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201708::ConstantOperand

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ConstantOperand from the namespace https://adwords.google.com/api/adwords/cm/v201708.

A constant operand in a matching function. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * type


=item * unit


=item * longValue


=item * booleanValue


=item * doubleValue


=item * stringValue




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

