use v5.20;
use strict;
use utf8;
use Test::More;

use_ok("Crypt::URandom::Password");

like new_ok("Crypt::URandom::Password")->get(),
  qr/^[A-Za-z0-9]{44}$/, "44 alphanumeric chars (default)";

like new_ok("Crypt::URandom::Password" => [ alphabet => [ "a", "z" ] ])->get(),
  qr/^[az]{44}$/,  "44 custom chars";

like new_ok("Crypt::URandom::Password" => [ alphabet => [ "A", "C", "G", "T" ], length => 8 ])->get(),
  qr/^[ACGT]{8}$/, "44 alphanumeric chars (a and z)";

like new_ok("Crypt::URandom::Password" => [ alphabet => "ACGT", length => 8 ])->get(),
  qr/^[ACGT]{8}$/, "8 chars of custom alphabet as string";

like new_ok("Crypt::URandom::Password" => [{ alphabet => "ACGT", length => 8 }])->get(),
  qr/^[ACGT]{8}$/, "8 chars of custom alphabet as string, with hashref to constructor";

like new_ok("Crypt::URandom::Password" => [ alphabet => [ "a", "z" ] ])->get(),
  qr/^[az]{44}$/,  "44 custom chars";

done_testing();
