
package MooseX::Getopt::Meta::Attribute;
use Moose;

our $VERSION   = '0.01';
our $AUTHORITY = 'cpan:STEVAN';

extends 'Moose::Meta::Attribute'; # << Moose extending Moose :)

has 'cmd_flag' => (
    is        => 'rw',
    isa       => 'Str',
    predicate => 'has_cmd_flag',
);

no Moose; 1;

__END__


=pod

=head1 NAME

MooseX::Getopt::Meta::Attribute - Optional meta attribute for custom option names

=head1 SYNOPSIS

  package App;
  use Moose;
  
  with 'MooseX::Getopt';
  
  has 'data' => (
      metaclass => 'MooseX::Getopt::Meta::Attribute',        
      is        => 'ro',
      isa       => 'Str',
      default   => 'file.dat',
      # tells MooseX::Getopt to use -f as the 
      # command line flag instead of the normal 
      # autogenerated one (--data)
      cmd_flag  => 'f',
  );

=head1 DESCRIPTION

This is a custom attribute metaclass which can be used to specify a 
the specific command line flag to use instead of the default one 
which L<MooseX::Getopt> will create for you. 

This is certainly not the prettiest way to go about this, but for 
now it works for those who might need such a feature.

=head1 METHODS

These methods are of little use to most users, they are used interally 
within L<MooseX::Getopt>.

=over 4

=item B<cmd_flag>

=item B<has_cmd_flag>

=item B<meta>

=back

=head1 BUGS

All complex software has bugs lurking in it, and this module is no 
exception. If you find a bug please either email me, or add the bug
to cpan-RT.

=head1 AUTHOR

Stevan Little E<lt>stevan@iinteractive.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2007 by Infinity Interactive, Inc.

L<http://www.iinteractive.com>

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut