#!perl

use strict;
use warnings;

use Test::More;
use Test::Differences;
use Cwd qw(getcwd chdir);
use English qw(-no_match_vars $CHILD_ERROR);

$ENV{TEST_EXAMPLE} or plan(
    skip_all => 'Set $ENV{TEST_EXAMPLE} to run this test.'
);

plan(tests => 1);

my @data = (
    {
        test   => 'all_ties',
        path   => 'example',
        script => '01_all_ties.pl',
        result => <<'EOT',
11 text1 translated

21 text1 translated # __x without placeholders
22 text1 translated # __x without placeholders and more common extractable
23 text2 translated {text}
24 text3 translated plural
25 text3 translated singular # __nx without placeholders
26 text3 translated plural # __xn without placeholders
27 text4 translated 1 singular
28 text4 translated 2 plural

31 ctext1 translated
32 ctext1 translated # __px without placeholders
33 ctext2 translated is good
34 ctext3 translated plural
35 ctext4 translated 2 plural

41 text1 original
42 text1 original # alternative writing
43 text3 original singular text3 original plural 2
44 special ctext1 original
45 special ctext3 original singular ctext3 original plural 2
EOT
    },
);

for my $data (@data) {
    my $dir = getcwd();
    chdir("$dir/$data->{path}");
    my $result = qx{perl $data->{script} 2>&1};
    $CHILD_ERROR
        and die "Couldn't run $data->{script} (status $CHILD_ERROR)";
    chdir($dir);
    eq_or_diff(
        $result,
        $data->{result},
        $data->{test},
    );
}
