use Mojo::Base -strict;

use Test::More;
use Mango::Protocol;

my $p = Mango::Protocol->new;

# Build empty update
is $p->build_update(1, 'foo', {}, {}, {}),
    "\x26\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd1\x07\x00\x00\x00\x00"
  . "\x00\x00\x66\x6f\x6f\x00\x00\x00\x00\x00\x05\x00\x00\x00\x00\x05\x00\x00"
  . "\x00\x00", 'empty update';

# Build empty insert
is $p->build_insert(1, 'foo', {}, {}),
  "\x1d\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd2\x07\x00\x00\x00\x00"
  . "\x00\x00\x66\x6f\x6f\x00\x05\x00\x00\x00\x00", 'empty insert';

# Build empty query
is $p->build_query(1, 'foo', {}, 0, 10, {}, {}),
    "\x2a\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd4\x07\x00\x00\x00\x00"
  . "\x00\x00\x66\x6f\x6f\x00\x00\x00\x00\x00\x0a\x00\x00\x00\x05\x00\x00\x00"
  . "\x00\x05\x00\x00\x00\x00", 'empty query';

# Build empty get_more
is $p->build_get_more(1, 'foo', 10, 1),
  "\x24\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd5\x07\x00\x00\x00\x00"
  . "\x00\x00\x66\x6f\x6f\x00\x0a\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00",
  'empty get_more';

# Build empty delete
is $p->build_delete(1, 'foo', {}, {}),
  "\x21\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd6\x07\x00\x00\x00\x00"
  . "\x00\x00\x66\x6f\x6f\x00\x00\x00\x00\x00\x05\x00\x00\x00\x00",
  'empty delete';

# Build empty kill_cursors
is $p->build_kill_cursors(1, 1),
  "\x20\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\xd7\x07\x00\x00\x00\x00"
  . "\x00\x00\x01\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00",
  'empty kill_cursors';

# Parse partial reply
my $before = my $after = "\x10";
is $p->parse_reply(\$after), undef, 'nothing';
is $before, $after, 'no changes';
$before = $after = "\x00\x01\x00\x00";
is $p->parse_reply(\$after), undef, 'nothing';
is $before, $after, 'no changes';

# Parse wrong message type
my $buffer = $p->build_insert(1, 'foo', {}, {}) . "\x00";
is $p->parse_reply(\$buffer), undef, 'nothing';
is $buffer, "\x00", 'message has been removed';

done_testing();
