#!/usr/bin/perl -w
use warnings;
use strict;
use lib '../lib';

use bignum;
use Test::More tests => 67;

use Astro::Units;
my $astro_kl =  new Astro::Units();
my $astro_mi =  new Astro::Units(unit =>'mi');

ok ($astro_kl->VERSION eq '1.00', 'Vesion Test');
ok ($astro_kl->get_astronomical_units(1) eq '149597870.7',"get_astronomical_units");
ok ($astro_kl->get_light_years(1) eq '9460730472580.8','get_light_years');
ok ($astro_kl->get_light_week(1) eq '181314478598.3999','get_light_week');
ok ($astro_kl->get_light_days(1) eq '25902068371.199997','get_light_days');
ok ($astro_kl->get_light_hours(1) eq '1079252848.8','get_light_hours');
ok ($astro_kl->get_light_minutes(1) eq '17987547.48','get_light_minutes');
ok ($astro_kl->get_light_seconds(1) eq '299792.458','get_light_seconds');
ok ($astro_kl->get_light_parsecs(1) eq '30856775814914.21805','get_light_parsecs');

ok ($astro_mi->get_astronomical_units(1) eq '92955807.27302',"get_astronomical_units");
ok ($astro_mi->get_light_years(1) eq '5878625373183.607730851','get_light_years');
ok ($astro_mi->get_light_week(1) eq '112663593736.57832011055436','get_light_week');
ok ($astro_mi->get_light_days(1) eq '16094799105.22548131412550703','get_light_days');
ok ($astro_mi->get_light_hours(1) eq '670616629.384395','get_light_hours');
ok ($astro_mi->get_light_minutes(1) eq '11176943.823073','get_light_minutes');
ok ($astro_mi->get_light_seconds(1) eq '186282.397051','get_light_seconds');
ok ($astro_mi->get_light_parsecs(1) eq '19173511576713.380141225244571701','get_light_parsecs');

ok( $astro_kl->convert_to_astronomical_units(1) eq '0.000000006684587122','convert_to_astronomical_units');
ok( $astro_kl->convert_to_light_years('1234,56,789.12_3465679_45_45mile') eq '0.000013049392906950429826613835528','convert_to_light_years');
ok( $astro_kl->convert_to_light_weeks('1') eq '0.0000000000055152793518213','convert_to_light_weeks');
ok( $astro_kl->convert_to_light_days("1") eq '0.000000000038606955462749084','convert_to_light_days');
ok( $astro_kl->convert_to_light_hours('1') eq '0.0000000009265669311', 'convert_to_light_hours');
ok( $astro_kl->convert_to_light_minutes('-1') eq '-0.00000005559401586', 'convert_to_light_minutes');
ok( $astro_kl->convert_to_light_seconds(00) eq '0', 'convert_to_light_seconds');
ok( $astro_kl->convert_to_light_parsec(-100) eq '-0.000000000003240779289444307756' ,'convert_to_light_parsec');

ok ($astro_mi->convert_to_astronomical_units(1) eq '0.000000010757800177',"convert_to_astronomical_units");
ok ($astro_mi->convert_to_light_years('1234,56,789.12_3465679_45_45mile') eq '0.00002100096217844323253888201652400031767894','convert_to_light_years');
ok ($astro_mi->convert_to_light_weeks("1") eq '0.000000000008875981733177498','convert_to_light_weeks');
ok ($astro_mi->convert_to_light_days(1) eq '0.000000000062131872132242462','convert_to_light_days');
ok ($astro_mi->convert_to_light_hours('1') eq '0.00000000149116493117','convert_to_light_hours');
ok ($astro_mi->convert_to_light_minutes('-1') eq '-0.00000008946989587','convert_to_light_minutes');
ok ($astro_mi->convert_to_light_seconds(00) eq '0','convert_to_light_seconds');
ok ($astro_mi->convert_to_light_parsec(-100) eq '-0.000000000005215528704791460021','convert_to_light_parsec');

ok( $astro_kl->au_to_light_years(1) eq '0.00001581250740982','au_to_light_years');
ok( $astro_kl->au_to_light_weeks(1) eq '0.0008250740473481426','au_to_light_weeks');
ok( $astro_kl->au_to_light_days(1) eq '0.0057755183314369961','au_to_light_days');
ok( $astro_kl->au_to_light_hours(1) eq '0.138612439954','au_to_light_hours');
ok( $astro_kl->au_to_light_minutes(1) eq '8.316746397', 'au_to_light_minutes');
ok( $astro_kl->au_to_light_seconds(1) eq '499.00478383', 'au_to_light_seconds');
ok( $astro_kl->au_to_light_parsecs(1) eq '0.000004848136811095274265', 'au_to_light_parsecs');

ok( $astro_kl->au_to_light_years(1) eq '0.00001581250740982','au_to_light_years');
ok( $astro_mi->au_to_light_weeks(1) eq '0.0008250740473481426','au_to_light_weeks');
ok( $astro_mi->au_to_light_days(1) eq '0.0057755183314369961','au_to_light_days');
ok( $astro_mi->au_to_light_hours(1) eq '0.138612439954','au_to_light_hours');
ok( $astro_mi->au_to_light_minutes(1) eq '8.316746397', 'au_to_light_minutes');
ok( $astro_mi->au_to_light_seconds(1) eq '499.00478383', 'au_to_light_seconds');
ok( $astro_mi->au_to_light_parsecs(1) eq '0.000004848136811095274265', 'au_to_light_parsecs');

ok( $astro_kl->light_years_to_au(1) eq '63241.07708426628026','light_years_to_au');
ok( $astro_kl->light_weeks_to_au(1) eq '1212.0124287196816364846','light_weeks_to_au');
ok( $astro_kl->light_days_to_au(1) eq '173.1446326742403092238665','light_days_to_au');
ok( $astro_kl->light_hours_to_au(1) eq '7.21435969476','light_hours_to_au');
ok( $astro_kl->light_minutes_to_au(1) eq '0.12023932824', 'light_minutes_to_au');
ok( $astro_kl->light_seconds_to_au(1) eq '0.0020039888041', 'light_seconds_to_au');
ok( $astro_kl->light_parsecs_to_au(1) eq '206264.80624710000000020053761', 'light_parsecs_to_au');

ok( $astro_mi->light_years_to_au(1) eq '63241.07708426628026','light_years_to_au');
ok( $astro_mi->light_weeks_to_au(1) eq '1212.0124287196816364846','light_weeks_to_au');
ok( $astro_mi->light_days_to_au(1) eq '173.1446326742403092238665','light_days_to_au');
ok( $astro_mi->light_hours_to_au(1) eq '7.21435969476','light_hours_to_au');
ok( $astro_mi->light_minutes_to_au(1) eq '0.12023932824', 'light_minutes_to_au');
ok( $astro_mi->light_seconds_to_au(1) eq '0.0020039888041', 'light_seconds_to_au');
ok( $astro_mi->light_parsecs_to_au(1) eq '206264.80624710000000020053761', 'light_parsecs_to_au');

#more test

my $string1 = '99999999998888888888999999999988888888889999999999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998,888,8888889999999999888888888999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999.999998_____899999999998888888888675444';
my $string1_out_kl ='149597870698337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298337801436832886522983378014383272030314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229850385507314368328865229833780143634735915374961498337801436832886522983378014368328865229833780143683288652298337801436347359153749614983378014368328865229835.4423422298337801436347357657770908';
my $string1_out_mi ='92955807271992688596616314798441711662869050287092028665185120949065146008436627810685070283056315727410900546350084154649437089453002153882452376143873853559821899086505800834064158957799043388665600579079302769844661255134625048705107192939712285791744856152658247544288464716989243941280939865263724460410184726736626745916437805272615611291185375126361519817773566980095224096815366913714847362880980613982985477401745516132893254331167109975762103393049203908156571165164087839606500094853740615928873098205948355115490148790046334944691657212819207309517955906154172223983645457636752303011538513104026561744026146285895908662059684035037436776909310751111227530691853087334577327388258113386479450948532053015927750582709565906814152458990432336282011075870990281368069454590730900189008778535408621337848093034396225514091216659320825360102541923821374117226875254057075326207537751242689800913601031104249205195733779339913883128072823357703600773537946081346064878824762856014385354143063489427285421793218545764217177225770148445667075986187772758029568446172373890556017469238626626044667786240942696706640903584194203568260827858813891484986658122107659922543289262189021654307490368835770808425902082773066418016802427897940637933448864173992529738914541135178245507362898390498957183557389456831086659449583091238111500318346397805462213264308150349070777595304547341545925869785066470790787342687351977043865878676217351791435732422125878379627586155830157421427519775453423487041220043591538007806122193499314937227716036368163999109809968762631771224693900212560700914346676534933704266554415721550754850652395550752253.98817296353904456948591212679022682534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998';

my $string2 ='1ww,,,,wWWW_,,,,,'; #bad input

my $string3 = '9999999.9998888888888999999999988888888889999999999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998,888,8888889999999999888888888999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998999888888888899999999998888888888675444999999999988888888889999999999888888888899999999998888888888999999999988888888886754449999999999888888888899999999998_____899999999998888888888675444Kilometers';

my $string3_out_kl ='1495978706983378.014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298337801436832886522983378014368328865229833780143634735915374961498337801436832886522983378014368328865229833780143832720303143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298503855073143683288652298337801436347359153749614983378014368328865229833780143683288652298337801436832886522983378014363473591537496149833780143683288652298354423422298337801436347357657770908';
my $string3_out_mi ='929558072719926.8859661631479844171166286905028709202866518512094906514600843662781068507028305631572741090054635008415464943708945300215388245237614387385355982189908650580083406415895779904338866560057907930276984466125513462504870510719293971228579174485615265824754428846471698924394128093986526372446041018472673662674591643780527261561129118537512636151981777356698009522409681536691371484736288098061398298547740174551613289325433116710997576210339304920390815657116516408783960650009485374061592887309820594835511549014879004633494469165721281920730951795590615417222398364545763675230301153851310402656174402614628589590866205968403503743677690931075111122753069185308733457732738825811338647945094853205301592775058270956590681415245899043233628201107587099028136806945459073090018900877853540862133784809303439622551409121665932082536010254192382137411722687525405707532620753775124268980091360103110424920519573377933991388312807282335770360077353794608134606487882476285601438535414306348942728542179321854576421717722577014844566707598618777275802956844617237389055601746923862662604466778624094269670664090358419420356826082785881389148498665812210765992254328926218902165430749036883577080842590208277306641801680242789794063793344886417399252973891454113517824550736289839049895718355738945683108665944958309123811150031834639780546221326430815034907077759530454734154592586978506647079078734268735197704386587867621735179143573242212587837962758615583015742142751977545342348704122004359153800780612219349931493722771603636816399910980996876263177122469390021256070091434667653493370426655441572155075485065239555075225398817296353904456948591212679022682534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998568360773085182534001431639226914817465998';

ok ($astro_kl->get_astronomical_units($string1) eq $string1_out_kl,"get_astronomical_units");
ok ($astro_kl->get_astronomical_units($string3) eq $string3_out_kl,"get_astronomical_units");
ok ($astro_kl->get_light_years($string2) eq '9460730472580.8','get_light_years');

ok ($astro_mi->get_astronomical_units($string1) eq $string1_out_mi,"get_astronomical_units");
ok ($astro_mi->get_astronomical_units($string3) eq $string3_out_mi,"get_astronomical_units");
ok ($astro_mi->get_light_years($string2) eq '5878625373183.607730851','get_light_years');

done_testing();