package AltRegex::Match;
$VERSION = 1.00;
use strict;
use warnings;

sub new {
	my $class = shift;
	my ($pre, $match, $post, $result) = splice @_, -4;
	bless {
			_pre				=> $pre,
			_match				=> $match,
			_post				=> $post,
			_result				=> $result,
			_subpatterns		=> [@_]
		  }, ref($class) || $class;
}

sub get_pre 	{ return $_[0]->{_pre} }
sub get_match	{ return $_[0]->{_match} }
sub get_post	{ return $_[0]->{_post} }
sub get_result  { return $_[0]->{_result} }

sub from
{
	my ($self) = @_;
	# example of Perl 'memoization'...
	# cramming a new value into $self,
	# on the fly and as it is requested.
	$self->{_from} = length($_[0]->{_pre})
		unless defined $self->{_from};
	return $self->{_from};
}

sub to
{
	my ($self) = @_;
	# example of Perl 'memoization'...
	# cramming a new value into $self,
	# on the fly and as it is requested.
	$self->{_to} = $self->from + length($self->{_match}) - 1
		unless defined $self->{_to};
	return $self->{_to};
}

sub subpatterns
{
	my ($self, $index) = @_;
	return $self->{_subpatterns}[$index] if defined $index;
	return @{$self->{_subpatterns}};
}

return 1;

__END__

=pod

=head1 NAME
AltRegex::Match

=head1 VERSION
This document refers to version 1.00 of AltRegex::Match, released December 23, 2019.

=head1 SYNOPSIS
Helper module for alternative object-oriented utility for using Perl Regex functionality.

=head1 DESCRIPTION
Helper module for alternative object-oriented utility for using Perl Regex functionality.

=head2 Overview
data members : _pre, _match, _post, _result
You can access the above data members using the get_pre(), get_match(),
get_post() and get_result() methods provided.

methods : new get_pre get_match get_post get_result

Look at each method header to surmise what the methods take as parameters and what is returned.

=head2 Constructor and initialization
my $matcher = AltRegex::Match->new(@subpatterns,$`,$&,$',$str)
The above line will create an AltRegex::Match object.
'@subpatterns' is an (optional) array usually containing a '1' or the empty array [].
$` (dollar-sign backtick) contains the character just prior to a match done in a method
of the AltRegex class.
$& (dollar-sign ampersand) contains the match itself.
$' (dollar-sign apostrophe) contains the character just after the match.
$str is a scalar reference to the regular expression result.

=head2 Class and object methods
Look at each method header to surmise what the methods take as parameters and what is returned.

=head1 ENVIRONMENT
Unix/Linux, Windows

=head1 DIAGNOSTICS

=over 1

=back

=head1 BUGS
None.

=head1 FILES
None, other than this package file itself.

=head1 AUTHOR
Steven Novakovich
snovakov@cpan.org

=head1 COPYRIGHT
It is free software; you can redistribute it and/or modify it under the terms of either:

a) the GNU General Public License as published by the Free Software Foundation; either version 1, or (at your option) any later version, or

b) the "Artistic License". 
