# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Net-Libnet.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use Test::More tests => 2;
BEGIN { use_ok('Net::Libnet') };


my $fail = 0;
foreach my $constname (qw(
	ARPHRD_APPLETLK ARPHRD_ARCNET ARPHRD_ATM ARPHRD_AX25 ARPHRD_CHAOS
	ARPHRD_DLCI ARPHRD_EETHER ARPHRD_ETHER ARPHRD_IEEE802 ARPHRD_IPSEC
	ARPHRD_LANSTAR ARPHRD_METRICOM ARPHRD_NETROM ARPHRD_PRONET
	ARPOP_INVREPLY ARPOP_INVREQUEST ARPOP_REPLY ARPOP_REQUEST
	ARPOP_REVREPLY ARPOP_REVREQUEST ASN_APPLICATION ASN_BIT8 ASN_BIT_STR
	ASN_BOOLEAN ASN_CONSTRUCTOR ASN_CONTEXT ASN_EXTENSION_ID ASN_INTEGER
	ASN_LONG_LEN ASN_NULL ASN_OBJECT_ID ASN_OCTET_STR ASN_PRIMITIVE
	ASN_PRIVATE ASN_SEQUENCE ASN_SET ASN_UNIVERSAL CQ_LOCK_READ
	CQ_LOCK_UNLOCKED CQ_LOCK_WRITE DHCP_MAGIC ETHERTYPE_ARP ETHERTYPE_EAP
	ETHERTYPE_IP ETHERTYPE_LOOPBACK ETHERTYPE_MPLS ETHERTYPE_PUP
	ETHERTYPE_REVARP ETHERTYPE_VLAN ETHER_ADDR_LEN FDDI_ADDR_LEN
	FDDI_TYPE_ARP FDDI_TYPE_IP FDDI_TYPE_REVARP GRE_ACK GRE_APOLLO_DOMAIN
	GRE_CHAOS GRE_CSUM GRE_DECNET GRE_ETHERTALK GRE_FLAGS_MASK
	GRE_FRAME_RELAY_ARP GRE_IP GRE_IP_AUTONOMOUS_SYSTEMS GRE_KEY
	GRE_NOVELL_IPX GRE_OSI_NETWORK_LAYER GRE_PPP GRE_PUP
	GRE_RAW_FRAME_RELAY GRE_REC GRE_RFC_1144_TCP_IP_COMPRESSION
	GRE_RFC_826_ARP GRE_ROUTING GRE_SECURE_DATA GRE_SEQ GRE_SNA GRE_STRICT
	GRE_TRANSPARENT_ETHERNET_BRIDGING GRE_VERSION_0 GRE_VERSION_1
	GRE_VERSION_MASK GRE_VINES GRE_VINES_ECHO GRE_VINES_LOOPBACK GRE_XNS
	ICMP6_ECHO ICMP6_ECHOREPLY ICMP6_PARAMPROB ICMP6_PKTTOOBIG
	ICMP6_TIMXCEED ICMP6_UNREACH ICMP_ECHO ICMP_ECHOREPLY ICMP_IREQ
	ICMP_IREQREPLY ICMP_MASKREPLY ICMP_MASKREQ ICMP_PARAMPROB
	ICMP_PARAMPROB_OPTABSENT ICMP_REDIRECT ICMP_REDIRECT_HOST
	ICMP_REDIRECT_NET ICMP_REDIRECT_TOSHOST ICMP_REDIRECT_TOSNET
	ICMP_ROUTERADVERT ICMP_ROUTERSOLICIT ICMP_SOURCEQUENCH ICMP_TIMXCEED
	ICMP_TIMXCEED_INTRANS ICMP_TIMXCEED_REASS ICMP_TSTAMP ICMP_TSTAMPREPLY
	ICMP_UNREACH ICMP_UNREACH_FILTER_PROHIB ICMP_UNREACH_HOST
	ICMP_UNREACH_HOST_PRECEDENCE ICMP_UNREACH_HOST_PROHIB
	ICMP_UNREACH_HOST_UNKNOWN ICMP_UNREACH_ISOLATED ICMP_UNREACH_NEEDFRAG
	ICMP_UNREACH_NET ICMP_UNREACH_NET_PROHIB ICMP_UNREACH_NET_UNKNOWN
	ICMP_UNREACH_PORT ICMP_UNREACH_PRECEDENCE_CUTOFF ICMP_UNREACH_PROTOCOL
	ICMP_UNREACH_SRCFAIL ICMP_UNREACH_TOSHOST ICMP_UNREACH_TOSNET
	IGMP_LEAVE_GROUP IGMP_MEMBERSHIP_QUERY IGMP_V1_MEMBERSHIP_REPORT
	IGMP_V2_MEMBERSHIP_REPORT IPOPT_EOL IPOPT_LSRR
	IPOPT_NOP IPOPT_RR IPOPT_SATID IPOPT_SECURITY IPOPT_SSRR IPOPT_TS
	IPPROTO_AH IPPROTO_ESP IPPROTO_GRE IPPROTO_ICMP6 IPPROTO_OSPF
	IPPROTO_OSPF_LSA IPPROTO_VRRP IPTOS_LOWCOST IPTOS_LOWDELAY
	IPTOS_RELIABILITY IPTOS_THROUGHPUT IP_DF IP_MAXPACKET IP_MF IP_OFFMASK
	IP_RF LIBNET_802_1Q_CFIMASK LIBNET_802_1Q_H LIBNET_802_1Q_PRIMASK
	LIBNET_802_1Q_VIDMASK LIBNET_802_1X_ENCASFAL LIBNET_802_1X_H
	LIBNET_802_1X_KEY LIBNET_802_1X_LOGOFF LIBNET_802_1X_PACKET
	LIBNET_802_1X_START LIBNET_802_2SNAP_H LIBNET_802_2_H LIBNET_802_3_H
	LIBNET_ADV_MASK LIBNET_ARP_ETH_IP_H LIBNET_ARP_H LIBNET_AS_E_BIT_ON
	LIBNET_BGP4_AUTHENTICATION_FAILURE LIBNET_BGP4_BAD_BGP_IDENTIFIER
	LIBNET_BGP4_BAD_MESSAGE_LENGTH LIBNET_BGP4_BAD_MESSAGE_TYPE
	LIBNET_BGP4_BAD_PEER_AS LIBNET_BGP4_CEASE
	LIBNET_BGP4_CONNECTION_NOT_SYNCHRONIZED LIBNET_BGP4_FINITE_STATE__ERROR
	LIBNET_BGP4_HEADER_H LIBNET_BGP4_HOLD_TIMER_EXPIRED
	LIBNET_BGP4_KEEPALIVE LIBNET_BGP4_MARKER_SIZE
	LIBNET_BGP4_MESSAGE_HEADER_ERROR LIBNET_BGP4_NOTIFICATION
	LIBNET_BGP4_NOTIFICATION_H LIBNET_BGP4_OPEN LIBNET_BGP4_OPEN_H
	LIBNET_BGP4_OPEN_MESSAGE_ERROR LIBNET_BGP4_UNACCEPTABLE_HOLD_TIME
	LIBNET_BGP4_UNSUPPORTED_OPTIONAL_PARAMETER
	LIBNET_BGP4_UNSUPPORTED_VERSION_NUMBER LIBNET_BGP4_UPDATE
	LIBNET_BGP4_UPDATE_H LIBNET_BGP4_UPDATE_MESSAGE_ERROR
	LIBNET_BOOTP_MIN_LEN LIBNET_CDP_ADDRESS LIBNET_CDP_CAPABIL
	LIBNET_CDP_CAP_L1F LIBNET_CDP_CAP_L2B LIBNET_CDP_CAP_L2S
	LIBNET_CDP_CAP_L2SRB LIBNET_CDP_CAP_L3R LIBNET_CDP_CAP_NOI
	LIBNET_CDP_CAP_SR LIBNET_CDP_DEVID LIBNET_CDP_H LIBNET_CDP_IPPREFIX
	LIBNET_CDP_PLATFORM LIBNET_CDP_PORTID LIBNET_CDP_VERSION LIBNET_DBD_IBI
	LIBNET_DBD_MBIT LIBNET_DBD_MSBIT LIBNET_DHCPV4_H LIBNET_DHCP_ARPTIMEOUT
	LIBNET_DHCP_BOOTFILESIZE LIBNET_DHCP_BROADCASTADDR LIBNET_DHCP_CLASSSID
	LIBNET_DHCP_CLIENTID LIBNET_DHCP_COOKIESERV LIBNET_DHCP_DISCOVERADDR
	LIBNET_DHCP_DNS LIBNET_DHCP_DOMAINNAME LIBNET_DHCP_DOMASKDISCOV
	LIBNET_DHCP_DOROUTEDISC LIBNET_DHCP_DUMPFILE LIBNET_DHCP_END
	LIBNET_DHCP_ETHERENCAP LIBNET_DHCP_EXTENPATH LIBNET_DHCP_FINGERSERVER
	LIBNET_DHCP_HOSTNAME LIBNET_DHCP_IMPSERV LIBNET_DHCP_IPFORWARD
	LIBNET_DHCP_IPTTL LIBNET_DHCP_IRCSERVER LIBNET_DHCP_LEASETIME
	LIBNET_DHCP_LOCALSUBNETS LIBNET_DHCP_LOGSERV LIBNET_DHCP_LPRSERV
	LIBNET_DHCP_MASKSUPPLY LIBNET_DHCP_MAXASMSIZE LIBNET_DHCP_MAXMSGSIZE
	LIBNET_DHCP_MESSAGE LIBNET_DHCP_MESSAGETYPE LIBNET_DHCP_MOBILEIPAGENT
	LIBNET_DHCP_MSGACK LIBNET_DHCP_MSGDECLINE LIBNET_DHCP_MSGDISCOVER
	LIBNET_DHCP_MSGINFORM LIBNET_DHCP_MSGNACK LIBNET_DHCP_MSGOFFER
	LIBNET_DHCP_MSGRELEASE LIBNET_DHCP_MSGREQUEST LIBNET_DHCP_MTUSIZE
	LIBNET_DHCP_MTUTABLE LIBNET_DHCP_MTUTIMEOUT LIBNET_DHCP_NAMESERVER
	LIBNET_DHCP_NBDD LIBNET_DHCP_NBNS LIBNET_DHCP_NBTCPIP
	LIBNET_DHCP_NBTCPSCOPE LIBNET_DHCP_NISDOMAIN LIBNET_DHCP_NISPLUSDOMAIN
	LIBNET_DHCP_NISPLUSSERVERS LIBNET_DHCP_NISSERVERS
	LIBNET_DHCP_NISTIMESERV LIBNET_DHCP_NNTPSERVER
	LIBNET_DHCP_OPTIONOVERLOAD LIBNET_DHCP_PAD LIBNET_DHCP_PARAMREQUEST
	LIBNET_DHCP_POLICYFILTER LIBNET_DHCP_POP3SERVER LIBNET_DHCP_REBINDTIME
	LIBNET_DHCP_RENEWTIME LIBNET_DHCP_REPLY LIBNET_DHCP_REQUEST
	LIBNET_DHCP_RESSERV LIBNET_DHCP_ROOTPATH LIBNET_DHCP_ROUTER
	LIBNET_DHCP_ROUTERSOLICIT LIBNET_DHCP_SERVIDENT LIBNET_DHCP_SMTPSERVER
	LIBNET_DHCP_SRCROUTE LIBNET_DHCP_STATICROUTE LIBNET_DHCP_STDASERVER
	LIBNET_DHCP_STSERVER LIBNET_DHCP_SUBNETMASK LIBNET_DHCP_SWAPSERV
	LIBNET_DHCP_TCPALIVEGARBAGE LIBNET_DHCP_TCPKEEPALIVE LIBNET_DHCP_TCPTTL
	LIBNET_DHCP_TIMEOFFSET LIBNET_DHCP_TIMESERVER LIBNET_DHCP_TRAILERENCAP
	LIBNET_DHCP_VENDSPECIFIC LIBNET_DHCP_WWWSERVER LIBNET_DHCP_XDISPLAYMGR
	LIBNET_DHCP_XFONT LIBNET_DNS_H LIBNET_DONT_RESOLVE LIBNET_ERRBUF_SIZE
	LIBNET_ETH_H LIBNET_FDDI_48BIT_ADDR LIBNET_FDDI_FC_REQD LIBNET_FDDI_H
	LIBNET_FDDI_LLC_FRAME LIBNET_GRE_H LIBNET_GRE_SRE_H
	LIBNET_ICMPV4_ECHO_H LIBNET_ICMPV4_H LIBNET_ICMPV4_MASK_H
	LIBNET_ICMPV4_REDIRECT_H LIBNET_ICMPV4_TIMXCEED_H LIBNET_ICMPV4_TS_H
	LIBNET_ICMPV4_UNREACH_H LIBNET_ICMPV6_H LIBNET_IGMP_H LIBNET_IPSEC_AH_H
	LIBNET_IPSEC_ESP_FTR_H LIBNET_IPSEC_ESP_HDR_H LIBNET_IPV4_H
	LIBNET_IPV6_DESTOPTS_H LIBNET_IPV6_FRAG_H LIBNET_IPV6_H
	LIBNET_IPV6_HBHOPTS_H LIBNET_IPV6_NH_DESTOPTS LIBNET_IPV6_NH_FRAGMENT
	LIBNET_IPV6_NH_HBH LIBNET_IPV6_NH_ROUTING LIBNET_IPV6_ROUTING_H
	LIBNET_ISL_H LIBNET_LABEL_SIZE LIBNET_LIL_ENDIAN LIBNET_LINK
	LIBNET_LINK_ADV LIBNET_LINK_ID_IP_DES LIBNET_LINK_ID_NBR_ID
	LIBNET_LINK_ID_SUB LIBNET_LS_TYPE_ASBR LIBNET_LS_TYPE_ASEXT
	LIBNET_LS_TYPE_IP LIBNET_LS_TYPE_NET LIBNET_LS_TYPE_RTR
	LIBNET_MAXOPTION_SIZE LIBNET_MAX_PACKET LIBNET_MODX LIBNET_MPLS_BOS_OFF
	LIBNET_MPLS_BOS_ON LIBNET_MPLS_H LIBNET_NTP_H LIBNET_NTP_LI_AC
	LIBNET_NTP_LI_AS LIBNET_NTP_LI_DS LIBNET_NTP_LI_NW LIBNET_NTP_MODE_A
	LIBNET_NTP_MODE_B LIBNET_NTP_MODE_C LIBNET_NTP_MODE_P LIBNET_NTP_MODE_R
	LIBNET_NTP_MODE_RC LIBNET_NTP_MODE_RP LIBNET_NTP_MODE_S
	LIBNET_NTP_REF_ACTS LIBNET_NTP_REF_CHU LIBNET_NTP_REF_DCF
	LIBNET_NTP_REF_GOES LIBNET_NTP_REF_GPS LIBNET_NTP_REF_LOCAL
	LIBNET_NTP_REF_LORC LIBNET_NTP_REF_MSF LIBNET_NTP_REF_OMEG
	LIBNET_NTP_REF_PPS LIBNET_NTP_REF_PTB LIBNET_NTP_REF_TDF
	LIBNET_NTP_REF_USNO LIBNET_NTP_REF_WWV LIBNET_NTP_REF_WWVB
	LIBNET_NTP_REF_WWVH LIBNET_NTP_STRATUM_PRIMARY
	LIBNET_NTP_STRATUM_UNAVAIL LIBNET_NTP_VN_2 LIBNET_NTP_VN_3
	LIBNET_NTP_VN_4 LIBNET_OFF LIBNET_ON LIBNET_OPT_DCBIT LIBNET_OPT_EABIT
	LIBNET_OPT_EBIT LIBNET_OPT_MCBIT LIBNET_OPT_NPBIT LIBNET_ORG_CODE_SIZE
	LIBNET_OSPF_AUTH_H LIBNET_OSPF_AUTH_MD5 LIBNET_OSPF_AUTH_NULL
	LIBNET_OSPF_AUTH_SIMPLE LIBNET_OSPF_CKSUM LIBNET_OSPF_DBD
	LIBNET_OSPF_DBD_H LIBNET_OSPF_H LIBNET_OSPF_HELLO LIBNET_OSPF_HELLO_H
	LIBNET_OSPF_LSA LIBNET_OSPF_LSA_H LIBNET_OSPF_LSR LIBNET_OSPF_LSR_H
	LIBNET_OSPF_LSU LIBNET_OSPF_LSU_H LIBNET_OSPF_LS_AS_EXT_H
	LIBNET_OSPF_LS_NET_H LIBNET_OSPF_LS_RTR_H LIBNET_OSPF_LS_SUM_H
	LIBNET_OSPF_UMD LIBNET_PBLOCK_802_1Q_H LIBNET_PBLOCK_802_1X_H
	LIBNET_PBLOCK_802_2SNAP_H LIBNET_PBLOCK_802_2_H LIBNET_PBLOCK_802_3_H
	LIBNET_PBLOCK_ARP_H LIBNET_PBLOCK_BGP4_HEADER_H
	LIBNET_PBLOCK_BGP4_NOTIFICATION_H LIBNET_PBLOCK_BGP4_OPEN_H
	LIBNET_PBLOCK_BGP4_UPDATE_H LIBNET_PBLOCK_CDP_H LIBNET_PBLOCK_DATA_H
	LIBNET_PBLOCK_DHCPV4_H LIBNET_PBLOCK_DNSV4_H LIBNET_PBLOCK_DO_CHECKSUM
	LIBNET_PBLOCK_ETH_H LIBNET_PBLOCK_FDDI_H LIBNET_PBLOCK_GRE_H
	LIBNET_PBLOCK_GRE_SRE_H LIBNET_PBLOCK_ICMPV4_ECHO_H
	LIBNET_PBLOCK_ICMPV4_H LIBNET_PBLOCK_ICMPV4_MASK_H
	LIBNET_PBLOCK_ICMPV4_REDIRECT_H LIBNET_PBLOCK_ICMPV4_TIMXCEED_H
	LIBNET_PBLOCK_ICMPV4_TS_H LIBNET_PBLOCK_ICMPV4_UNREACH_H
	LIBNET_PBLOCK_IGMP_H LIBNET_PBLOCK_IPDATA LIBNET_PBLOCK_IPO_H
	LIBNET_PBLOCK_IPSEC_AH_H LIBNET_PBLOCK_IPSEC_ESP_FTR_H
	LIBNET_PBLOCK_IPSEC_ESP_HDR_H LIBNET_PBLOCK_IPV4_H
	LIBNET_PBLOCK_IPV6_DESTOPTS_H LIBNET_PBLOCK_IPV6_FRAG_H
	LIBNET_PBLOCK_IPV6_H LIBNET_PBLOCK_IPV6_HBHOPTS_H
	LIBNET_PBLOCK_IPV6_ROUTING_H LIBNET_PBLOCK_ISL_H
	LIBNET_PBLOCK_LS_AS_EXT_H LIBNET_PBLOCK_LS_NET_H LIBNET_PBLOCK_LS_RTR_H
	LIBNET_PBLOCK_LS_SUM_H LIBNET_PBLOCK_MPLS_H LIBNET_PBLOCK_NTP_H
	LIBNET_PBLOCK_OSPF_AUTH_H LIBNET_PBLOCK_OSPF_CKSUM
	LIBNET_PBLOCK_OSPF_DBD_H LIBNET_PBLOCK_OSPF_H
	LIBNET_PBLOCK_OSPF_HELLO_H LIBNET_PBLOCK_OSPF_LSA_H
	LIBNET_PBLOCK_OSPF_LSR_H LIBNET_PBLOCK_OSPF_LSU_H LIBNET_PBLOCK_RIP_H
	LIBNET_PBLOCK_RPC_CALL_H LIBNET_PBLOCK_SEBEK_H LIBNET_PBLOCK_STP_CONF_H
	LIBNET_PBLOCK_STP_TCN_H LIBNET_PBLOCK_TCPDATA LIBNET_PBLOCK_TCPO_H
	LIBNET_PBLOCK_TCP_H LIBNET_PBLOCK_TOKEN_RING_H LIBNET_PBLOCK_UDP_H
	LIBNET_PBLOCK_VRRP_H LIBNET_PMAP_PROC_BCAST LIBNET_PMAP_PROC_CALLIT
	LIBNET_PMAP_PROC_DUMP LIBNET_PMAP_PROC_GETADDR
	LIBNET_PMAP_PROC_GETADDRLIST LIBNET_PMAP_PROC_GETSTAT
	LIBNET_PMAP_PROC_GETTIME LIBNET_PMAP_PROC_GETVERSADDR
	LIBNET_PMAP_PROC_INDIRECT LIBNET_PMAP_PROC_NULL LIBNET_PMAP_PROC_SET
	LIBNET_PMAP_PROC_TADDR2UADDR LIBNET_PMAP_PROC_UADDR2TADDR
	LIBNET_PMAP_PROC_UNSET LIBNET_PMAP_PROGRAM LIBNET_PR16 LIBNET_PR2
	LIBNET_PR32 LIBNET_PR8 LIBNET_PRAND_MAX LIBNET_PROTO_CDP
	LIBNET_PROTO_ISL LIBNET_PRu16 LIBNET_PRu32 LIBNET_PTAG_INITIALIZER
	LIBNET_RAW4 LIBNET_RAW4_ADV LIBNET_RAW6 LIBNET_RAW6_ADV LIBNET_RESOLVE
	LIBNET_RIP_H LIBNET_RPC_CALL LIBNET_RPC_CALL_H LIBNET_RPC_CALL_TCP_H
	LIBNET_RPC_LAST_FRAG LIBNET_RPC_REPLY LIBNET_RPC_VERS
	LIBNET_RTR_FLAGS_B LIBNET_RTR_FLAGS_E LIBNET_RTR_FLAGS_W
	LIBNET_RTR_TYPE_PTP LIBNET_RTR_TYPE_STUB LIBNET_RTR_TYPE_TRANS
	LIBNET_SAP_SNAP LIBNET_SAP_STP LIBNET_SEBEK_H LIBNET_STP_CONF_H
	LIBNET_STP_TCN_H LIBNET_TCP_DNSV4_H LIBNET_TCP_H
	LIBNET_TOKEN_RING_FRAME LIBNET_TOKEN_RING_H LIBNET_TOKEN_RING_LLC_FRAME
	LIBNET_UDP_DNSV4_H LIBNET_UDP_H LIBNET_VRRP_AUTH_IPAH
	LIBNET_VRRP_AUTH_NONE LIBNET_VRRP_AUTH_PASSWD LIBNET_VRRP_H
	LIBNET_VRRP_TYPE_ADVERT LIBNET_VRRP_VERSION_01 LIBNET_VRRP_VERSION_02
	MAX_OID_LEN MAX_SUBID OSPFVERSION RIPCMD_MAX RIPCMD_POLL
	RIPCMD_POLLENTRY RIPCMD_REQUEST RIPCMD_RESPONSE RIPCMD_TRACEOFF
	RIPCMD_TRACEON RIPVER_0 RIPVER_1 RIPVER_2 RTR_TYPE_VRTL
	SEBEK_CMD_LENGTH SEBEK_PROTO_VERSION SEBEK_TYPE_READ SEBEK_TYPE_WRITE
	TH_ACK TH_CWR TH_ECE TH_FIN TH_PUSH TH_RST TH_SYN TH_URG
	TOKEN_RING_ADDR_LEN TOKEN_RING_TYPE_ARP TOKEN_RING_TYPE_IP
	TOKEN_RING_TYPE_REVARP)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Net::Libnet macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

