# ************************************************************************* 
# Copyright (c) 2014, SUSE LLC
# 
# All rights reserved.
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
# notice, this list of conditions and the following disclaimer in the
# documentation and/or other materials provided with the distribution.
# 
# 3. Neither the name of SUSE LLC nor the names of its contributors may be
# used to endorse or promote products derived from this software without
# specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.
# ************************************************************************* 
#
# top-level CLI module
#
package App::Dochazka::CLI;

use 5.006;
use strict;
use warnings FATAL => 'all';

use App::CELL qw( $CELL );
use Data::Dumper;
use Exporter 'import';
use Test::More;



=head1 NAME

App::Dochazka::CLI - Dochazka command line client



=head1 VERSION

Version 0.151

=cut

our $VERSION = '0.151';



=head1 SYNOPSIS

Dochazka command line client.

    bash$ dochazka-cli
    Dochazka(2014-08-08) demo> 



=head1 DESCRIPTION

L<App::Dochazka::CLI> is the Command Line Interface (CLI) component of the
Dochazka Attendance & Time Tracking system. 

It implements a number of commands, which are documented in L<App::Dochazka::CLI::Guide>.


=head1 PACKAGE VARIABLES AND EXPORTS

=over

=item * C<< $current_date >>

The current date, as determined by C<bin/dochazka-cli>

=item * C<< $current_emp >>

The L<App::Dochazka::Model::Employee> object of the current employee.

=item * C<< $current_priv >>

The privlevel of the current employee.

=item * C<< $debug_mode >>

Tells parser whether to display debug messages

=back

=cut

our ( $current_date, $current_emp, $current_priv, $debug_mode, $message );
our @EXPORT_OK = qw( 
    $current_date 
    $current_emp 
    $current_priv 
    $debug_mode
);

1;

