#!perl
# Copyright (C) 2001-2007, The Perl Foundation.
# $Id: auto_ctags-04.t 27227 2008-04-29 02:17:08Z jkeenan $
# auto_ctags-04.t

use strict;
use warnings;
use Test::More tests =>  13;
use Carp;
use lib qw( lib t/configure/testlib );
use_ok('config::init::defaults');
use_ok('config::auto::ctags');
use Parrot::Configure;
use Parrot::Configure::Options qw( process_options );
use Parrot::Configure::Test qw( test_step_thru_runstep);
use IO::CaptureOutput qw| capture |;

my $args = process_options(
    {
        argv => [ ],
        mode => q{configure},
    }
);

my $conf = Parrot::Configure->new;

test_step_thru_runstep( $conf, q{init::defaults}, $args );

my $pkg = q{auto::ctags};

$conf->add_steps($pkg);
$conf->options->set( %{$args} );

my ( $task, $step_name, $step);
$task        = $conf->steps->[1];
$step_name   = $task->step;

$step = $step_name->new();
ok( defined $step, "$step_name constructor returned defined value" );
isa_ok( $step, $step_name );


ok(auto::ctags::_probe_for_ctags_output('Exuberant Ctags', 0),
    "Probe returned true when output matched");

ok(! auto::ctags::_probe_for_ctags_output('alpha', 0),
    "Probe returned false when output matched");

{
    my $stdout;
    my $rv = capture(
        sub { auto::ctags::_probe_for_ctags_output('Exuberant Ctags', 1) },
        \$stdout
    );
    ok($rv, "Probe returned true when output matched");
}

{
    my $stdout;
    my $rv = capture(
        sub { auto::ctags::_probe_for_ctags_output('alpha', 1) },
        \$stdout
    );
    ok(! $rv, "Probe returned false when output matched");
}


pass("Completed all tests in $0");

################### DOCUMENTATION ###################

=head1 NAME

t/steps/auto_ctags-04.t - tests Parrot::Configure step auto::ctags

=head1 SYNOPSIS

    prove t/steps/auto_ctags-04.t

=head1 DESCRIPTION

Regression tests for the L<Parrot::Configure step auto::ctags> module.
This file holds tests for Parrot::Configure step
auto::ctags::_probe_for_ctags_output()
(a non-exported subroutine).

=head1 AUTHOR

Paul Cochrane <paultcochrane at gmail dot com>

=cut

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
